/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.eclipse.jdt.core.compiler.CharOperation;

public class DSLPreferences {
    public static final String AUTO_ADD_DSL_SUPPORT = "org.codehaus.groovy.eclipse.dsl.auto.add.support";
    public static final String DISABLED_SCRIPTS = "org.codehaus.groovy.eclipse.dsl.scripts.disabled";

    private DSLPreferences() {
    }

    public static String[] getDisabledScripts() {
        String disabled = GroovyDSLCoreActivator.getDefault().getPreferenceStore().getString(DISABLED_SCRIPTS);
        if (disabled == null) {
            return CharOperation.NO_STRINGS;
        }
        return disabled.split(",");
    }

    public static Set<String> getDisabledScriptsAsSet() {
        return new HashSet<String>(Arrays.asList(DSLPreferences.getDisabledScripts()));
    }

    public static void setDisabledScripts(String[] disabled) {
        String[] filtered = DSLPreferences.filter(disabled);
        GroovyDSLCoreActivator.getDefault().getPreferenceStore().putValue(DISABLED_SCRIPTS, DSLPreferences.join(filtered));
    }

    private static String join(String[] filtered) {
        StringBuilder sb = new StringBuilder();
        if (filtered.length > 0) {
            String[] stringArray = filtered;
            int n = filtered.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sb.append(s);
                sb.append(',');
                ++n2;
            }
            sb.replace(sb.length() - 1, sb.length(), "");
            return sb.toString();
        }
        return "";
    }

    private static String[] filter(String[] disabled) {
        return disabled;
    }
}

