/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.checker;

import java.io.PrintStream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.eclipse.dsl.checker.IStaticCheckerHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Shell;

public class SysoutStaticCheckerHandler
implements IStaticCheckerHandler {
    private int numProblems;
    private final PrintStream out;

    public SysoutStaticCheckerHandler(PrintStream out) {
        this.out = out;
    }

    @Override
    public void handleUnknownReference(ASTNode node, Position position, int line) {
        ++this.numProblems;
        this.out.println(this.createUnknownMessage(node, line));
    }

    @Override
    public void handleTypeAssertionFailed(ASTNode node, String expectedType, String actualType, Position position, int line) {
        ++this.numProblems;
        this.out.println(this.createInvalidTypeMessage(node, expectedType, actualType, line));
    }

    @Override
    public void setResource(IFile resource) {
        this.out.println("\nChecking: " + String.valueOf(resource.getFullPath()));
    }

    private String createUnknownMessage(ASTNode node, int line) {
        return "\tLine " + line + ": unknown type: " + node.getText();
    }

    private String createInvalidTypeMessage(ASTNode node, String expectedType, String actualType, int line) {
        return "\tLine " + line + ": Invalid inferred type.  " + node.getText() + "  Expected: " + expectedType + " Actual: " + actualType;
    }

    @Override
    public int numProblemsFound() {
        return this.numProblems;
    }

    @Override
    public void handleResourceStart(IResource resource) throws CoreException {
    }

    @Override
    public boolean finish(Shell shell) {
        String message = this.createMessage();
        this.out.println(message);
        if (this.out != System.out) {
            this.out.close();
            System.out.println(message);
        }
        return this.numProblems == 0;
    }

    private String createMessage() {
        if (this.numProblems == 0) {
            return "SUCCESS";
        }
        if (this.numProblems == 1) {
            return "FAILURE found 1 type checking problem";
        }
        return "FAILURE found " + this.numProblems + " type checking problems";
    }
}

