/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.webui.common.ECombobox;
import com.kms.katalon.core.webui.common.Result;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class EListbox
extends ECombobox {
    public EListbox(WebDriver driver, WebElement webElement) {
        super(driver, webElement);
    }

    @Override
    public void getElementValue() throws Exception {
        List elements;
        Result checkExist = this.isExist();
        if (checkExist.getReturnValue().equals(true) && (elements = this.element.findElements(By.tagName((String)"option"))).size() > 0) {
            this.value = "";
            for (WebElement child : elements) {
                if (!child.isSelected()) continue;
                this.value = this.value + ", " + child.getText();
            }
            if (this.value.length() > 1) {
                this.value = this.value.substring(2);
            }
        }
    }

    public Result selectAll() {
        try {
            int count = this.countOptions();
            Integer[] allIndex = new Integer[count];
            int i = 0;
            while (i < count) {
                allIndex[i] = i + 1;
                ++i;
            }
            Result result = this.selectItemsByIndex(allIndex);
            if (result.getMessage() == null) {
                return this.reportHappyCase((String[])result.getReturnValue());
            }
            return this.reportUnhappyCase(null, result.needReNewDriver(), "INT146", result.getMessage());
        }
        catch (Exception e) {
            return this.reportUnhappyCase(null, true, "INT147", e.getMessage());
        }
    }

    public Result selectFromTo(String begin, String end) {
        try {
            List<String> lstOption = this.getListOptionText();
            int idxBegin = lstOption.indexOf(begin) + 1;
            int idxEnd = lstOption.indexOf(end) + 1;
            Result selectItems = this.selectIndexFromTo(idxBegin, idxEnd);
            if (selectItems.getMessage() == null) {
                return this.reportHappyCase((String[])selectItems.getReturnValue());
            }
            return this.reportUnhappyCase(null, selectItems.needReNewDriver(), "INT148", selectItems.getMessage());
        }
        catch (Exception e) {
            return this.reportUnhappyCase(null, true, "INT149", e.getMessage());
        }
    }

    public Result selectIndexFromTo(int start, int end) {
        Result checkEnable = this.isEnable();
        if (checkEnable.getReturnValue().equals(true)) {
            List allOptions = this.selectEle.getOptions();
            ArrayList<String> selectedItems = new ArrayList<String>();
            if (start <= 0 || end < start) {
                return this.reportUnhappyCase(null, false, "INT150", new Object[0]);
            }
            int i = start;
            while (i <= end) {
                try {
                    this.selectEle.selectByIndex(i - 1);
                    selectedItems.add(((WebElement)allOptions.get(i - 1)).getText());
                }
                catch (Exception e) {
                    return this.reportUnhappyCase(null, true, "ITN151", Integer.toString(i), e.getMessage());
                }
                ++i;
            }
            return this.reportHappyCase(selectedItems.toArray(new String[0]));
        }
        return Result.reportUnHappyCaseWithMessage(null, checkEnable.needReNewDriver(), checkEnable.getMessage());
    }

    public Result unSelectItemsByIndex(Integer[] input) {
        Result checkEnable = this.isEnable();
        if (checkEnable.getReturnValue().equals(true)) {
            List allOptions = this.selectEle.getOptions();
            ArrayList<String> deSelectedItems = new ArrayList<String>();
            Integer[] integerArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                int item = integerArray[n2];
                try {
                    this.selectEle.deselectByIndex(item);
                    deSelectedItems.add(((WebElement)allOptions.get(item)).getText());
                }
                catch (Exception e) {
                    return this.reportUnhappyCase(null, true, "INT152", item, e.getMessage());
                }
                ++n2;
            }
            return this.reportHappyCase(deSelectedItems.toArray(new String[0]));
        }
        return this.reportUnhappyCase(null, checkEnable.needReNewDriver(), "INT153", checkEnable.getMessage());
    }

    public Result unSelectFromTo(String begin, String end) {
        try {
            List<String> lstOption = this.getListOptionText();
            int idxBegin = lstOption.indexOf(begin) + 1;
            int idxEnd = lstOption.indexOf(end) + 1;
            Result deSelectItems = this.unSelectIndexFromTo(idxBegin, idxEnd);
            if (deSelectItems.getMessage() == null) {
                return this.reportHappyCase((String[])deSelectItems.getReturnValue());
            }
            return this.reportUnhappyCase(null, deSelectItems.needReNewDriver(), "INT154", begin, end, deSelectItems.getMessage());
        }
        catch (Exception e) {
            return this.reportUnhappyCase(null, true, "INT155", begin, end, e.getMessage());
        }
    }

    public Result unSelectIndexFromTo(int start, int end) {
        Result checkEnable = this.isEnable();
        if (checkEnable.getReturnValue().equals(true)) {
            List allOptions = this.selectEle.getOptions();
            ArrayList<String> deSelectedItems = new ArrayList<String>();
            if (start <= 0 || end < start) {
                return this.reportUnhappyCase(null, false, "INT156", new Object[0]);
            }
            int i = start;
            while (i <= end) {
                try {
                    this.selectEle.deselectByIndex(i - 1);
                    deSelectedItems.add(((WebElement)allOptions.get(i - 1)).getText());
                }
                catch (Exception e) {
                    return this.reportUnhappyCase(null, true, "INT157", Integer.toString(i), e.getMessage());
                }
                ++i;
            }
            return this.reportHappyCase(deSelectedItems.toArray(new String[0]));
        }
        return this.reportUnhappyCase(null, checkEnable.needReNewDriver(), "INT158", checkEnable.getMessage());
    }

    public Result unSelectAll() {
        try {
            int count = this.countOptions();
            Integer[] allIndex = new Integer[count];
            int i = 0;
            while (i < count) {
                allIndex[i] = i + 1;
                ++i;
            }
            Result result = this.unSelectItemsByIndex(allIndex);
            if (result.getMessage() == null) {
                return this.reportHappyCase((String[])result.getReturnValue());
            }
            return this.reportUnhappyCase(null, result.needReNewDriver(), result.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            return this.reportUnhappyCase(null, true, "INT159", e.getMessage());
        }
    }

    public Result unSelectItemsByVisibleText(String[] input) {
        Result checkEnable = this.isEnable();
        if (checkEnable.getReturnValue().equals(true)) {
            String[] stringArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                try {
                    this.selectEle.deselectByVisibleText(item);
                }
                catch (Exception e) {
                    return this.reportUnhappyCase(null, true, "INT160", item, e.getMessage());
                }
                ++n2;
            }
            return this.reportHappyCase(input);
        }
        return this.reportUnhappyCase(null, checkEnable.needReNewDriver(), "INT161", checkEnable.getMessage());
    }

    public Result unSelectItemsByValue(String[] input) {
        Result checkEnable = this.isEnable();
        if (checkEnable.getReturnValue().equals(true)) {
            String[] stringArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                try {
                    this.selectEle.deselectByValue(item);
                }
                catch (Exception e) {
                    return this.reportUnhappyCase(null, true, "INT160", item, e.getMessage());
                }
                ++n2;
            }
            return this.reportHappyCase(input);
        }
        return this.reportUnhappyCase(null, checkEnable.needReNewDriver(), "INT161", checkEnable.getMessage());
    }
}

