/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver.chromium;

import com.kms.katalon.core.webui.driver.AbstractDriverBuilder;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.FileUtil;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.chromium.ChromiumOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;

public abstract class ChromiumDriverBuilder
extends AbstractDriverBuilder {
    private static final String SMART_WAIT_ADDON_PATH = "Smart Wait.zip";
    private static final String SMART_LOCATOR_ADDON_PATH = "Smart Locator.zip";
    private static final String FLUTTER_APP_TESTING_ADDON_PATH = "Flutter-Based App Testing.zip";
    private static final String CANVAS_TEXT_EXTRACTION_ADDON_PATH = "Canvas Text Extraction.zip";
    private static final String CLOSED_SHADOW_DOM_ADDON_PATH = "Closed Shadow DOM.zip";

    @Override
    protected boolean canUseBiDi() {
        return true;
    }

    @Override
    protected AbstractDriverOptions<?> addSmartWaitExtension(AbstractDriverOptions<?> options) throws IOException {
        return this.addExtension(options, SMART_WAIT_ADDON_PATH);
    }

    @Override
    protected AbstractDriverOptions<?> addSmartLocatorExtension(AbstractDriverOptions<?> options) throws IOException {
        return this.addExtension(options, SMART_LOCATOR_ADDON_PATH);
    }

    @Override
    protected AbstractDriverOptions<?> addFlutterAppTestingExtension(AbstractDriverOptions<?> options) throws IOException {
        return this.addExtension(options, FLUTTER_APP_TESTING_ADDON_PATH);
    }

    @Override
    protected AbstractDriverOptions<?> addCanvasTextExtractionExtension(AbstractDriverOptions<?> options) throws IOException {
        return this.addExtension(options, CANVAS_TEXT_EXTRACTION_ADDON_PATH);
    }

    @Override
    protected AbstractDriverOptions<?> addClosedShadowDOMTestingExtension(AbstractDriverOptions<?> options) throws IOException {
        return this.addExtension(options, CLOSED_SHADOW_DOM_ADDON_PATH);
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractDriverOptions<?> addExtension(AbstractDriverOptions<?> options, String extensionPath) throws IOException {
        void chromiumOptions;
        boolean installedKcu = WebDriverPropertyUtil.didUserProfileInstallKatalonCompactUtility(WebUIDriverType.CHROME_DRIVER, this.capabilities);
        if (installedKcu) {
            return options;
        }
        if (!(options instanceof ChromiumOptions)) {
            return options;
        }
        ChromiumOptions chromiumOptions2 = (ChromiumOptions)options;
        File extension = new File(FileUtil.getExtensionsDirectory(), extensionPath);
        chromiumOptions.addExtensions(new File[]{extension});
        return chromiumOptions;
    }

    @Override
    protected Capabilities ignoreUnhandledPrompt(Capabilities capabilities) {
        Object currentBehavior = capabilities.getCapability("unhandledPromptBehavior");
        if (currentBehavior != null) {
            return capabilities;
        }
        Map<String, String> userPromptHandler = Map.of("alert", "ignore", "beforeUnload", "ignore", "confirm", "ignore", "default", "ignore", "file", "ignore", "prompt", "ignore");
        MutableCapabilities newCaps = new MutableCapabilities(capabilities);
        newCaps.setCapability("unhandledPromptBehavior", userPromptHandler);
        return newCaps;
    }
}

