/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.handlers;

import com.katalon.platform.api.exception.PlatformException;
import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.exceptions.JobCancelException;
import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.composer.execution.launcher.IDELauncher;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.ExtensionRequiredException;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.menu.impl.ToolControlImpl;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;

public class UIExecutionHandler {
    public void launch(final ILauncher launcher) {
        final Job job = new Job("Launching test execution"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Launching test execution...", 5);
                    monitor.subTask(StringConstants.HAND_JOB_ACTIVATING_VIEWERS);
                    UIExecutionHandler.openConsoleLog();
                    UIExecutionHandler.this.validateJobProgressMonitor(monitor);
                    monitor.worked(1);
                    monitor.subTask("Scheduling launcher...");
                    LauncherManager launcherManager = LauncherManager.getInstance();
                    launcherManager.addLauncher(launcher);
                    monitor.worked(1);
                    monitor.done();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (JobCancelException jobCancelException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    Status status = new Status(2, FrameworkUtil.getBundle(AbstractExecutionHandler.class).getSymbolicName(), e.getMessage(), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                if (event.getResult() != null && event.getResult().matches(2)) {
                    UISynchronizeService.asyncExec(() -> {
                        if (event.getResult().getException() == null) {
                            MessageDialog.openInformation(null, (String)StringConstants.WARN_TITLE, (String)event.getResult().getMessage());
                        } else {
                            MultiStatusErrorDialog.showErrorDialog((String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_SELECTED_TEST_SUITE, (String)event.getResult().getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)event.getResult().getException()));
                        }
                    });
                }
                job.removeJobChangeListener((IJobChangeListener)this);
            }
        });
    }

    public void executeTestSuite(final TestSuiteEntity testSuite, final LaunchMode launchMode, final IRunConfiguration runConfig) throws Exception {
        if (testSuite == null) {
            return;
        }
        final Job job = new Job(StringConstants.HAND_JOB_LAUNCHING_TEST_SUITE){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(StringConstants.HAND_JOB_LAUNCHING_TEST_SUITE, 5);
                    monitor.subTask(StringConstants.HAND_JOB_VALIDATING_TEST_SUITE);
                    TestSuiteExecutedEntity testSuiteExecutedEntity = new TestSuiteExecutedEntity(testSuite);
                    monitor.subTask("Preparing test cases...");
                    testSuiteExecutedEntity.prepareTestCases();
                    int totalTestCases = testSuiteExecutedEntity.getTotalTestCases();
                    if (totalTestCases > 0) {
                        monitor.subTask(StringConstants.HAND_JOB_ACTIVATING_VIEWERS);
                        UIExecutionHandler.openConsoleLog();
                        UIExecutionHandler.this.validateJobProgressMonitor(monitor);
                        monitor.worked(1);
                        monitor.subTask(StringConstants.HAND_JOB_BUILDING_SCRIPTS);
                        runConfig.build((FileEntity)testSuite, (IExecutedEntity)testSuiteExecutedEntity);
                        UIExecutionHandler.this.validateJobProgressMonitor(monitor);
                        monitor.worked(1);
                        monitor.subTask(StringConstants.HAND_JOB_LAUNCHING_TEST_SUITE);
                        LauncherManager launcherManager = LauncherManager.getInstance();
                        IDELauncher launcher = new IDELauncher(launcherManager, runConfig, launchMode);
                        launcherManager.addLauncher((ILauncher)launcher);
                        monitor.worked(1);
                        monitor.done();
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    UISynchronizeService.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.WARN_TITLE, (String)StringConstants.HAND_WARN_MSG_NO_TEST_CASE_SELECTED);
                        }
                    });
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (JobCancelException jobCancelException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (ExtensionRequiredException e) {
                    Status status = new Status(2, FrameworkUtil.getBundle(AbstractExecutionHandler.class).getSymbolicName(), e.getMessage());
                    return status;
                }
                catch (PlatformException e) {
                    Status status = new Status(2, FrameworkUtil.getBundle(AbstractExecutionHandler.class).getSymbolicName(), e.getDetailMessage(), (Throwable)e);
                    return status;
                }
                catch (Exception e) {
                    Status status = new Status(2, FrameworkUtil.getBundle(AbstractExecutionHandler.class).getSymbolicName(), e.getMessage(), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                if (event.getResult() != null && event.getResult().matches(2)) {
                    UISynchronizeService.asyncExec(() -> {
                        if (event.getResult().getException() == null) {
                            MessageDialog.openInformation(null, (String)StringConstants.WARN_TITLE, (String)event.getResult().getMessage());
                        } else {
                            MultiStatusErrorDialog.showErrorDialog((String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_SELECTED_TEST_SUITE, (String)event.getResult().getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)event.getResult().getException()));
                        }
                    });
                }
                job.removeJobChangeListener((IJobChangeListener)this);
            }
        });
    }

    public static void openConsoleLog() {
        IPreferenceStore debugUIPreferences = DebugUIPlugin.getDefault().getPreferenceStore();
        debugUIPreferences.setValue("DEBUG.consoleOpenOnErr", false);
        debugUIPreferences.setValue("DEBUG.consoleOpenOnOut", false);
        debugUIPreferences.setValue("org.eclipse.debug.ui.auto_remove_old_launches", false);
        UISynchronizeService.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ToolControlImpl toolControl;
                MPart consoleLogPart;
                EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
                MApplication application = ApplicationSingleton.getInstance().getApplication();
                List psList = modelService.findElements((MUIElement)application, null, MPerspectiveStack.class, null);
                MPartStack consolePartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.console", ((MPerspectiveStack)psList.get(0)).getSelectedElement());
                consolePartStack.getTags().remove("Minimized");
                consolePartStack.setVisible(true);
                if (!consolePartStack.isToBeRendered()) {
                    consolePartStack.setToBeRendered(true);
                }
                if ((consoleLogPart = (MPart)modelService.find("com.kms.katalon.partstack.console.log", (MUIElement)consolePartStack)) != null && consolePartStack.getSelectedElement() != consoleLogPart) {
                    consolePartStack.setSelectedElement((MUIElement)consoleLogPart);
                }
                MPartStack rightPartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.outline", (MUIElement)application);
                MPart jobViewerPart = (MPart)modelService.find("com.kms.katalon.composer.execution.part.job", (MUIElement)rightPartStack);
                if (rightPartStack.getSelectedElement() != jobViewerPart) {
                    rightPartStack.setSelectedElement((MUIElement)jobViewerPart);
                }
                if ((toolControl = (ToolControlImpl)modelService.find("com.kms.katalon.partstack.outline(com.kms.katalon.composer.window.main).(com.kms.katalon.composer.perspective.keyword)", (MUIElement)application)).getObject() != null) {
                    TrimStack trimStack = (TrimStack)toolControl.getObject();
                    trimStack.showStack(true);
                }
            }
        });
    }

    public UISynchronize getSync() {
        return UISynchronizeService.getInstance().getSync();
    }

    void validateJobProgressMonitor(IProgressMonitor monitor) throws JobCancelException {
        if (monitor.isCanceled()) {
            throw new JobCancelException();
        }
    }
}

