/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.launcher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.launcher.IDELaunchProcess;
import com.kms.katalon.composer.execution.launcher.IDELaunchShorcut;
import com.kms.katalon.composer.execution.launcher.IDEObservableLauncher;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.appium.util.AppiumVersionUtil;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.mobile.util.MobileRunConfigurationUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testcase.RecordOption;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.collector.ExecutionInfo;
import com.kms.katalon.execution.collector.ExecutionInfoCollector;
import com.kms.katalon.execution.collector.SelfHealingExecutionReport;
import com.kms.katalon.execution.collector.SelfHealingExecutionReportCollector;
import com.kms.katalon.execution.configuration.ExistingRunConfiguration;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.FeatureFileExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.launcher.ConsoleLauncher;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.execution.mobile.configuration.MobileRunConfiguration;
import com.kms.katalon.execution.mobile.util.MobileExecutionUtil;
import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.execution.setting.ReportSettingStore;
import com.kms.katalon.execution.util.ExecutionExceptionUtil;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.Project;
import com.kms.katalon.testops.core.model.AnalyticsIntegrationSetting;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.tracking.model.TestCaseTrackingInfo;
import com.kms.katalon.tracking.model.TestEntityTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteTrackingInfo;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class IDELauncher
extends ReportableLauncher
implements ILaunchListener,
IDEObservableLauncher {
    private ITestOpsController testOpsController = this.getTestOpsControllerInstance();
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private boolean observed;
    private ILaunch launch;
    private LaunchMode mode;
    private boolean launchRemoved;
    private boolean executeFromHere;

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    public IDELauncher(LauncherManager manager, IRunConfiguration runConfig, LaunchMode mode) {
        super(manager, runConfig);
        this.mode = mode;
        this.observed = false;
    }

    public IDELauncher(LauncherManager manager, IRunConfiguration runConfig, LaunchMode mode, boolean executeFromHere) {
        this(manager, runConfig, mode);
        this.executeFromHere = executeFromHere;
    }

    public ReportableLauncher clone(IRunConfiguration newConfig) {
        return new IDELauncher(this.getManager(), newConfig, this.mode);
    }

    protected ILaunchProcess launch() throws ExecutionException {
        try {
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    IFile scriptFile = GroovyUtil.getTempScriptIFile((File)IDELauncher.this.getRunConfig().getExecutionSetting().getScriptFile(), (ProjectEntity)ProjectController.getInstance().getCurrentProject());
                    if (scriptFile == null) {
                        return;
                    }
                    IDELauncher.this.launchRemoved = false;
                    HashMap<String, String> environmentVariables = new HashMap<String, String>();
                    try {
                        environmentVariables.putAll(IDELauncher.this.runConfig.getAdditionalEnvironmentVariables());
                    }
                    catch (ExecutionException | IOException e) {
                        throw new ExecutionException(e);
                    }
                    Map protectedGlobalVariables = IDELauncher.this.getProtectedGlobalVariables();
                    try {
                        String protectedGlobalVariablesString = IDELauncher.this.convertMapToString(protectedGlobalVariables, true);
                        if (StringUtils.isNotBlank((String)protectedGlobalVariablesString)) {
                            environmentVariables.put("ProtectedGlobalVariables", protectedGlobalVariablesString);
                        }
                    }
                    catch (JsonProcessingException | UnsupportedEncodingException | GeneralSecurityException e) {
                        throw new ExecutionException(e);
                    }
                    Map overridingGlobalVariables = IDELauncher.this.getOverridingGlobalVariables();
                    try {
                        String overridingGlobalVariablesString = IDELauncher.this.convertMapToString(overridingGlobalVariables, true);
                        if (StringUtils.isNotBlank((String)overridingGlobalVariablesString)) {
                            environmentVariables.put("OverridingGlobalVariables", overridingGlobalVariablesString);
                        }
                    }
                    catch (JsonProcessingException | UnsupportedEncodingException | GeneralSecurityException e) {
                        throw new ExecutionException(e);
                    }
                    Map overridingProtectedGlobalVariables = IDELauncher.this.getOverridingProtectedGlobalVariables();
                    try {
                        String overridingProtectedGlobalVariablesString = IDELauncher.this.convertMapToString(overridingProtectedGlobalVariables, true);
                        if (StringUtils.isNotBlank((String)overridingProtectedGlobalVariablesString)) {
                            environmentVariables.put("OverridingProtectedGlobalVariables", overridingProtectedGlobalVariablesString);
                        }
                    }
                    catch (JsonProcessingException | UnsupportedEncodingException | GeneralSecurityException e) {
                        throw new ExecutionException(e);
                    }
                    ILaunch expectedLaunch = new IDELaunchShorcut().launch(scriptFile, IDELauncher.this.mode, IDELauncher.this.runConfig, environmentVariables);
                    IDELauncher.this.launch = IDELauncher.this.launchRemoved ? null : expectedLaunch;
                }

                public void handleException(Throwable exception) {
                    LoggerSingleton.logError((Throwable)exception);
                    String longPathErrorMessage = ExecutionExceptionUtil.getLongPathErrorMessage((Throwable)exception);
                    if (StringUtils.isNotEmpty((String)longPathErrorMessage)) {
                        LogUtil.logError((String)longPathErrorMessage);
                    }
                }
            });
            IDELaunchProcess iDELaunchProcess = this.launch != null ? new IDELaunchProcess(this.launch, this.isUseGenerateConsoleLog(), this.getReportFolder()) : null;
            return iDELaunchProcess;
        }
        finally {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        }
    }

    protected void onStartExecutionComplete() {
        super.onStartExecutionComplete();
        this.sendUpdateLogViewerEvent(this.getId());
        if (this.runConfig instanceof ExistingRunConfiguration) {
            this.pauseExecutionSession((ExistingRunConfiguration)this.runConfig);
        }
    }

    private void pauseExecutionSession(ExistingRunConfiguration runConfig) {
        ExecutionSession executionSession = ExecutionSessionSocketServer.getInstance().getExecutionSessionBySessionAndRemoteURL(runConfig.getSessionId(), runConfig.getRemoteUrl());
        if (executionSession != null) {
            executionSession.pause();
        }
    }

    public void setStatus(LauncherStatus status, String message) {
        super.setStatus(status, message);
        this.sendUpdateJobViewerEvent();
    }

    protected void onUpdateResult(TestStatus.TestStatusValue statusValue) {
        super.onUpdateResult(statusValue);
        this.sendUpdateJobViewerEvent();
    }

    @Override
    public void setObserved(boolean observed) {
        this.observed = observed;
    }

    @Override
    public boolean isObserved() {
        return this.observed;
    }

    protected void postExecutionComplete() {
        super.postExecutionComplete();
        this.sendUpdateJobViewerEvent();
        this.eventBroker.post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
        this.updateReport();
        if (this.runConfig instanceof ExistingRunConfiguration) {
            this.resumeExecutionSession((ExistingRunConfiguration)this.runConfig);
        } else {
            this.resumeExecutionSession(this.runConfig);
        }
        this.sendTrackingEvent();
        this.notifyExecutionComplete();
    }

    protected void sendTrackingEvent() {
        if (this.getStatus() != LauncherStatus.TERMINATED) {
            File reportFolder = this.getReportFolder();
            SelfHealingExecutionReport selfHealingReport = SelfHealingExecutionReportCollector.getInstance().collect(this.runConfig, reportFolder);
            ExecutionInfo executionInfo = ExecutionInfoCollector.getInstance().collect(this.runConfig, this.getTestSuiteLogRecord(), this.getLogRecords());
            IExecutedEntity executedEntity = this.getExecutedEntity();
            boolean isAIAPITestCase = false;
            if (executedEntity instanceof TestCaseExecutedEntity) {
                TestCaseEntity testCaseEntity = (TestCaseEntity)((TestCaseExecutedEntity)executedEntity).getEntity();
                isAIAPITestCase = testCaseEntity.isAPITestGenerationTestCase();
                String resultTestcase = this.getExecutionResult();
                Trackings.trackExecuteTestCase((TestCaseTrackingInfo)this.buildTestCaseTrackingInfo(selfHealingReport, executionInfo, resultTestcase, false, RecordOption.TESTCLOUD_NATIVE_MOBILE.equals((Object)testCaseEntity.getRecordOption()), this.getTestCloudRunConfiguration(), isAIAPITestCase, testCaseEntity.getOrigin()));
            } else if (executedEntity instanceof TestCaseBindingExecutedEntity) {
                TestCaseEntity testCaseEntity = (TestCaseEntity)((TestCaseBindingExecutedEntity)executedEntity).getEntity();
                boolean isUseDataBinding = !testCaseEntity.getVariables().isEmpty() && !TestCaseController.getInstance().isNotUsingDataBinding(testCaseEntity);
                String resultTestcase = this.getExecutionResult();
                Trackings.trackExecuteTestCase((TestCaseTrackingInfo)this.buildTestCaseTrackingInfo(selfHealingReport, executionInfo, resultTestcase, isUseDataBinding, RecordOption.TESTCLOUD_NATIVE_MOBILE.equals((Object)testCaseEntity.getRecordOption()), null, isAIAPITestCase, testCaseEntity.getOrigin()));
            } else if (executedEntity instanceof TestSuiteExecutedEntity) {
                TestSuiteExecutedEntity tsExecutedEntity = (TestSuiteExecutedEntity)executedEntity;
                Trackings.trackExecuteTestSuiteInGuiMode((TestSuiteTrackingInfo)this.buildTestSuiteTrackingInfo(tsExecutedEntity, selfHealingReport, executionInfo, this.getTestCloudRunConfiguration(), this.getTestCloudRecorderTestCaseCount(tsExecutedEntity.getExecutedItems()), this.getAIAPITestCaseCount(tsExecutedEntity.getExecutedItems()), this.getTestSuiteLogRecord()));
            } else if (executedEntity instanceof FeatureFileExecutedEntity) {
                String resultFeatureFile = this.getExecutionResult();
                Trackings.trackExecuteFeatureFile((String)this.mode.toString(), (String)this.runConfig.getReportDriverName(), (String)resultFeatureFile, (long)(this.getEndTime().getTime() - this.getStartTime().getTime()), (boolean)selfHealingReport.isEnabled(), (boolean)selfHealingReport.isTriggered(), (String)selfHealingReport.getHealingInfo(), (Map)executionInfo.getKeywordsUsage());
            }
        }
    }

    private int getTestCloudRecorderTestCaseCount(List<IExecutedEntity> executedItems) {
        int count = 0;
        for (IExecutedEntity executed : executedItems) {
            TestCaseEntity entity;
            TestCaseExecutedEntity testCaseExecuted;
            FileEntity fileEntity;
            if (!(executed instanceof TestCaseExecutedEntity) || !((fileEntity = (testCaseExecuted = (TestCaseExecutedEntity)executed).getEntity()) instanceof TestCaseEntity) || !RecordOption.TESTCLOUD_NATIVE_MOBILE.equals((Object)(entity = (TestCaseEntity)fileEntity).getRecordOption())) continue;
            ++count;
        }
        return count;
    }

    private int getAIAPITestCaseCount(List<IExecutedEntity> executedItems) {
        int count = 0;
        for (IExecutedEntity executed : executedItems) {
            TestCaseEntity entity;
            TestCaseExecutedEntity testCaseExecuted;
            FileEntity fileEntity;
            if (!(executed instanceof TestCaseExecutedEntity) || !((fileEntity = (testCaseExecuted = (TestCaseExecutedEntity)executed).getEntity()) instanceof TestCaseEntity) || !(entity = (TestCaseEntity)fileEntity).isAPITestGenerationTestCase()) continue;
            ++count;
        }
        return count;
    }

    private Boolean isTestCloudTunnelEnabled(IRunConfiguration runConfiguration) {
        Boolean isUsingTestCloudTunnel = null;
        if (runConfiguration.getAdditionalInfo().containsKey("isUsingTestCloudTunnel")) {
            isUsingTestCloudTunnel = Boolean.valueOf((String)runConfiguration.getAdditionalInfo().get("isUsingTestCloudTunnel"));
        }
        return isUsingTestCloudTunnel;
    }

    protected String getExecutionResult() {
        String resultExecution = null;
        resultExecution = this.getResult().getNumFailures() > 0 ? TestStatus.TestStatusValue.FAILED.toString() : (this.getResult().getNumErrors() > 0 ? TestStatus.TestStatusValue.ERROR.toString() : TestStatus.TestStatusValue.PASSED.toString());
        return resultExecution;
    }

    private void resumeExecutionSession(IRunConfiguration runConfig) {
        ExecutionSession executionSession = ExecutionSessionSocketServer.getInstance().getExecutionSessionByLogFolderPath(runConfig.getExecutionSetting().getFolderPath());
        if (executionSession != null) {
            executionSession.resume();
        }
    }

    private void resumeExecutionSession(ExistingRunConfiguration runConfig) {
        ExecutionSession executionSession = ExecutionSessionSocketServer.getInstance().getExecutionSessionBySessionAndRemoteURL(runConfig.getSessionId(), runConfig.getRemoteUrl());
        if (executionSession != null) {
            executionSession.resume();
        }
    }

    protected void updateReport() {
        try {
            if (this.getTestSuite() == null || this.getStatus() != LauncherStatus.DONE) {
                return;
            }
            ReportEntity report = ReportController.getInstance().getReportEntity(this.getTestSuite(), this.getId(), this.getRunConfig().getExecutionSessionId());
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", null);
            if (ExecutionDefaultSettingStore.getStore().isPostExecOpenReport()) {
                this.eventBroker.post("REPORT/OPEN", (Object)report);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void updateLastRun(Date startTime) throws Exception {
        super.updateLastRun(startTime);
        TestSuiteEntity testSuite = this.getTestSuite();
        this.eventBroker.send("TESTSUITE/UPDATED", (Object)new Object[]{testSuite.getId(), testSuite});
    }

    public void clean() {
        try {
            IDELaunchShorcut.cleanConfiguration(this.getLaunch());
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            IFile scriptFile = GroovyUtil.getTempScriptIFile((File)this.getRunConfig().getExecutionSetting().getScriptFile(), (ProjectEntity)currentProject);
            if (scriptFile == null) {
                return;
            }
            scriptFile.delete(true, null);
            IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)currentProject);
            libFolder.refreshLocal(1, null);
            if (this.isObserved()) {
                this.sendUpdateLogViewerEvent(null);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void sendUpdateLogViewerEvent(String message) {
        this.eventBroker.send("CONSOLE_LOG/RESET", (Object)message);
    }

    protected void sendUpdateJobViewerEvent() {
        this.eventBroker.post("JOB/REFRESH", null);
    }

    protected void notifyExecutionComplete() {
        this.eventBroker.post("JOB/COMPLETED", (Object)this.getId());
    }

    protected synchronized void writeError(String line) {
        LogUtil.logErrorMessage((String)line);
    }

    private boolean isExpectedLaunch(ILaunch launch) {
        String expectedName = FilenameUtils.getBaseName((String)this.getRunConfig().getExecutionSetting().getScriptFile().getName());
        ILaunchConfiguration launchConfig = launch.getLaunchConfiguration();
        return launchConfig != null && expectedName.equals(launchConfig.getName());
    }

    @Override
    public LaunchMode getMode() {
        return this.mode;
    }

    public void launchRemoved(ILaunch launch) {
        if (this.isExpectedLaunch(launch)) {
            this.launchRemoved = true;
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    @Override
    public void suspend() {
        try {
            this.getLaunch().getDebugTarget().suspend();
            this.onSuspended();
        }
        catch (DebugException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void onSuspended() {
        this.setStatus(LauncherStatus.SUSPENDED);
        this.sendUpdateJobViewerEvent();
    }

    @Override
    public void resume() {
        try {
            this.getLaunch().getDebugTarget().resume();
            this.setStatus(LauncherStatus.RUNNING);
            this.sendUpdateJobViewerEvent();
        }
        catch (DebugException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    public String getDisplayMessage() {
        String currentStatusMessage = this.getMessage();
        String displayMessage = StringUtils.isNotEmpty((String)currentStatusMessage) ? currentStatusMessage : this.getStatus().toString();
        return "<" + displayMessage + "> - " + this.getRunConfig().getName();
    }

    protected void onStartExecution() {
        this.eventBroker.post("JOB/REFRESH", (Object)this.getId());
        this.eventBroker.send("CONSOLE_LOG/RESET", (Object)this.getId());
        super.onStartExecution();
    }

    private TestCaseTrackingInfo buildTestCaseTrackingInfo(SelfHealingExecutionReport selfHealingExecutionReport, ExecutionInfo executionInfo, String resultTestcase, boolean isUseDataBinding, boolean isRecordedWithTestCloud, String testCloudRunConfiguration, boolean isAIAPITestCase, String origin) {
        String remoteDomainUrl = this.runConfig.getRemoteDomain();
        TestCaseTrackingInfo trackingInfo = new TestCaseTrackingInfo();
        trackingInfo.setLaunchMode(this.mode.toString());
        trackingInfo.setDriverType(this.runConfig.getReportDriverName());
        trackingInfo.setResult(resultTestcase);
        trackingInfo.setDuration(this.getEndTime().getTime() - this.getStartTime().getTime());
        trackingInfo.setEnableSelfHealing(selfHealingExecutionReport.isEnabled());
        trackingInfo.setTriggerSelfHealing(selfHealingExecutionReport.isTriggered());
        trackingInfo.setHealingInfo(selfHealingExecutionReport.getHealingInfo());
        trackingInfo.setExecuteFromHere(this.executeFromHere);
        trackingInfo.setKeywordsUsage(executionInfo.getKeywordsUsage());
        trackingInfo.setUsingApplitools(executionInfo.isUsingApplitools());
        trackingInfo.setUseDataBinding(isUseDataBinding);
        trackingInfo.setRecordedWithTestCloud(isRecordedWithTestCloud);
        trackingInfo.setTestCloudRunConfiguration(testCloudRunConfiguration);
        trackingInfo.setAIAPITestCase(isAIAPITestCase);
        trackingInfo.setRemoteDomain(remoteDomainUrl);
        trackingInfo.setOrigin(origin);
        this.addAppiumInfoForTracking((TestEntityTrackingInfo)trackingInfo);
        this.addIntegrationSettingInfoForTracking((TestEntityTrackingInfo)trackingInfo);
        ExecutionDefaultSettingStore executionStore = ExecutionDefaultSettingStore.getStore();
        if (executionStore != null) {
            trackingInfo.setSmartWaitEnabled(executionStore.isSmartWaitEnabled());
        }
        return trackingInfo;
    }

    private void addAppiumInfoForTracking(TestEntityTrackingInfo trackInfo) {
        boolean isMobileCustomRunConfig = MobileRunConfigurationUtil.usingCustomRunConfigurationId((String)this.runConfig.getName(), (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        if (this.runConfig instanceof MobileRunConfiguration || isMobileCustomRunConfig) {
            String appiumDir = this.runConfig instanceof MobileRunConfiguration ? ((MobileRunConfiguration)this.runConfig).getAppiumDir() : MobileExecutionUtil.findAppiumDir();
            String appiumVersion = AppiumVersionUtil.readVersionFromFile((String)appiumDir);
            trackInfo.setAppiumVersion(appiumVersion);
        }
    }

    private TestSuiteTrackingInfo buildTestSuiteTrackingInfo(TestSuiteExecutedEntity tsExecutedEntity, SelfHealingExecutionReport selfHealingExecutionReport, ExecutionInfo executionInfo, String testCloudRunConfiguration, int numTestCloudRecorderTestCase, int numberOfAIAPITestCase, TestSuiteLogRecord testSuiteLogRecord) {
        boolean isInTestSuiteCollection = tsExecutedEntity.isInCollection();
        boolean isDynamicTestSuite = tsExecutedEntity.getEntity() != null ? tsExecutedEntity.getEntity() instanceof FilteringTestSuiteEntity : false;
        String resultTestSuite = this.getExecutionResult();
        int numberOfEmailsSent = MailUtil.getNumberOfEmailsSentForTestSuite((boolean)this.getAreEmailsSent(), (TestSuiteExecutedEntity)((TestSuiteExecutedEntity)this.getExecutedEntity()), (TestSuiteLogRecord)this.getTestSuiteLogRecord());
        TestSuiteTrackingInfo trackingInfo = new TestSuiteTrackingInfo();
        trackingInfo.setLaunchMode(this.mode.toString());
        trackingInfo.setDriverType(this.runConfig.getReportDriverName());
        trackingInfo.setResult(resultTestSuite);
        trackingInfo.setDuration(this.getEndTime().getTime() - this.getStartTime().getTime());
        trackingInfo.setRetryStrategy(this.getRetryStrategy());
        trackingInfo.setNumberOfRetry(this.getNumberOfRetry());
        trackingInfo.setEnableSelfHealing(selfHealingExecutionReport.isEnabled());
        trackingInfo.setTriggerSelfHealing(selfHealingExecutionReport.isTriggered());
        trackingInfo.setHealingInfo(selfHealingExecutionReport.getHealingInfo());
        trackingInfo.setTotalTestCases(this.getResult().getTotalTestCases());
        trackingInfo.setPassedTestCases(this.getResult().getNumPasses());
        trackingInfo.setFailedTestCases(this.getResult().getNumFailures());
        trackingInfo.setErrorTestCases(this.getResult().getNumErrors());
        trackingInfo.setSkippedTestCases(this.getResult().getNumSkips());
        trackingInfo.setIncompleteTestCases(this.getResult().getNumIncomplete());
        ApplicationContext context = ApplicationContext.getInstance();
        Organization organization = context.getOrganization();
        if (Objects.nonNull(organization)) {
            trackingInfo.setOrgId(organization.getId());
        }
        trackingInfo.setInCollection(isInTestSuiteCollection);
        trackingInfo.setEnableScreenshot(executionInfo.isEnableScreenshot());
        trackingInfo.setEnableHideHostname(ExecutionUtil.isEnabledHideHostname().booleanValue());
        trackingInfo.setEnableVideo(executionInfo.isEnableScreenshot());
        trackingInfo.setVideoRecordingLevel(executionInfo.getVideoRecordingLevel());
        trackingInfo.setNumTestSteps(this.getNumTestSteps());
        trackingInfo.setAdditionalProps(this.getIntegratedContributionsTrackingData());
        trackingInfo.setKeywordsUsage(executionInfo.getKeywordsUsage());
        trackingInfo.setExecutedTestCaseKeywordTypes(executionInfo.getExecutedTestCaseKeywordTypes());
        trackingInfo.setExecutedKeywordNames(executionInfo.getExecutedKeywordNames());
        trackingInfo.setUsingApplitools(executionInfo.isUsingApplitools());
        trackingInfo.setUseDataBinding(tsExecutedEntity.isUseDdtAtTCLevel());
        trackingInfo.setDynamicTestSuite(isDynamicTestSuite);
        trackingInfo.setIsTestCloudTunnelEnabled((Object)this.isTestCloudTunnelEnabled(this.runConfig));
        trackingInfo.setNumberOfEmailsSent(numberOfEmailsSent);
        trackingInfo.setTestCloudRunConfiguration(testCloudRunConfiguration);
        trackingInfo.setTestSuiteCollectionId(tsExecutedEntity.getTestSuiteCollectionId());
        trackingInfo.setTestcloudRecorderTestCaseCount(numTestCloudRecorderTestCase);
        trackingInfo.setNumberOfAIAPITestCase(numberOfAIAPITestCase);
        trackingInfo.setReportGenerationTypes(this.getReportGenerationTypes());
        trackingInfo.setSuiteTestCaseDataBinding(ExecutionUtil.hasSuiteTestCaseDataBinding((TestSuiteExecutedEntity)tsExecutedEntity));
        trackingInfo.setOrigin(testSuiteLogRecord.getOrigin());
        String remoteDomainUrl = this.runConfig.getRemoteDomain();
        if (StringUtils.isNotBlank((String)remoteDomainUrl)) {
            trackingInfo.setRemoteDomain(remoteDomainUrl);
        }
        this.addAppiumInfoForTracking((TestEntityTrackingInfo)trackingInfo);
        this.addIntegrationSettingInfoForTracking((TestEntityTrackingInfo)trackingInfo);
        ExecutionDefaultSettingStore executionStore = ExecutionDefaultSettingStore.getStore();
        if (executionStore != null) {
            trackingInfo.setSmartWaitEnabled(executionStore.isSmartWaitEnabled());
        }
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        trackingInfo.setAIEmailReport(MailUtil.isAnalyzeFailedReasonByAI((ProjectEntity)currentProject));
        try {
            trackingInfo.setAIHtmlReport(ReportSettingStore.getStore().useAnalyzeFailedReasonByAI());
        }
        catch (IOException iOException) {}
        return trackingInfo;
    }

    private void addIntegrationSettingInfoForTracking(TestEntityTrackingInfo trackInfo) {
        String analyticsProjectId = "";
        String analyticsAccountId = "";
        AnalyticsIntegrationSetting integratedSetting = this.testOpsController.getRequestOptions().getIntegratedSetting();
        if (integratedSetting != null) {
            Project project = integratedSetting.getProject();
            analyticsProjectId = project != null ? project.getId().toString() : "";
            analyticsAccountId = project != null ? project.getAccountId().toString() : "";
        }
        trackInfo.setTestOpsProjectId(analyticsProjectId);
        trackInfo.setTestOpsAccountId(analyticsAccountId);
        trackInfo.setTestCloudProjectId(analyticsProjectId);
        trackInfo.setTestCloudAccountId(analyticsAccountId);
    }

    private ITestOpsController getTestOpsControllerInstance() {
        if (this.testOpsController == null) {
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(ConsoleLauncher.class).getBundleContext());
            this.testOpsController = (ITestOpsController)context.get(ITestOpsController.class);
        }
        return this.testOpsController;
    }
}

