/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.equo.chromium.swt.Browser;
import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.EmailTemplateConfigurationTrackingInfo;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.webserver.WebViewController;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class EmailTemplatePage
extends PreferencePageWithHelp {
    public static final String TYPE_TEST_SUITE = "TEST_SUITE";
    public static final String TYPE_TEST_SUITE_COLLECTION = "TEST_SUITE_COLLECTION";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([^}]+)\\}");
    private Browser browser;
    private String type;

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.browser = (Browser)ComponentBuilder.browser((Composite)this.initBrowserComposite(parent)).build();
        this.browser.setJavascriptEnabled(true);
        this.loadEditorContent(false);
        Button previewButton = new Button(parent, 8);
        previewButton.setText("Preview");
        previewButton.setLayoutData((Object)this.configureButtonLayout());
        previewButton.addListener(13, e -> this.onPreview());
        return this.browser;
    }

    private Composite initBrowserComposite(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        composite.setLayout((Layout)new FillLayout());
        return composite;
    }

    private GridData configureButtonLayout() {
        GridData gd = new GridData(1, 4, true, false, 2, 1);
        gd.widthHint = 100;
        return gd;
    }

    private void onPreview() {
        try {
            this.save();
            this.trackConfig(true, false, this.extractVariables(this.getHTMLTemplate()));
            String rawHtml = this.getHtmlMessage();
            String evaluated = GroovyStringUtil.evaluate((String)rawHtml, (Map)EmailVariableBinding.getTestEmailVariables());
            File previewFile = this.writeTempHtml(evaluated);
            this.openInBrowser(previewFile);
        }
        catch (Exception ex) {
            this.reportError(ex);
        }
    }

    protected void performDefaults() {
        try {
            this.loadEditorContent(true);
            this.trackConfig(false, true, this.extractVariables(this.getHTMLTemplate()));
        }
        catch (Exception ex) {
            this.reportError(ex);
        }
    }

    public boolean performOk() {
        if (!this.isControlCreated()) {
            return true;
        }
        try {
            this.save();
            this.trackConfig(false, false, this.extractVariables(this.getHTMLTemplate()));
            return true;
        }
        catch (Exception ex) {
            this.reportError(ex);
            return false;
        }
    }

    private void loadEditorContent(boolean defaults) {
        String query = MessageFormat.format("type={0}&setDefaults={1}", this.type, defaults);
        this.browser.setUrl(WebViewController.getInstance().getPage("EmailTemplatePage.html?" + query));
    }

    protected String getHtmlMessage() {
        String body = (String)this.browser.evaluate("return tinymce.activeEditor.getContent({ format: 'html' });");
        return "<html><body>" + body + "</body></html>";
    }

    private File writeTempHtml(String content) throws IOException {
        File file = File.createTempFile("email_template_preview", ".html");
        file.deleteOnExit();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileWriter writer = new FileWriter(file);){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return file;
    }

    private void openInBrowser(File file) throws IOException {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(file.toURI());
        }
    }

    private void trackConfig(boolean preview, boolean restoreDefaults, Set<String> vars) {
        EmailTemplateConfigurationTrackingInfo info = new EmailTemplateConfigurationTrackingInfo();
        info.setPreviewClicked(preview);
        info.setRetoreDefault(restoreDefaults);
        info.setModifyEmailTemplate(!preview && !restoreDefaults);
        if (vars != null && !vars.isEmpty()) {
            info.setEmailVariablesUsed(vars.stream().map(String::trim).collect(Collectors.joining(", ")));
        }
        try {
            if (TYPE_TEST_SUITE.equals(this.type)) {
                Trackings.trackTestSuiteEmailTemplateConfiguration((EmailTemplateConfigurationTrackingInfo)info);
            } else {
                Trackings.trackTestSuiteCollectionEmailTemplateConfiguration((EmailTemplateConfigurationTrackingInfo)info);
            }
        }
        catch (Exception e) {
            LogUtil.logError((String)"Failed to track email template configuration");
            LogUtil.logError((Throwable)e);
        }
    }

    private Set<String> extractVariables(String template) {
        Matcher matcher = VARIABLE_PATTERN.matcher(template);
        LinkedHashSet<String> vars = new LinkedHashSet<String>();
        while (matcher.find()) {
            vars.add(matcher.group(1));
        }
        vars.remove("status_color");
        vars.remove("status_bg_color");
        return vars;
    }

    private void reportError(Exception ex) {
        MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)StringConstants.ERROR_TITLE, (String)ex.getMessage());
        LoggerSingleton.logError((Throwable)ex);
    }

    protected abstract String getHTMLTemplate() throws Exception;

    protected abstract String getDefaultHTMLTemplate() throws Exception;

    protected abstract void save() throws Exception;

    public void setType(String type) {
        this.type = type;
    }
}

