/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExperimentalApi;
import graphql.PublicSpi;
import graphql.execution.ExecutionContext;
import graphql.execution.instrumentation.DocumentAndVariables;
import graphql.execution.instrumentation.ExecuteObjectInstrumentationContext;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.FieldFetchingInstrumentationContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.language.Document;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicSpi
public interface Instrumentation {
    @Nullable
    default public CompletableFuture<InstrumentationState> createStateAsync(InstrumentationCreateStateParameters parameters) {
        InstrumentationState state = this.createState(parameters);
        return state == null ? null : CompletableFuture.completedFuture(state);
    }

    @Nullable
    default public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return null;
    }

    @Nullable
    default public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return SimpleInstrumentationContext.noOp();
    }

    @Nullable
    default public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return SimpleInstrumentationContext.noOp();
    }

    @Nullable
    default public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters, InstrumentationState state) {
        return SimpleInstrumentationContext.noOp();
    }

    @Nullable
    default public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters, InstrumentationState state) {
        return SimpleInstrumentationContext.noOp();
    }

    @Nullable
    default public ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters, InstrumentationState state) {
        return ExecutionStrategyInstrumentationContext.NOOP;
    }

    @Nullable
    default public ExecuteObjectInstrumentationContext beginExecuteObject(InstrumentationExecutionStrategyParameters parameters, InstrumentationState state) {
        return ExecuteObjectInstrumentationContext.NOOP;
    }

    @ExperimentalApi
    default public InstrumentationContext<Object> beginDeferredField(InstrumentationState state) {
        return SimpleInstrumentationContext.noOp();
    }

    @Nullable
    default public InstrumentationContext<ExecutionResult> beginSubscribedFieldEvent(InstrumentationFieldParameters parameters, InstrumentationState state) {
        return SimpleInstrumentationContext.noOp();
    }

    @Nullable
    default public InstrumentationContext<Object> beginFieldExecution(InstrumentationFieldParameters parameters, InstrumentationState state) {
        return SimpleInstrumentationContext.noOp();
    }

    @Deprecated(since="2024-04-18")
    @Nullable
    default public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        return SimpleInstrumentationContext.noOp();
    }

    @Nullable
    default public FieldFetchingInstrumentationContext beginFieldFetching(InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        InstrumentationContext<Object> ctx = this.beginFieldFetch(parameters, state);
        return FieldFetchingInstrumentationContext.adapter(ctx);
    }

    @Nullable
    default public InstrumentationContext<Object> beginFieldCompletion(InstrumentationFieldCompleteParameters parameters, InstrumentationState state) {
        return SimpleInstrumentationContext.noOp();
    }

    @Nullable
    default public InstrumentationContext<Object> beginFieldListCompletion(InstrumentationFieldCompleteParameters parameters, InstrumentationState state) {
        return SimpleInstrumentationContext.noOp();
    }

    @NotNull
    default public ExecutionInput instrumentExecutionInput(ExecutionInput executionInput, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return executionInput;
    }

    @NotNull
    default public DocumentAndVariables instrumentDocumentAndVariables(DocumentAndVariables documentAndVariables, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return documentAndVariables;
    }

    @NotNull
    default public GraphQLSchema instrumentSchema(GraphQLSchema schema, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return schema;
    }

    @NotNull
    default public ExecutionContext instrumentExecutionContext(ExecutionContext executionContext, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return executionContext;
    }

    @NotNull
    default public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        return dataFetcher;
    }

    @NotNull
    default public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return CompletableFuture.completedFuture(executionResult);
    }
}

