/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.application;

import com.katalon.mobile.core.enums.MobileProvider;
import com.katalon.recorder.core.constant.AttributeConditionOperator;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.domain.exception.RecorderPreferencesException;
import com.katalon.recorder.core.domain.exception.RecordingException;
import com.katalon.recorder.core.domain.model.CapturedObjectAttribute;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.ICapturedObjectAttribute;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.mobile.core.application.IMobileRecorderSession;
import com.katalon.recorder.mobile.core.application.IMobileRecorderSessionContext;
import com.katalon.recorder.mobile.core.domain.IMobileRecorderManager;
import com.katalon.recorder.mobile.core.models.CustomProviderConfiguration;
import com.katalon.recorder.mobile.core.models.IMobileCapturedObject;
import com.katalon.recorder.mobile.core.models.IMobileRecordingConnection;
import com.katalon.recorder.mobile.core.models.MobileProviderConfiguration;
import com.katalon.recorder.mobile.core.models.MobileRecorderConfiguration;
import com.katalon.recorder.mobile.core.models.MobileRecorderSession;
import com.katalon.recorder.mobile.core.models.MobileSaveTestCaseRequest;
import com.katalon.recorder.mobile.core.models.MobileWebElement;
import com.katalon.recorder.mobile.core.models.RemoteProviderConfiguration;
import com.katalon.recorder.mobile.utils.MobileWebElementConverter;
import com.kms.katalon.composer.mobile.objectspy.dialog.AddElementToObjectRepositoryDialogV2;
import com.kms.katalon.composer.mobile.objectspy.dialog.SaveTestCaseDialog;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileRecorderSessionContext
implements IMobileRecorderSessionContext {
    private Logger logger = LoggerFactory.getLogger(MobileRecorderSessionContext.class);
    public static final String CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH = PropertySettingStoreUtil.EXTERNAL_SETTING_ROOT_FOLDER_NAME + File.separator + "execution";
    @Inject
    private IMobileRecorderManager manager;
    private MobileRecorderConfiguration configuration;
    private IMobileRecorderSession session;
    private Thread heartbeatThread;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final int DEFAULT_NEW_COMMAND_TIMEOUT = 60;

    public IMobileRecorderSession getSession() {
        return this.session;
    }

    public void addObject(ICapturedObject object) {
        this.session.addObject(object);
    }

    public void addStep(IStep step) {
        this.session.addStep(step);
    }

    public MobileProvider getActiveProvider() {
        return this.configuration.getActiveProvider();
    }

    public MobileProviderConfiguration getActiveProviderConfiguration() {
        MobileProvider activeProvider = this.getActiveProvider();
        if (MobileProvider.REMOTE.equals((Object)activeProvider)) {
            RemoteProviderConfiguration remoteProviderConfiguration = this.getRemoteProviderConfiguration();
            MobileProviderConfiguration mobileConfiguration = this.configuration.getProviderConfiguration(activeProvider);
            remoteProviderConfiguration.setApplicationMode(mobileConfiguration.getApplicationMode());
            remoteProviderConfiguration.setApplicationPath(mobileConfiguration.getApplicationPath());
            remoteProviderConfiguration.setApplicationId(mobileConfiguration.getApplicationId());
            remoteProviderConfiguration.setTimeout(mobileConfiguration.getTimeout());
            this.configuration.setProviderConfiguration(activeProvider, (MobileProviderConfiguration)remoteProviderConfiguration);
        } else if (MobileProvider.CUSTOM.equals((Object)activeProvider)) {
            CustomProviderConfiguration customProviderConfiguration = this.getCustomProviderConfiguration();
            MobileProviderConfiguration mobileConfiguration = this.configuration.getProviderConfiguration(activeProvider);
            customProviderConfiguration.setApplicationMode(mobileConfiguration.getApplicationMode());
            customProviderConfiguration.setApplicationPath(mobileConfiguration.getApplicationPath());
            customProviderConfiguration.setApplicationId(mobileConfiguration.getApplicationId());
            customProviderConfiguration.setTimeout(mobileConfiguration.getTimeout());
            this.configuration.setProviderConfiguration(activeProvider, (MobileProviderConfiguration)customProviderConfiguration);
        }
        return this.configuration.getProviderConfiguration(activeProvider);
    }

    public MobileRecorderConfiguration getConfiguration() throws RecorderPreferencesException {
        if (this.configuration.getProvidersConfiguration() != null) {
            this.configuration.getProvidersConfiguration().put(MobileProvider.REMOTE, this.getRemoteProviderConfiguration());
            this.configuration.getProvidersConfiguration().put(MobileProvider.CUSTOM, this.getCustomProviderConfiguration());
        }
        return this.configuration;
    }

    private RemoteProviderConfiguration getRemoteProviderConfiguration() {
        return this.manager.getRemoteProviderConfiguration();
    }

    private CustomProviderConfiguration getCustomProviderConfiguration() {
        return this.manager.getCustomProviderConfiguration();
    }

    public void initialize() throws RecorderPreferencesException {
        this.configuration = this.manager.loadConfiguration();
    }

    public boolean isRecordingPaused() {
        return this.session.isRecordingPaused();
    }

    public void onRecordingStarted(IMobileRecordingConnection connection) {
        this.session = new MobileRecorderSession();
        this.session.addMobileRecordingConnection(connection);
        this.startHeartbeat();
    }

    public void onRecordingStopped() {
        this.stopHeartbeat();
    }

    public void pauseRecording(String recordingConnectionId) {
        this.session.pauseRecording(recordingConnectionId);
    }

    public void resumeRecording(String recordingConnectionId) {
        this.session.resumeRecording(recordingConnectionId);
    }

    public void updateActiveMobileDeviceProvider(MobileProvider provider) throws RecorderPreferencesException {
        this.configuration.setActiveProvider(provider);
        this.saveConfiguration(this.configuration);
    }

    public void updateMobileRecorderConfiguration(MobileRecorderConfiguration newConfiguration) throws RecorderPreferencesException {
        if (newConfiguration == null) {
            throw new IllegalArgumentException("Mobile Recorder Configuration cannot be null");
        }
        if (newConfiguration.getActiveProvider() == null) {
            throw new IllegalArgumentException("Active provider cannot be null");
        }
        if (newConfiguration.getProvidersConfiguration() == null) {
            throw new IllegalArgumentException("Providers configuration cannot be null");
        }
        if (newConfiguration.getProvidersConfiguration().isEmpty()) {
            throw new IllegalArgumentException("Providers configuration cannot be empty");
        }
        this.configuration = newConfiguration;
        this.saveConfiguration(this.configuration);
    }

    private void saveConfiguration(MobileRecorderConfiguration configuration) throws RecorderPreferencesException {
        this.configuration = configuration;
        this.manager.saveConfiguration(configuration);
    }

    private void startHeartbeat() {
        if (this.heartbeatThread == null) {
            int newCommandTimeout = 60;
            try {
                newCommandTimeout = this.manager.getNewCommandTimeout();
                if (newCommandTimeout <= 0) {
                    newCommandTimeout = 60;
                }
            }
            catch (RecordingException recordingException) {}
            int heartbeatTimeout = newCommandTimeout / 2 * 1000;
            this.heartbeatThread = new Thread(() -> {
                while (this.running.get()) {
                    try {
                        this.manager.heartbeat();
                        Thread.sleep(heartbeatTimeout);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (Exception e) {
                        this.logger.error("Heartbeat error: " + e.getMessage());
                    }
                }
            }, "Driver-Heartbeat-Thread");
            this.heartbeatThread.setDaemon(true);
            this.heartbeatThread.start();
        }
    }

    private void stopHeartbeat() {
        this.running.set(false);
        if (this.heartbeatThread != null) {
            this.heartbeatThread.interrupt();
        }
    }

    public List<IStep> getSteps() {
        return this.session.getSteps();
    }

    public void setSteps(IStep[] steps) {
        this.session.setSteps(steps);
    }

    public List<ICapturedObject> getObjects() {
        return this.session.getObjects();
    }

    public void saveTestCase(MobileSaveTestCaseRequest saveTestCaseRequest) {
        saveTestCaseRequest.setSteps(this.getSteps());
        saveTestCaseRequest.setVariables(this.getVariables());
        this.manager.saveTestCase(saveTestCaseRequest);
    }

    public List<IVariable> getVariables() {
        return this.session.getVariables();
    }

    public void setVariables(IVariable[] variables) {
        this.session.setVariables(variables);
    }

    public SaveTestCaseDialog.ExportTestCaseSelectionResult openSaveTestCaseDialog() throws RecordingException {
        return this.manager.openSaveTestCaseDialog();
    }

    public AddElementToObjectRepositoryDialogV2.AddToObjectRepositoryDialogResult openSaveTestObjectDialog() throws RecordingException {
        return this.manager.openSaveTestObjectDialog(this.getObjects());
    }

    public CompletableFuture<List<MobileWebElement>> verifyObjectAsync(String id, LocatorType locatorType) {
        IMobileCapturedObject object = (IMobileCapturedObject)this.findObject(id);
        if (object == null) {
            return CompletableFuture.failedFuture((Throwable)new NoSuchElementException("Object not found for id: " + id));
        }
        return this.manager.findElementsByLocatorTypeAsync((ICapturedObject)object, locatorType).thenApply(webElements -> webElements.stream().map(e -> MobileWebElementConverter.toMobileWebElement(e, object.getDevicePlatform())).collect(Collectors.toList()));
    }

    public CompletableFuture<ICapturedObject> takeScreenshotAsync(String id) {
        ICapturedObject object = this.findObject(id);
        if (object == null) {
            return CompletableFuture.failedFuture((Throwable)new NoSuchElementException("Object not found for id: " + id));
        }
        return this.manager.findElementsByDefaultLocatorAsync(object).thenCompose(webElements -> {
            if (webElements.isEmpty()) {
                return CompletableFuture.failedFuture((Throwable)new NoSuchElementException("No elements found for object id: " + id));
            }
            WebElement element = (WebElement)webElements.get(0);
            return this.manager.captureElementScreenshot(element).thenCompose(image -> {
                CapturedObjectAttribute imageAttribute = new CapturedObjectAttribute("image", AttributeConditionOperator.EQUALS, image, Boolean.valueOf(true));
                object.addAttribute((ICapturedObjectAttribute)imageAttribute);
                return this.manager.resetLocatorAsync(object, LocatorType.IMAGE);
            });
        });
    }

    public CompletableFuture<ICapturedObject> resetLocatorAsync(String id, LocatorType locatorType) {
        ICapturedObject object = this.findObject(id);
        if (object == null) {
            return CompletableFuture.failedFuture((Throwable)new NoSuchElementException("Object not found for id: " + id));
        }
        return this.manager.resetLocatorAsync(object, locatorType);
    }

    public CompletableFuture<ICapturedObject> makeDefaultLocatorAsync(String id, LocatorType locatorType) {
        ICapturedObject object = this.findObject(id);
        if (object == null) {
            return CompletableFuture.failedFuture((Throwable)new NoSuchElementException("Object not found for id: " + id));
        }
        return this.manager.setDefaultLocatorAsync(object, locatorType);
    }

    ICapturedObject findObject(String id) {
        return this.session.getObjects().stream().filter(obj -> id.equals(obj.getId())).findFirst().orElse(null);
    }
}

