/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.models.dto;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.mobile.core.enums.MobileDevicePlatform;
import com.katalon.recorder.core.constant.ParameterType;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.KeywordStep;
import com.katalon.recorder.core.domain.model.KeywordStepArgument;
import com.katalon.recorder.mobile.core.enums.MobileAction;
import com.katalon.recorder.mobile.core.interfaces.IMobileActionRequest;
import com.katalon.recorder.mobile.core.models.MobileWebElement;
import com.katalon.recorder.mobile.models.dto.MobileSetEncryptedTextRequest;
import com.katalon.recorder.mobile.utils.MobileWebElementConverter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="action", visible=true, defaultImpl=MobileActionRequest.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=MobileSetEncryptedTextRequest.class, name="SET_ENCRYPTED_TEXT")})
public class MobileActionRequest
implements IMobileActionRequest {
    protected final Logger logger = LoggerFactory.getLogger(MobileActionRequest.class);
    private String id;
    private MobileAction action;
    private MobileDevicePlatform devicePlatform;
    private List<KeywordStepArgument> arguments;

    private List<Object> convertToStepArguments(List<Object> objects) {
        return objects.stream().map(obj -> {
            Object object;
            if (obj instanceof ICapturedObject) {
                ICapturedObject capturedObject = (ICapturedObject)obj;
                object = capturedObject.getName();
            } else {
                object = obj;
            }
            return object;
        }).toList();
    }

    protected ICapturedObject convertWebElement(Object object) throws JsonProcessingException {
        if (object == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString(object);
        MobileWebElement webElement = (MobileWebElement)mapper.readValue(jsonString, MobileWebElement.class);
        return MobileWebElementConverter.toCapturedObject(webElement);
    }

    public MobileAction getAction() {
        return this.action;
    }

    public List<Object> getArguments() {
        return this.arguments.stream().map(obj -> {
            if (ParameterType.TEST_OBJECT.equals((Object)obj.getType()) && obj.getValue() != null) {
                try {
                    return this.convertWebElement(obj.getValue());
                }
                catch (JsonProcessingException e) {
                    this.logger.error(e.getMessage());
                }
            }
            return obj.getValue();
        }).toList();
    }

    public MobileDevicePlatform getDevicePlatform() {
        return this.devicePlatform;
    }

    public String getId() {
        return this.id;
    }

    public IStep getStep() {
        this.logger.info("Method: " + this.action.getMethodName());
        KeywordStep step = new KeywordStep();
        step.setArguments(this.convertToStepArguments(this.getArguments()));
        return step;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAction(MobileAction action) {
        this.action = action;
    }

    public void setArguments(List<KeywordStepArgument> arguments) {
        this.arguments = arguments;
    }

    public void setDevicePlatform(MobileDevicePlatform devicePlatform) {
        this.devicePlatform = devicePlatform;
    }
}

