/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CapturingContext;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public abstract class ReferenceBinding
extends TypeBinding {
    public char[][] compoundName;
    public char[] sourceName;
    public int modifiers;
    public PackageBinding fPackage;
    char[] fileName;
    char[] constantPoolName;
    char[] signature;
    private Map<TypeBinding, Boolean> compatibleCache;
    int typeBits;
    protected MethodBinding[] singleAbstractMethod;
    protected static final DysfunctionalInterfaceException DYSFUNCTIONAL_INTERFACE_EXCEPTION = new DysfunctionalInterfaceException("Not a functional interface");
    public static final ReferenceBinding LUB_GENERIC = new ReferenceBinding(){
        {
            this.id = 0;
        }

        @Override
        public boolean hasTypeBit(int bit) {
            return false;
        }
    };
    private static final Comparator<FieldBinding> FIELD_COMPARATOR = new Comparator<FieldBinding>(){

        @Override
        public int compare(FieldBinding o1, FieldBinding o2) {
            char[] n1 = o1.name;
            char[] n2 = o2.name;
            return ReferenceBinding.compare(n1, n2, n1.length, n2.length);
        }
    };
    private static final Comparator<MethodBinding> METHOD_COMPARATOR = new Comparator<MethodBinding>(){

        @Override
        public int compare(MethodBinding m1, MethodBinding m2) {
            char[] s1 = m1.selector;
            char[] s2 = m2.selector;
            int c = ReferenceBinding.compare(s1, s2, s1.length, s2.length);
            return c == 0 ? m1.parameters.length - m2.parameters.length : c;
        }
    };
    protected static ProblemMethodBinding samProblemBinding = new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 17);
    static final Comparator<ReferenceBinding> BASIC_MEMBER_TYPES_COMPARATOR = (o1, o2) -> {
        char[] n1 = o1.sourceName;
        char[] n2 = o2.sourceName;
        if (n1 == null) {
            if (n2 == null) {
                return 0;
            }
            return -1;
        }
        if (n2 == null) {
            return 1;
        }
        return ReferenceBinding.compare(n1, n2, n1.length, n2.length);
    };

    public ReferenceBinding(ReferenceBinding prototype) {
        super(prototype);
        this.compoundName = prototype.compoundName;
        this.sourceName = prototype.sourceName;
        this.modifiers = prototype.modifiers;
        this.fPackage = prototype.fPackage;
        this.fileName = prototype.fileName;
        this.constantPoolName = prototype.constantPoolName;
        this.signature = prototype.signature;
        this.compatibleCache = prototype.compatibleCache;
        this.typeBits = prototype.typeBits;
        this.singleAbstractMethod = prototype.singleAbstractMethod;
    }

    public ReferenceBinding() {
    }

    public MethodBinding getRecordComponentAccessor(char[] name) {
        return null;
    }

    public static FieldBinding binarySearch(char[] name, FieldBinding[] sortedFields) {
        if (sortedFields == null) {
            return null;
        }
        int max = sortedFields.length;
        if (max == 0) {
            return null;
        }
        int left = 0;
        int right = max - 1;
        int nameLength = name.length;
        int mid = 0;
        while (left <= right) {
            mid = left + (right - left) / 2;
            char[] midName = sortedFields[mid].name;
            int compare = ReferenceBinding.compare(name, sortedFields[mid].name, nameLength, midName.length);
            if (compare < 0) {
                right = mid - 1;
                continue;
            }
            if (compare > 0) {
                left = mid + 1;
                continue;
            }
            return sortedFields[mid];
        }
        return null;
    }

    public static long binarySearch(char[] selector, MethodBinding[] sortedMethods) {
        if (sortedMethods == null) {
            return -1L;
        }
        int max = sortedMethods.length;
        if (max == 0) {
            return -1L;
        }
        int left = 0;
        int right = max - 1;
        int selectorLength = selector.length;
        int mid = 0;
        while (left <= right) {
            mid = left + (right - left) / 2;
            char[] midSelector = sortedMethods[mid].selector;
            int compare = ReferenceBinding.compare(selector, sortedMethods[mid].selector, selectorLength, midSelector.length);
            if (compare < 0) {
                right = mid - 1;
                continue;
            }
            if (compare > 0) {
                left = mid + 1;
                continue;
            }
            int start = mid;
            int end = mid;
            while (start > left && CharOperation.equals(sortedMethods[start - 1].selector, selector)) {
                --start;
            }
            while (end < right && CharOperation.equals(sortedMethods[end + 1].selector, selector)) {
                ++end;
            }
            return (long)start + ((long)end << 32);
        }
        return -1L;
    }

    static int compare(char[] str1, char[] str2, int len1, int len2) {
        int n = Math.min(len1, len2);
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = str1[i];
            if (c1 == (c2 = str2[i++])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static void sortFields(FieldBinding[] sortedFields, int left, int right) {
        Arrays.sort(sortedFields, left, right, FIELD_COMPARATOR);
    }

    public static void sortMethods(MethodBinding[] sortedMethods, int left, int right) {
        Arrays.sort(sortedMethods, left, right, METHOD_COMPARATOR);
    }

    static void sortMemberTypes(ReferenceBinding[] sortedMemberTypes, int left, int right) {
        Arrays.sort(sortedMemberTypes, left, right, BASIC_MEMBER_TYPES_COMPARATOR);
    }

    public FieldBinding[] availableFields() {
        return this.fields();
    }

    public MethodBinding[] availableMethods() {
        return this.methods();
    }

    public boolean hasHierarchyCheckStarted() {
        return (this.tagBits & 0x100L) != 0L;
    }

    public void setHierarchyCheckDone() {
    }

    protected boolean isFieldInitializationFinished() {
        return true;
    }

    @Override
    public boolean canBeInstantiated() {
        return (this.modifiers & 0x6600) == 0;
    }

    public boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.fPackage;
    }

    public boolean canBeSeenBy(ReferenceBinding receiverType, ReferenceBinding invocationType) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isStatic()) {
            receiverType = receiverType.actualType();
        }
        if (TypeBinding.equalsEquals(invocationType, this) && TypeBinding.equalsEquals(invocationType, receiverType)) {
            return true;
        }
        if (this.isProtected()) {
            if (TypeBinding.equalsEquals(invocationType, this)) {
                return true;
            }
            if (invocationType.fPackage == this.fPackage) {
                return true;
            }
            TypeBinding currentType = invocationType.erasure();
            TypeBinding declaringClass = this.enclosingType().erasure();
            if (TypeBinding.equalsEquals(declaringClass, invocationType)) {
                return true;
            }
            if (declaringClass == null) {
                return false;
            }
            do {
                if (currentType.findSuperTypeOriginatingFrom(declaringClass) == null) continue;
                return true;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (!TypeBinding.equalsEquals(receiverType, this) && !TypeBinding.equalsEquals(receiverType, this.enclosingType())) {
                return false;
            }
            if (TypeBinding.notEquals(invocationType, this)) {
                ReferenceBinding outerInvocationType = invocationType;
                ReferenceBinding temp = outerInvocationType.enclosingType();
                while (temp != null) {
                    outerInvocationType = temp;
                    temp = temp.enclosingType();
                }
                ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.erasure();
                temp = outerDeclaringClass.enclosingType();
                while (temp != null) {
                    outerDeclaringClass = temp;
                    temp = temp.enclosingType();
                }
                if (TypeBinding.notEquals(outerInvocationType, outerDeclaringClass)) {
                    return false;
                }
            }
            return true;
        }
        if (invocationType.fPackage != this.fPackage) {
            return false;
        }
        ReferenceBinding currentType = receiverType;
        TypeBinding originalDeclaringClass = (this.enclosingType() == null ? this : this.enclosingType()).original();
        do {
            if (currentType.isCapture() ? TypeBinding.equalsEquals(originalDeclaringClass, currentType.erasure().original()) : TypeBinding.equalsEquals(originalDeclaringClass, currentType.original())) {
                return true;
            }
            PackageBinding currentPackage = currentType.fPackage;
            if (currentPackage == null || currentPackage == this.fPackage) continue;
            return false;
        } while ((currentType = currentType.superclass()) != null);
        return false;
    }

    @Override
    public boolean canBeSeenBy(Scope scope) {
        if (scope.compilationUnitScope() != null && scope.compilationUnitScope().canSeeEverything()) {
            return true;
        }
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (TypeBinding.equalsEquals(invocationType, this)) {
            return true;
        }
        if (invocationType == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.fPackage;
        }
        if (this.isProtected()) {
            if (invocationType.fPackage == this.fPackage) {
                return true;
            }
            TypeBinding declaringClass = this.enclosingType();
            if (declaringClass == null) {
                return false;
            }
            declaringClass = declaringClass.erasure();
            TypeBinding currentType = invocationType.erasure();
            do {
                if (TypeBinding.equalsEquals(declaringClass, invocationType)) {
                    return true;
                }
                if (currentType.findSuperTypeOriginatingFrom(declaringClass) == null) continue;
                return true;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            ReferenceBinding outerInvocationType = invocationType;
            ReferenceBinding temp = outerInvocationType.enclosingType();
            while (temp != null) {
                outerInvocationType = temp;
                temp = temp.enclosingType();
            }
            ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.erasure();
            temp = outerDeclaringClass.enclosingType();
            while (temp != null) {
                outerDeclaringClass = temp;
                temp = temp.enclosingType();
            }
            return TypeBinding.equalsEquals(outerInvocationType, outerDeclaringClass);
        }
        return invocationType.fPackage == this.fPackage;
    }

    public char[] computeGenericTypeSignature(TypeVariableBinding[] typeVariables) {
        boolean isMemberOfGeneric;
        boolean bl = isMemberOfGeneric = this.isMemberType() && this.hasEnclosingInstanceContext() && (this.enclosingType().modifiers & 0x40000000) != 0;
        if (typeVariables == Binding.NO_TYPE_VARIABLES && !isMemberOfGeneric) {
            return this.signature();
        }
        StringBuilder sig = new StringBuilder(10);
        if (isMemberOfGeneric) {
            typeSig = this.enclosingType().genericTypeSignature();
            sig.append(typeSig, 0, typeSig.length - 1);
            sig.append('.');
            sig.append(this.sourceName);
        } else {
            typeSig = this.signature();
            sig.append(typeSig, 0, typeSig.length - 1);
        }
        if (typeVariables == Binding.NO_TYPE_VARIABLES) {
            sig.append(';');
        } else {
            sig.append('<');
            TypeVariableBinding[] typeVariableBindingArray = typeVariables;
            int n = typeVariables.length;
            int n2 = 0;
            while (n2 < n) {
                TypeVariableBinding typeVariable = typeVariableBindingArray[n2];
                sig.append(typeVariable.genericTypeSignature());
                ++n2;
            }
            sig.append(">;");
        }
        int sigLength = sig.length();
        char[] result = new char[sigLength];
        sig.getChars(0, sigLength, result, 0);
        return result;
    }

    public void computeId() {
        block0 : switch (this.compoundName.length) {
            case 3: {
                char[] packageName = this.compoundName[0];
                switch (packageName.length) {
                    case 3: {
                        if (CharOperation.equals(TypeConstants.ORG_JUNIT_ASSERT, this.compoundName)) {
                            this.id = 70;
                        }
                        return;
                    }
                    case 4: {
                        if (CharOperation.equals(TypeConstants.JAVA, packageName)) break;
                        return;
                    }
                    case 5: {
                        switch (packageName[1]) {
                            case 'a': {
                                if (CharOperation.equals(TypeConstants.JAVAX_ANNOTATION_INJECT_INJECT, this.compoundName)) {
                                    this.id = 80;
                                }
                                return;
                            }
                            case 'u': {
                                if (CharOperation.equals(TypeConstants.JUNIT_FRAMEWORK_ASSERT, this.compoundName)) {
                                    this.id = 69;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 7: {
                        switch (packageName[1]) {
                            case 'a': {
                                if (CharOperation.equals(TypeConstants.JAKARTA_ANNOTATION_INJECT_INJECT, this.compoundName)) {
                                    this.id = 94;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    default: {
                        return;
                    }
                }
                packageName = this.compoundName[1];
                if (packageName.length == 0) {
                    return;
                }
                char[] typeName = this.compoundName[2];
                if (typeName.length == 0) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.LANG, this.compoundName[1])) {
                    switch (packageName[0]) {
                        case 'i': {
                            if (CharOperation.equals(packageName, TypeConstants.IO)) {
                                switch (typeName[0]) {
                                    case 'C': {
                                        if (CharOperation.equals(typeName, TypeConstants.JAVA_IO_CLOSEABLE[2])) {
                                            this.typeBits |= 2;
                                        }
                                        return;
                                    }
                                    case 'E': {
                                        if (CharOperation.equals(typeName, TypeConstants.JAVA_IO_EXTERNALIZABLE[2])) {
                                            this.id = 56;
                                        }
                                        return;
                                    }
                                    case 'I': {
                                        if (CharOperation.equals(typeName, TypeConstants.JAVA_IO_IOEXCEPTION[2])) {
                                            this.id = 58;
                                        }
                                        return;
                                    }
                                    case 'O': {
                                        if (CharOperation.equals(typeName, TypeConstants.JAVA_IO_OBJECTSTREAMEXCEPTION[2])) {
                                            this.id = 57;
                                        }
                                        return;
                                    }
                                    case 'P': {
                                        if (CharOperation.equals(typeName, TypeConstants.JAVA_IO_PRINTSTREAM[2])) {
                                            this.id = 53;
                                        }
                                        return;
                                    }
                                    case 'S': {
                                        if (CharOperation.equals(typeName, TypeConstants.JAVA_IO_SERIALIZABLE[2])) {
                                            this.id = 37;
                                        }
                                        return;
                                    }
                                }
                            }
                            return;
                        }
                        case 'u': {
                            if (CharOperation.equals(packageName, TypeConstants.UTIL)) {
                                switch (typeName[0]) {
                                    case 'C': {
                                        if (CharOperation.equals(typeName, TypeConstants.JAVA_UTIL_COLLECTION[2])) {
                                            this.id = 59;
                                            this.typeBits |= 0x200;
                                        }
                                        return;
                                    }
                                    case 'I': {
                                        if (CharOperation.equals(typeName, TypeConstants.JAVA_UTIL_ITERATOR[2])) {
                                            this.id = 39;
                                        }
                                        return;
                                    }
                                    case 'L': {
                                        if (CharOperation.equals(typeName, TypeConstants.JAVA_UTIL_LIST[2])) {
                                            this.id = 92;
                                            this.typeBits |= 0x400;
                                        }
                                        return;
                                    }
                                    case 'M': {
                                        if (CharOperation.equals(typeName, TypeConstants.JAVA_UTIL_MAP[2])) {
                                            this.id = 91;
                                            this.typeBits |= 0x100;
                                        }
                                        return;
                                    }
                                    case 'O': {
                                        if (CharOperation.equals(typeName, TypeConstants.JAVA_UTIL_OBJECTS[2])) {
                                            this.id = 74;
                                        }
                                        return;
                                    }
                                }
                            }
                            return;
                        }
                    }
                    return;
                }
                switch (typeName[0]) {
                    case 'A': {
                        switch (typeName.length) {
                            case 13: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_AUTOCLOSEABLE[2])) {
                                    this.id = 62;
                                    this.typeBits |= 1;
                                }
                                return;
                            }
                            case 14: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ASSERTIONERROR[2])) {
                                    this.id = 35;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'B': {
                        switch (typeName.length) {
                            case 4: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_BYTE[2])) {
                                    this.id = 26;
                                }
                                return;
                            }
                            case 7: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_BOOLEAN[2])) {
                                    this.id = 33;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'C': {
                        switch (typeName.length) {
                            case 5: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_CLASS[2])) {
                                    this.id = 16;
                                }
                                return;
                            }
                            case 9: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_CHARACTER[2])) {
                                    this.id = 28;
                                } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_CLONEABLE[2])) {
                                    this.id = 36;
                                }
                                return;
                            }
                            case 22: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_CLASSNOTFOUNDEXCEPTION[2])) {
                                    this.id = 23;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'D': {
                        switch (typeName.length) {
                            case 6: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_DOUBLE[2])) {
                                    this.id = 32;
                                }
                                return;
                            }
                            case 10: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_DEPRECATED[2])) {
                                    this.id = 44;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'E': {
                        switch (typeName.length) {
                            case 4: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ENUM[2])) {
                                    this.id = 41;
                                }
                                return;
                            }
                            case 5: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ERROR[2])) {
                                    this.id = 19;
                                }
                                return;
                            }
                            case 9: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_EXCEPTION[2])) {
                                    this.id = 25;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'F': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_FLOAT[2])) {
                            this.id = 31;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_FUNCTIONAL_INTERFACE[2])) {
                            this.id = 77;
                        }
                        return;
                    }
                    case 'I': {
                        switch (typeName.length) {
                            case 7: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_INTEGER[2])) {
                                    this.id = 29;
                                }
                                return;
                            }
                            case 8: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ITERABLE[2])) {
                                    this.id = 38;
                                }
                                return;
                            }
                            case 24: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ILLEGALARGUMENTEXCEPTION[2])) {
                                    this.id = 42;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'L': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_LONG[2])) {
                            this.id = 30;
                        }
                        return;
                    }
                    case 'N': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_NOCLASSDEFFOUNDERROR[2])) {
                            this.id = 22;
                        }
                        return;
                    }
                    case 'O': {
                        switch (typeName.length) {
                            case 6: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_OBJECT[2])) {
                                    this.id = 1;
                                }
                                return;
                            }
                            case 8: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_OVERRIDE[2])) {
                                    this.id = 47;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'R': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION[2])) {
                            this.id = 24;
                        }
                        if (!CharOperation.equals(typeName, TypeConstants.JAVA_LANG_RECORD[2])) break block0;
                        this.id = 93;
                        break block0;
                    }
                    case 'S': {
                        switch (typeName.length) {
                            case 5: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_SHORT[2])) {
                                    this.id = 27;
                                }
                                return;
                            }
                            case 6: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_STRING[2])) {
                                    this.id = 11;
                                } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_SYSTEM[2])) {
                                    this.id = 18;
                                }
                                return;
                            }
                            case 11: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_SAFEVARARGS[2])) {
                                    this.id = 60;
                                }
                                return;
                            }
                            case 12: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_STRINGBUFFER[2])) {
                                    this.id = 17;
                                }
                                return;
                            }
                            case 13: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_STRINGBUILDER[2])) {
                                    this.id = 40;
                                }
                                return;
                            }
                            case 16: {
                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_SUPPRESSWARNINGS[2])) {
                                    this.id = 49;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'T': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_THROWABLE[2])) {
                            this.id = 21;
                        }
                        return;
                    }
                    case 'V': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_VOID[2])) {
                            this.id = 34;
                        }
                        return;
                    }
                }
                break;
            }
            case 4: {
                if (CharOperation.equals(TypeConstants.COM_GOOGLE_INJECT_INJECT, this.compoundName)) {
                    this.id = 81;
                    return;
                }
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                    return;
                }
                char[] packageName = this.compoundName[1];
                if (packageName.length == 0) {
                    return;
                }
                packageName = this.compoundName[2];
                if (packageName.length == 0) {
                    return;
                }
                char[] typeName = this.compoundName[3];
                if (typeName.length == 0) {
                    return;
                }
                switch (packageName[0]) {
                    case 'a': {
                        if (CharOperation.equals(packageName, TypeConstants.ANNOTATION)) {
                            switch (typeName[0]) {
                                case 'A': {
                                    if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION[3])) {
                                        this.id = 43;
                                    }
                                    return;
                                }
                                case 'D': {
                                    if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED[3])) {
                                        this.id = 45;
                                    }
                                    return;
                                }
                                case 'E': {
                                    if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE[3])) {
                                        this.id = 52;
                                    }
                                    return;
                                }
                                case 'I': {
                                    if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_INHERITED[3])) {
                                        this.id = 46;
                                    }
                                    return;
                                }
                                case 'R': {
                                    switch (typeName.length) {
                                        case 9: {
                                            if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_RETENTION[3])) {
                                                this.id = 48;
                                            }
                                            return;
                                        }
                                        case 10: {
                                            if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_REPEATABLE[3])) {
                                                this.id = 90;
                                            }
                                            return;
                                        }
                                        case 15: {
                                            if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY[3])) {
                                                this.id = 51;
                                            }
                                            return;
                                        }
                                    }
                                    return;
                                }
                                case 'T': {
                                    if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_TARGET[3])) {
                                        this.id = 50;
                                    }
                                    return;
                                }
                            }
                        }
                        return;
                    }
                    case 'i': {
                        if (CharOperation.equals(packageName, TypeConstants.INVOKE)) {
                            if (typeName.length == 0) {
                                return;
                            }
                            switch (typeName[0]) {
                                case 'M': {
                                    if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_$_POLYMORPHICSIGNATURE[3])) {
                                        this.id = 61;
                                    }
                                    return;
                                }
                            }
                        }
                        return;
                    }
                    case 'r': {
                        if (CharOperation.equals(packageName, TypeConstants.REFLECT)) {
                            switch (typeName[0]) {
                                case 'C': {
                                    if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_REFLECT_CONSTRUCTOR[2])) {
                                        this.id = 20;
                                    }
                                    return;
                                }
                                case 'F': {
                                    if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_REFLECT_FIELD[2])) {
                                        this.id = 54;
                                    }
                                    return;
                                }
                                case 'M': {
                                    if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_REFLECT_METHOD[2])) {
                                        this.id = 55;
                                    }
                                    return;
                                }
                            }
                        }
                        return;
                    }
                }
                break;
            }
            case 5: {
                char[] packageName = this.compoundName[0];
                switch (packageName[0]) {
                    case 'j': {
                        if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                            return;
                        }
                        packageName = this.compoundName[1];
                        if (packageName.length == 0) {
                            return;
                        }
                        if (CharOperation.equals(TypeConstants.LANG, packageName)) {
                            packageName = this.compoundName[2];
                            if (packageName.length == 0) {
                                return;
                            }
                            switch (packageName[0]) {
                                case 'i': {
                                    if (CharOperation.equals(packageName, TypeConstants.INVOKE)) {
                                        char[] typeName = this.compoundName[3];
                                        if (typeName.length == 0) {
                                            return;
                                        }
                                        switch (typeName[0]) {
                                            case 'M': {
                                                char[] memberTypeName = this.compoundName[4];
                                                if (memberTypeName.length == 0) {
                                                    return;
                                                }
                                                if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_POLYMORPHICSIGNATURE[3]) && CharOperation.equals(memberTypeName, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_POLYMORPHICSIGNATURE[4])) {
                                                    this.id = 61;
                                                }
                                                return;
                                            }
                                        }
                                    }
                                    return;
                                }
                            }
                            return;
                        }
                        return;
                    }
                    case 'o': {
                        if (!CharOperation.equals(TypeConstants.ORG, this.compoundName[0])) {
                            return;
                        }
                        packageName = this.compoundName[1];
                        if (packageName.length == 0) {
                            return;
                        }
                        switch (packageName[0]) {
                            case 'e': {
                                if (CharOperation.equals(TypeConstants.ECLIPSE, packageName)) {
                                    packageName = this.compoundName[2];
                                    if (packageName.length == 0) {
                                        return;
                                    }
                                    switch (packageName[0]) {
                                        case 'c': {
                                            if (CharOperation.equals(packageName, TypeConstants.CORE)) {
                                                char[] typeName = this.compoundName[3];
                                                if (typeName.length == 0) {
                                                    return;
                                                }
                                                switch (typeName[0]) {
                                                    case 'r': {
                                                        char[] memberTypeName = this.compoundName[4];
                                                        if (memberTypeName.length == 0) {
                                                            return;
                                                        }
                                                        if (CharOperation.equals(typeName, TypeConstants.ORG_ECLIPSE_CORE_RUNTIME_ASSERT[3]) && CharOperation.equals(memberTypeName, TypeConstants.ORG_ECLIPSE_CORE_RUNTIME_ASSERT[4])) {
                                                            this.id = 68;
                                                        }
                                                        return;
                                                    }
                                                }
                                            }
                                            return;
                                        }
                                    }
                                    return;
                                }
                                return;
                            }
                            case 'a': {
                                if (CharOperation.equals(TypeConstants.APACHE, packageName) && CharOperation.equals(TypeConstants.COMMONS, this.compoundName[2])) {
                                    if (CharOperation.equals(TypeConstants.ORG_APACHE_COMMONS_LANG_VALIDATE, this.compoundName)) {
                                        this.id = 71;
                                    } else if (CharOperation.equals(TypeConstants.ORG_APACHE_COMMONS_LANG3_VALIDATE, this.compoundName)) {
                                        this.id = 72;
                                    }
                                }
                                return;
                            }
                            case 'j': {
                                if (CharOperation.equals(TypeConstants.ORG_JUNIT_JUPITER_API_ASSERTIONS, this.compoundName)) {
                                    this.id = 75;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'c': {
                        if (!CharOperation.equals(TypeConstants.COM, this.compoundName[0])) {
                            return;
                        }
                        if (CharOperation.equals(TypeConstants.COM_GOOGLE_COMMON_BASE_PRECONDITIONS, this.compoundName)) {
                            this.id = 73;
                        }
                        return;
                    }
                }
                break;
            }
            case 6: {
                if (!CharOperation.equals(TypeConstants.ORG, this.compoundName[0])) break;
                if (CharOperation.equals(TypeConstants.SPRING, this.compoundName[1])) {
                    if (CharOperation.equals(TypeConstants.AUTOWIRED, this.compoundName[5]) && CharOperation.equals(TypeConstants.ORG_SPRING_AUTOWIRED, this.compoundName)) {
                        this.id = 82;
                    }
                    return;
                }
                if (CharOperation.equals(TypeConstants.JUNIT, this.compoundName[1])) {
                    if (CharOperation.equals(TypeConstants.METHOD_SOURCE, this.compoundName[5]) && CharOperation.equals(TypeConstants.ORG_JUNIT_METHOD_SOURCE, this.compoundName)) {
                        this.id = 93;
                    }
                    return;
                }
                if (!CharOperation.equals(TypeConstants.JDT, this.compoundName[2]) || !CharOperation.equals(TypeConstants.ITYPEBINDING, this.compoundName[5])) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.ORG_ECLIPSE_JDT_CORE_DOM_ITYPEBINDING, this.compoundName)) break;
                this.typeBits |= 0x10;
                break;
            }
            case 7: {
                if (!CharOperation.equals(TypeConstants.JDT, this.compoundName[2]) || !CharOperation.equals(TypeConstants.TYPEBINDING, this.compoundName[6])) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.ORG_ECLIPSE_JDT_INTERNAL_COMPILER_LOOKUP_TYPEBINDING, this.compoundName)) break;
                this.typeBits |= 0x10;
            }
        }
    }

    public void computeId(LookupEnvironment environment) {
        environment.getUnannotatedType(this);
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        if (!isLeaf) {
            return this.signature();
        }
        return this.genericTypeSignature();
    }

    @Override
    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        this.constantPoolName = CharOperation.concatWith(this.compoundName, '/');
        return this.constantPoolName;
    }

    @Override
    public String debugName() {
        return this.compoundName != null ? (this.hasTypeAnnotations() ? this.annotatedDebugName() : new String(this.readableName())) : "UNNAMED TYPE";
    }

    @Override
    public int depth() {
        int depth = 0;
        ReferenceBinding current = this;
        while ((current = current.enclosingType()) != null) {
            ++depth;
        }
        return depth;
    }

    public boolean detectAnnotationCycle() {
        if ((this.tagBits & 0x100000000L) == 0x100000000L) {
            return false;
        }
        if ((this.tagBits & 0x80000000L) == 0x80000000L) {
            return true;
        }
        this.tagBits |= 0x80000000L;
        MethodBinding[] currentMethods = this.methods();
        boolean inCycle = false;
        MethodBinding[] methodBindingArray = currentMethods;
        int n = currentMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding currentMethod = methodBindingArray[n2];
            TypeBinding returnType = currentMethod.returnType.leafComponentType().erasure();
            if (TypeBinding.equalsEquals(this, returnType)) {
                if (this instanceof SourceTypeBinding) {
                    decl = (MethodDeclaration)currentMethod.sourceMethod();
                    ((SourceTypeBinding)this).scope.problemReporter().annotationCircularity(this, this, decl != null ? decl.returnType : null);
                }
            } else if (returnType.isAnnotationType() && ((ReferenceBinding)returnType).detectAnnotationCycle()) {
                if (this instanceof SourceTypeBinding) {
                    decl = (MethodDeclaration)currentMethod.sourceMethod();
                    ((SourceTypeBinding)this).scope.problemReporter().annotationCircularity(this, returnType, decl != null ? decl.returnType : null);
                }
                inCycle = true;
            }
            ++n2;
        }
        if (inCycle) {
            return true;
        }
        this.tagBits &= 0xFFFFFFFF7FFFFFFFL;
        this.tagBits |= 0x100000000L;
        return false;
    }

    public final ReferenceBinding enclosingTypeAt(int relativeDepth) {
        ReferenceBinding current = this;
        while (relativeDepth-- > 0 && current != null) {
            current = current.enclosingType();
        }
        return current;
    }

    @Override
    public ReferenceBinding actualType() {
        return this;
    }

    @Override
    public int enumConstantCount() {
        FieldBinding[] fields;
        int count = 0;
        FieldBinding[] fieldBindingArray = fields = this.fields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldBinding field = fieldBindingArray[n2];
            if ((field.modifiers & 0x4000) != 0) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public int fieldCount() {
        return this.fields().length;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        return this.retrieveAnnotations(this.prototype());
    }

    public AnnotationBinding[] getAnnotations(long requestedInitialization) {
        return this.getAnnotations();
    }

    @Override
    public long getAnnotationTagBits() {
        return this.tagBits;
    }

    public RecordComponent getRecordComponent(char[] name) {
        if (this.isRecord()) {
            RecordComponentBinding[] rcbs = this.components();
            int length = rcbs == null ? 0 : rcbs.length;
            int i = 0;
            while (i < length) {
                if (CharOperation.equals(name, rcbs[i].name)) {
                    return rcbs[i].sourceRecordComponent();
                }
                ++i;
            }
        }
        return null;
    }

    public RecordComponent[] getRecordComponents() {
        RecordComponent[] recordComponents = ASTNode.NO_RECORD_COMPONENTS;
        if (this.isRecord()) {
            int length;
            RecordComponentBinding[] rcbs = this.components();
            int n = length = rcbs == null ? 0 : rcbs.length;
            if (length > 0) {
                recordComponents = new RecordComponent[length];
                int i = 0;
                while (i < length) {
                    recordComponents[i] = rcbs[i].sourceRecordComponent();
                    ++i;
                }
            }
        }
        return recordComponents;
    }

    public int getEnclosingInstancesSlotSize() {
        if (this.isStatic()) {
            return 0;
        }
        return this.enclosingType() == null ? 0 : 1;
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        return null;
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        return null;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public ReferenceBinding getMemberType(char[] typeName) {
        ReferenceBinding[] memberTypes = this.memberTypes();
        int memberTypeIndex = ReferenceBinding.binarySearch(typeName, memberTypes);
        if (memberTypeIndex >= 0) {
            return memberTypes[memberTypeIndex];
        }
        return null;
    }

    static int binarySearch(char[] sourceName, ReferenceBinding[] sortedMemberTypes) {
        if (sortedMemberTypes == null) {
            return -1;
        }
        int max = sortedMemberTypes.length;
        int nameLength = sourceName.length;
        if (max == 0) {
            return -1;
        }
        int left = 0;
        int right = max - 1;
        while (left <= right) {
            int compare;
            int mid = left + (right - left) / 2;
            char[] midName = sortedMemberTypes[mid].sourceName;
            int n = compare = midName == null ? 1 : ReferenceBinding.compare(sourceName, midName, nameLength, midName.length);
            if (compare < 0) {
                right = mid - 1;
                continue;
            }
            if (compare > 0) {
                left = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    @Override
    public MethodBinding[] getMethods(char[] selector) {
        return Binding.NO_METHODS;
    }

    public MethodBinding[] getMethods(char[] selector, int suggestedParameterLength) {
        return this.getMethods(selector);
    }

    public int getOuterLocalVariablesSlotSize() {
        return 0;
    }

    @Override
    public PackageBinding getPackage() {
        return this.fPackage;
    }

    public TypeVariableBinding getTypeVariable(char[] variableName) {
        TypeVariableBinding[] typeVariables = this.typeVariables();
        int i = typeVariables.length;
        while (--i >= 0) {
            if (!CharOperation.equals(typeVariables[i].sourceName, variableName)) continue;
            return typeVariables[i];
        }
        return null;
    }

    public int hashCode() {
        return this.compoundName == null || this.compoundName.length == 0 ? super.hashCode() : CharOperation.hashCode(this.compoundName[this.compoundName.length - 1]);
    }

    public boolean hasIncompatibleSuperType(ReferenceBinding otherType) {
        TypeBinding match;
        if (TypeBinding.equalsEquals(this, otherType)) {
            return false;
        }
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        ReferenceBinding currentType = this;
        do {
            if ((match = otherType.findSuperTypeOriginatingFrom(currentType)) != null && match.isProvablyDistinct(currentType)) {
                return true;
            }
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == null || itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
            if (interfacesToVisit == null) {
                interfacesToVisit = itsInterfaces;
                nextPosition = interfacesToVisit.length;
                continue;
            }
            int itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            int a = 0;
            while (a < itsLength) {
                block16: {
                    ReferenceBinding next = itsInterfaces[a];
                    int b = 0;
                    while (b < nextPosition) {
                        if (!TypeBinding.equalsEquals(next, interfacesToVisit[b])) {
                            ++b;
                            continue;
                        }
                        break block16;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
                ++a;
            }
        } while ((currentType = currentType.superclass()) != null);
        int i = 0;
        while (i < nextPosition) {
            currentType = interfacesToVisit[i];
            if (TypeBinding.equalsEquals(currentType, otherType)) {
                return false;
            }
            match = otherType.findSuperTypeOriginatingFrom(currentType);
            if (match != null && match.isProvablyDistinct(currentType)) {
                return true;
            }
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces != null && itsInterfaces != Binding.NO_SUPERINTERFACES) {
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                int a = 0;
                while (a < itsLength) {
                    block17: {
                        ReferenceBinding next = itsInterfaces[a];
                        int b = 0;
                        while (b < nextPosition) {
                            if (!TypeBinding.equalsEquals(next, interfacesToVisit[b])) {
                                ++b;
                                continue;
                            }
                            break block17;
                        }
                        interfacesToVisit[nextPosition++] = next;
                    }
                    ++a;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean hasMemberTypes() {
        return false;
    }

    boolean hasNonNullDefaultForType(TypeBinding type, int location, int sourceStart) {
        if (type != null && !type.acceptsNonNullDefault()) {
            return false;
        }
        ReferenceBinding currentType = this;
        while (currentType != null) {
            int nullDefault = ((ReferenceBinding)currentType.original()).getNullDefault();
            if (nullDefault != 0) {
                return (nullDefault & location) != 0;
            }
            currentType = currentType.enclosingType();
        }
        return (this.getPackage().getDefaultNullness() & location) != 0;
    }

    int getNullDefault() {
        return 0;
    }

    @Override
    public boolean acceptsNonNullDefault() {
        return true;
    }

    public final boolean hasRestrictedAccess() {
        return (this.modifiers & 0x40000) != 0;
    }

    public boolean hasNullBit(int mask) {
        return (this.typeBits & mask) != 0;
    }

    public boolean implementsInterface(ReferenceBinding anInterface, boolean searchHierarchy) {
        if (TypeBinding.equalsEquals(this, anInterface)) {
            return true;
        }
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        ReferenceBinding currentType = this;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) == null || itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
            if (interfacesToVisit == null) {
                interfacesToVisit = itsInterfaces;
                nextPosition = interfacesToVisit.length;
                continue;
            }
            int itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            int a = 0;
            while (a < itsLength) {
                block14: {
                    ReferenceBinding next = itsInterfaces[a];
                    int b = 0;
                    while (b < nextPosition) {
                        if (!TypeBinding.equalsEquals(next, interfacesToVisit[b])) {
                            ++b;
                            continue;
                        }
                        break block14;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
                ++a;
            }
        } while (searchHierarchy && (currentType = currentType.superclass()) != null);
        int i = 0;
        while (i < nextPosition) {
            currentType = interfacesToVisit[i];
            if (currentType.isEquivalentTo(anInterface)) {
                return true;
            }
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces != null && itsInterfaces != Binding.NO_SUPERINTERFACES) {
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                int a = 0;
                while (a < itsLength) {
                    block15: {
                        ReferenceBinding next = itsInterfaces[a];
                        int b = 0;
                        while (b < nextPosition) {
                            if (!TypeBinding.equalsEquals(next, interfacesToVisit[b])) {
                                ++b;
                                continue;
                            }
                            break block15;
                        }
                        interfacesToVisit[nextPosition++] = next;
                    }
                    ++a;
                }
            }
            ++i;
        }
        return false;
    }

    boolean implementsMethod(MethodBinding method) {
        char[] selector = method.selector;
        ReferenceBinding type = this;
        while (type != null) {
            MethodBinding[] methods = type.methods();
            long range = ReferenceBinding.binarySearch(selector, methods);
            if (range >= 0L) {
                int start = (int)range;
                int end = (int)(range >> 32);
                int i = start;
                while (i <= end) {
                    if (methods[i].areParametersEqual(method)) {
                        return true;
                    }
                    ++i;
                }
            }
            type = type.superclass();
        }
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    @Override
    public boolean isAnnotationType() {
        return (this.modifiers & 0x2000) != 0;
    }

    public final boolean isBinaryBinding() {
        return (this.tagBits & 0x40L) != 0L;
    }

    @Override
    public boolean isClass() {
        return (this.modifiers & 0x6200) == 0;
    }

    @Override
    public boolean isRecord() {
        return (this.modifiers & 0x1000000) != 0;
    }

    private static SourceTypeBinding getSourceTypeBinding(ReferenceBinding ref) {
        if (ref instanceof SourceTypeBinding) {
            SourceTypeBinding stb = (SourceTypeBinding)ref;
            return stb;
        }
        if (ref instanceof ParameterizedTypeBinding) {
            SourceTypeBinding stb;
            ParameterizedTypeBinding ptb = (ParameterizedTypeBinding)ref;
            return ptb.type instanceof SourceTypeBinding ? (stb = (SourceTypeBinding)ptb.type) : null;
        }
        return null;
    }

    public boolean isNestmateOf(ReferenceBinding other) {
        SourceTypeBinding s1 = ReferenceBinding.getSourceTypeBinding(this);
        SourceTypeBinding s2 = ReferenceBinding.getSourceTypeBinding(other);
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.isNestmateOf(s2);
    }

    @Override
    public boolean isProperType(boolean admitCapture18) {
        ReferenceBinding outer = this.enclosingType();
        if (outer != null && !outer.isProperType(admitCapture18)) {
            return false;
        }
        return super.isProperType(admitCapture18);
    }

    @Override
    public boolean isCompatibleWith(TypeBinding otherType, Scope captureScope) {
        if (ReferenceBinding.equalsEquals(otherType, this)) {
            return true;
        }
        if (otherType.id == 1) {
            return true;
        }
        if (this.compatibleCache == null) {
            this.compatibleCache = new HashMap<TypeBinding, Boolean>();
            Object result = null;
        } else {
            Boolean result = this.compatibleCache.get(otherType);
            if (result != null) {
                return result == Boolean.TRUE;
            }
        }
        this.compatibleCache.put(otherType, Boolean.FALSE);
        if (this.isCompatibleWith0(otherType, captureScope)) {
            this.compatibleCache.put(otherType, Boolean.TRUE);
            return true;
        }
        if (captureScope == null && this instanceof TypeVariableBinding && ((TypeVariableBinding)this).firstBound instanceof ParameterizedTypeBinding) {
            this.compatibleCache.put(otherType, null);
        }
        return false;
    }

    private boolean isCompatibleWith0(TypeBinding otherType, Scope captureScope) {
        if (TypeBinding.equalsEquals(otherType, this)) {
            return true;
        }
        if (otherType.id == 1) {
            return true;
        }
        if (this.isEquivalentTo(otherType)) {
            return true;
        }
        switch (otherType.kind()) {
            case 516: 
            case 8196: {
                return false;
            }
            case 4100: {
                ReferenceContext referenceContext;
                MethodScope methodScope;
                if (otherType.isCapture()) {
                    CaptureBinding otherCapture = (CaptureBinding)otherType;
                    TypeBinding otherLowerBound = otherCapture.lowerBound;
                    if (otherLowerBound != null) {
                        if (otherLowerBound.isArrayType()) {
                            return false;
                        }
                        return this.isCompatibleWith(otherLowerBound);
                    }
                }
                if (otherType instanceof InferenceVariable && captureScope != null && (methodScope = captureScope.methodScope()) != null && (referenceContext = methodScope.referenceContext) instanceof LambdaExpression && ((LambdaExpression)referenceContext).inferenceContext != null) {
                    return true;
                }
            }
            case 4: 
            case 260: 
            case 1028: 
            case 2052: 
            case 32772: {
                switch (this.kind()) {
                    case 260: 
                    case 1028: 
                    case 2052: {
                        if (!TypeBinding.equalsEquals(this.erasure(), otherType.erasure())) break;
                        return false;
                    }
                }
                ReferenceBinding otherReferenceType = (ReferenceBinding)otherType;
                if (otherReferenceType.isIntersectionType18()) {
                    ReferenceBinding[] intersectingTypes;
                    ReferenceBinding[] referenceBindingArray = intersectingTypes = ((IntersectionTypeBinding18)otherReferenceType).intersectingTypes;
                    int n = intersectingTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ReferenceBinding binding = referenceBindingArray[n2];
                        if (!this.isCompatibleWith(binding)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                if (otherReferenceType.isInterface()) {
                    if (this.implementsInterface(otherReferenceType, true)) {
                        return true;
                    }
                    if (this instanceof TypeVariableBinding && captureScope != null) {
                        TypeVariableBinding typeVariable = (TypeVariableBinding)this;
                        if (typeVariable.firstBound instanceof ParameterizedTypeBinding) {
                            TypeBinding bound = typeVariable.firstBound.capture(captureScope, -1, -1);
                            return bound.isCompatibleWith(otherReferenceType);
                        }
                    }
                }
                if (this.isInterface()) {
                    return false;
                }
                return otherReferenceType.isSuperclassOf(this);
            }
        }
        return false;
    }

    public final boolean isNonSealed() {
        return (this.modifiers & 0x4000000) != 0;
    }

    @Override
    public boolean isSealed() {
        return (this.modifiers & 0x10000000) != 0;
    }

    @Override
    public boolean isSubtypeOf(TypeBinding other, boolean simulatingBugJDK8026527) {
        if (this.isSubTypeOfRTL(other)) {
            return true;
        }
        TypeBinding candidate = this.findSuperTypeOriginatingFrom(other);
        if (candidate == null) {
            return false;
        }
        if (TypeBinding.equalsEquals(candidate, other)) {
            return true;
        }
        if (other.isRawType() && TypeBinding.equalsEquals(candidate.erasure(), other.erasure())) {
            return true;
        }
        TypeBinding[] sis = other.typeArguments();
        TypeBinding[] tis = candidate.typeArguments();
        if (tis == null || sis == null) {
            return false;
        }
        if (sis.length != tis.length) {
            return false;
        }
        int i = 0;
        while (i < sis.length) {
            if (!tis[i].isTypeArgumentContainedBy(sis[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isSubTypeOfRTL(TypeBinding other) {
        ReferenceBinding[] intersecting;
        if (TypeBinding.equalsEquals(this, other)) {
            return true;
        }
        if (other instanceof CaptureBinding) {
            TypeBinding lower = ((CaptureBinding)other).lowerBound;
            return lower != null && this.isSubtypeOf(lower, false);
        }
        if (other instanceof ReferenceBinding && (intersecting = other.getIntersectingTypes()) != null) {
            ReferenceBinding[] referenceBindingArray = intersecting;
            int n = intersecting.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding binding = referenceBindingArray[n2];
                if (!this.isSubtypeOf(binding, false)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public final boolean isDefault() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isHierarchyBeingConnected() {
        return (this.tagBits & 0x200L) == 0L && (this.tagBits & 0x100L) != 0L;
    }

    public boolean isHierarchyBeingActivelyConnected() {
        return (this.tagBits & 0x200L) == 0L && (this.tagBits & 0x100L) != 0L && (this.tagBits & 0x80000L) == 0L;
    }

    public boolean isHierarchyConnected() {
        return true;
    }

    @Override
    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    private boolean isPatentlyDysfunctional(Scope scope) {
        if (!this.isInterface() || this.isSealed() || this.isAnnotationType()) {
            return true;
        }
        MethodBinding samCandidate = null;
        MethodBinding[] methodBindingArray = this.methods();
        int n = methodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding method = methodBindingArray[n2];
            if (method.isAbstract() && !method.redeclaresPublicObjectMethod(scope)) {
                if (samCandidate == null) {
                    samCandidate = method;
                } else if (!CharOperation.equals(samCandidate.selector, method.selector) || samCandidate.parameters.length != method.parameters.length) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isFunctionalInterface(Scope scope) {
        MethodBinding method;
        return this.isInterface() && (method = this.getSingleAbstractMethod(scope, true)) != null && method.isValidBinding();
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isOrEnclosedByPrivateType() {
        if (this.isLocalType()) {
            return true;
        }
        ReferenceBinding type = this;
        while (type != null) {
            if ((type.modifiers & 2) != 0) {
                return true;
            }
            type = type.enclosingType();
        }
        return false;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    @Override
    public final boolean isStatic() {
        return (this.modifiers & 0x208) != 0 || (this.tagBits & 4L) == 0L;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public boolean isSuperclassOf(ReferenceBinding otherType) {
        while ((otherType = otherType.superclass()) != null) {
            if (!(otherType = CapturingContext.maybeCapture(otherType)).isEquivalentTo(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isThrowable() {
        ReferenceBinding current = this;
        do {
            switch (current.id) {
                case 19: 
                case 21: 
                case 24: 
                case 25: {
                    return true;
                }
            }
        } while ((current = current.superclass()) != null);
        return false;
    }

    @Override
    public boolean isUncheckedException(boolean includeSupertype) {
        switch (this.id) {
            case 19: 
            case 24: {
                return true;
            }
            case 21: 
            case 25: {
                return includeSupertype;
            }
        }
        ReferenceBinding current = this;
        while ((current = current.superclass()) != null) {
            switch (current.id) {
                case 19: 
                case 24: {
                    return true;
                }
                case 21: 
                case 25: {
                    return false;
                }
            }
        }
        return false;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        if ((this.modifiers & 0x300000) != 0) {
            return true;
        }
        if (this.getPackage().isViewedAsDeprecated()) {
            this.tagBits |= this.getPackage().tagBits & 0x4000000000000000L;
            return true;
        }
        return false;
    }

    public boolean isImplicitType() {
        return false;
    }

    public ReferenceBinding[] memberTypes() {
        return Binding.NO_MEMBER_TYPES;
    }

    public MethodBinding[] methods() {
        return Binding.NO_METHODS;
    }

    public final ReferenceBinding outermostEnclosingType() {
        ReferenceBinding last;
        ReferenceBinding current = this;
        do {
            last = current;
        } while ((current = current.enclosingType()) != null);
        return last;
    }

    public TypeVariableBinding[] typeVariablesIncludingEnclosing() {
        TypeVariableBinding[] outerVariables;
        ReferenceBinding enclosingType = this.enclosingType();
        TypeVariableBinding[] ownVariables = this.typeVariables();
        TypeVariableBinding[] typeVariableBindingArray = outerVariables = this.hasEnclosingInstanceContext() && enclosingType != null ? enclosingType.typeVariablesIncludingEnclosing() : Binding.NO_TYPE_VARIABLES;
        if (outerVariables == null || outerVariables == Binding.NO_TYPE_VARIABLES) {
            return ownVariables == null ? Binding.NO_TYPE_VARIABLES : ownVariables;
        }
        if (ownVariables == null || ownVariables == Binding.NO_TYPE_VARIABLES) {
            return outerVariables;
        }
        int outerVariablesCount = outerVariables.length;
        TypeVariableBinding[] allVariables = new TypeVariableBinding[outerVariablesCount + ownVariables.length];
        System.arraycopy(outerVariables, 0, allVariables, 0, outerVariablesCount);
        System.arraycopy(ownVariables, 0, allVariables, outerVariablesCount, ownVariables.length);
        return allVariables;
    }

    public TypeBinding[] typeArgumentsIncludingEnclosing() {
        TypeBinding[] outerArguments;
        ReferenceBinding enclosingType = this.enclosingType();
        TypeBinding[] ownArguments = this.typeArguments();
        TypeBinding[] typeBindingArray = outerArguments = this.hasEnclosingInstanceContext() && enclosingType != null ? enclosingType.typeArguments() : Binding.NO_TYPES;
        if (outerArguments == null || outerArguments == Binding.NO_TYPES) {
            return ownArguments == null ? Binding.NO_TYPES : ownArguments;
        }
        if (ownArguments == null || ownArguments == Binding.NO_TYPES) {
            return outerArguments;
        }
        int outerArgumentsCount = outerArguments.length;
        TypeBinding[] allArguments = new TypeBinding[outerArgumentsCount + ownArguments.length];
        System.arraycopy(outerArguments, 0, allArguments, 0, outerArgumentsCount);
        System.arraycopy(ownArguments, 0, allArguments, outerArgumentsCount, ownArguments.length);
        return allArguments;
    }

    @Override
    public char[] qualifiedSourceName() {
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().qualifiedSourceName(), this.sourceName(), '.');
        }
        return this.sourceName();
    }

    @Override
    public char[] readableName() {
        return this.readableName(true);
    }

    public char[] readableName(boolean showGenerics) {
        TypeVariableBinding[] typeVars;
        char[] readableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(showGenerics && this.hasEnclosingInstanceContext()), this.sourceName, '.') : CharOperation.concatWith(this.compoundName, '.');
        if (showGenerics && (typeVars = this.typeVariables()) != Binding.NO_TYPE_VARIABLES) {
            StringBuilder nameBuffer = new StringBuilder(10);
            nameBuffer.append(readableName).append('<');
            int i = 0;
            int length = typeVars.length;
            while (i < length) {
                if (i > 0) {
                    nameBuffer.append(',');
                }
                nameBuffer.append(typeVars[i].readableName());
                ++i;
            }
            nameBuffer.append('>');
            int nameLength = nameBuffer.length();
            readableName = new char[nameLength];
            nameBuffer.getChars(0, nameLength, readableName, 0);
        }
        return readableName;
    }

    protected void appendNullAnnotation(StringBuilder nameBuffer, CompilerOptions options) {
        if (options.isAnnotationBasedNullAnalysisEnabled) {
            if (options.usesNullTypeAnnotations()) {
                AnnotationBinding[] annotationBindingArray = this.typeAnnotations;
                int n = this.typeAnnotations.length;
                int n2 = 0;
                while (n2 < n) {
                    AnnotationBinding annotation = annotationBindingArray[n2];
                    ReferenceBinding annotationType = annotation.getAnnotationType();
                    if (annotationType.hasNullBit(96)) {
                        nameBuffer.append('@').append(annotationType.shortReadableName()).append(' ');
                    }
                    ++n2;
                }
            } else {
                if ((this.tagBits & 0x100000000000000L) != 0L) {
                    char[][] nonNullAnnotationName = options.nonNullAnnotationName;
                    nameBuffer.append('@').append(nonNullAnnotationName[nonNullAnnotationName.length - 1]).append(' ');
                }
                if ((this.tagBits & 0x80000000000000L) != 0L) {
                    char[][] nullableAnnotationName = options.nullableAnnotationName;
                    nameBuffer.append('@').append(nullableAnnotationName[nullableAnnotationName.length - 1]).append(' ');
                }
            }
        }
    }

    public AnnotationHolder retrieveAnnotationHolder(Binding binding, boolean forceInitialization) {
        Map<Binding, AnnotationHolder> store = this.storedAnnotations(forceInitialization, false);
        return store == null ? null : store.get(binding);
    }

    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        AnnotationHolder holder = this.retrieveAnnotationHolder(binding, true);
        return holder == null ? Binding.NO_ANNOTATIONS : holder.getAnnotations();
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotations, boolean forceStore) {
        this.storeAnnotations(this, annotations, forceStore);
    }

    public void setContainerAnnotationType(ReferenceBinding value) {
    }

    public void tagAsHavingDefectiveContainerType() {
    }

    @Override
    public char[] nullAnnotatedReadableName(CompilerOptions options, boolean shortNames) {
        if (shortNames) {
            return this.nullAnnotatedShortReadableName(options);
        }
        return this.nullAnnotatedReadableName(options);
    }

    char[] nullAnnotatedReadableName(CompilerOptions options) {
        StringBuilder nameBuffer = new StringBuilder(10);
        if (this.isMemberType()) {
            nameBuffer.append(this.enclosingType().nullAnnotatedReadableName(options, false));
            nameBuffer.append('.');
            this.appendNullAnnotation(nameBuffer, options);
            nameBuffer.append(this.sourceName);
        } else if (this.compoundName != null) {
            int l = this.compoundName.length;
            int i = 0;
            while (i < l - 1) {
                nameBuffer.append(this.compoundName[i]);
                nameBuffer.append('.');
                ++i;
            }
            this.appendNullAnnotation(nameBuffer, options);
            nameBuffer.append(this.compoundName[i]);
        } else {
            this.appendNullAnnotation(nameBuffer, options);
            if (this.sourceName != null) {
                nameBuffer.append(this.sourceName);
            } else {
                nameBuffer.append(this.readableName());
            }
        }
        TypeBinding[] arguments = this.typeArguments();
        if (arguments != null && arguments.length > 0) {
            nameBuffer.append('<');
            int i = 0;
            int length = arguments.length;
            while (i < length) {
                if (i > 0) {
                    nameBuffer.append(',');
                }
                nameBuffer.append(arguments[i].nullAnnotatedReadableName(options, false));
                ++i;
            }
            nameBuffer.append('>');
        }
        int nameLength = nameBuffer.length();
        char[] readableName = new char[nameLength];
        nameBuffer.getChars(0, nameLength, readableName, 0);
        return readableName;
    }

    char[] nullAnnotatedShortReadableName(CompilerOptions options) {
        StringBuilder nameBuffer = new StringBuilder(10);
        if (this.isMemberType()) {
            nameBuffer.append(this.enclosingType().nullAnnotatedReadableName(options, true));
            nameBuffer.append('.');
            this.appendNullAnnotation(nameBuffer, options);
            nameBuffer.append(this.sourceName);
        } else {
            this.appendNullAnnotation(nameBuffer, options);
            if (this.sourceName != null) {
                nameBuffer.append(this.sourceName);
            } else {
                nameBuffer.append(this.shortReadableName());
            }
        }
        TypeBinding[] arguments = this.typeArguments();
        if (arguments != null && arguments.length > 0) {
            nameBuffer.append('<');
            int i = 0;
            int length = arguments.length;
            while (i < length) {
                if (i > 0) {
                    nameBuffer.append(',');
                }
                nameBuffer.append(arguments[i].nullAnnotatedReadableName(options, true));
                ++i;
            }
            nameBuffer.append('>');
        }
        int nameLength = nameBuffer.length();
        char[] shortReadableName = new char[nameLength];
        nameBuffer.getChars(0, nameLength, shortReadableName, 0);
        return shortReadableName;
    }

    @Override
    public char[] shortReadableName() {
        return this.shortReadableName(true);
    }

    public char[] shortReadableName(boolean showGenerics) {
        TypeVariableBinding[] typeVars;
        char[] shortReadableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(showGenerics && this.hasEnclosingInstanceContext()), this.sourceName, '.') : this.sourceName;
        if (showGenerics && (typeVars = this.typeVariables()) != Binding.NO_TYPE_VARIABLES) {
            StringBuilder nameBuffer = new StringBuilder(10);
            nameBuffer.append(shortReadableName).append('<');
            int i = 0;
            int length = typeVars.length;
            while (i < length) {
                if (i > 0) {
                    nameBuffer.append(',');
                }
                nameBuffer.append(typeVars[i].shortReadableName());
                ++i;
            }
            nameBuffer.append('>');
            int nameLength = nameBuffer.length();
            shortReadableName = new char[nameLength];
            nameBuffer.getChars(0, nameLength, shortReadableName, 0);
        }
        return shortReadableName;
    }

    @Override
    public char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = CharOperation.concat('L', this.constantPoolName(), ';');
        return this.signature;
    }

    @Override
    public char[] sourceName() {
        return this.sourceName;
    }

    void storeAnnotationHolder(Binding binding, AnnotationHolder holder) {
        if (holder == null) {
            Map<Binding, AnnotationHolder> store = this.storedAnnotations(false, false);
            if (store != null) {
                store.remove(binding);
            }
        } else {
            Map<Binding, AnnotationHolder> store = this.storedAnnotations(true, false);
            if (store != null) {
                store.put(binding, holder);
            }
        }
    }

    void storeAnnotations(Binding binding, AnnotationBinding[] annotations, boolean forceStore) {
        AnnotationHolder holder = null;
        if (annotations == null || annotations.length == 0) {
            Map<Binding, AnnotationHolder> store = this.storedAnnotations(false, forceStore);
            if (store != null) {
                holder = store.get(binding);
            }
            if (holder == null) {
                return;
            }
        } else {
            Map<Binding, AnnotationHolder> store = this.storedAnnotations(true, forceStore);
            if (store == null) {
                return;
            }
            holder = store.get(binding);
            if (holder == null) {
                holder = new AnnotationHolder();
            }
        }
        this.storeAnnotationHolder(binding, holder.setAnnotations(annotations));
    }

    Map<Binding, AnnotationHolder> storedAnnotations(boolean forceInitialize, boolean forceStore) {
        return null;
    }

    @Override
    public ReferenceBinding superclass() {
        return null;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        return Binding.NO_SUPERINTERFACES;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.isStatic()) {
            return null;
        }
        ReferenceBinding enclosingType = this.enclosingType();
        if (enclosingType == null) {
            return null;
        }
        return new ReferenceBinding[]{enclosingType};
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods();
    }

    public FieldBinding[] unResolvedFields() {
        return Binding.NO_FIELDS;
    }

    protected int applyCloseableClassWhitelists(CompilerOptions options) {
        switch (this.compoundName.length) {
            case 3: {
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0]) || !CharOperation.equals(TypeConstants.IO, this.compoundName[1])) break;
                char[] simpleName = this.compoundName[2];
                int l = TypeConstants.JAVA_IO_WRAPPER_CLOSEABLES.length;
                int i = 0;
                while (i < l) {
                    if (CharOperation.equals(simpleName, TypeConstants.JAVA_IO_WRAPPER_CLOSEABLES[i])) {
                        return 4;
                    }
                    ++i;
                }
                l = TypeConstants.JAVA_IO_RESOURCE_FREE_CLOSEABLES.length;
                i = 0;
                while (i < l) {
                    if (CharOperation.equals(simpleName, TypeConstants.JAVA_IO_RESOURCE_FREE_CLOSEABLES[i])) {
                        return 8;
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                int i;
                int l;
                if (CharOperation.equals(TypeConstants.JAVA, this.compoundName[0]) && CharOperation.equals(TypeConstants.UTIL, this.compoundName[1]) && CharOperation.equals(TypeConstants.ZIP, this.compoundName[2])) {
                    char[] simpleName = this.compoundName[3];
                    l = TypeConstants.JAVA_UTIL_ZIP_WRAPPER_CLOSEABLES.length;
                    i = 0;
                    while (i < l) {
                        if (CharOperation.equals(simpleName, TypeConstants.JAVA_UTIL_ZIP_WRAPPER_CLOSEABLES[i])) {
                            return 4;
                        }
                        ++i;
                    }
                }
                int i2 = 0;
                while (i2 < 3) {
                    if (!CharOperation.equals(this.compoundName[i2], TypeConstants.ONE_UTIL_STREAMEX[i2])) {
                        return 0;
                    }
                    ++i2;
                }
                char[][] cArray = TypeConstants.RESOURCE_FREE_CLOSEABLE_STREAMEX;
                int n = TypeConstants.RESOURCE_FREE_CLOSEABLE_STREAMEX.length;
                l = 0;
                while (l < n) {
                    char[] streamName = cArray[l];
                    if (CharOperation.equals(this.compoundName[3], streamName)) {
                        return 8;
                    }
                    ++l;
                }
                break;
            }
        }
        int l = TypeConstants.OTHER_WRAPPER_CLOSEABLES.length;
        int i = 0;
        while (i < l) {
            if (CharOperation.equals(this.compoundName, TypeConstants.OTHER_WRAPPER_CLOSEABLES[i])) {
                return 4;
            }
            ++i;
        }
        if (options.analyseResourceLeaks) {
            if (options.isAnnotationBasedResourceAnalysisEnabled && (this.getAnnotationTagBits() & 0x400000000000000L) != 0L) {
                return 8;
            }
            ReferenceBinding mySuper = this.superclass();
            if (mySuper != null && mySuper.id != 1) {
                if (this.hasMethodWithNumArgs(TypeConstants.CLOSE, 0)) {
                    return 0;
                }
                return mySuper.applyCloseableClassWhitelists(options);
            }
        }
        return 0;
    }

    protected boolean hasMethodWithNumArgs(char[] selector, int numArgs) {
        MethodBinding[] methodBindingArray = this.unResolvedMethods();
        int n = methodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding methodBinding = methodBindingArray[n2];
            if (CharOperation.equals(methodBinding.selector, selector) && methodBinding.parameters.length == numArgs) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected int applyCloseableWhitelists(CompilerOptions options) {
        return this.isInterface() ? this.applyCloseableInterfaceWhitelists(options) : this.applyCloseableClassWhitelists(options);
    }

    protected int applyCloseableInterfaceWhitelists(CompilerOptions options) {
        switch (this.compoundName.length) {
            case 4: {
                if (!CharOperation.equals(this.compoundName[0], TypeConstants.JAVA_UTIL_STREAM[0])) break;
                int i = 1;
                while (i < 3) {
                    if (!CharOperation.equals(this.compoundName[i], TypeConstants.JAVA_UTIL_STREAM[i])) {
                        return 0;
                    }
                    ++i;
                }
                char[][] cArray = TypeConstants.RESOURCE_FREE_CLOSEABLE_J_U_STREAMS;
                int n = TypeConstants.RESOURCE_FREE_CLOSEABLE_J_U_STREAMS.length;
                int n2 = 0;
                while (n2 < n) {
                    char[] streamName = cArray[n2];
                    if (CharOperation.equals(this.compoundName[3], streamName)) {
                        return 8;
                    }
                    ++n2;
                }
                break;
            }
        }
        if (options.isAnnotationBasedResourceAnalysisEnabled && (this.getAnnotationTagBits() & 0x400000000000000L) != 0L) {
            return 8;
        }
        return 0;
    }

    public void detectWrapperResource() {
        if (this.hasTypeBit(3) && !this.hasTypeBit(12)) {
            int numResourceFields = 0;
            FieldBinding[] fieldBindingArray = this.fields();
            int n = fieldBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldBinding field = fieldBindingArray[n2];
                if (field.type != null && field.type.hasTypeBit(3) && (field.tagBits & 0x200000000000000L) != 0L) {
                    ++numResourceFields;
                }
                ++n2;
            }
            if (numResourceFields == 1) {
                boolean nonPrivateCtorsReceiveResource = false;
                MethodBinding[] methodBindingArray = this.methods();
                int n3 = methodBindingArray.length;
                n = 0;
                while (n < n3) {
                    MethodBinding method = methodBindingArray[n];
                    if (method.isConstructor() && !method.isPrivate() && method.parameters.length > 0) {
                        TypeBinding param = method.parameters[0];
                        if (param.hasTypeBit(3) && method.ownsParameter(0)) {
                            nonPrivateCtorsReceiveResource = true;
                        } else {
                            nonPrivateCtorsReceiveResource = false;
                            break;
                        }
                    }
                    ++n;
                }
                if (nonPrivateCtorsReceiveResource) {
                    this.typeBits |= 4;
                }
            }
        }
    }

    private MethodBinding[] getFunctionalInterfaceAbstractContracts(Scope scope, boolean replaceWildcards) throws DysfunctionalInterfaceException {
        LookupEnvironment environment = scope.environment();
        boolean isAnnotationBasedNullAnalysisEnabled = environment.globalOptions.isAnnotationBasedNullAnalysisEnabled;
        MethodBinding samCandidate = null;
        MethodBinding[] methods = (MethodBinding[])this.collateFunctionalInterfaceContracts(scope, replaceWildcards, new HashSet<ReferenceBinding>()).sorted((m1, m2) -> CharOperation.compareTo(m1.selector, m2.selector)).toArray(MethodBinding[]::new);
        int i = 0;
        int length = methods.length;
        while (i < length) {
            MethodBinding method = methods[i];
            int j = i + 1;
            while (j < length) {
                MethodBinding otherMethod = methods[j];
                if (method.selector.length != otherMethod.selector.length || !CharOperation.equals(method.selector, otherMethod.selector)) break;
                if (MethodVerifier.doesMethodOverride(otherMethod, method, environment)) {
                    method = null;
                    methods[i] = null;
                    break;
                }
                ++j;
            }
            if (method != null && method.isAbstract()) {
                if (samCandidate == null) {
                    samCandidate = method;
                } else if (!CharOperation.equals(samCandidate.selector, method.selector) || samCandidate.parameters.length != method.parameters.length) {
                    throw DYSFUNCTIONAL_INTERFACE_EXCEPTION;
                }
                if (isAnnotationBasedNullAnalysisEnabled) {
                    ImplicitNullAnnotationVerifier.ensureNullnessIsKnown(method, scope);
                }
            }
            ++i;
        }
        return (MethodBinding[])Arrays.stream(methods).filter(m -> m != null && m.isAbstract()).toArray(MethodBinding[]::new);
    }

    protected Stream<MethodBinding> collateFunctionalInterfaceContracts(Scope scope, boolean replaceWildcards, Set<ReferenceBinding> visitedInterfaces) throws DysfunctionalInterfaceException {
        if (!this.isInterface() || !this.isValidBinding()) {
            throw DYSFUNCTIONAL_INTERFACE_EXCEPTION;
        }
        Predicate<MethodBinding> isContractual = m -> {
            if (m == null || m.isStatic() || m.redeclaresPublicObjectMethod(scope) || m.isPrivate()) {
                return false;
            }
            if (!m.isValidBinding()) {
                throw DYSFUNCTIONAL_INTERFACE_EXCEPTION;
            }
            return true;
        };
        return Stream.concat(Arrays.stream(this.superInterfaces()).filter(iface -> visitedInterfaces.add((ReferenceBinding)iface)).flatMap(superInterface -> superInterface.collateFunctionalInterfaceContracts(scope, replaceWildcards, visitedInterfaces)), Arrays.stream(this.methods()).filter(isContractual));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public MethodBinding getSingleAbstractMethod(Scope scope, boolean replaceWildcards) {
        v0 = index = replaceWildcards != false ? 0 : 1;
        if (this.singleAbstractMethod != null) {
            if (this.singleAbstractMethod[index] != null) {
                return this.singleAbstractMethod[index];
            }
        } else {
            this.singleAbstractMethod = new MethodBinding[2];
            if (this.isPatentlyDysfunctional(scope)) {
                this.singleAbstractMethod[0] = this.singleAbstractMethod[1] = ReferenceBinding.samProblemBinding;
                return this.singleAbstractMethod[1];
            }
        }
        if (this.compoundName != null) {
            scope.compilationUnitScope().recordQualifiedReference(this.compoundName);
        }
        methods = null;
        try {
            methods = this.getFunctionalInterfaceAbstractContracts(scope, replaceWildcards);
            if (methods == null || methods.length == 0) {
                this.singleAbstractMethod[index] = ReferenceBinding.samProblemBinding;
                return this.singleAbstractMethod[index];
            }
            contractParameterLength = 0;
            contractSelector = null;
            var10_10 = methods;
            var9_11 = methods.length;
            var8_12 = 0;
            while (var8_12 < var9_11) {
                method = var10_10[var8_12];
                if (method != null) {
                    if (contractSelector == null) {
                        contractSelector = method.selector;
                        contractParameterLength = method.parameters == null ? 0 : method.parameters.length;
                    } else {
                        v1 = methodParameterLength = method.parameters == null ? 0 : method.parameters.length;
                        if (methodParameterLength != contractParameterLength || !CharOperation.equals(method.selector, contractSelector)) {
                            this.singleAbstractMethod[index] = ReferenceBinding.samProblemBinding;
                            return this.singleAbstractMethod[index];
                        }
                    }
                }
                ++var8_12;
            }
        }
        catch (DysfunctionalInterfaceException e) {
            this.singleAbstractMethod[index] = ReferenceBinding.samProblemBinding;
            return this.singleAbstractMethod[index];
        }
        if (methods.length == 1) {
            this.singleAbstractMethod[index] = methods[0];
            return this.singleAbstractMethod[index];
        }
        environment = scope.environment();
        genericMethodSeen = false;
        length = methods.length;
        analyseNullAnnotations = environment.globalOptions.isAnnotationBasedNullAnalysisEnabled;
        i = length - 1;
        while (i >= 0) {
            block37: {
                method = methods[i];
                otherMethod = null;
                if (method.typeVariables != Binding.NO_TYPE_VARIABLES) {
                    genericMethodSeen = true;
                }
                returnType = method.returnType;
                parameters = method.parameters;
                j = 0;
                while (j < length) {
                    if (i != j) {
                        otherMethod = methods[j];
                        if (otherMethod.typeVariables != Binding.NO_TYPE_VARIABLES) {
                            genericMethodSeen = true;
                        }
                        if (genericMethodSeen && (otherMethod = MethodVerifier.computeSubstituteMethod(otherMethod, method, environment)) == null || !MethodVerifier.isSubstituteParameterSubsignature(method, otherMethod, environment) || !MethodVerifier.areReturnTypesCompatible(method, otherMethod, environment)) break block37;
                        if (analyseNullAnnotations) {
                            returnType = NullAnnotationMatching.strongerType(returnType, otherMethod.returnType, environment);
                            parameters = NullAnnotationMatching.weakerTypes(parameters, otherMethod.parameters, environment);
                        }
                    }
                    ++j;
                }
                exceptions = new ReferenceBinding[]{};
                exceptionsCount = 0;
                exceptionsLength = 0;
                theAbstractMethod = method;
                shouldEraseThrows = theAbstractMethod.typeVariables == Binding.NO_TYPE_VARIABLES && genericMethodSeen != false;
                shouldAdaptThrows = theAbstractMethod.typeVariables != Binding.NO_TYPE_VARIABLES;
                typeVariableLength = theAbstractMethod.typeVariables.length;
                i = 0;
                block5: while (i < length) {
                    method = methods[i];
                    methodThrownExceptions = method.thrownExceptions;
                    v2 = methodExceptionsLength = methodThrownExceptions == null ? 0 : methodThrownExceptions.length;
                    if (methodExceptionsLength == 0) break;
                    if (shouldAdaptThrows && method != theAbstractMethod) {
                        v3 = methodThrownExceptions;
                        methodThrownExceptions = new ReferenceBinding[methodExceptionsLength];
                        System.arraycopy(v3, 0, methodThrownExceptions, 0, methodExceptionsLength);
                        tv = 0;
                        while (tv < typeVariableLength) {
                            if (methodThrownExceptions[tv] instanceof TypeVariableBinding) {
                                methodThrownExceptions[tv] = theAbstractMethod.typeVariables[tv];
                            }
                            ++tv;
                        }
                    }
                    j = 0;
                    while (j < methodExceptionsLength) {
                        block38: {
                            methodException = methodThrownExceptions[j];
                            if (shouldEraseThrows) {
                                methodException = (ReferenceBinding)methodException.erasure();
                            }
                            k = 0;
                            block8: while (k < length) {
                                if (i == k) ** GOTO lbl120
                                otherMethod = methods[k];
                                otherMethodThrownExceptions = otherMethod.thrownExceptions;
                                v4 = otherMethodExceptionsLength = otherMethodThrownExceptions == null ? 0 : otherMethodThrownExceptions.length;
                                if (otherMethodExceptionsLength == 0) break block5;
                                if (shouldAdaptThrows && otherMethod != theAbstractMethod) {
                                    v5 = otherMethodThrownExceptions;
                                    otherMethodThrownExceptions = new ReferenceBinding[otherMethodExceptionsLength];
                                    System.arraycopy(v5, 0, otherMethodThrownExceptions, 0, otherMethodExceptionsLength);
                                    tv = 0;
                                    while (tv < typeVariableLength) {
                                        if (otherMethodThrownExceptions[tv] instanceof TypeVariableBinding) {
                                            otherMethodThrownExceptions[tv] = theAbstractMethod.typeVariables[tv];
                                        }
                                        ++tv;
                                    }
                                }
                                l = 0;
                                while (l < otherMethodExceptionsLength) {
                                    otherException = otherMethodThrownExceptions[l];
                                    if (shouldEraseThrows) {
                                        otherException = (ReferenceBinding)otherException.erasure();
                                    }
                                    if (!methodException.isCompatibleWith(otherException)) {
                                        ++l;
                                        continue;
                                    }
lbl120:
                                    // 3 sources

                                    ++k;
                                    continue block8;
                                }
                                break block38;
                            }
                            if (exceptionsCount == exceptionsLength) {
                                v6 = exceptions;
                                exceptions = new ReferenceBinding[exceptionsLength += 16];
                                System.arraycopy(v6, 0, exceptions, 0, exceptionsCount);
                            }
                            exceptions[exceptionsCount++] = methodException;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (exceptionsCount != exceptionsLength) {
                    v7 = exceptions;
                    exceptions = new ReferenceBinding[exceptionsCount];
                    System.arraycopy(v7, 0, exceptions, 0, exceptionsCount);
                }
                this.singleAbstractMethod[index] = new MethodBinding(theAbstractMethod.modifiers | 4096, theAbstractMethod.selector, returnType, parameters, exceptions, theAbstractMethod.declaringClass);
                this.singleAbstractMethod[index].typeVariables = theAbstractMethod.typeVariables;
                return this.singleAbstractMethod[index];
            }
            --i;
        }
        this.singleAbstractMethod[index] = ReferenceBinding.samProblemBinding;
        return this.singleAbstractMethod[index];
    }

    public static boolean isConsistentIntersection(TypeBinding[] intersectingTypes) {
        TypeBinding[] ci = new TypeBinding[intersectingTypes.length];
        int i = 0;
        while (i < ci.length) {
            TypeBinding current = intersectingTypes[i];
            ci[i] = current.isClass() || current.isArrayType() ? current : current.superclass();
            ++i;
        }
        TypeBinding mostSpecific = ci[0];
        int i2 = 1;
        while (i2 < ci.length) {
            TypeBinding current = ci[i2];
            if (!current.isTypeVariable() && !current.isWildcard() && current.isProperType(true) && !mostSpecific.isSubtypeOf(current, false)) {
                if (current.isSubtypeOf(mostSpecific, false)) {
                    mostSpecific = current;
                } else {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public ModuleBinding module() {
        if (this.fPackage != null) {
            return this.fPackage.enclosingModule;
        }
        return null;
    }

    public boolean hasEnclosingInstanceContext() {
        if (this.isStatic()) {
            return false;
        }
        if (this.isNestedType()) {
            return true;
        }
        MethodBinding enclosingMethod = this.enclosingMethod();
        if (enclosingMethod != null) {
            return !enclosingMethod.isStatic();
        }
        return false;
    }

    public List<ReferenceBinding> getAllEnumerableAvatars() {
        if (!this.isSealed()) {
            throw new UnsupportedOperationException("Operation valid only on sealed types!");
        }
        HashSet<ReferenceBinding> permSet = new HashSet<ReferenceBinding>(Arrays.asList(this.permittedTypes()));
        if (this.isClass() && this.canBeInstantiated()) {
            permSet.add(this);
        }
        HashSet<ReferenceBinding> oldSet = new HashSet<ReferenceBinding>(permSet);
        do {
            for (ReferenceBinding type : permSet) {
                if (!type.isSealed()) continue;
                oldSet.addAll(Arrays.asList(type.permittedTypes()));
            }
            HashSet<ReferenceBinding> tmp = oldSet;
            oldSet = permSet;
            permSet = tmp;
        } while (oldSet.size() != permSet.size());
        return new ArrayList<ReferenceBinding>(permSet);
    }

    public boolean isDisjointFrom(ReferenceBinding that) {
        if (this.isInterface()) {
            if (that.isInterface()) {
                if (this.findSuperTypeOriginatingFrom(that) != null || that.findSuperTypeOriginatingFrom(this) != null) {
                    return false;
                }
                if (this.isSealed()) {
                    ReferenceBinding[] referenceBindingArray = this.permittedTypes();
                    int n = referenceBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ReferenceBinding directSubType = referenceBindingArray[n2];
                        if (!directSubType.isDisjointFrom(that)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                if (that.isSealed()) {
                    ReferenceBinding[] referenceBindingArray = that.permittedTypes();
                    int n = referenceBindingArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ReferenceBinding directSubType = referenceBindingArray[n3];
                        if (!this.isDisjointFrom(directSubType)) {
                            return false;
                        }
                        ++n3;
                    }
                    return true;
                }
                return false;
            }
            return that.isDisjointFrom(this);
        }
        if (that.isInterface()) {
            if (this.findSuperTypeOriginatingFrom(that) != null) {
                return false;
            }
            if (this.isFinal()) {
                return true;
            }
            if (this.isSealed()) {
                ReferenceBinding[] referenceBindingArray = this.permittedTypes();
                int n = referenceBindingArray.length;
                int n4 = 0;
                while (n4 < n) {
                    ReferenceBinding directSubclass = referenceBindingArray[n4];
                    if (!directSubclass.isDisjointFrom(that)) {
                        return false;
                    }
                    ++n4;
                }
                return true;
            }
            if (that.isSealed()) {
                ReferenceBinding[] referenceBindingArray = that.permittedTypes();
                int n = referenceBindingArray.length;
                int n5 = 0;
                while (n5 < n) {
                    ReferenceBinding directSubType = referenceBindingArray[n5];
                    if (!this.isDisjointFrom(directSubType)) {
                        return false;
                    }
                    ++n5;
                }
                return true;
            }
            return false;
        }
        return this.findSuperTypeOriginatingFrom(that) == null && that.findSuperTypeOriginatingFrom(this) == null;
    }

    static class DysfunctionalInterfaceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        DysfunctionalInterfaceException(String message) {
            super(message);
        }
    }
}

