/*
 * Decompiled with CFR 0.152.
 */
package com.github.kklisura.cdt.services.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.kklisura.cdt.protocol.support.types.EventHandler;
import com.github.kklisura.cdt.protocol.support.types.EventListener;
import com.github.kklisura.cdt.services.ChromeDevToolsService;
import com.github.kklisura.cdt.services.WebSocketService;
import com.github.kklisura.cdt.services.config.ChromeDevToolsServiceConfiguration;
import com.github.kklisura.cdt.services.exceptions.ChromeDevToolsInvocationException;
import com.github.kklisura.cdt.services.exceptions.WebSocketServiceException;
import com.github.kklisura.cdt.services.executors.EventExecutorService;
import com.github.kklisura.cdt.services.impl.ChromeServiceImpl;
import com.github.kklisura.cdt.services.types.ChromeTab;
import com.github.kklisura.cdt.services.types.EventListenerImpl;
import com.github.kklisura.cdt.services.types.MethodInvocation;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChromeDevToolsServiceImpl
implements ChromeDevToolsService,
Consumer<String>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromeDevToolsServiceImpl.class);
    private static final String ID_PROPERTY = "id";
    private static final String ERROR_PROPERTY = "error";
    private static final String RESULT_PROPERTY = "result";
    private static final String METHOD_PROPERTY = "method";
    private static final String PARAMS_PROPERTY = "params";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private WebSocketService webSocketService;
    private Map<Long, InvocationResult> invocationResultMap = new ConcurrentHashMap<Long, InvocationResult>();
    private ChromeTab chromeTab;
    private ChromeServiceImpl chromeService;
    private ChromeDevToolsServiceConfiguration configuration;
    private EventExecutorService eventExecutorService;
    private Map<String, Set<EventListenerImpl>> eventNameToHandlersMap = new HashMap<String, Set<EventListenerImpl>>();
    private CountDownLatch closeLatch;

    public ChromeDevToolsServiceImpl(WebSocketService webSocketService, ChromeDevToolsServiceConfiguration configuration) throws WebSocketServiceException {
        this.webSocketService = webSocketService;
        this.configuration = configuration;
        this.eventExecutorService = configuration.getEventExecutorService();
        this.closeLatch = new CountDownLatch(1);
        this.webSocketService.addMessageHandler(this);
    }

    public void setChromeService(ChromeServiceImpl chromeService) {
        this.chromeService = chromeService;
    }

    public void setChromeTab(ChromeTab chromeTab) {
        this.chromeTab = chromeTab;
    }

    @Override
    public <T> T invoke(String returnProperty, Class<T> clazz, MethodInvocation methodInvocation) {
        return this.invoke(returnProperty, clazz, null, methodInvocation);
    }

    @Override
    public <T> T invoke(String returnProperty, Class<T> clazz, Class<?>[] returnTypeClasses, MethodInvocation methodInvocation) {
        try {
            InvocationResult invocationResult = new InvocationResult(returnProperty);
            this.invocationResultMap.put(methodInvocation.getId(), invocationResult);
            this.webSocketService.send(OBJECT_MAPPER.writeValueAsString((Object)methodInvocation));
            boolean hasReceivedResponse = invocationResult.waitForResult(this.configuration.getReadTimeout(), TimeUnit.SECONDS);
            this.invocationResultMap.remove(methodInvocation.getId());
            if (!hasReceivedResponse) {
                throw new ChromeDevToolsInvocationException("Timeout expired while waiting for server response.");
            }
            if (invocationResult.isSuccess()) {
                if (Void.TYPE.equals(clazz)) {
                    return null;
                }
                if (returnTypeClasses != null) {
                    return this.readJsonObject(returnTypeClasses, clazz, invocationResult.getResult());
                }
                return this.readJsonObject(clazz, invocationResult.getResult());
            }
            ErrorObject error = this.readJsonObject(ErrorObject.class, invocationResult.getResult());
            StringBuilder errorMessageBuilder = new StringBuilder(error.getMessage());
            if (error.getData() != null) {
                errorMessageBuilder.append(": ");
                errorMessageBuilder.append(error.getData());
            }
            throw new ChromeDevToolsInvocationException(error.getCode(), errorMessageBuilder.toString());
        }
        catch (WebSocketServiceException e) {
            throw new ChromeDevToolsInvocationException("Failed sending web socket message.", e);
        }
        catch (InterruptedException e) {
            throw new ChromeDevToolsInvocationException("Interrupted while waiting response.", e);
        }
        catch (IOException ex) {
            throw new ChromeDevToolsInvocationException("Failed reading response message.", ex);
        }
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.webSocketService.close();
            if (this.chromeService != null) {
                this.chromeService.clearChromeDevToolsServiceCache(this.chromeTab);
            }
            this.eventExecutorService.shutdown();
            this.closeLatch.countDown();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closeLatch.getCount() == 0L;
    }

    @Override
    public void waitUntilClosed() {
        try {
            this.closeLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public EventListener addEventListener(String domainName, String eventName, EventHandler eventHandler, Class<?> eventType) {
        String name = domainName + "." + eventName;
        EventListenerImpl eventListener = new EventListenerImpl(name, eventHandler, eventType, this);
        this.eventNameToHandlersMap.computeIfAbsent(name, this::createEventHandlerSet).add(eventListener);
        return eventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(EventListener eventListener) {
        Set listeners;
        EventListenerImpl eventListenerImpl = (EventListenerImpl)eventListener;
        String name = eventListenerImpl.getKey();
        EventHandler eventHandler = eventListenerImpl.getHandler();
        Set set = listeners = this.eventNameToHandlersMap.computeIfAbsent(name, this::createEventHandlerSet);
        synchronized (set) {
            listeners.removeIf(next -> eventHandler.equals(next.getHandler()));
        }
    }

    @Override
    public void accept(String message) {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(message);
            JsonNode idNode = jsonNode.get(ID_PROPERTY);
            if (idNode != null) {
                Long id = idNode.asLong();
                InvocationResult invocationResult = this.invocationResultMap.get(id);
                if (invocationResult != null) {
                    JsonNode resultNode = jsonNode.get(RESULT_PROPERTY);
                    JsonNode errorNode = jsonNode.get(ERROR_PROPERTY);
                    if (errorNode != null) {
                        invocationResult.signalResultReady(false, errorNode);
                    } else {
                        if (invocationResult.getReturnProperty() != null && resultNode != null) {
                            resultNode = resultNode.get(invocationResult.getReturnProperty());
                        }
                        if (resultNode != null) {
                            invocationResult.signalResultReady(true, resultNode);
                        } else {
                            invocationResult.signalResultReady(true, null);
                        }
                    }
                } else {
                    LOGGER.warn("Received result response with unknown invocation id {}. {}", (Object)id, (Object)jsonNode.asText());
                }
            } else {
                JsonNode methodNode = jsonNode.get(METHOD_PROPERTY);
                JsonNode paramsNode = jsonNode.get(PARAMS_PROPERTY);
                if (methodNode != null) {
                    this.handleEvent(methodNode.asText(), paramsNode);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed reading web socket message!", (Throwable)ex);
        }
        catch (Exception ex) {
            LOGGER.error("Failed receiving web socket message!", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvent(String name, JsonNode params) {
        Set<EventListenerImpl> listeners = this.eventNameToHandlersMap.get(name);
        if (listeners != null) {
            HashSet<EventListenerImpl> eventListeners;
            Set<EventListenerImpl> set = listeners;
            synchronized (set) {
                eventListeners = new HashSet<EventListenerImpl>(listeners);
            }
            if (!eventListeners.isEmpty()) {
                this.eventExecutorService.execute(() -> {
                    Object event = null;
                    for (EventListenerImpl listener : listeners) {
                        try {
                            if (event == null) {
                                event = this.readJsonObject(listener.getParamType(), params);
                            }
                            listener.getHandler().onEvent(event);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error while processing event {}", (Object)name, (Object)e);
                        }
                    }
                });
            }
        }
    }

    private <T> T readJsonObject(Class<?>[] classParameters, Class<T> parameterizedClazz, JsonNode jsonNode) throws IOException {
        if (jsonNode == null) {
            throw new ChromeDevToolsInvocationException("Failed converting null response to clazz " + parameterizedClazz.getName());
        }
        TypeFactory typeFactory = OBJECT_MAPPER.getTypeFactory();
        JavaType javaType = null;
        if (classParameters.length > 1) {
            for (int i = classParameters.length - 2; i >= 0; --i) {
                javaType = javaType == null ? typeFactory.constructParametricType(classParameters[i], new Class[]{classParameters[i + 1]}) : typeFactory.constructParametricType(classParameters[i], new JavaType[]{javaType});
            }
            javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(parameterizedClazz, new JavaType[]{javaType});
        } else {
            javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(parameterizedClazz, new Class[]{classParameters[0]});
        }
        return (T)OBJECT_MAPPER.readerFor(javaType).readValue(jsonNode);
    }

    private <T> T readJsonObject(Class<T> clazz, JsonNode jsonNode) throws IOException {
        if (jsonNode == null) {
            throw new ChromeDevToolsInvocationException("Failed converting null response to clazz " + clazz.getName());
        }
        return (T)OBJECT_MAPPER.readerFor(clazz).readValue(jsonNode);
    }

    private Set<EventListenerImpl> createEventHandlerSet(String unused) {
        return Collections.synchronizedSet(new HashSet());
    }

    private static class InvocationResult {
        private String returnProperty;
        private JsonNode result;
        private boolean isSuccess;
        private CountDownLatch countDownLatch = new CountDownLatch(1);

        public InvocationResult(String returnProperty) {
            this.returnProperty = returnProperty;
        }

        public String getReturnProperty() {
            return this.returnProperty;
        }

        public JsonNode getResult() {
            return this.result;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public void signalResultReady(boolean isSuccess, JsonNode result) {
            this.isSuccess = isSuccess;
            this.result = result;
            this.countDownLatch.countDown();
        }

        public boolean waitForResult(long timeout, TimeUnit timeUnit) throws InterruptedException {
            if (timeout == 0L) {
                this.countDownLatch.await();
                return true;
            }
            return this.countDownLatch.await(timeout, timeUnit);
        }
    }

    private static class ErrorObject {
        private Long code;
        private String message;
        private String data;

        private ErrorObject() {
        }

        public String getData() {
            return this.data;
        }

        public Long getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

