/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.marketing.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.common.About;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.marketing.core.model.MarketingSurvey;
import com.kms.katalon.marketing.core.model.MarketingUrl;
import com.kms.katalon.marketing.core.model.MarketingUrlContext;
import com.kms.katalon.marketing.core.model.SurveyContext;
import com.kms.katalon.marketing.core.sevices.IMarketingService;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.services.ISessionManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.HashMap;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarketingService
implements IMarketingService {
    private final String HEADER_KS_COMPONENT = "X-Katalon-Studio-Component";
    private final String HEADER_KS_VERSION = "X-Katalon-Studio-Version";
    private final String SURVEY_PATH = "/v1/surveys";
    private final String MKR_URL_PATH = "/v1/views";
    @Inject
    private ISessionManager sessionManager;
    @Inject
    private IDiscoveryService discoveryService;
    @Inject
    private INetworkPreferences networkPreferences;
    @Inject
    private IHttpClient httpClient;

    public MarketingSurvey getSurvey(SurveyContext surveyContext) throws Exception {
        AuthenticationToken katOneToken;
        block3: {
            try {
                katOneToken = this.sessionManager.getKatOneToken();
                if (katOneToken != null) break block3;
                return null;
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e, (String)"Error when getting the quick start survey");
                throw e;
            }
        }
        String baseUrl = this.discoveryService.getServerUrl(ServerType.MARKETING);
        URI baseUri = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/v1/surveys");
        URI uri = uriBuilder.build();
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonBody = objectMapper.writeValueAsString((Object)surveyContext);
        String accessToken = katOneToken.getAccessToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Katalon-Studio-Component", ApplicationEdition.get().getName());
        headers.put("X-Katalon-Studio-Version", About.releaseVersion());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)Authentication.BearerAuthentication((String)accessToken)).proxy(proxyConfig).build();
        HttpResponse response = this.httpClient.jsonPost(uri, jsonBody, httpOptions);
        return (MarketingSurvey)response.json(MarketingSurvey.class);
    }

    public MarketingUrl getUrl(MarketingUrlContext marketingUrlContext) throws Exception {
        AuthenticationToken katOneToken;
        block3: {
            try {
                katOneToken = this.sessionManager.getKatOneToken();
                if (katOneToken != null) break block3;
                return null;
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e, (String)"Error when getting MKT URL");
                throw e;
            }
        }
        String baseUrl = this.discoveryService.getServerUrl(ServerType.MARKETING);
        URI baseUri = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/v1/views");
        URI uri = uriBuilder.build();
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonBody = objectMapper.writeValueAsString((Object)marketingUrlContext);
        String accessToken = katOneToken.getAccessToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Katalon-Studio-Component", ApplicationEdition.get().getName());
        headers.put("X-Katalon-Studio-Version", About.releaseVersion());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)Authentication.BearerAuthentication((String)accessToken)).proxy(proxyConfig).build();
        HttpResponse response = this.httpClient.jsonPost(uri, jsonBody, httpOptions);
        return (MarketingUrl)response.json(MarketingUrl.class);
    }
}

