/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.service;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.testcloud.core.model.APITestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudApplication;
import com.kms.katalon.testcloud.core.model.TestCloudApplicationRequest;
import com.kms.katalon.testcloud.core.model.TestCloudConfiguration;
import com.kms.katalon.testcloud.core.model.TestCloudDeviceRequest;
import com.kms.katalon.testcloud.core.model.TestCloudEntity;
import com.kms.katalon.testcloud.core.model.TestCloudEnvironment;
import com.kms.katalon.testcloud.core.model.TestCloudExecutionMode;
import com.kms.katalon.testcloud.core.model.TestCloudExecutionSessionResponse;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOS;
import com.kms.katalon.testcloud.core.model.TestCloudOS;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import com.kms.katalon.testcloud.core.model.TestCloudSessionTypeRequest;
import com.kms.katalon.testcloud.core.model.TestCloudSessionTypes;
import com.kms.katalon.testcloud.core.model.TestCloudTunnel;
import com.kms.katalon.testcloud.core.model.TestCloudUsage;
import com.kms.katalon.testcloud.core.model.exception.TestCloudAPIException;
import com.kms.katalon.testcloud.core.model.exception.TestCloudException;
import com.kms.katalon.testcloud.core.service.ITestCloudController;
import com.kms.katalon.testcloud.core.service.ITestCloudManager;
import com.kms.katalon.testops.core.model.TestOpsRequestOptions;
import com.kms.katalon.testops.core.services.ITestOpsManager;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class TestCloudController
implements ITestCloudController {
    private final Logger logger = LoggerFactory.getLogger(TestCloudController.class);
    @Inject
    private ITestCloudManager testCloudManager;
    @Inject
    private ITestOpsManager testOpsManager;

    public boolean isEnabled() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    public boolean isMobileNativeSupported() {
        try {
            return this.testCloudManager.isMobileNativeSupported();
        }
        catch (TestCloudException e) {
            this.logger.error(e.getMessage());
            return false;
        }
    }

    public List<TestCloudMobileDevice> requestTestCloudDevice() {
        return this.testCloudManager.requestTestCloudDevices(this.buildTestCloudDeviceRequest());
    }

    public List<TestCloudMobileDevice> requestTestCloudDevice(MobilePlatform mobilePlatform) {
        return this.testCloudManager.requestTestCloudDevices(this.buildTestCloudDeviceRequest(mobilePlatform.toString()));
    }

    public List<TestCloudApplication> requestTestCloudApplication() {
        return this.testCloudManager.requestTestCloudApplications(this.buildTestCloudApplicationRequest("", "READY", null));
    }

    public List<TestCloudApplication> requestTestCloudApplication(MobilePlatform mobilePlatform) {
        return this.testCloudManager.requestTestCloudApplications(this.buildTestCloudApplicationRequest(mobilePlatform.toString(), "READY", null));
    }

    public TestCloudApplication requestTestCloudApplication(String applicationId) throws TestCloudException {
        return this.testCloudManager.requestTestCloudApplication(this.buildTestCloudApplicationRequest("", "READY", applicationId));
    }

    public TestCloudSessionTypes requestTestCloudSessionTypes() throws TestCloudException {
        return this.testCloudManager.requestTestCloudSessionTypes();
    }

    public TestCloudSessionTypes requestTestCloudSessionTypes(TestOpsRequestOptions options) throws TestCloudException {
        return this.testCloudManager.requestTestCloudSessionTypes(options);
    }

    public IRunConfiguration buildRunConfiguration(TestCloudEntity device, TestCloudSessionType type, TestCloudExecutionMode executionMode) throws TestCloudException {
        return this.testCloudManager.buildRunConfiguration(device, type, executionMode);
    }

    private TestCloudDeviceRequest buildTestCloudDeviceRequest() {
        boolean defaultAvailableOnly = true;
        TestCloudDeviceRequest request = new TestCloudDeviceRequest(defaultAvailableOnly);
        return request;
    }

    private TestCloudDeviceRequest buildTestCloudDeviceRequest(String platform) {
        boolean defaultAvailableOnly = true;
        TestCloudDeviceRequest request = new TestCloudDeviceRequest(platform, defaultAvailableOnly);
        return request;
    }

    private TestCloudApplicationRequest buildTestCloudApplicationRequest(String platform, String status, String applicationId) {
        boolean sortDesc = true;
        TestCloudApplicationRequest request = new TestCloudApplicationRequest(platform, status, sortDesc);
        if (applicationId != null) {
            request.setApplicationId(applicationId);
        }
        return request;
    }

    private TestCloudSessionTypeRequest buildTestCloudSessionTypeRequest() {
        return new TestCloudSessionTypeRequest();
    }

    public TestCloudConfiguration[] getConfigurations() throws TestCloudAPIException {
        return this.testCloudManager.getConfigurations();
    }

    public TestCloudEnvironment[] getEnvironments() throws TestCloudAPIException {
        return this.testCloudManager.getEnvironments();
    }

    public APITestCloudMobileDevice[] getMobileDevices() throws TestCloudAPIException {
        return this.testCloudManager.getMobileDevices();
    }

    public boolean checkTestCloudLicense() throws TestCloudException {
        return this.testCloudManager.checkTestCloudLicense();
    }

    public boolean isIntegrationEnabled() {
        return this.testOpsManager.isTestCloudIntegrationEnabled();
    }

    public List<TestCloudMobileOS> parseMobileDevicesForDialog(APITestCloudMobileDevice[] mobileDevices) {
        return this.testCloudManager.parseMobileDevicesForDialog(mobileDevices);
    }

    public List<TestCloudOS> parseEnvironmentsToOSForDialog(TestCloudEnvironment[] environments) {
        return this.testCloudManager.parseEnvironmentsToOSForDialog(environments);
    }

    public int getOSTimeout(String os) throws TestCloudAPIException {
        return this.testCloudManager.getOSTimeout(os);
    }

    public String getGATrialMessage() throws TestCloudAPIException {
        return this.testCloudManager.getGATrialMessage();
    }

    public TestCloudTunnel[] getTunnels() throws TestCloudAPIException {
        return this.testCloudManager.getTunnels();
    }

    public TestCloudUsage getUsage() throws TestCloudAPIException {
        return this.testCloudManager.getUsage();
    }

    public TestCloudExecutionSessionResponse getExecutionSession(String executionSessionId) throws TestCloudAPIException {
        return this.testCloudManager.getExecutionSession(executionSessionId);
    }
}

