/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PColorActivity;
import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PAffineTransformException;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolo.util.PObjectOutputStream;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class PNode
implements Cloneable,
Serializable,
Printable {
    private static final float TRANSPARENCY_RESOLUTION = 0.01f;
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CLIENT_PROPERTIES = "clientProperties";
    public static final int PROPERTY_CODE_CLIENT_PROPERTIES = 1;
    public static final String PROPERTY_BOUNDS = "bounds";
    public static final int PROPERTY_CODE_BOUNDS = 2;
    public static final String PROPERTY_FULL_BOUNDS = "fullBounds";
    public static final int PROPERTY_CODE_FULL_BOUNDS = 4;
    public static final String PROPERTY_TRANSFORM = "transform";
    public static final int PROPERTY_CODE_TRANSFORM = 8;
    public static final String PROPERTY_VISIBLE = "visible";
    public static final int PROPERTY_CODE_VISIBLE = 16;
    public static final String PROPERTY_PAINT = "paint";
    public static final int PROPERTY_CODE_PAINT = 32;
    public static final String PROPERTY_TRANSPARENCY = "transparency";
    public static final int PROPERTY_CODE_TRANSPARENCY = 64;
    public static final String PROPERTY_PICKABLE = "pickable";
    public static final int PROPERTY_CODE_PICKABLE = 128;
    public static final String PROPERTY_CHILDREN_PICKABLE = "childrenPickable";
    public static final int PROPERTY_CODE_CHILDREN_PICKABLE = 256;
    public static final String PROPERTY_CHILDREN = "children";
    public static final int PROPERTY_CODE_CHILDREN = 512;
    public static final String PROPERTY_PARENT = "parent";
    public static final int PROPERTY_CODE_PARENT = 1024;
    private static final PBounds TEMP_REPAINT_BOUNDS = new PBounds();
    public static PSceneGraphDelegate SCENE_GRAPH_DELEGATE = null;
    private transient PNode parent;
    private List children;
    private final PBounds bounds = new PBounds();
    private PAffineTransform transform;
    private Paint paint;
    private float transparency = 1.0f;
    private MutableAttributeSet clientProperties;
    private PBounds fullBoundsCache = new PBounds();
    private int propertyChangeParentMask = 0;
    private transient SwingPropertyChangeSupport changeSupport;
    private transient EventListenerList listenerList;
    private boolean pickable = true;
    private boolean childrenPickable = true;
    private boolean visible = true;
    private boolean childBoundsVolatile;
    private boolean paintInvalid;
    private boolean childPaintInvalid;
    private boolean boundsChanged;
    private boolean fullBoundsInvalid;
    private boolean childBoundsInvalid;
    private boolean occluded;
    private String name;
    public static final int FILL_STRATEGY_ASPECT_FIT = 1;
    public static final int FILL_STRATEGY_ASPECT_COVER = 2;
    public static final int FILL_STRATEGY_EXACT_FIT = 4;

    public PNode(String newName) {
        this();
        this.setName(newName);
    }

    public PNode() {
    }

    public PInterpolatingActivity animateToBounds(double x, double y, double width, double height, long duration) {
        if (duration == 0L) {
            this.setBounds(x, y, width, height);
            return null;
        }
        final PBounds dst = new PBounds(x, y, width, height);
        PInterpolatingActivity interpolatingActivity = new PInterpolatingActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE){
            private PBounds src;

            protected void activityStarted() {
                this.src = PNode.this.getBounds();
                PNode.this.startResizeBounds();
                super.activityStarted();
            }

            public void setRelativeTargetValue(float zeroToOne) {
                PNode.this.setBounds(this.src.x + (double)zeroToOne * (dst.x - this.src.x), this.src.y + (double)zeroToOne * (dst.y - this.src.y), this.src.width + (double)zeroToOne * (dst.width - this.src.width), this.src.height + (double)zeroToOne * (dst.height - this.src.height));
            }

            protected void activityFinished() {
                super.activityFinished();
                PNode.this.endResizeBounds();
            }
        };
        this.addActivity(interpolatingActivity);
        return interpolatingActivity;
    }

    public PTransformActivity animateTransformToBounds(double x, double y, double width, double height, long duration) {
        PAffineTransform t = new PAffineTransform();
        t.setToScale(width / this.getWidth(), height / this.getHeight());
        double scale = t.getScale();
        t.setOffset(x - this.getX() * scale, y - this.getY() * scale);
        return this.animateToTransform(t, duration);
    }

    public PTransformActivity animateToPositionScaleRotation(double x, double y, double scale, double theta, long duration) {
        PAffineTransform t = this.getTransform();
        t.setOffset(x, y);
        t.setScale(scale);
        t.setRotation(theta);
        return this.animateToTransform(t, duration);
    }

    public PTransformActivity animateToTransform(AffineTransform destTransform, long duration) {
        if (duration == 0L) {
            this.setTransform(destTransform);
            return null;
        }
        PTransformActivity.Target t = new PTransformActivity.Target(){

            public void setTransform(AffineTransform aTransform) {
                PNode.this.setTransform(aTransform);
            }

            public void getSourceMatrix(double[] aSource) {
                PNode.this.getTransformReference(true).getMatrix(aSource);
            }
        };
        PTransformActivity ta = new PTransformActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE, t, destTransform);
        this.addActivity(ta);
        return ta;
    }

    public PInterpolatingActivity animateToColor(Color destColor, long duration) {
        if (duration == 0L) {
            this.setPaint(destColor);
            return null;
        }
        PColorActivity.Target t = new PColorActivity.Target(){

            public Color getColor() {
                return (Color)PNode.this.getPaint();
            }

            public void setColor(Color color) {
                PNode.this.setPaint(color);
            }
        };
        PColorActivity ca = new PColorActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE, t, destColor);
        this.addActivity(ca);
        return ca;
    }

    public PInterpolatingActivity animateToTransparency(float zeroToOne, long duration) {
        if (duration == 0L) {
            this.setTransparency(zeroToOne);
            return null;
        }
        final float dest = zeroToOne;
        PInterpolatingActivity ta = new PInterpolatingActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE){
            private float source;

            protected void activityStarted() {
                this.source = PNode.this.getTransparency();
                super.activityStarted();
            }

            public void setRelativeTargetValue(float zeroToOne) {
                PNode.this.setTransparency(this.source + zeroToOne * (dest - this.source));
            }
        };
        this.addActivity(ta);
        return ta;
    }

    public boolean addActivity(PActivity activity) {
        PRoot r = this.getRoot();
        if (r != null) {
            return r.addActivity(activity);
        }
        return false;
    }

    public MutableAttributeSet getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new SimpleAttributeSet();
        }
        return this.clientProperties;
    }

    public Object getAttribute(Object key) {
        if (this.clientProperties == null || key == null) {
            return null;
        }
        return this.clientProperties.getAttribute(key);
    }

    public void addAttribute(Object key, Object value) {
        if (value == null && this.clientProperties == null) {
            return;
        }
        Object oldValue = this.getAttribute(key);
        if (value != oldValue) {
            if (this.clientProperties == null) {
                this.clientProperties = new SimpleAttributeSet();
            }
            if (value == null) {
                this.clientProperties.removeAttribute(key);
            } else {
                this.clientProperties.addAttribute(key, value);
            }
            if (this.clientProperties.getAttributeCount() == 0 && this.clientProperties.getResolveParent() == null) {
                this.clientProperties = null;
            }
            this.firePropertyChange(1, PROPERTY_CLIENT_PROPERTIES, null, this.clientProperties);
            this.firePropertyChange(1, key.toString(), oldValue, value);
        }
    }

    public Enumeration getClientPropertyKeysEnumeration() {
        if (this.clientProperties == null) {
            return PUtil.NULL_ENUMERATION;
        }
        return this.clientProperties.getAttributeNames();
    }

    public Object getAttribute(Object key, Object defaultValue) {
        Object value = this.getAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean getBooleanAttribute(Object key, boolean defaultValue) {
        Boolean value = (Boolean)this.getAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int getIntegerAttribute(Object key, int defaultValue) {
        Number value = (Number)this.getAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        return value.intValue();
    }

    public double getDoubleAttribute(Object key, double defaultValue) {
        Number value = (Number)this.getAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        return value.doubleValue();
    }

    public Object getClientProperty(Object key) {
        return this.getAttribute(key);
    }

    public void addClientProperty(Object key, Object value) {
        this.addAttribute(key, value);
    }

    public Iterator getClientPropertyKeysIterator() {
        Enumeration enumeration = this.getClientPropertyKeysEnumeration();
        return new ClientPropertyKeyIterator(enumeration);
    }

    public Object clone() {
        try {
            byte[] ser = PObjectOutputStream.toByteArray(this);
            return new ObjectInputStream(new ByteArrayInputStream(ser)).readObject();
        }
        catch (IOException e2) {
            return null;
        }
        catch (ClassNotFoundException e3) {
            return null;
        }
    }

    public Point2D localToParent(Point2D localPoint) {
        if (this.transform == null) {
            return localPoint;
        }
        return this.transform.transform(localPoint, localPoint);
    }

    public Dimension2D localToParent(Dimension2D localDimension) {
        if (this.transform == null) {
            return localDimension;
        }
        return this.transform.transform(localDimension, localDimension);
    }

    public Rectangle2D localToParent(Rectangle2D localRectangle) {
        if (this.transform == null) {
            return localRectangle;
        }
        return this.transform.transform(localRectangle, localRectangle);
    }

    public Point2D parentToLocal(Point2D parentPoint) {
        if (this.transform == null) {
            return parentPoint;
        }
        return this.transform.inverseTransform(parentPoint, parentPoint);
    }

    public Dimension2D parentToLocal(Dimension2D parentDimension) {
        if (this.transform == null) {
            return parentDimension;
        }
        return this.transform.inverseTransform(parentDimension, parentDimension);
    }

    public Rectangle2D parentToLocal(Rectangle2D parentRectangle) {
        if (this.transform == null) {
            return parentRectangle;
        }
        return this.transform.inverseTransform(parentRectangle, parentRectangle);
    }

    public Point2D localToGlobal(Point2D localPoint) {
        PNode n2 = this;
        while (n2 != null) {
            n2.localToParent(localPoint);
            n2 = n2.parent;
        }
        return localPoint;
    }

    public Dimension2D localToGlobal(Dimension2D localDimension) {
        PNode n2 = this;
        while (n2 != null) {
            n2.localToParent(localDimension);
            n2 = n2.parent;
        }
        return localDimension;
    }

    public Rectangle2D localToGlobal(Rectangle2D localRectangle) {
        PNode n2 = this;
        while (n2 != null) {
            n2.localToParent(localRectangle);
            n2 = n2.parent;
        }
        return localRectangle;
    }

    public Point2D globalToLocal(Point2D globalPoint) {
        PAffineTransform globalTransform = this.computeGlobalTransform(this);
        return globalTransform.inverseTransform(globalPoint, globalPoint);
    }

    private PAffineTransform computeGlobalTransform(PNode node) {
        if (node == null) {
            return new PAffineTransform();
        }
        PAffineTransform parentGlobalTransform = this.computeGlobalTransform(node.parent);
        if (node.transform != null) {
            parentGlobalTransform.concatenate(node.transform);
        }
        return parentGlobalTransform;
    }

    public Dimension2D globalToLocal(Dimension2D globalDimension) {
        if (this.parent != null) {
            this.parent.globalToLocal(globalDimension);
        }
        return this.parentToLocal(globalDimension);
    }

    public Rectangle2D globalToLocal(Rectangle2D globalRectangle) {
        if (this.parent != null) {
            this.parent.globalToLocal(globalRectangle);
        }
        return this.parentToLocal(globalRectangle);
    }

    public PAffineTransform getLocalToGlobalTransform(PAffineTransform dest) {
        PAffineTransform result = dest;
        if (this.parent != null) {
            result = this.parent.getLocalToGlobalTransform(result);
            if (this.transform != null) {
                result.concatenate(this.transform);
            }
        } else if (dest == null) {
            result = this.getTransform();
        } else if (this.transform != null) {
            result.setTransform(this.transform);
        } else {
            result.setToIdentity();
        }
        return result;
    }

    public PAffineTransform getGlobalToLocalTransform(PAffineTransform dest) {
        PAffineTransform result = this.getLocalToGlobalTransform(dest);
        try {
            result.setTransform(result.createInverse());
        }
        catch (NoninvertibleTransformException e2) {
            throw new PAffineTransformException(e2, result);
        }
        return result;
    }

    public EventListenerList getListenerList() {
        return this.listenerList;
    }

    public void addInputEventListener(PInputEventListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.getListenerList().add(PInputEventListener.class, listener);
    }

    public void removeInputEventListener(PInputEventListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.getListenerList().remove(PInputEventListener.class, listener);
        if (this.listenerList.getListenerCount() == 0) {
            this.listenerList = null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public int getPropertyChangeParentMask() {
        return this.propertyChangeParentMask;
    }

    public void setPropertyChangeParentMask(int propertyChangeParentMask) {
        this.propertyChangeParentMask = propertyChangeParentMask;
    }

    protected void firePropertyChange(int propertyCode, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = null;
        if (this.changeSupport != null) {
            event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            this.changeSupport.firePropertyChange(event);
        }
        if (this.parent != null && (propertyCode & this.propertyChangeParentMask) != 0) {
            if (event == null) {
                event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            }
            this.parent.fireChildPropertyChange(event, propertyCode);
        }
    }

    protected void fireChildPropertyChange(PropertyChangeEvent event, int propertyCode) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(event);
        }
        if (this.parent != null && (propertyCode & this.propertyChangeParentMask) != 0) {
            this.parent.fireChildPropertyChange(event, propertyCode);
        }
    }

    public PBounds getBounds() {
        return (PBounds)this.getBoundsReference().clone();
    }

    public PBounds getBoundsReference() {
        return this.bounds;
    }

    public void startResizeBounds() {
    }

    public void endResizeBounds() {
    }

    public boolean setX(double x) {
        return this.setBounds(x, this.getY(), this.getWidth(), this.getHeight());
    }

    public boolean setY(double y) {
        return this.setBounds(this.getX(), y, this.getWidth(), this.getHeight());
    }

    public boolean setWidth(double width) {
        return this.setBounds(this.getX(), this.getY(), width, this.getHeight());
    }

    public boolean setHeight(double height) {
        return this.setBounds(this.getX(), this.getY(), this.getWidth(), height);
    }

    public boolean setBounds(Rectangle2D newBounds) {
        return this.setBounds(newBounds.getX(), newBounds.getY(), newBounds.getWidth(), newBounds.getHeight());
    }

    public boolean setBounds(double x, double y, double width, double height) {
        if (this.bounds.x != x || this.bounds.y != y || this.bounds.width != width || this.bounds.height != height) {
            this.bounds.setRect(x, y, width, height);
            if (width <= 0.0 || height <= 0.0) {
                this.bounds.reset();
            }
            this.internalUpdateBounds(x, y, width, height);
            this.invalidatePaint();
            this.signalBoundsChanged();
            return true;
        }
        return false;
    }

    protected void internalUpdateBounds(double x, double y, double width, double height) {
    }

    public void resetBounds() {
        this.setBounds(0.0, 0.0, 0.0, 0.0);
    }

    public double getX() {
        return this.getBoundsReference().getX();
    }

    public double getY() {
        return this.getBoundsReference().getY();
    }

    public double getWidth() {
        return this.getBoundsReference().getWidth();
    }

    public double getHeight() {
        return this.getBoundsReference().getHeight();
    }

    public PBounds getGlobalBounds() {
        return (PBounds)this.localToGlobal(this.getBounds());
    }

    public boolean centerBoundsOnPoint(double localX, double localY) {
        double dx = localX - this.bounds.getCenterX();
        double dy = localY - this.bounds.getCenterY();
        return this.setBounds(this.bounds.x + dx, this.bounds.y + dy, this.bounds.width, this.bounds.height);
    }

    public void centerFullBoundsOnPoint(double parentX, double parentY) {
        double dx = parentX - this.getFullBoundsReference().getCenterX();
        double dy = parentY - this.getFullBoundsReference().getCenterY();
        this.offset(dx, dy);
    }

    public boolean intersects(Rectangle2D localBounds) {
        if (localBounds == null) {
            return true;
        }
        return this.getBoundsReference().intersects(localBounds);
    }

    public PBounds getFullBounds() {
        return (PBounds)this.getFullBoundsReference().clone();
    }

    public PBounds getFullBoundsReference() {
        this.validateFullBounds();
        return this.fullBoundsCache;
    }

    public PBounds computeFullBounds(PBounds dstBounds) {
        PBounds result = this.getUnionOfChildrenBounds(dstBounds);
        result.add(this.getBoundsReference());
        this.localToParent(result);
        return result;
    }

    public PBounds getUnionOfChildrenBounds(PBounds dstBounds) {
        PBounds resultBounds;
        if (dstBounds == null) {
            resultBounds = new PBounds();
        } else {
            resultBounds = dstBounds;
            resultBounds.resetToZero();
        }
        int count = this.getChildrenCount();
        for (int i2 = 0; i2 < count; ++i2) {
            PNode each = (PNode)this.children.get(i2);
            resultBounds.add(each.getFullBoundsReference());
        }
        return resultBounds;
    }

    public PBounds getGlobalFullBounds() {
        PBounds b2 = this.getFullBounds();
        if (this.parent != null) {
            this.parent.localToGlobal(b2);
        }
        return b2;
    }

    public boolean fullIntersects(Rectangle2D parentBounds) {
        if (parentBounds == null) {
            return true;
        }
        return this.getFullBoundsReference().intersects(parentBounds);
    }

    protected boolean getBoundsVolatile() {
        return false;
    }

    protected boolean getChildBoundsVolatile() {
        return this.childBoundsVolatile;
    }

    protected void setChildBoundsVolatile(boolean childBoundsVolatile) {
        this.childBoundsVolatile = childBoundsVolatile;
    }

    protected boolean getBoundsChanged() {
        return this.boundsChanged;
    }

    protected void setBoundsChanged(boolean boundsChanged) {
        this.boundsChanged = boundsChanged;
    }

    protected boolean getFullBoundsInvalid() {
        return this.fullBoundsInvalid;
    }

    protected void setFullBoundsInvalid(boolean fullBoundsInvalid) {
        this.fullBoundsInvalid = fullBoundsInvalid;
    }

    protected boolean getChildBoundsInvalid() {
        return this.childBoundsInvalid;
    }

    protected void setChildBoundsInvalid(boolean childBoundsInvalid) {
        this.childBoundsInvalid = childBoundsInvalid;
    }

    public void signalBoundsChanged() {
        this.invalidateFullBounds();
        this.setBoundsChanged(true);
        this.firePropertyChange(2, PROPERTY_BOUNDS, null, this.bounds);
        int count = this.getChildrenCount();
        for (int i2 = 0; i2 < count; ++i2) {
            PNode each = (PNode)this.children.get(i2);
            each.parentBoundsChanged();
        }
    }

    public void invalidateLayout() {
        this.invalidateFullBounds();
    }

    protected void parentBoundsChanged() {
    }

    public void invalidateFullBounds() {
        this.setFullBoundsInvalid(true);
        PNode n2 = this.parent;
        while (n2 != null && !n2.getChildBoundsInvalid()) {
            n2.setChildBoundsInvalid(true);
            n2 = n2.parent;
        }
        if (SCENE_GRAPH_DELEGATE != null) {
            SCENE_GRAPH_DELEGATE.nodeFullBoundsInvalidated(this);
        }
    }

    protected boolean validateFullBounds() {
        boolean boundsVolatile = this.getBoundsVolatile();
        if (this.fullBoundsInvalid || this.childBoundsInvalid || boundsVolatile || this.childBoundsVolatile) {
            if (boundsVolatile && !this.boundsChanged) {
                this.signalBoundsChanged();
            }
            if (this.childBoundsInvalid || this.childBoundsVolatile) {
                this.childBoundsVolatile = false;
                int count = this.getChildrenCount();
                for (int i2 = 0; i2 < count; ++i2) {
                    PNode each = (PNode)this.children.get(i2);
                    this.childBoundsVolatile |= each.validateFullBounds();
                }
            }
            this.layoutChildren();
            if (this.fullBoundsInvalid) {
                boolean fullBoundsChanged;
                double oldX = this.fullBoundsCache.x;
                double oldY = this.fullBoundsCache.y;
                double oldWidth = this.fullBoundsCache.width;
                double oldHeight = this.fullBoundsCache.height;
                boolean oldEmpty = this.fullBoundsCache.isEmpty();
                this.fullBoundsCache = this.computeFullBounds(this.fullBoundsCache);
                boolean bl = fullBoundsChanged = this.fullBoundsCache.x != oldX || this.fullBoundsCache.y != oldY || this.fullBoundsCache.width != oldWidth || this.fullBoundsCache.height != oldHeight || this.fullBoundsCache.isEmpty() != oldEmpty;
                if (fullBoundsChanged) {
                    if (this.parent != null) {
                        this.parent.invalidateFullBounds();
                    }
                    this.firePropertyChange(4, PROPERTY_FULL_BOUNDS, null, this.fullBoundsCache);
                    if (this.paintInvalid && !oldEmpty) {
                        TEMP_REPAINT_BOUNDS.setRect(oldX, oldY, oldWidth, oldHeight);
                        this.repaintFrom(TEMP_REPAINT_BOUNDS, this);
                    }
                }
            }
            this.boundsChanged = false;
            this.fullBoundsInvalid = false;
            this.childBoundsInvalid = false;
        }
        return boundsVolatile || this.childBoundsVolatile;
    }

    protected void layoutChildren() {
    }

    public double getRotation() {
        if (this.transform == null) {
            return 0.0;
        }
        return this.transform.getRotation();
    }

    public void setRotation(double theta) {
        this.rotate(theta - this.getRotation());
    }

    public void rotate(double theta) {
        this.rotateAboutPoint(theta, 0.0, 0.0);
    }

    public void rotateInPlace(double theta) {
        PBounds b2 = this.getFullBoundsReference();
        double px = b2.x;
        double py = b2.y;
        this.rotateAboutPoint(theta, 0.0, 0.0);
        b2 = this.getFullBoundsReference();
        this.offset(px - b2.x, py - b2.y);
    }

    public void rotateAboutPoint(double theta, Point2D point) {
        this.rotateAboutPoint(theta, point.getX(), point.getY());
    }

    public void rotateAboutPoint(double theta, double x, double y) {
        this.getTransformReference(true).rotate(theta, x, y);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public double getGlobalRotation() {
        return this.getLocalToGlobalTransform(null).getRotation();
    }

    public void setGlobalRotation(double theta) {
        if (this.parent != null) {
            this.setRotation(theta - this.parent.getGlobalRotation());
        } else {
            this.setRotation(theta);
        }
    }

    public double getScale() {
        if (this.transform == null) {
            return 1.0;
        }
        return this.transform.getScale();
    }

    public void setScale(double scale) {
        if (scale == 0.0) {
            throw new RuntimeException("Can't set scale to 0");
        }
        this.scale(scale / this.getScale());
    }

    public void scale(double scale) {
        this.scaleAboutPoint(scale, 0.0, 0.0);
    }

    public void scaleAboutPoint(double scale, Point2D point) {
        this.scaleAboutPoint(scale, point.getX(), point.getY());
    }

    public void scaleAboutPoint(double scale, double x, double y) {
        this.getTransformReference(true).scaleAboutPoint(scale, x, y);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public double getGlobalScale() {
        return this.getLocalToGlobalTransform(null).getScale();
    }

    public void setGlobalScale(double scale) {
        if (this.parent != null) {
            this.setScale(scale / this.parent.getGlobalScale());
        } else {
            this.setScale(scale);
        }
    }

    public double getXOffset() {
        if (this.transform == null) {
            return 0.0;
        }
        return this.transform.getTranslateX();
    }

    public double getYOffset() {
        if (this.transform == null) {
            return 0.0;
        }
        return this.transform.getTranslateY();
    }

    public Point2D getOffset() {
        if (this.transform == null) {
            return new Point2D.Double();
        }
        return new Point2D.Double(this.transform.getTranslateX(), this.transform.getTranslateY());
    }

    public void setOffset(Point2D point) {
        this.setOffset(point.getX(), point.getY());
    }

    public void setOffset(double x, double y) {
        this.getTransformReference(true).setOffset(x, y);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public void offset(double dx, double dy) {
        this.getTransformReference(true);
        this.setOffset(this.transform.getTranslateX() + dx, this.transform.getTranslateY() + dy);
    }

    public void translate(double dx, double dy) {
        this.getTransformReference(true).translate(dx, dy);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public Point2D getGlobalTranslation() {
        Point2D p = this.getOffset();
        if (this.parent != null) {
            this.parent.localToGlobal(p);
        }
        return p;
    }

    public void setGlobalTranslation(Point2D globalPoint) {
        if (this.parent != null) {
            this.parent.getGlobalToLocalTransform(null).transform(globalPoint, globalPoint);
        }
        this.setOffset(globalPoint);
    }

    public void transformBy(AffineTransform aTransform) {
        this.getTransformReference(true).concatenate(aTransform);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public static double lerp(double t, double a2, double b2) {
        return a2 + t * (b2 - a2);
    }

    public PActivity animateToRelativePosition(Point2D srcPt, Point2D destPt, Rectangle2D destBounds, int millis) {
        if (this.parent == null) {
            return null;
        }
        PBounds srcBounds = this.getGlobalFullBounds();
        double srcx = PNode.lerp(srcPt.getX(), ((RectangularShape)srcBounds).getX(), ((RectangularShape)srcBounds).getX() + ((RectangularShape)srcBounds).getWidth());
        double srcy = PNode.lerp(srcPt.getY(), ((RectangularShape)srcBounds).getY(), ((RectangularShape)srcBounds).getY() + ((RectangularShape)srcBounds).getHeight());
        double destx = PNode.lerp(destPt.getX(), destBounds.getX(), destBounds.getX() + destBounds.getWidth());
        double desty = PNode.lerp(destPt.getY(), destBounds.getY(), destBounds.getY() + destBounds.getHeight());
        Point2D.Double pt1 = new Point2D.Double(srcx, srcy);
        this.globalToLocal(pt1);
        Point2D.Double pt2 = new Point2D.Double(destx, desty);
        this.globalToLocal(pt2);
        double dx = ((Point2D)pt2).getX() - ((Point2D)pt1).getX();
        double dy = ((Point2D)pt2).getY() - ((Point2D)pt1).getY();
        PAffineTransform at = new PAffineTransform(this.getTransformReference(true));
        at.translate(dx, dy);
        return this.animateToTransform(at, millis);
    }

    public void position(Point2D srcPt, Point2D destPt, Rectangle2D destBounds, int millis) {
        this.animateToRelativePosition(srcPt, destPt, destBounds, millis);
    }

    public PAffineTransform getTransform() {
        if (this.transform == null) {
            return new PAffineTransform();
        }
        return (PAffineTransform)this.transform.clone();
    }

    public PAffineTransform getTransformReference(boolean createNewTransformIfNull) {
        if (this.transform == null && createNewTransformIfNull) {
            this.transform = new PAffineTransform();
        }
        return this.transform;
    }

    public PAffineTransform getInverseTransform() {
        if (this.transform == null) {
            return new PAffineTransform();
        }
        try {
            return new PAffineTransform(this.transform.createInverse());
        }
        catch (NoninvertibleTransformException e2) {
            throw new PAffineTransformException(e2, this.transform);
        }
    }

    public void setTransform(AffineTransform transform) {
        if (transform == null) {
            this.transform = null;
        } else {
            this.getTransformReference(true).setTransform(transform);
        }
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public boolean getPaintInvalid() {
        return this.paintInvalid;
    }

    public void setPaintInvalid(boolean paintInvalid) {
        this.paintInvalid = paintInvalid;
    }

    public boolean getChildPaintInvalid() {
        return this.childPaintInvalid;
    }

    public void setChildPaintInvalid(boolean childPaintInvalid) {
        this.childPaintInvalid = childPaintInvalid;
    }

    public void invalidatePaint() {
        this.setPaintInvalid(true);
        PNode n2 = this.parent;
        while (n2 != null && !n2.getChildPaintInvalid()) {
            n2.setChildPaintInvalid(true);
            n2 = n2.parent;
        }
        if (SCENE_GRAPH_DELEGATE != null) {
            SCENE_GRAPH_DELEGATE.nodePaintInvalidated(this);
        }
    }

    public void validateFullPaint() {
        if (this.getPaintInvalid()) {
            this.repaint();
            this.setPaintInvalid(false);
        }
        if (this.getChildPaintInvalid()) {
            int count = this.getChildrenCount();
            for (int i2 = 0; i2 < count; ++i2) {
                PNode each = (PNode)this.children.get(i2);
                each.validateFullPaint();
            }
            this.setChildPaintInvalid(false);
        }
    }

    public void repaint() {
        TEMP_REPAINT_BOUNDS.setRect(this.getFullBoundsReference());
        this.repaintFrom(TEMP_REPAINT_BOUNDS, this);
    }

    public void repaintFrom(PBounds localBounds, PNode childOrThis) {
        if (this.parent != null) {
            if (childOrThis != this) {
                this.localToParent(localBounds);
            } else if (!this.getVisible()) {
                return;
            }
            this.parent.repaintFrom(localBounds, this);
        }
    }

    public boolean isOpaque(Rectangle2D boundary) {
        return false;
    }

    public boolean getOccluded() {
        return this.occluded;
    }

    public void setOccluded(boolean occluded) {
        this.occluded = occluded;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean isVisible) {
        if (this.getVisible() != isVisible) {
            if (!isVisible) {
                this.repaint();
            }
            this.visible = isVisible;
            this.firePropertyChange(16, PROPERTY_VISIBLE, null, null);
            this.invalidatePaint();
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint newPaint) {
        if (this.paint == newPaint) {
            return;
        }
        Paint oldPaint = this.paint;
        this.paint = newPaint;
        this.invalidatePaint();
        this.firePropertyChange(32, PROPERTY_PAINT, oldPaint, this.paint);
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float newTransparency) {
        if (Math.abs(this.transparency - newTransparency) > 0.01f) {
            float oldTransparency = this.transparency;
            this.transparency = newTransparency;
            this.invalidatePaint();
            this.firePropertyChange(64, PROPERTY_TRANSPARENCY, new Float(oldTransparency), new Float(newTransparency));
        }
    }

    protected void paint(PPaintContext paintContext) {
        if (this.paint != null) {
            Graphics2D g2 = paintContext.getGraphics();
            g2.setPaint(this.paint);
            g2.fill(this.getBoundsReference());
        }
    }

    public void fullPaint(PPaintContext paintContext) {
        if (this.getVisible() && this.fullIntersects(paintContext.getLocalClip())) {
            paintContext.pushTransform(this.transform);
            paintContext.pushTransparency(this.transparency);
            if (!this.getOccluded()) {
                this.paint(paintContext);
            }
            int count = this.getChildrenCount();
            for (int i2 = 0; i2 < count; ++i2) {
                PNode each = (PNode)this.children.get(i2);
                each.fullPaint(paintContext);
            }
            this.paintAfterChildren(paintContext);
            paintContext.popTransparency(this.transparency);
            paintContext.popTransform(this.transform);
        }
    }

    protected void paintAfterChildren(PPaintContext paintContext) {
    }

    public Image toImage() {
        PBounds b2 = this.getFullBoundsReference();
        return this.toImage((int)Math.ceil(b2.getWidth()), (int)Math.ceil(b2.getHeight()), null);
    }

    public Image toImage(int width, int height, Paint backgroundPaint) {
        BufferedImage result;
        if (GraphicsEnvironment.isHeadless()) {
            result = new BufferedImage(width, height, 2);
        } else {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            result = graphicsConfiguration.createCompatibleImage(width, height, 3);
        }
        return this.toImage(result, backgroundPaint);
    }

    public Image toImage(BufferedImage image, Paint backGroundPaint) {
        return this.toImage(image, backGroundPaint, 1);
    }

    public Image toImage(BufferedImage image, Paint backGroundPaint, int fillStrategy) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        Graphics2D g2 = image.createGraphics();
        if (backGroundPaint != null) {
            g2.setPaint(backGroundPaint);
            g2.fillRect(0, 0, imageWidth, imageHeight);
        }
        g2.setClip(0, 0, imageWidth, imageHeight);
        PBounds nodeBounds = this.getFullBounds();
        nodeBounds.expandNearestIntegerDimensions();
        double nodeWidth = nodeBounds.getWidth();
        double nodeHeight = nodeBounds.getHeight();
        double imageRatio = (double)imageWidth / ((double)imageHeight * 1.0);
        double nodeRatio = nodeWidth / nodeHeight;
        switch (fillStrategy) {
            case 1: {
                double scale = nodeRatio <= imageRatio ? (double)image.getHeight() / nodeHeight : (double)image.getWidth() / nodeWidth;
                g2.scale(scale, scale);
                g2.translate(-nodeBounds.x, -nodeBounds.y);
                break;
            }
            case 2: {
                double scale = nodeRatio <= imageRatio ? (double)image.getWidth() / nodeWidth : (double)image.getHeight() / nodeHeight;
                g2.scale(scale, scale);
                break;
            }
            case 4: {
                g2.scale((double)image.getWidth() / nodeWidth, (double)image.getHeight() / nodeHeight);
                g2.translate(-nodeBounds.x, -nodeBounds.y);
                break;
            }
            default: {
                throw new IllegalArgumentException("Fill strategy provided is invalid");
            }
        }
        PPaintContext pc = new PPaintContext(g2);
        pc.setRenderQuality(1);
        this.fullPaint(pc);
        return image;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printJob.defaultPage();
        Book book = new Book();
        book.append(this, pageFormat);
        printJob.setPageable(book);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException e2) {
                throw new RuntimeException("Error Printing", e2);
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        if (!(graphics instanceof Graphics2D)) {
            throw new IllegalArgumentException("Provided graphics context is not a Graphics2D object");
        }
        Graphics2D g2 = (Graphics2D)graphics;
        PBounds imageBounds = this.getFullBounds();
        imageBounds.expandNearestIntegerDimensions();
        g2.setClip(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double scale = pageFormat.getImageableWidth() / imageBounds.getWidth();
        if (pageFormat.getImageableHeight() / imageBounds.getHeight() < scale) {
            scale = pageFormat.getImageableHeight() / imageBounds.getHeight();
        }
        g2.scale(scale, scale);
        g2.translate(-imageBounds.x, -imageBounds.y);
        PPaintContext pc = new PPaintContext(g2);
        pc.setRenderQuality(1);
        this.fullPaint(pc);
        return 0;
    }

    public boolean getPickable() {
        return this.pickable;
    }

    public void setPickable(boolean isPickable) {
        if (this.getPickable() != isPickable) {
            this.pickable = isPickable;
            this.firePropertyChange(128, PROPERTY_PICKABLE, null, null);
        }
    }

    public boolean getChildrenPickable() {
        return this.childrenPickable;
    }

    public void setChildrenPickable(boolean areChildrenPickable) {
        if (this.getChildrenPickable() != areChildrenPickable) {
            this.childrenPickable = areChildrenPickable;
            this.firePropertyChange(256, PROPERTY_CHILDREN_PICKABLE, null, null);
        }
    }

    protected boolean pick(PPickPath pickPath) {
        return false;
    }

    public boolean fullPick(PPickPath pickPath) {
        if (this.getVisible() && (this.getPickable() || this.getChildrenPickable()) && this.fullIntersects(pickPath.getPickBounds())) {
            boolean thisPickable;
            pickPath.pushNode(this);
            pickPath.pushTransform(this.transform);
            boolean bl = thisPickable = this.getPickable() && pickPath.acceptsNode(this);
            if (thisPickable && this.pick(pickPath)) {
                return true;
            }
            if (this.getChildrenPickable()) {
                int count = this.getChildrenCount();
                for (int i2 = count - 1; i2 >= 0; --i2) {
                    PNode each = (PNode)this.children.get(i2);
                    if (!each.fullPick(pickPath)) continue;
                    return true;
                }
            }
            if (thisPickable && this.pickAfterChildren(pickPath)) {
                return true;
            }
            pickPath.popTransform(this.transform);
            pickPath.popNode(this);
        }
        return false;
    }

    public void findIntersectingNodes(Rectangle2D fullBounds, ArrayList results) {
        if (this.fullIntersects(fullBounds)) {
            Rectangle2D localBounds = this.parentToLocal((Rectangle2D)fullBounds.clone());
            if (this.intersects(localBounds)) {
                results.add(this);
            }
            int count = this.getChildrenCount();
            for (int i2 = count - 1; i2 >= 0; --i2) {
                PNode each = (PNode)this.children.get(i2);
                each.findIntersectingNodes(localBounds, results);
            }
        }
    }

    protected boolean pickAfterChildren(PPickPath pickPath) {
        return this.intersects(pickPath.getPickBounds());
    }

    public void addChild(PNode child) {
        int insertIndex = this.getChildrenCount();
        if (child.parent == this) {
            --insertIndex;
        }
        this.addChild(insertIndex, child);
    }

    public void addChild(int index, PNode child) {
        PNode oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
        child.setParent(this);
        this.getChildrenReference().add(index, child);
        child.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(512, PROPERTY_CHILDREN, null, this.children);
    }

    public void addChildren(Collection nodes) {
        Iterator i2 = nodes.iterator();
        while (i2.hasNext()) {
            PNode each = (PNode)i2.next();
            this.addChild(each);
        }
    }

    public boolean isAncestorOf(PNode node) {
        PNode p = node.parent;
        while (p != null) {
            if (p == this) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public boolean isDescendentOf(PNode node) {
        PNode p = this.parent;
        while (p != null) {
            if (p == node) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public boolean isDescendentOfRoot() {
        return this.getRoot() != null;
    }

    public void moveToBack() {
        PNode p = this.parent;
        if (p != null) {
            p.removeChild(this);
            p.addChild(0, this);
        }
    }

    public void moveInBackOf(PNode sibling) {
        PNode p = this.parent;
        if (p != null && p == sibling.getParent()) {
            p.removeChild(this);
            int index = p.indexOfChild(sibling);
            p.addChild(index, this);
        }
    }

    public void moveToFront() {
        PNode p = this.parent;
        if (p != null) {
            p.removeChild(this);
            p.addChild(this);
        }
    }

    public void moveInFrontOf(PNode sibling) {
        PNode p = this.parent;
        if (p != null && p == sibling.getParent()) {
            p.removeChild(this);
            int index = p.indexOfChild(sibling);
            p.addChild(index + 1, this);
        }
    }

    public PNode getParent() {
        return this.parent;
    }

    public void setParent(PNode newParent) {
        PNode old = this.parent;
        this.parent = newParent;
        this.firePropertyChange(1024, PROPERTY_PARENT, old, this.parent);
    }

    public int indexOfChild(PNode child) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(child);
    }

    public PNode removeChild(PNode child) {
        int index = this.indexOfChild(child);
        if (index == -1) {
            return null;
        }
        return this.removeChild(index);
    }

    public PNode removeChild(int index) {
        if (this.children == null) {
            return null;
        }
        PNode child = (PNode)this.children.remove(index);
        if (this.children.size() == 0) {
            this.children = null;
        }
        child.repaint();
        child.setParent(null);
        this.invalidateFullBounds();
        this.firePropertyChange(512, PROPERTY_CHILDREN, null, this.children);
        return child;
    }

    public void removeChildren(Collection childrenNodes) {
        Iterator i2 = childrenNodes.iterator();
        while (i2.hasNext()) {
            PNode each = (PNode)i2.next();
            this.removeChild(each);
        }
    }

    public void removeAllChildren() {
        if (this.children != null) {
            int count = this.children.size();
            for (int i2 = 0; i2 < count; ++i2) {
                PNode each = (PNode)this.children.get(i2);
                each.setParent(null);
            }
            this.children = null;
            this.invalidatePaint();
            this.invalidateFullBounds();
            this.firePropertyChange(512, PROPERTY_CHILDREN, null, this.children);
        }
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public void reparent(PNode newParent) {
        PAffineTransform originalTransform = this.getLocalToGlobalTransform(null);
        PAffineTransform newTransform = newParent.getGlobalToLocalTransform(null);
        newTransform.concatenate(originalTransform);
        this.removeFromParent();
        this.setTransform(newTransform);
        newParent.addChild(this);
        this.computeFullBounds(this.fullBoundsCache);
    }

    public void replaceWith(PNode replacementNode) {
        if (this.parent != null) {
            PNode p = this.parent;
            int index = p.getChildrenReference().indexOf(this);
            p.removeChild(this);
            p.addChild(index, replacementNode);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getChildrenCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public PNode getChild(int index) {
        return (PNode)this.children.get(index);
    }

    public List getChildrenReference() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public ListIterator getChildrenIterator() {
        if (this.children == null) {
            return Collections.EMPTY_LIST.listIterator();
        }
        return Collections.unmodifiableList(this.children).listIterator();
    }

    public PRoot getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return null;
    }

    public Collection getAllNodes() {
        return this.getAllNodes(null, null);
    }

    public Collection getAllNodes(PNodeFilter filter, Collection resultantNodes) {
        ArrayList<PNode> results = resultantNodes == null ? new ArrayList<PNode>() : resultantNodes;
        if (filter == null || filter.accept(this)) {
            results.add(this);
        }
        if (filter == null || filter.acceptChildrenOf(this)) {
            int count = this.getChildrenCount();
            for (int i2 = 0; i2 < count; ++i2) {
                PNode each = (PNode)this.children.get(i2);
                each.getAllNodes(filter, results);
            }
        }
        return results;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!(out instanceof PObjectOutputStream)) {
            throw new IllegalArgumentException("PNode.writeObject may only be used with PObjectOutputStreams");
        }
        out.defaultWriteObject();
        ((PObjectOutputStream)out).writeConditionalObject(this.parent);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.parent = (PNode)in.readObject();
    }

    protected String paramString() {
        return "";
    }

    public PInputEventListener[] getInputEventListeners() {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return new PInputEventListener[0];
        }
        EventListener[] listeners = this.listenerList.getListeners(PInputEventListener.class);
        PInputEventListener[] result = new PInputEventListener[listeners.length];
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            result[i2] = (PInputEventListener)listeners[i2];
        }
        return result;
    }

    public static interface PSceneGraphDelegate {
        public void nodePaintInvalidated(PNode var1);

        public void nodeFullBoundsInvalidated(PNode var1);
    }

    private static final class ClientPropertyKeyIterator
    implements Iterator {
        private final Enumeration enumeration;

        private ClientPropertyKeyIterator(Enumeration enumeration) {
            this.enumeration = enumeration;
        }

        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        public Object next() {
            return this.enumeration.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

