/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.handles;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolox.handles.PHandle;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.Cursor;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.ListIterator;

public class PBoundsHandle
extends PHandle {
    private static final long serialVersionUID = 1L;
    private transient PBasicInputEventHandler handleCursorHandler;

    public static void addBoundsHandlesTo(PNode node) {
        node.addChild(new PBoundsHandle(PBoundsLocator.createEastLocator(node)));
        node.addChild(new PBoundsHandle(PBoundsLocator.createWestLocator(node)));
        node.addChild(new PBoundsHandle(PBoundsLocator.createNorthLocator(node)));
        node.addChild(new PBoundsHandle(PBoundsLocator.createSouthLocator(node)));
        node.addChild(new PBoundsHandle(PBoundsLocator.createNorthEastLocator(node)));
        node.addChild(new PBoundsHandle(PBoundsLocator.createNorthWestLocator(node)));
        node.addChild(new PBoundsHandle(PBoundsLocator.createSouthEastLocator(node)));
        node.addChild(new PBoundsHandle(PBoundsLocator.createSouthWestLocator(node)));
    }

    public static void addStickyBoundsHandlesTo(PNode node, PCamera camera) {
        camera.addChild(new PBoundsHandle(PBoundsLocator.createEastLocator(node)));
        camera.addChild(new PBoundsHandle(PBoundsLocator.createWestLocator(node)));
        camera.addChild(new PBoundsHandle(PBoundsLocator.createNorthLocator(node)));
        camera.addChild(new PBoundsHandle(PBoundsLocator.createSouthLocator(node)));
        camera.addChild(new PBoundsHandle(PBoundsLocator.createNorthEastLocator(node)));
        camera.addChild(new PBoundsHandle(PBoundsLocator.createNorthWestLocator(node)));
        camera.addChild(new PBoundsHandle(PBoundsLocator.createSouthEastLocator(node)));
        camera.addChild(new PBoundsHandle(PBoundsLocator.createSouthWestLocator(node)));
    }

    public static void removeBoundsHandlesFrom(PNode node) {
        ArrayList<PNode> handles = new ArrayList<PNode>();
        ListIterator i2 = node.getChildrenIterator();
        while (i2.hasNext()) {
            PNode each = (PNode)i2.next();
            if (!(each instanceof PBoundsHandle)) continue;
            handles.add(each);
        }
        node.removeChildren(handles);
    }

    public PBoundsHandle(PBoundsLocator locator) {
        super(locator);
    }

    protected void installHandleEventHandlers() {
        super.installHandleEventHandlers();
        this.handleCursorHandler = new MouseCursorUpdateHandler();
        this.addInputEventListener(this.handleCursorHandler);
    }

    public PBasicInputEventHandler getHandleCursorEventHandler() {
        return this.handleCursorHandler;
    }

    public void startHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        PBoundsLocator l2 = (PBoundsLocator)this.getLocator();
        l2.getNode().startResizeBounds();
    }

    public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
        PBoundsLocator l2 = (PBoundsLocator)this.getLocator();
        PNode n2 = l2.getNode();
        PBounds b2 = n2.getBounds();
        PNode parent = this.getParent();
        if (parent != n2 && parent instanceof PCamera) {
            ((PCamera)parent).localToView(aLocalDimension);
        }
        this.localToGlobal(aLocalDimension);
        n2.globalToLocal(aLocalDimension);
        double dx = aLocalDimension.getWidth();
        double dy = aLocalDimension.getHeight();
        switch (l2.getSide()) {
            case 1: {
                b2.setRect(b2.x, b2.y + dy, b2.width, b2.height - dy);
                break;
            }
            case 5: {
                b2.setRect(b2.x, b2.y, b2.width, b2.height + dy);
                break;
            }
            case 3: {
                b2.setRect(b2.x, b2.y, b2.width + dx, b2.height);
                break;
            }
            case 7: {
                b2.setRect(b2.x + dx, b2.y, b2.width - dx, b2.height);
                break;
            }
            case 8: {
                b2.setRect(b2.x + dx, b2.y + dy, b2.width - dx, b2.height - dy);
                break;
            }
            case 6: {
                b2.setRect(b2.x + dx, b2.y, b2.width - dx, b2.height + dy);
                break;
            }
            case 2: {
                b2.setRect(b2.x, b2.y + dy, b2.width + dx, b2.height - dy);
                break;
            }
            case 4: {
                b2.setRect(b2.x, b2.y, b2.width + dx, b2.height + dy);
                break;
            }
            default: {
                throw new RuntimeException("Invalid side returned from PBoundsLocator");
            }
        }
        boolean flipX = false;
        boolean flipY = false;
        if (b2.width < 0.0) {
            flipX = true;
            b2.width = -b2.width;
            b2.x -= b2.width;
        }
        if (b2.height < 0.0) {
            flipY = true;
            b2.height = -b2.height;
            b2.y -= b2.height;
        }
        if (flipX || flipY) {
            this.flipSiblingBoundsHandles(flipX, flipY);
        }
        n2.setBounds(b2);
    }

    public void endHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        PBoundsLocator l2 = (PBoundsLocator)this.getLocator();
        l2.getNode().endResizeBounds();
    }

    public void flipSiblingBoundsHandles(boolean flipX, boolean flipY) {
        ListIterator i2 = this.getParent().getChildrenIterator();
        while (i2.hasNext()) {
            Object each = i2.next();
            if (!(each instanceof PBoundsHandle)) continue;
            ((PBoundsHandle)each).flipHandleIfNeeded(flipX, flipY);
        }
    }

    public void flipHandleIfNeeded(boolean flipX, boolean flipY) {
        PBoundsLocator l2 = (PBoundsLocator)this.getLocator();
        if (!flipX && !flipY) {
            return;
        }
        switch (l2.getSide()) {
            case 1: {
                if (!flipY) break;
                l2.setSide(5);
                break;
            }
            case 5: {
                if (!flipY) break;
                l2.setSide(1);
                break;
            }
            case 3: {
                if (!flipX) break;
                l2.setSide(7);
                break;
            }
            case 7: {
                if (!flipX) break;
                l2.setSide(3);
                break;
            }
            case 8: {
                if (flipX && flipY) {
                    l2.setSide(4);
                    break;
                }
                if (flipX) {
                    l2.setSide(2);
                    break;
                }
                if (!flipY) break;
                l2.setSide(6);
                break;
            }
            case 6: {
                if (flipX && flipY) {
                    l2.setSide(2);
                    break;
                }
                if (flipX) {
                    l2.setSide(4);
                    break;
                }
                if (!flipY) break;
                l2.setSide(8);
                break;
            }
            case 2: {
                if (flipX && flipY) {
                    l2.setSide(6);
                    break;
                }
                if (flipX) {
                    l2.setSide(8);
                    break;
                }
                if (!flipY) break;
                l2.setSide(4);
                break;
            }
            case 4: {
                if (flipX && flipY) {
                    l2.setSide(8);
                    break;
                }
                if (flipX) {
                    l2.setSide(6);
                    break;
                }
                if (!flipY) break;
                l2.setSide(2);
                break;
            }
            default: {
                throw new RuntimeException("Invalid side received from PBoundsLocator");
            }
        }
        this.setLocator(l2);
    }

    public Cursor getCursorFor(int side) {
        switch (side) {
            case 1: {
                return new Cursor(8);
            }
            case 5: {
                return new Cursor(9);
            }
            case 3: {
                return new Cursor(11);
            }
            case 7: {
                return new Cursor(10);
            }
            case 8: {
                return new Cursor(6);
            }
            case 6: {
                return new Cursor(4);
            }
            case 2: {
                return new Cursor(7);
            }
            case 4: {
                return new Cursor(5);
            }
        }
        return null;
    }

    private class MouseCursorUpdateHandler
    extends PBasicInputEventHandler {
        boolean cursorPushed = false;

        public void mouseEntered(PInputEvent aEvent) {
            if (!this.cursorPushed) {
                aEvent.pushCursor(PBoundsHandle.this.getCursorFor(((PBoundsLocator)PBoundsHandle.this.getLocator()).getSide()));
                this.cursorPushed = true;
            }
        }

        public void mouseExited(PInputEvent aEvent) {
            PPickPath focus;
            if (this.cursorPushed && ((focus = aEvent.getInputManager().getMouseFocus()) == null || focus.getPickedNode() != PBoundsHandle.this)) {
                aEvent.popCursor();
                this.cursorPushed = false;
            }
        }

        public void mouseReleased(PInputEvent event) {
            if (this.cursorPushed) {
                event.popCursor();
                this.cursorPushed = false;
            }
        }
    }
}

