/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.handles;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolox.handles.PBoundsHandle;

public class PStickyHandleManager
extends PNode {
    private static final long serialVersionUID = 1L;
    private PNode target;
    private PCamera camera;

    public PStickyHandleManager(PCamera newCamera, PNode newTarget) {
        this.setCameraTarget(newCamera, newTarget);
        PBoundsHandle.addBoundsHandlesTo(this);
    }

    public void setCameraTarget(PCamera newCamera, PNode newTarget) {
        this.camera = newCamera;
        this.camera.addChild(this);
        this.target = newTarget;
    }

    public boolean setBounds(double x, double y, double width, double height) {
        PBounds b2 = new PBounds(x, y, width, height);
        this.camera.localToGlobal(b2);
        this.camera.localToView(b2);
        this.target.globalToLocal(b2);
        this.target.setBounds(b2);
        return super.setBounds(x, y, width, height);
    }

    protected boolean getBoundsVolatile() {
        return true;
    }

    public PBounds getBoundsReference() {
        PBounds targetBounds = this.target.getFullBounds();
        this.camera.viewToLocal(targetBounds);
        this.camera.globalToLocal(targetBounds);
        PBounds bounds = super.getBoundsReference();
        bounds.setRect(targetBounds);
        return super.getBoundsReference();
    }

    public void startResizeBounds() {
        super.startResizeBounds();
        this.target.startResizeBounds();
    }

    public void endResizeBounds() {
        super.endResizeBounds();
        this.target.endResizeBounds();
    }

    public boolean pickAfterChildren(PPickPath pickPath) {
        return false;
    }
}

