/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.pswing;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PAffineTransformException;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import edu.umd.cs.piccolox.pswing.PSwingEvent;
import edu.umd.cs.piccolox.pswing.PSwingMouseEvent;
import edu.umd.cs.piccolox.pswing.PSwingMouseWheelEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class PSwingEventHandler
implements PInputEventListener {
    private PNode listenNode = null;
    private boolean active = false;
    private Component previousComponent = null;
    private Point2D prevPoint = null;
    private Point2D previousOffset = null;
    private boolean recursing = false;
    private final ButtonData leftButtonData = new ButtonData();
    private final ButtonData middleButtonData = new ButtonData();
    private final ButtonData rightButtonData = new ButtonData();
    private final PSwingCanvas canvas;

    public PSwingEventHandler(PSwingCanvas canvas, PNode listenNode) {
        this.canvas = canvas;
        this.listenNode = listenNode;
    }

    public PSwingEventHandler(PSwingCanvas canvas) {
        this.canvas = canvas;
    }

    void setActive(boolean active) {
        if (this.active && !active) {
            if (this.listenNode != null) {
                this.active = false;
                this.listenNode.removeInputEventListener(this);
            }
        } else if (!this.active && active && this.listenNode != null) {
            this.active = true;
            this.listenNode.addInputEventListener(this);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private Component findShowingComponentAt(Component component, int x, int y) {
        Container contain;
        Component child;
        if (!component.contains(x, y)) {
            return null;
        }
        if (component instanceof Container && (child = this.findShowingChildAt(contain = (Container)component, x, y)) != null) {
            return child;
        }
        return component;
    }

    private Component findShowingChildAt(Container container, int x, int y) {
        Component[] children = container.getComponents();
        for (int i2 = 0; i2 < children.length; ++i2) {
            Component child = children[i2];
            if (child == null) continue;
            Point p = child.getLocation();
            if ((child = child instanceof Container ? this.findShowingComponentAt(child, x - p.x, y - p.y) : child.getComponentAt(x - p.x, y - p.y)) == null || !child.isShowing()) continue;
            return child;
        }
        return null;
    }

    void dispatchEvent(PSwingEvent pSwingMouseEvent, PInputEvent aEvent) {
        PSwingEvent e2;
        MouseEvent tempEvent;
        MouseEvent mEvent = pSwingMouseEvent.asMouseEvent();
        PNode pickedNode = pSwingMouseEvent.getPath().getPickedNode();
        PNode currentNode = pSwingMouseEvent.getCurrentNode();
        Component comp = null;
        Point point = null;
        Point offset = new Point();
        if (currentNode instanceof PSwing && pickedNode.isDescendentOf(this.canvas.getRoot())) {
            PSwing swing = (PSwing)currentNode;
            PNode grabNode = pickedNode;
            point = new Point(mEvent.getX(), mEvent.getY());
            this.cameraToLocal(pSwingMouseEvent.getPath().getTopCamera(), point, grabNode);
            this.prevPoint = (Point)point.clone();
            comp = this.findShowingComponentAt(swing.getComponent(), point.x, point.y);
            if (comp != null && comp != swing.getComponent()) {
                offset = this.extractSwingOffset(comp, swing);
            }
            if (comp != null && this.isMousePress(pSwingMouseEvent)) {
                if (SwingUtilities.isLeftMouseButton(mEvent)) {
                    this.leftButtonData.setState(pickedNode, comp, offset.x, offset.y);
                } else if (SwingUtilities.isMiddleMouseButton(mEvent)) {
                    this.middleButtonData.setState(pickedNode, comp, offset.x, offset.y);
                } else if (SwingUtilities.isRightMouseButton(mEvent)) {
                    this.rightButtonData.setState(pickedNode, comp, offset.x, offset.y);
                }
            }
        }
        if (this.isDragOrRelease(pSwingMouseEvent)) {
            if (this.isLeftMouseButtonOnComponent(mEvent)) {
                this.handleButton(pSwingMouseEvent, aEvent, this.leftButtonData);
            }
            if (this.isMiddleMouseButtonOnComponent(mEvent)) {
                this.handleButton(pSwingMouseEvent, aEvent, this.middleButtonData);
            }
            if (this.isRightMouseButtonOnComponent(mEvent)) {
                this.handleButton(pSwingMouseEvent, aEvent, this.rightButtonData);
            }
        } else if (this.isPressOrClickOrMove(pSwingMouseEvent) && comp != null) {
            tempEvent = new MouseEvent(comp, pSwingMouseEvent.getID(), mEvent.getWhen(), mEvent.getModifiers(), point.x - offset.x, point.y - offset.y, mEvent.getClickCount(), mEvent.isPopupTrigger());
            e2 = PSwingMouseEvent.createMouseEvent(tempEvent.getID(), tempEvent, aEvent);
            this.dispatchEvent(comp, e2);
        } else if (this.isWheelEvent(pSwingMouseEvent) && comp != null) {
            MouseWheelEvent mWEvent = (MouseWheelEvent)mEvent;
            MouseWheelEvent tempEvent2 = new MouseWheelEvent(comp, pSwingMouseEvent.getID(), mEvent.getWhen(), mEvent.getModifiers(), point.x - offset.x, point.y - offset.y, mEvent.getClickCount(), mEvent.isPopupTrigger(), mWEvent.getScrollType(), mWEvent.getScrollAmount(), mWEvent.getWheelRotation());
            PSwingMouseWheelEvent e22 = new PSwingMouseWheelEvent(tempEvent2.getID(), tempEvent2, aEvent);
            this.dispatchEvent(comp, e22);
        }
        if (this.previousComponent != null) {
            if (comp == null || pSwingMouseEvent.getID() == 505) {
                tempEvent = this.createExitEvent(mEvent);
                e2 = PSwingMouseEvent.createMouseEvent(tempEvent.getID(), tempEvent, aEvent);
                this.dispatchEvent(this.previousComponent, e2);
                this.previousComponent = null;
            } else if (this.previousComponent != comp) {
                tempEvent = this.createExitEvent(mEvent);
                e2 = PSwingMouseEvent.createMouseEvent(tempEvent.getID(), tempEvent, aEvent);
                this.dispatchEvent(this.previousComponent, e2);
                tempEvent = this.createEnterEvent(comp, mEvent, offset.x, offset.y);
                e2 = PSwingMouseEvent.createMouseEvent(tempEvent.getID(), tempEvent, aEvent);
                comp.dispatchEvent(e2.asMouseEvent());
            }
        } else if (comp != null) {
            tempEvent = this.createEnterEvent(comp, mEvent, offset.x, offset.y);
            e2 = PSwingMouseEvent.createMouseEvent(tempEvent.getID(), tempEvent, aEvent);
            this.dispatchEvent(comp, e2);
        }
        this.previousComponent = comp;
        if (comp != null) {
            this.previousOffset = offset;
        }
    }

    private Point extractSwingOffset(Component comp, PSwing swing) {
        int offsetX = 0;
        int offsetY = 0;
        for (Component c2 = comp; c2 != swing.getComponent(); c2 = c2.getParent()) {
            offsetX += c2.getLocation().x;
            offsetY += c2.getLocation().y;
        }
        return new Point(offsetX, offsetY);
    }

    private boolean isRightMouseButtonOnComponent(MouseEvent mEvent) {
        return SwingUtilities.isRightMouseButton(mEvent) && this.rightButtonData.getFocusedComponent() != null;
    }

    private boolean isMiddleMouseButtonOnComponent(MouseEvent mEvent) {
        return SwingUtilities.isMiddleMouseButton(mEvent) && this.middleButtonData.getFocusedComponent() != null;
    }

    private boolean isLeftMouseButtonOnComponent(MouseEvent mEvent) {
        return SwingUtilities.isLeftMouseButton(mEvent) && this.leftButtonData.getFocusedComponent() != null;
    }

    private boolean isMousePress(PSwingEvent pSwingMouseEvent) {
        return pSwingMouseEvent.getID() == 501;
    }

    private boolean isWheelEvent(PSwingEvent pSwingMouseEvent) {
        return pSwingMouseEvent.getID() == 507;
    }

    private boolean isPressOrClickOrMove(PSwingEvent pSwingMouseEvent) {
        return this.isMousePress(pSwingMouseEvent) || pSwingMouseEvent.getID() == 500 || pSwingMouseEvent.getID() == 503;
    }

    private boolean isDragOrRelease(PSwingEvent pSwingMouseEvent) {
        return pSwingMouseEvent.getID() == 506 || pSwingMouseEvent.getID() == 502;
    }

    private MouseEvent createEnterEvent(Component comp, MouseEvent e1, int offX, int offY) {
        return new MouseEvent(comp, 504, e1.getWhen(), 0, (int)this.prevPoint.getX() - offX, (int)this.prevPoint.getY() - offY, e1.getClickCount(), e1.isPopupTrigger());
    }

    private MouseEvent createExitEvent(MouseEvent e1) {
        return new MouseEvent(this.previousComponent, 505, e1.getWhen(), 0, (int)this.prevPoint.getX() - (int)this.previousOffset.getX(), (int)this.prevPoint.getY() - (int)this.previousOffset.getY(), e1.getClickCount(), e1.isPopupTrigger());
    }

    private void handleButton(PSwingEvent e1, PInputEvent aEvent, ButtonData buttonData) {
        MouseEvent m1 = e1.asMouseEvent();
        if (this.involvesSceneNode(buttonData)) {
            Point2D.Double pt = new Point2D.Double(m1.getX(), m1.getY());
            this.cameraToLocal(e1.getPath().getTopCamera(), pt, buttonData.getPNode());
            MouseEvent tempEvent = new MouseEvent(buttonData.getFocusedComponent(), m1.getID(), m1.getWhen(), m1.getModifiers(), (int)((Point2D)pt).getX() - buttonData.getOffsetX(), (int)((Point2D)pt).getY() - buttonData.getOffsetY(), m1.getClickCount(), m1.isPopupTrigger());
            PSwingEvent e2 = PSwingMouseEvent.createMouseEvent(tempEvent.getID(), tempEvent, aEvent);
            this.dispatchEvent(buttonData.getFocusedComponent(), e2);
        } else {
            this.dispatchEvent(buttonData.getFocusedComponent(), e1);
        }
        m1.consume();
        if (e1.getID() == 502) {
            buttonData.mouseReleased();
        }
    }

    private boolean involvesSceneNode(ButtonData buttonData) {
        return buttonData.getPNode().isDescendentOf(this.canvas.getRoot());
    }

    private void dispatchEvent(final Component target, final PSwingEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                target.dispatchEvent(event.asMouseEvent());
            }
        });
    }

    private void cameraToLocal(PCamera camera, Point2D pt, PNode node) {
        if (node != null) {
            if (this.descendsFromLayer(node)) {
                AffineTransform inverse = this.invertTransform(camera.getViewTransform());
                inverse.transform(pt, pt);
            }
            node.globalToLocal(pt);
        }
    }

    private boolean descendsFromLayer(PNode node) {
        PNode searchNode = node;
        while (searchNode != null) {
            if (!((searchNode = searchNode.getParent()) instanceof PLayer)) continue;
            return true;
        }
        return false;
    }

    private AffineTransform invertTransform(PAffineTransform transform) {
        try {
            return transform.createInverse();
        }
        catch (NoninvertibleTransformException e2) {
            throw new PAffineTransformException(e2, transform);
        }
    }

    public void processEvent(PInputEvent aEvent, int type) {
        if (!aEvent.isMouseEvent()) {
            return;
        }
        InputEvent sourceSwingEvent = aEvent.getSourceSwingEvent();
        if (!(sourceSwingEvent instanceof MouseEvent)) {
            throw new RuntimeException("PInputEvent.getSourceSwingEvent was not a MouseEvent.  Actual event: " + sourceSwingEvent + ", class=" + sourceSwingEvent.getClass().getName());
        }
        this.processMouseEvent(aEvent, (MouseEvent)sourceSwingEvent);
    }

    private void processMouseEvent(PInputEvent aEvent, MouseEvent swingMouseEvent) {
        if (!this.recursing) {
            this.recursing = true;
            PSwingEvent pSwingMouseEvent = PSwingMouseEvent.createMouseEvent(swingMouseEvent.getID(), swingMouseEvent, aEvent);
            this.dispatchEvent(pSwingMouseEvent, aEvent);
            if (pSwingMouseEvent.asMouseEvent().isConsumed()) {
                aEvent.setHandled(true);
            }
            this.recursing = false;
        }
    }

    private static class ButtonData {
        private PNode focusNode = null;
        private Component focusComponent = null;
        private int focusOffX = 0;
        private int focusOffY = 0;

        private ButtonData() {
        }

        public void setState(PNode visualNode, Component comp, int offX, int offY) {
            this.focusComponent = comp;
            this.focusNode = visualNode;
            this.focusOffX = offX;
            this.focusOffY = offY;
        }

        public Component getFocusedComponent() {
            return this.focusComponent;
        }

        public PNode getPNode() {
            return this.focusNode;
        }

        public int getOffsetX() {
            return this.focusOffX;
        }

        public int getOffsetY() {
            return this.focusOffY;
        }

        public void mouseReleased() {
            this.focusComponent = null;
            this.focusNode = null;
        }
    }
}

