/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.qas.api.ClientConfiguration;
import org.qas.api.handler.RequestHandler;
import org.qas.api.http.ExecutionContext;
import org.qas.api.http.HttpAuthClient;
import org.qas.api.http.basic.HttpUrlConnectionAuthClient;

public abstract class ApiWebServiceClient<T extends ApiWebServiceClient<T>> {
    protected URI endpoint;
    protected ClientConfiguration configuration;
    protected HttpAuthClient client;
    protected final List<RequestHandler> requestHandlers;
    protected int timeOffset;

    protected ApiWebServiceClient(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.client = this.createHttpAuthClient(configuration);
        this.requestHandlers = Collections.synchronizedList(new LinkedList());
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = this.configuration.getProtocol().toString() + "://" + endpoint;
        }
        try {
            this.endpoint = new URI(endpoint);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void setConfiguration(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.client = this.createHttpAuthClient(configuration);
    }

    public ApiWebServiceClient<T> withConfiguration(ClientConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public void shutdown() {
        this.client.shutdown();
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    public ApiWebServiceClient<T> withRequestHandler(RequestHandler requestHandler) {
        this.addRequestHandler(requestHandler);
        return this;
    }

    public ApiWebServiceClient<T> removeRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.remove(requestHandler);
        return this;
    }

    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    public ApiWebServiceClient<T> withTimeOffset(int timeOffset) {
        this.setTimeOffset(timeOffset);
        return this;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    protected ExecutionContext createExecutionContext() {
        return new ExecutionContext(this.requestHandlers);
    }

    protected HttpAuthClient createHttpAuthClient(ClientConfiguration configuration) {
        return new HttpUrlConnectionAuthClient(configuration);
    }
}

