/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.internal;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.qas.api.JsonMapper;
import org.qas.api.JsonModel;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonModel
public class PropertyContainer
implements Cloneable {
    protected static final Pattern RESERVED_NAME = Pattern.compile("^__.*__$");
    protected static final String NL = System.getProperty("line.separator");
    protected final Map<String, Object> properties = new HashMap<String, Object>();

    @JsonGetter
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @JsonIgnore
    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>(this.properties.size());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(props);
    }

    @JsonIgnore
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    @JsonAnySetter
    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void setPropertiesFrom(PropertyContainer src) {
        for (Map.Entry<String, Object> entry : src.getPropertyMap().entrySet()) {
            String name = entry.getKey();
            ArrayList<Object> entryValue = entry.getValue();
            if (entryValue instanceof Collection) {
                ArrayList<Object> destColl;
                Collection srcCol = entryValue;
                entryValue = destColl = new ArrayList<Object>(srcCol.size());
                for (Object element : srcCol) {
                    destColl.add(PropertyContainer.cloneIfMutable(element));
                }
            } else {
                entryValue = PropertyContainer.cloneIfMutable(entryValue);
            }
            this.properties.put(name, entryValue);
        }
    }

    @JsonIgnore
    protected Object clone() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @JsonIgnore
    protected boolean hasProperties() {
        for (Map.Entry<String, Object> entry : this.getPropertyMap().entrySet()) {
            if (RESERVED_NAME.matcher(entry.getKey()).find()) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    protected boolean isVisible(String key) {
        return !RESERVED_NAME.matcher(key).find();
    }

    @Deprecated
    public void appendPropertiesTo(StringBuilder builder, String indent, int depth) {
    }

    @JsonAnyGetter
    public Map<String, Object> getPropertyMap() {
        return this.properties;
    }

    @JsonIgnore
    @Deprecated
    public String elementName() {
        return "container";
    }

    @JsonIgnore
    @Deprecated
    public String jsonElementName() {
        return this.elementName();
    }

    @Deprecated
    public void appendPropertiesTo(JsonObject jsonObject) throws JsonException {
    }

    @JsonIgnore
    public JsonObject toJson() throws JsonException {
        JsonObject jsonObject = new JsonObject(JsonMapper.toMap(this));
        return jsonObject;
    }

    @JsonIgnore
    public String toString() {
        return JsonMapper.toJson(this);
    }

    private static Object cloneIfMutable(Object source) {
        if (source instanceof Date) {
            return ((Date)source).clone();
        }
        if (source instanceof PropertyContainer) {
            return ((PropertyContainer)source).clone();
        }
        return source;
    }

    public Integer asInteger(String key) {
        return this.asInteger(key, 0);
    }

    public Integer asInteger(String key, Integer defaultValue) {
        try {
            return (Integer)this.getProperty(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Long asLong(String key) {
        return this.asLong(key, 0L);
    }

    public Long asLong(String key, Long defaultValue) {
        try {
            return (Long)this.getProperty(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String asString(String key) {
        return this.asString(key, "");
    }

    public String asString(String key, String defaultValue) {
        Object value = this.getProperty(key);
        if (null == value) {
            return defaultValue;
        }
        return value instanceof String ? (String)value : value.toString();
    }

    public Date asDate(String key) {
        return this.asDate(key, null);
    }

    public Date asDate(String key, Date defaultValue) {
        try {
            return (Date)this.getProperty(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

