/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.MoveTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestSuiteRequestMarshaller;

public final class MoveTestSuiteRequestMarshaller
extends AbstractTestSuiteRequestMarshaller<MoveTestSuiteRequest> {
    @Override
    public Request marshall(MoveTestSuiteRequest testSuiteRequest) throws Exception {
        testSuiteRequest = ApiPreconditions.notNull(testSuiteRequest);
        MoveTestSuiteRequestMarshaller.validateProjectId(testSuiteRequest.getProjectId());
        Long testSuiteId = testSuiteRequest.getTestSuiteId() != null ? testSuiteRequest.getTestSuiteId() : (testSuiteRequest.getTestSuite() == null ? null : testSuiteRequest.getTestSuite().getId());
        MoveTestSuiteRequestMarshaller.validateTestSuiteId(testSuiteId);
        ApiPreconditions.notNull(testSuiteRequest.getArtifactLevel(), "Invalid artifact level passed to marshall(...)");
        MoveTestSuiteRequestMarshaller.validateArtifactLevel(testSuiteRequest.getArtifactLevel());
        MoveTestSuiteRequestMarshaller.validateArtifact(testSuiteRequest.getArtifactLevel(), testSuiteRequest.getArtifactId());
        Request request = this.createJsonRequest(testSuiteRequest, "MoveTestSuite", HttpMethod.PUT);
        StringBuilder builder = this.createApiPathBuilder(testSuiteRequest.getProjectId());
        builder.append('/').append(testSuiteId);
        request.setResourcePath(builder.toString());
        if (testSuiteRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
            request.addParameter("parentId", String.valueOf(testSuiteRequest.getArtifactId()));
        } else {
            request.addParameter("parentId", "0");
        }
        request.addParameter("parentType", testSuiteRequest.getArtifactLevel().getQueryParam());
        if (testSuiteRequest.getTestSuite() != null) {
            request.setContent(new StringInputStream(JsonMapper.toJson(testSuiteRequest.getTestSuite())));
        }
        return request;
    }
}

