/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.selfhealing.healers;

import com.kms.katalon.core.aut.ApplicationUnderTest;
import com.kms.katalon.core.executionpipeline.ExecutionPipeline;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.selfhealing.SelfHealingInputSource;
import com.kms.katalon.core.selfhealing.SimpleTestObjectHealer;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.FileUtil;
import com.kms.katalon.core.util.HTMLMinifier;
import com.kms.katalon.core.util.ImageProcessor;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.execution.selfhealing.healers.LLMTestObjectHealer;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

public class SelfHealingPipeline
extends ExecutionPipeline<SelfHealingContext> {
    private KeywordLogger logger = KeywordLogger.getInstance(((Object)((Object)this)).getClass());

    public SelfHealingPipeline() {
        this.initSelfHealingPhases();
    }

    private void initSelfHealingPhases() {
        this.registerBasicHealingPhase();
        this.registerLLMHealingPhase();
    }

    private void registerBasicHealingPhase() {
        this.registerPhase(context -> {
            ElementFinder basicSelfHealer = ((SelfHealingContext)context.data).params.basicSelfHealer;
            TestObject testObject = ((SelfHealingContext)context.data).params.testObject;
            List<WebElement> foundElements = basicSelfHealer.find(testObject);
            if (foundElements == null || foundElements.isEmpty()) {
                return;
            }
            ((SelfHealingContext)context.data).results.foundElements = foundElements;
            context.subPipeline.requestSkip();
        });
    }

    private void registerLLMHealingPhase() {
        this.registerPhase(context -> {
            List<SimpleTestObjectHealer.FoundLocator> foundLocators;
            File screenshotFile;
            String elementScreenshot;
            SelfHealingContext data = (SelfHealingContext)context.data;
            List<WebElement> foundElements = data.results.foundElements;
            if (foundElements != null && !foundElements.isEmpty()) {
                return;
            }
            SelfHealingParams params = data.params;
            ElementFinder elementFinder = params.elementFinder;
            ApplicationUnderTest aut = params.aut;
            TestObject testObject = params.testObject;
            List<SelfHealingInputSource> aiSelfHealingInputSources = params.aiSelfHealingInputSources;
            this.logger.logInfo("Recovering element locator by using AI Self-Healing...");
            LLMTestObjectHealer.LLMTestObjectHealingInput llmHealingInput = new LLMTestObjectHealer.LLMTestObjectHealingInput();
            llmHealingInput.testObject = testObject;
            if (aiSelfHealingInputSources.contains(SelfHealingInputSource.PAGE_SOURCE)) {
                llmHealingInput.pageSource = new HTMLMinifier(aut.getPageSource()).minify();
            }
            if (aiSelfHealingInputSources.contains(SelfHealingInputSource.ACCESSIBILITY_TREE)) {
                llmHealingInput.accessibilityTree = aut.getAccessibilityTree();
            }
            if (aiSelfHealingInputSources.contains(SelfHealingInputSource.ELEMENT_SCREENSHOT) && StringUtils.isNotBlank((CharSequence)(elementScreenshot = (String)testObject.getSelectorCollection().get(SelectorMethod.IMAGE))) && (screenshotFile = new File(elementScreenshot)).exists()) {
                llmHealingInput.elementScreenshot = FileUtil.readFileAsBase64((File)screenshotFile);
            }
            if (aiSelfHealingInputSources.contains(SelfHealingInputSource.FULL_PAGE_SCREENSHOT)) {
                llmHealingInput.fullpageScreenshot = ImageProcessor.fromBase64((String)aut.takeFullPageScreenshot()).scale(0.5).toJPEG().toJPEGBase64();
            }
            if ((foundLocators = new LLMTestObjectHealer().heal(llmHealingInput)) == null || foundLocators.isEmpty()) {
                this.logger.logInfo("No possible locators found");
                return;
            }
            this.logger.logInfo(MessageFormat.format("Found \"{0}\" possible locators:\n {1}", foundLocators.size(), JsonUtil.toJson(foundLocators)));
            for (SimpleTestObjectHealer.FoundLocator foundLocator : foundLocators) {
                this.logger.logInfo(MessageFormat.format("Verifying locator: \"{0}\"", foundLocator.value));
                TestObject tempTestObject = new TestObject("self-healing-temp-test-object-id");
                tempTestObject.setSelectorMethod(foundLocator.type);
                tempTestObject.setSelectorValue(foundLocator.type, foundLocator.value);
                try {
                    foundElements = elementFinder.find(tempTestObject);
                    if (foundElements != null && !foundElements.isEmpty()) {
                        this.logger.logInfo(MessageFormat.format("Found valid locator: \"{0}\"", foundLocator.value));
                        data.results.foundElements = foundElements;
                        return;
                    }
                    this.logger.logInfo(MessageFormat.format("Invalid locator: \"{0}\"", foundLocator.value));
                }
                catch (Exception error) {
                    this.logger.logInfo(MessageFormat.format("Invalid locator: \"{0}\"", foundLocator.value));
                    this.logger.logWarning(error.getMessage());
                }
            }
        });
    }

    public SelfHealingContext execute(SelfHealingParams params) throws Exception {
        SelfHealingContext context = new SelfHealingContext();
        context.params = params;
        return (SelfHealingContext)this.execute(context);
    }

    public static interface ElementFinder {
        public List<WebElement> find(TestObject var1);
    }

    public static class SelfHealingContext {
        public SelfHealingParams params = new SelfHealingParams();
        public SelfHealingResults results = new SelfHealingResults();
    }

    public static class SelfHealingParams {
        public TestObject testObject;
        public ApplicationUnderTest aut;
        public String currentAction;
        public String currentActionPrompt;
        public ElementFinder elementFinder;
        public ElementFinder basicSelfHealer;
        public boolean useBasicSelfHealing;
        public boolean useAISelfHealing;
        public List<SelfHealingInputSource> aiSelfHealingInputSources;
    }

    public static class SelfHealingResults {
        public List<WebElement> foundElements;
        public String foundLocator;
    }
}

