/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor;

import io.cucumber.eclipse.editor.hyperlinks.IStepDefinitionOpener;
import io.cucumber.eclipse.editor.launching.ILauncher;
import io.cucumber.eclipse.editor.steps.IStepDefinitionsProvider;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={CucumberServiceRegistry.class})
public class CucumberServiceRegistry {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final List<IStepDefinitionsProvider> stepDefinitionsProvider = new CopyOnWriteArrayList<IStepDefinitionsProvider>();
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final List<IStepDefinitionOpener> stepDefinitionOpener = new CopyOnWriteArrayList<IStepDefinitionOpener>();
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final List<ILauncher> cucumberLauncher = new CopyOnWriteArrayList<ILauncher>();
    private static final AtomicReference<CucumberServiceRegistry> REGISTRY = new AtomicReference();

    @Activate
    void start() {
        REGISTRY.set(this);
    }

    @Deactivate
    void stop() {
        REGISTRY.compareAndSet(this, null);
    }

    private static CucumberServiceRegistry get() {
        return Objects.requireNonNullElseGet(REGISTRY.get(), CucumberServiceRegistry::new);
    }

    public static List<IStepDefinitionOpener> getStepDefinitionOpener() {
        return Collections.unmodifiableList(CucumberServiceRegistry.get().stepDefinitionOpener);
    }

    public static List<ILauncher> getLauncher() {
        return Collections.unmodifiableList(CucumberServiceRegistry.get().cucumberLauncher);
    }

    public static List<IStepDefinitionsProvider> getStepDefinitionsProvider(IResource resource) {
        return CucumberServiceRegistry.get().stepDefinitionsProvider.stream().filter(p -> {
            try {
                return p.support(resource);
            }
            catch (CoreException e) {
                return false;
            }
        }).collect(Collectors.toUnmodifiableList());
    }
}

