/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.debug;

import io.cucumber.eclipse.editor.debug.DebugRunnable;
import io.cucumber.eclipse.editor.debug.GherkingGroupValue;
import io.cucumber.eclipse.editor.debug.GherkingStackFrame;
import io.cucumber.eclipse.editor.debug.GherkingStepDefinitionValue;
import io.cucumber.eclipse.editor.debug.GherkingStepVariable;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepDefinition;
import io.cucumber.messages.types.TestStep;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class GherkingStepStackFrame
extends GherkingStackFrame {
    private Step step;
    private StepDefinition stepDefinition;
    private TestStep testStep;
    private DebugRunnable stepOverHandler;

    public GherkingStepStackFrame(IThread thread, TestStep testStep, Step step, StepDefinition stepDefinition) {
        super(thread, step.getLocation().getLine().intValue(), "[" + step.getKeyword().strip() + "] " + step.getText());
        this.testStep = testStep;
        this.step = step;
        this.stepDefinition = stepDefinition;
        if (stepDefinition != null) {
            System.out.println(stepDefinition);
            GherkingStepDefinitionValue value = new GherkingStepDefinitionValue((IDebugElement)this, stepDefinition, step.getText());
            this.addVariable(new GherkingStepVariable(this, stepDefinition.getPattern().getSource(), value));
            this.addGroups(this, value::addVariable);
        } else {
            this.addGroups(this, this::addVariable);
        }
    }

    private void addGroups(GherkingStackFrame stepFrame, Consumer<IVariable> variableConsumer) {
        AtomicInteger counter = new AtomicInteger();
        this.testStep.getStepMatchArgumentsLists().stream().flatMap(list -> list.stream().flatMap(p -> p.getStepMatchArguments().stream())).forEach(argument -> argument.getParameterTypeName().ifPresent(type -> variableConsumer.accept(new GherkingStepVariable(stepFrame, "arg" + counter.get(), new GherkingGroupValue((IDebugElement)stepFrame.getDebugTarget(), (String)type, argument.getGroup())))));
    }

    public Step getStep() {
        return this.step;
    }

    public StepDefinition getStepDefinition() {
        return this.stepDefinition;
    }

    public TestStep getTestStep() {
        return this.testStep;
    }

    public void setStepOverHandler(DebugRunnable runnable) {
        this.stepOverHandler = runnable;
    }

    @Override
    public boolean canStepOver() {
        return this.stepOverHandler != null;
    }

    @Override
    public void stepOver() throws DebugException {
        if (this.stepOverHandler != null) {
            this.stepOverHandler.run();
        }
    }
}

