/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.debug;

import io.cucumber.eclipse.editor.debug.GherkingDebugElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public abstract class GherkingValue
extends GherkingDebugElement
implements IValue {
    private List<IVariable> variables = new ArrayList<IVariable>();
    private String typeName;

    public GherkingValue(IDebugElement parent, String typeName) {
        super(parent.getDebugTarget());
        this.typeName = typeName;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.typeName;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return (IVariable[])this.variables.toArray(IVariable[]::new);
    }

    public boolean hasVariables() throws DebugException {
        return this.variables.size() > 0;
    }

    public void addVariable(IVariable variable) {
        this.variables.add(variable);
    }
}

