/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.hyperlinks;

import io.cucumber.eclipse.editor.CucumberServiceRegistry;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.hyperlinks.StepHyperlink;
import io.cucumber.eclipse.editor.marker.MarkerFactory;
import io.cucumber.messages.types.Step;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;

public class StepHyperlinkDetector
implements IHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        int offset = region.getOffset();
        IDocument document = textViewer.getDocument();
        GherkinEditorDocument editorDocument = GherkinEditorDocument.get(document);
        if (editorDocument != null) {
            IResource resource = editorDocument.getResource();
            List openers = CucumberServiceRegistry.getStepDefinitionOpener().stream().filter(opener -> {
                try {
                    return opener.canOpen(resource);
                }
                catch (CoreException e1) {
                    return false;
                }
            }).collect(Collectors.toList());
            if (openers.size() > 0) {
                int lineStartOffset;
                int lineNumber;
                block7: {
                    lineNumber = document.getLineOfOffset(offset) + 1;
                    IRegion lineInfo = document.getLineInformationOfOffset(offset);
                    lineStartOffset = lineInfo.getOffset();
                    if (!MarkerFactory.hasMarker(editorDocument.getResource(), "cucumber.eclipse.marker.gherkin.unmatched_step", lineNumber)) break block7;
                    return null;
                }
                try {
                    IHyperlink[] hyperlinks = (IHyperlink[])editorDocument.getSteps().filter(step -> step.getLocation().getLine() == (long)lineNumber).map(step -> {
                        long column = step.getLocation().getColumn().orElse(0L) - 1L;
                        String keyword = step.getKeyword();
                        Long statementStartOffset = (long)lineStartOffset + column + (long)keyword.length();
                        Region stepRegion = new Region(statementStartOffset.intValue(), step.getText().length());
                        return new StepHyperlink((IRegion)stepRegion, (Step)step, textViewer, resource, openers);
                    }).filter(Objects::nonNull).toArray(IHyperlink[]::new);
                    if (hyperlinks.length > 0) {
                        return hyperlinks;
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

