/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.steps;

import io.cucumber.cucumberexpressions.CucumberExpressionParserSupport;
import io.cucumber.cucumberexpressions.ExpressionFactory;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ExpressionDefinition {
    private static final Map<Locale, ExpressionFactory> EXPRESSION_FACTORY_MAP = new ConcurrentHashMap<Locale, ExpressionFactory>();
    private final String text;
    private final String lang;

    public ExpressionDefinition(String text) {
        this(text, "");
    }

    @Deprecated
    public ExpressionDefinition(String text, String lang) {
        if (text == null) {
            throw new IllegalArgumentException("text cant be null");
        }
        this.text = text;
        this.lang = lang;
    }

    public String getText() {
        return this.text;
    }

    @Deprecated
    public String getLang() {
        return this.lang;
    }

    public boolean matchIgnoreTypes(String text, Locale locale) {
        try {
            return EXPRESSION_FACTORY_MAP.computeIfAbsent(locale, l -> new ExpressionFactory(new ParameterTypeRegistry(l))).createExpression(CucumberExpressionParserSupport.replaceVariables(this.getText(), CucumberExpressionParserSupport.VariableReplacement.MATCH_ALL)).match(text, new Type[0]) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public String getTextWithoutVariables() {
        return CucumberExpressionParserSupport.replaceVariables(this.getText(), CucumberExpressionParserSupport.VariableReplacement.DELETE);
    }

    public String toString() {
        return this.text + " (" + this.lang + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionDefinition other = (ExpressionDefinition)obj;
        if (this.lang == null ? other.lang != null : !this.lang.equals(other.lang)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

