/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.steps;

import io.cucumber.eclipse.editor.steps.ExpressionDefinition;
import io.cucumber.eclipse.editor.steps.StepParameter;
import java.util.Comparator;
import java.util.Objects;
import org.eclipse.core.resources.IResource;

public final class StepDefinition {
    public static final int NO_LINE_NUMBER = -1;
    public static final String NO_SOURCE_NAME = null;
    public static final String NO_PACKAGE_NAME = null;
    public static final String NO_LABEL = null;
    public static final IResource NO_SOURCE = null;
    public static final Comparator<? super StepDefinition> EXPRESSION_TEXT_ORDER = (s1, s2) -> s1.getExpression().getText().compareToIgnoreCase(s2.getExpression().getText());
    private final IResource source;
    private final int lineNumber;
    private final ExpressionDefinition expression;
    private final String label;
    private final String sourceName;
    private final String packageName;
    private final String id;
    private StepParameter[] parameters;
    private String description;

    public StepDefinition(String id, String label, ExpressionDefinition expression, IResource source, int lineNumber, String sourceName, String packageName, StepParameter[] parameters, String description) {
        this.id = id;
        this.label = label;
        this.expression = expression;
        this.source = source;
        this.lineNumber = lineNumber;
        this.sourceName = sourceName;
        this.packageName = packageName;
        this.description = description;
        this.parameters = Objects.requireNonNullElseGet(parameters, () -> new StepParameter[0]);
    }

    public StepParameter[] getParameters() {
        return this.parameters;
    }

    public IResource getSource() {
        return this.source;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getSourceName() {
        if (this.sourceName == null && this.source != null) {
            return this.source.getName();
        }
        return this.sourceName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getSourceName() + ":" + this.lineNumber;
        }
        return this.label;
    }

    public String toString() {
        if (this.lineNumber != 0) {
            return "Step [text=" + String.valueOf(this.getExpression()) + ", source=" + String.valueOf(this.source) + ", lineNumber=" + this.lineNumber + "]";
        }
        return "Step [text=" + String.valueOf(this.getExpression()) + ", source=" + this.sourceName + ", package=" + this.packageName + "]";
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.sourceName == null ? 0 : this.sourceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StepDefinition other = (StepDefinition)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals((Object)other.source)) {
            return false;
        }
        return !(this.sourceName == null ? other.sourceName != null : !this.sourceName.equals(other.sourceName));
    }
}

