/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.w3c.dom.css.CSSValue;

public class CStackRenderer
extends StackRenderer {
    private static final String THE_PART_KEY = "thePart";
    boolean adjusting = false;
    private IPresentationEngine renderer;
    private IEclipsePreferences preferences;
    private Field removeRootField;

    public CStackRenderer(IPresentationEngine renderer, IEclipsePreferences preferences) {
        this.renderer = renderer;
        this.preferences = preferences;
    }

    private boolean hasVisibleMenuItems(MMenu viewMenu, MPart part) {
        Menu menu;
        MenuManager manager;
        if (!viewMenu.isToBeRendered() || !viewMenu.isVisible()) {
            return false;
        }
        for (MMenuElement menuElement : viewMenu.getChildren()) {
            if (!menuElement.isToBeRendered() || !menuElement.isVisible()) continue;
            if (OpaqueElementUtil.isOpaqueMenuItem((MUIElement)menuElement) || OpaqueElementUtil.isOpaqueMenuSeparator((MUIElement)menuElement)) {
                IContributionItem item = (IContributionItem)OpaqueElementUtil.getOpaqueItem((MUIElement)menuElement);
                if (item == null || !item.isVisible()) continue;
                return true;
            }
            return true;
        }
        Object menuRenderer = viewMenu.getRenderer();
        if (menuRenderer instanceof MenuManagerRenderer && (manager = ((MenuManagerRenderer)menuRenderer).getManager(viewMenu)) != null && manager.isVisible()) {
            return true;
        }
        Control control = (Control)part.getWidget();
        if (control != null && (menu = (Menu)this.renderer.createGui((MUIElement)viewMenu, (Object)control.getShell(), part.getContext())) != null) {
            MenuManagerRenderer menuManagerRenderer;
            MenuManager manager2;
            menuRenderer = viewMenu.getRenderer();
            if (menuRenderer instanceof MenuManagerRenderer && (manager2 = (menuManagerRenderer = (MenuManagerRenderer)menuRenderer).getManager(viewMenu)) != null) {
                manager2.markDirty();
            }
            return menu.getItemCount() != 0;
        }
        return false;
    }

    private boolean isPartBeingRemoved() {
        try {
            MUIElement removingElement = (MUIElement)this.getRemoveRootField().get(this.renderer);
            if (removingElement != null) {
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {}
        return false;
    }

    private Field getRemoveRootField() throws NoSuchFieldException {
        if (this.removeRootField == null) {
            this.removeRootField = this.renderer.getClass().getDeclaredField("removeRoot");
            this.removeRootField.setAccessible(true);
        }
        return this.removeRootField;
    }

    private void updateMRUValue(CTabFolder ctf) {
        boolean actualMRUValue = this.getMRUValue((Control)ctf);
        ctf.setMRUVisible(actualMRUValue);
    }

    private boolean getMRUValue(Control control) {
        return this.getMRUValueFromPreferences();
    }

    private boolean getInitialMRUValue(Control control) {
        CSSRenderingUtils util = (CSSRenderingUtils)this.context.get(CSSRenderingUtils.class);
        if (util == null) {
            return this.getMRUValueFromPreferences();
        }
        CSSValue value = util.getCSSValue(control, "MPartStack", "swt-mru-visible");
        if (value == null) {
            value = util.getCSSValue(control, "MPartStack", "mru-visible");
        }
        if (value == null) {
            return this.getMRUValueFromPreferences();
        }
        return Boolean.parseBoolean(value.getCssText());
    }

    private boolean getMRUValueFromPreferences() {
        boolean initialMRUValue = this.preferences.getBoolean("enableMRUDefault", true);
        boolean actualValue = this.preferences.getBoolean("enableMRU", initialMRUValue);
        return actualValue;
    }
}

