/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.activation.dialog.IdleTimeoutDialog;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.handlers.DeactivateHandler;
import com.kms.katalon.core.util.Debouncer;
import com.kms.katalon.core.util.TimeUtil;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.session.core.model.AdministrationManagedKsSetting;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.OrganizationSetting;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.SessionExpireSchedule;
import com.kms.katalon.session.services.SessionController;
import com.kms.katalon.testops.core.model.TestOpsRequestOptions;
import com.kms.katalon.testops.core.model.TestOpsSession;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.testops.services.TestOpsController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class IdleTimeoutHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    SessionController sessionController;
    @Inject
    private IDiscoveryController discoveryController;
    private ITestOpsController testOpsController = TestOpsController.getInstance();
    private static final long MILISECONDS_PER_MINUTE = 60000L;
    private static final long CHECK_LAUNCHER_RUNNING_INTERVAL = 1000L;
    private static final long TIMEOUT_POPUP_CLASSIFY_THRESHOLD = 60L;
    private IdleTimeoutDialog idleTimeoutDialog;
    private Debouncer<String> idleDebouncer;
    private Timer checkLauncherTimer;
    private Timer deactivateTimer;
    private Long maxContinuousIdleSessions;
    private Listener userInteractListener = new Listener(){

        public void handleEvent(org.eclipse.swt.widgets.Event event) {
            IdleTimeoutHandler.this.resetIdleTimer();
        }
    };
    private static IdleTimeoutHandler instance;

    public static IdleTimeoutHandler getInstance() {
        return instance;
    }

    @PostConstruct
    private void registerEventHandler() {
        instance = this;
        this.eventBroker.subscribe("ACTIVATION/CHECKED", new EventHandler(){

            public void handleEvent(Event event) {
                Optional<AiConfigPolicy> aiConfigPolicyOpt;
                ApplicationContext context = ApplicationContext.getInstance();
                AiConfigPolicy aiConfigPolicy = new AiConfigPolicy(AiConfigPolicyType.AI_DISABLED);
                AdministrationManagedKsSetting ksSettings = new AdministrationManagedKsSetting();
                Session session = IdleTimeoutHandler.this.sessionController.getSession();
                License license = session.getLicense();
                if (Objects.nonNull(license) && license.isOffline()) {
                    context.setAiConfigPolicy(aiConfigPolicy);
                    context.setAdministrationManagedKsSetting(ksSettings);
                    IdleTimeoutHandler.this.eventBroker.post("STUDIOASSIST/AI_AUTO_TAG_SETTING_POLICY_SET", (Object)ksSettings.getAiAutoTagging().getType());
                    return;
                }
                OrganizationSetting organizationSetting = IdleTimeoutHandler.this.fetchOrganizationSetting();
                ksSettings = IdleTimeoutHandler.this.fetchKsSetting().orElse(new AdministrationManagedKsSetting());
                if (LoginMethod.SSO == ApplicationInfo.getLoginMethod() && (aiConfigPolicyOpt = IdleTimeoutHandler.this.fetchAiConfigPolicy(ksSettings)).isPresent()) {
                    aiConfigPolicy = aiConfigPolicyOpt.get();
                }
                context.setAdministrationManagedKsSetting(ksSettings);
                context.setAiConfigPolicy(aiConfigPolicy);
                IdleTimeoutHandler.this.eventBroker.post("STUDIOASSIST/AI_AUTO_TAG_SETTING_POLICY_SET", (Object)ksSettings.getAiAutoTagging().getType());
                if (organizationSetting == null || !organizationSetting.isKseIdleTimeoutEnabled()) {
                    return;
                }
                IdleTimeoutHandler.this.maxContinuousIdleSessions = organizationSetting.getMaxContinuousIdleSessions();
                Long idleTimeout = organizationSetting.getKseIdleTimeout() * 60000L;
                Long showWarningPopupTimeout = idleTimeout >= 3600000L ? Long.valueOf(idleTimeout - 900000L) : Long.valueOf(Math.round((double)idleTimeout.longValue() / 4.0 * 3.0));
                long closePopupTimeout = idleTimeout - showWarningPopupTimeout;
                IdleTimeoutHandler.this.idleDebouncer = new Debouncer(key -> {
                    IdleTimeoutHandler.this.showIdleTimeoutWarningDialog(closePopupTimeout);
                    IdleTimeoutHandler.this.runDeactivateTimer(closePopupTimeout);
                }, showWarningPopupTimeout.longValue());
                IdleTimeoutHandler.this.resetIdleTimer();
                IdleTimeoutHandler.this.registerInteractionListeners();
                IdleTimeoutHandler.this.checkLauncherTimer = TimeUtil.setInterval(timer -> {
                    if (LauncherManager.getInstance().isAnyLauncherRunning()) {
                        IdleTimeoutHandler.this.resetIdleTimer();
                    }
                }, (long)1000L);
            }
        });
        this.eventBroker.subscribe("ACTIVATION/DEACTIVATED", new EventHandler(){

            public void handleEvent(Event event) {
                IdleTimeoutHandler.this.stopCountingDown();
            }
        });
    }

    private Optional<AdministrationManagedKsSetting> fetchKsSetting() {
        try {
            return Optional.ofNullable(this.testOpsController.getKsAppSetting());
        }
        catch (Exception exception) {
            LoggerSingleton.logError((String)"Failed to retrieve KS Setting in Idle Timeout Handler, error: ");
            LoggerSingleton.logError((Throwable)exception);
            LoggerSingleton.logError((String)"Fallback to empty KS Setting");
            return Optional.empty();
        }
    }

    private Optional<AiConfigPolicy> fetchAiConfigPolicy(AdministrationManagedKsSetting setting) {
        try {
            return Optional.ofNullable(this.testOpsController.getAiAppConfig(setting));
        }
        catch (Exception exception) {
            LoggerSingleton.logError((String)"Failed to retrieve AI Config Policy in Idle Timeout Handler, error: ");
            LoggerSingleton.logError((Throwable)exception);
            LoggerSingleton.logError((String)"Fallback to empty AI Config Policy");
            return Optional.empty();
        }
    }

    private OrganizationSetting fetchOrganizationSetting() {
        try {
            String serverUrl = this.discoveryController.getServerUrl(ServerType.TESTOPS);
            Session session = this.sessionController.getSession();
            TestOpsSession toSession = new TestOpsSession();
            toSession.setToken(session.getAdminToken());
            toSession.setKatOneToken(session.getKatOneToken());
            Organization organization = this.sessionController.getSession().getOrganization();
            TestOpsRequestOptions options = TestOpsRequestOptions.builder().serverUrl(serverUrl).session(toSession).build();
            return this.testOpsController.getOrganizationSetting(organization.getId(), options);
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
            return null;
        }
    }

    private void showIdleTimeoutWarningDialog(long popupTimeout) {
        if (this.idleTimeoutDialog != null && this.idleTimeoutDialog.isOpened()) {
            return;
        }
        new Thread(() -> UISynchronizeService.syncExec(() -> {
            this.idleTimeoutDialog = new IdleTimeoutDialog(Display.getCurrent().getActiveShell(), popupTimeout, this.maxContinuousIdleSessions);
            int code = this.idleTimeoutDialog.open();
            if (code == 0) {
                this.resetIdleTimer();
                this.turnOffDeactivateTimer();
                this.reduceMaxContinuousIdleSesssion();
                return;
            }
            if (code == 1) {
                return;
            }
            if (code == 16) {
                DeactivateHandler.getInstance().execute();
            }
            this.stopCountingDown();
        })).start();
    }

    private void runDeactivateTimer(long popupTimeout) {
        this.deactivateTimer = TimeUtil.setTimeout(() -> {
            UISynchronizeService.syncExec(() -> this.stopCountingDown());
            DeactivateHandler.getInstance().execute(SessionExpireSchedule.Reason.USER_IDLE);
        }, (long)popupTimeout);
    }

    private void resetIdleTimer() {
        if (this.idleDebouncer != null && !this.idleDebouncer.isStopped()) {
            this.idleDebouncer.call((Object)"IdleTimeCountDownKey");
        }
    }

    private void turnOffDeactivateTimer() {
        if (this.deactivateTimer != null) {
            this.deactivateTimer.cancel();
        }
    }

    private void reduceMaxContinuousIdleSesssion() {
        if (this.maxContinuousIdleSessions > 0L) {
            this.maxContinuousIdleSessions = this.maxContinuousIdleSessions - 1L;
        }
    }

    public void stopCountingDown() {
        this.unregisterInteractionListeners();
        if (this.idleDebouncer != null) {
            this.idleDebouncer.terminate();
        }
        if (this.checkLauncherTimer != null) {
            this.checkLauncherTimer.cancel();
        }
        if (this.idleTimeoutDialog != null && this.idleTimeoutDialog.isOpened()) {
            this.idleTimeoutDialog.forceClose();
        }
        this.turnOffDeactivateTimer();
    }

    private void registerInteractionListeners() {
        this.unregisterInteractionListeners();
        Display.getCurrent().addFilter(5, this.userInteractListener);
        Display.getCurrent().addFilter(3, this.userInteractListener);
        Display.getCurrent().addFilter(1, this.userInteractListener);
    }

    private void unregisterInteractionListeners() {
        Display.getCurrent().removeFilter(5, this.userInteractListener);
        Display.getCurrent().removeFilter(3, this.userInteractListener);
        Display.getCurrent().removeFilter(1, this.userInteractListener);
    }

    static /* synthetic */ void access$0(IdleTimeoutHandler idleTimeoutHandler, long l) {
        idleTimeoutHandler.showIdleTimeoutWarningDialog(l);
    }

    static /* synthetic */ void access$1(IdleTimeoutHandler idleTimeoutHandler, long l) {
        idleTimeoutHandler.runDeactivateTimer(l);
    }
}

