/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.OutputParameterForCallableStatement;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.JPAQuery;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.conversion.Base64;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.AttachmentHelper;
import org.eclipse.persistence.internal.xr.Invocation;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.ValueObject;
import org.eclipse.persistence.internal.xr.XRDynamicEntity_CollectionWrapper;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatModel;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLFragmentCollectionMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Element;

public class QueryOperation
extends Operation {
    public static final String ORACLEOPAQUE_STR = "oracle.sql.OPAQUE";
    private static final String IORACLEOPAQUE_STR = "oracle.jdbc.OracleOpaque";
    protected static final String RESULT_STR = "result";
    protected static final String XMLTYPEFACTORY_STR = "org.eclipse.persistence.internal.platform.database.oracle.xdb.XMLTypeFactoryImpl";
    protected static final String GETSTRING_METHOD = "getString";
    protected static final String ATTACHMENT_STR = "/attachment";
    protected static final String CURSOR_OF_STR = "cursor of ";
    protected static final String DATAHANDLER_STR = "DataHandler";
    protected static final String RESULTS_STR = "results";
    protected static final String VALUEOBJECT_STR = "ValueObject";
    protected static final String VALUE_STR = "value";
    protected static final String SIMPLEXML_FORMAT_STR = "/simple-xml-format";
    protected static final String SIMPLEXML_STR = "simpleXML";
    protected static final String DATABASEQUERY_STR = "databasequery";
    protected static final String ITEMS_STR = "ITEMS";
    protected static final String XSD_STR = "xmlns:xsd";
    protected static final String XSI_STR = "xmlns:xsi";
    protected static final String XSITYPE_STR = "xsi:type";
    protected static final String BASE64_BINARY_STR = "xsd:base64Binary";
    protected Result result;
    protected QueryHandler queryHandler;
    protected boolean userDefined = true;

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public QueryHandler getQueryHandler() {
        return this.queryHandler;
    }

    public void setQueryHandler(QueryHandler queryHandler) {
        this.queryHandler = queryHandler;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    @Override
    public boolean isCollection() {
        return this.result != null && this.result.isCollection();
    }

    public boolean isSimpleXMLFormat() {
        return this.result != null && this.result.getSimpleXMLFormat() != null;
    }

    public boolean isAttachment() {
        return this.result != null && this.result.getAttachment() != null;
    }

    public QName getResultType() {
        if (this.result != null) {
            return this.result.getType();
        }
        return null;
    }

    @Override
    public boolean hasResponse() {
        return this.result != null;
    }

    @Override
    public void validate(XRServiceAdapter xrService) {
        QName resultType;
        super.validate(xrService);
        QName qName = resultType = this.result == null ? null : this.result.getType();
        if (resultType != null && !resultType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            boolean sxf;
            boolean bl = sxf = resultType.getLocalPart().equals("simple-xml-format") || resultType.getLocalPart().equals("cursor of simple-xml-format");
            if (!sxf && !xrService.descriptorsByQName.containsKey(resultType)) {
                throw DBWSException.resultHasNoMapping(resultType.toString(), this.name);
            }
        }
        if (this.queryHandler != null) {
            this.queryHandler.validate(xrService, this);
        }
    }

    @Override
    public void initialize(XRServiceAdapter xrService) {
        DatabaseQuery dq;
        super.initialize(xrService);
        if (this.queryHandler == null && (dq = xrService.getORSession().getQuery(this.name)) != null) {
            this.queryHandler = new QueryHandler(){

                @Override
                public void initializeDatabaseQuery(XRServiceAdapter xrService, QueryOperation queryOperation) {
                }

                @Override
                public void initializeArguments(XRServiceAdapter xrService, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
                }

                @Override
                public void initializeCall(XRServiceAdapter xrService, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
                }
            };
            this.queryHandler.setDatabaseQuery(dq);
        }
        if (this.queryHandler == null) {
            throw DBWSException.couldNotLocateQueryForSession(this.name, xrService.getORSession().getName());
        }
        this.queryHandler.initialize(xrService, this);
        Session oxSession = xrService.getOXSession();
        QName resultType = this.result == null ? null : this.result.getType();
        this.addSimpleXMLFormatModelDescriptor(xrService);
        this.addValueObjectDescriptor(xrService);
        if (resultType == null && this.isAttachment()) {
            Attachment attachment = this.result.getAttachment();
            XMLDescriptor descriptor = (XMLDescriptor)oxSession.getProject().getClassDescriptor(DataHandler.class);
            if (descriptor == null) {
                descriptor = new XMLDescriptor();
                descriptor.setAlias(DATAHANDLER_STR);
                descriptor.setJavaClass(DataHandler.class);
                descriptor.setInstantiationPolicy(new DataHandlerInstantiationPolicy(attachment.getMimeType()));
                XMLBinaryDataMapping mapping = new XMLBinaryDataMapping();
                mapping.setAttributeName(RESULTS_STR);
                mapping.setAttributeAccessor(new AttributeAccessor(){

                    @Override
                    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
                        Object result;
                        block12: {
                            result = null;
                            DataHandler dataHandler = (DataHandler)object;
                            try {
                                result = dataHandler.getContent();
                                if (!(result instanceof InputStream)) break block12;
                                Throwable throwable = null;
                                Object var5_7 = null;
                                try (InputStream is = (InputStream)result;){
                                    byte[] buf = new byte[2048];
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    int bytesRead = is.read(buf);
                                    while (bytesRead >= 0) {
                                        baos.write(buf, 0, bytesRead);
                                        bytesRead = is.read(buf);
                                    }
                                    result = baos.toByteArray();
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return result;
                    }

                    @Override
                    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
                    }
                });
                mapping.setXPath("simple-xml-format/simple-xml/attachment");
                mapping.setSwaRef(true);
                mapping.setShouldInlineBinaryData(false);
                mapping.setMimeType(attachment.getMimeType());
                descriptor.addMapping(mapping);
                NamespaceResolver nr = new NamespaceResolver();
                descriptor.setNamespaceResolver(nr);
                oxSession.getProject().addDescriptor(descriptor);
                ((DatabaseSessionImpl)oxSession).initializeDescriptorIfSessionAlive(descriptor);
                xrService.getXMLContext().storeXMLDescriptorByQName(descriptor);
            }
        }
    }

    protected void addValueObjectDescriptor(XRServiceAdapter xrService) {
        Session oxSession = xrService.getOXSession();
        XMLDescriptor descriptor = (XMLDescriptor)oxSession.getProject().getClassDescriptor(ValueObject.class);
        if (descriptor == null) {
            descriptor = new XMLDescriptor();
            descriptor.setAlias(VALUEOBJECT_STR);
            descriptor.setJavaClass(ValueObject.class);
            XMLDirectMapping mapping = new XMLDirectMapping();
            mapping.setAttributeName(VALUE_STR);
            mapping.setXPath(VALUE_STR);
            descriptor.addMapping(mapping);
            NamespaceResolver nr = new NamespaceResolver();
            descriptor.setNamespaceResolver(nr);
            oxSession.getProject().addDescriptor(descriptor);
            ((DatabaseSessionImpl)oxSession).initializeDescriptorIfSessionAlive(descriptor);
            xrService.getXMLContext().storeXMLDescriptorByQName(descriptor);
        }
    }

    protected void addSimpleXMLFormatModelDescriptor(XRServiceAdapter xrService) {
        Session oxSession;
        XMLDescriptor simpleXMLFormatDescriptor;
        if (this.isSimpleXMLFormat() && (simpleXMLFormatDescriptor = (XMLDescriptor)(oxSession = xrService.getOXSession()).getProject().getClassDescriptor(SimpleXMLFormatModel.class)) == null) {
            simpleXMLFormatDescriptor = new XMLDescriptor();
            simpleXMLFormatDescriptor.setJavaClass(SimpleXMLFormatModel.class);
            simpleXMLFormatDescriptor.setAlias("simple-xml-format");
            simpleXMLFormatDescriptor.setDefaultRootElement("simple-xml-format");
            XMLFragmentCollectionMapping xmlTag = new XMLFragmentCollectionMapping();
            xmlTag.setAttributeName(SIMPLEXML_STR);
            xmlTag.setXPath("simple-xml");
            simpleXMLFormatDescriptor.addMapping(xmlTag);
            NamespaceResolver nr = new NamespaceResolver();
            simpleXMLFormatDescriptor.setNamespaceResolver(nr);
            XMLSchemaURLReference schemaReference = new XMLSchemaURLReference("");
            schemaReference.setSchemaContext(SIMPLEXML_FORMAT_STR);
            schemaReference.setType(1);
            simpleXMLFormatDescriptor.setSchemaReference(schemaReference);
            oxSession.getProject().addDescriptor(simpleXMLFormatDescriptor);
            ((DatabaseSessionImpl)oxSession).initializeDescriptorIfSessionAlive(simpleXMLFormatDescriptor);
            xrService.getXMLContext().storeXMLDescriptorByQName(simpleXMLFormatDescriptor);
        }
    }

    @Override
    public Object invoke(XRServiceAdapter xrService, Invocation invocation) {
        Object value;
        DatabaseQuery query = this.queryHandler.getDatabaseQuery();
        if (query.getProperty(DATABASEQUERY_STR) != null) {
            query = (DatabaseQuery)query.getProperty(DATABASEQUERY_STR);
        }
        ArrayList<Object> argVals = new ArrayList<Object>();
        if (query.getArguments().size() == 0) {
            int idx = 0;
            for (Parameter parameter : this.getParameters()) {
                query.addArgument(Integer.toString(++idx), Util.SCHEMA_2_CLASS.get(parameter.getType()));
                argVals.add(invocation.getParameter(parameter.getName()));
            }
        } else {
            for (Parameter param : this.getParameters()) {
                argVals.add(invocation.getParameter(param.getName()));
            }
        }
        if (this.isSimpleXMLFormat() && query.isDataReadQuery()) {
            ((DataReadQuery)query).setResultType(0);
        }
        if ((value = xrService.getORSession().getActiveSession().executeQuery(query, argVals)) != null) {
            ArrayList arrayList;
            if (this.result != null && (this.result.getType() == Constants.INT_QNAME || this.result.getType().equals(Util.SXF_QNAME))) {
                if (value instanceof ArrayList && ((ArrayList)value).isEmpty()) {
                    ((ArrayList)value).add(1);
                } else if (value instanceof Vector && ((Vector)value).isEmpty()) {
                    ((Vector)value).add(1);
                }
            }
            if (value instanceof ArrayList && (arrayList = (ArrayList)value).size() > 0 && arrayList.get(0) instanceof Object[]) {
                Object[] objs = (Object[])arrayList.get(0);
                if (this.isCollection()) {
                    value = new ArrayList();
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        ((ArrayList)value).add(obj);
                        ++n2;
                    }
                } else {
                    value = objs[0];
                }
            }
            if (this.isSimpleXMLFormat()) {
                value = this.createSimpleXMLFormat(xrService, value);
            } else {
                QName qName;
                if (!this.isCollection() && value instanceof Vector) {
                    if (((Vector)value).isEmpty()) {
                        return null;
                    }
                    value = ((Vector)value).firstElement();
                }
                if ((qName = this.getResultType()) != null) {
                    if (this.isAttachment() || !this.isCollection() && qName.equals(Constants.BASE_64_BINARY_QNAME)) {
                        String mimeType = "application/octet-stream";
                        if (this.isAttachment() && this.result.getAttachment().getMimeType() != null) {
                            mimeType = this.result.getAttachment().getMimeType();
                        }
                        if (value instanceof Blob) {
                            value = ((XMLConversionManager)xrService.getOXSession().getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.APBYTE);
                        }
                        return AttachmentHelper.buildAttachmentHandler((byte[])value, mimeType);
                    }
                    if (qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        ValueObject vo = new ValueObject();
                        vo.value = value;
                        value = vo;
                    } else {
                        XMLDescriptor xdesc;
                        Object targetObject = value;
                        if (xrService.descriptorsByQName.containsKey(qName)) {
                            Vector results;
                            xdesc = xrService.descriptorsByQName.get(qName);
                            ClassDescriptor desc = xrService.getORSession().getDescriptorForAlias(xdesc.getAlias());
                            if (desc.isAggregateDescriptor() && !desc.isObjectRelationalDataTypeDescriptor() && !desc.isRelationalDescriptor()) {
                                if (this.isCollection()) {
                                    XRDynamicEntity_CollectionWrapper xrCollWrapper = new XRDynamicEntity_CollectionWrapper();
                                    results = (Vector)value;
                                    int i = 0;
                                    int len = results.size();
                                    while (i < len) {
                                        Object o = desc.getObjectBuilder().buildNewInstance();
                                        this.populateTargetObjectFromRecord(desc.getMappings(), (AbstractRecord)results.get(i), o, (AbstractSession)xrService.getORSession());
                                        xrCollWrapper.add(o);
                                        ++i;
                                    }
                                    targetObject = xrCollWrapper;
                                } else {
                                    targetObject = desc.getObjectBuilder().buildNewInstance();
                                    this.populateTargetObjectFromRecord(desc.getMappings(), (AbstractRecord)value, targetObject, (AbstractSession)xrService.getORSession());
                                }
                            } else if (this.isCollection() && value instanceof Vector) {
                                if (((Vector)value).size() > 0 && !(((Vector)value).get(0) instanceof AbstractRecord)) {
                                    return value;
                                }
                                XRDynamicEntity_CollectionWrapper xrCollWrapper = new XRDynamicEntity_CollectionWrapper();
                                results = (Vector)value;
                                int i = 0;
                                int len = results.size();
                                while (i < len) {
                                    Object o = desc.getObjectBuilder().buildNewInstance();
                                    this.populateTargetObjectFromRecord(desc.getMappings(), (AbstractRecord)results.get(i), o, (AbstractSession)xrService.getORSession());
                                    xrCollWrapper.add(o);
                                    ++i;
                                }
                                targetObject = xrCollWrapper;
                            } else if (value instanceof AbstractRecord) {
                                targetObject = desc.getObjectBuilder().buildNewInstance();
                                this.populateTargetObjectFromRecord(desc.getMappings(), (AbstractRecord)value, targetObject, (AbstractSession)xrService.getORSession());
                            }
                        }
                        if (value instanceof ArrayList) {
                            xdesc = xrService.descriptorsByQName.get(qName);
                            ClassDescriptor desc = xrService.getORSession().getDescriptorForAlias(xdesc.getAlias());
                            targetObject = desc.getObjectBuilder().buildNewInstance();
                            Object[] objs = new Object[]{((ArrayList)value).get(0)};
                            DatabaseRecord dr = new DatabaseRecord();
                            dr.add(new DatabaseField(ITEMS_STR), objs);
                            this.populateTargetObjectFromRecord(desc.getMappings(), dr, targetObject, (AbstractSession)xrService.getORSession());
                        }
                        value = targetObject;
                    }
                }
            }
        }
        return value;
    }

    protected void populateTargetObjectFromRecord(Vector<DatabaseMapping> mappings, AbstractRecord record, Object targetObject, AbstractSession session) {
        ReadObjectQuery roq = new ReadObjectQuery();
        roq.setSession(session);
        for (DatabaseMapping dm : mappings) {
            dm.readFromRowIntoObject(record, null, targetObject, null, roq, session, true);
        }
    }

    public Object createSimpleXMLFormat(XRServiceAdapter xrService, Object value) {
        XMLRoot xmlRoot = new XMLRoot();
        SimpleXMLFormat simpleXMLFormat = this.result.getSimpleXMLFormat();
        String tempSimpleXMLFormatTag = "simple-xml-format";
        String simpleXMLFormatTag = simpleXMLFormat.getSimpleXMLFormatTag();
        if (simpleXMLFormatTag != null && !"".equals(simpleXMLFormatTag)) {
            tempSimpleXMLFormatTag = simpleXMLFormatTag;
        }
        xmlRoot.setLocalName(tempSimpleXMLFormatTag);
        String tempXMLTag = "simple-xml";
        String xmlTag = simpleXMLFormat.getXMLTag();
        if (xmlTag != null && !"".equals(xmlTag)) {
            tempXMLTag = xmlTag;
        }
        Vector<DatabaseRecord> records = null;
        if (value instanceof ArrayList) {
            JPAQuery jpaQuery = (JPAQuery)this.queryHandler.getDatabaseQuery();
            ArrayList<DatabaseField> paramFlds = new ArrayList<DatabaseField>();
            DatasourceCall dsCall = (DatasourceCall)jpaQuery.getDatabaseQuery().getDatasourceCall();
            for (Object obj : dsCall.getParameters()) {
                if (obj instanceof OutputParameterForCallableStatement) {
                    paramFlds.add(((OutputParameterForCallableStatement)obj).getOutputField());
                    continue;
                }
                if (!(obj instanceof Object[])) continue;
                Object[] objArray = (Object[])obj;
                int i = 0;
                while (i < objArray.length) {
                    Object o = objArray[i];
                    if (o instanceof OutputParameterForCallableStatement) {
                        paramFlds.add(((OutputParameterForCallableStatement)o).getOutputField());
                    }
                    ++i;
                }
            }
            DatabaseRecord dr = new DatabaseRecord();
            if (paramFlds.size() > 0) {
                int i = 0;
                while (i < ((ArrayList)value).size()) {
                    dr.add((DatabaseField)paramFlds.get(i), ((ArrayList)value).get(i));
                    ++i;
                }
            } else {
                dr.add(new DatabaseField(RESULT_STR), ((ArrayList)value).get(0));
            }
            records = new Vector();
            records.add(dr);
        } else if (value instanceof Vector) {
            Class<?> vectorContent = ((Vector)value).firstElement().getClass();
            if (DatabaseRecord.class.isAssignableFrom(vectorContent)) {
                records = (Vector<DatabaseRecord>)value;
            } else {
                records = new Vector<DatabaseRecord>();
                DatabaseRecord dr = new DatabaseRecord();
                dr.add(new DatabaseField(RESULT_STR), ((Vector)value).firstElement());
                records.add(dr);
            }
        } else {
            records = new Vector<DatabaseRecord>();
            DatabaseRecord dr = new DatabaseRecord();
            dr.add(new DatabaseField(RESULT_STR), value);
            records.add(dr);
        }
        SimpleXMLFormatModel simpleXMLFormatModel = new SimpleXMLFormatModel();
        XMLConversionManager conversionManager = (XMLConversionManager)xrService.getOXSession().getDatasourcePlatform().getConversionManager();
        SessionLog log = xrService.getOXSession().getSessionLog();
        for (DatabaseRecord dr : records) {
            Element rowElement = Util.TEMP_DOC.createElement(tempXMLTag);
            for (DatabaseField field : dr.getFields()) {
                String elementName;
                Object fieldValue;
                if (field instanceof ObjectRelationalDatabaseField) {
                    ObjectRelationalDatabaseField ordtField = (ObjectRelationalDatabaseField)field;
                    if (xrService.getOXSession().getDescriptor(ordtField.getType()) != null) {
                        xrService.getXMLContext().createMarshaller().marshal(dr.get(field), rowElement);
                        continue;
                    }
                }
                if ((fieldValue = dr.get(field)) == null) continue;
                if (fieldValue instanceof Calendar) {
                    Calendar cValue = (Calendar)fieldValue;
                    fieldValue = conversionManager.convertObject(cValue, ClassConstants.STRING, Constants.DATE_TIME_QNAME);
                }
                if (fieldValue instanceof Date) {
                    Date dValue = (Date)fieldValue;
                    fieldValue = conversionManager.convertObject(dValue, ClassConstants.STRING, Constants.DATE_QNAME);
                } else if (fieldValue instanceof Time) {
                    Time tValue = (Time)fieldValue;
                    fieldValue = conversionManager.convertObject(tValue, ClassConstants.STRING, Constants.TIME_QNAME);
                } else if (fieldValue instanceof Timestamp) {
                    Timestamp tsValue = (Timestamp)fieldValue;
                    fieldValue = conversionManager.convertObject(tsValue, ClassConstants.STRING, Constants.DATE_TIME_QNAME);
                } else if (fieldValue instanceof Blob) {
                    fieldValue = conversionManager.convertObject(fieldValue, ClassConstants.APBYTE);
                } else if (SQLXML.class.isAssignableFrom(fieldValue.getClass())) {
                    SQLXML sqlXml = (SQLXML)fieldValue;
                    try {
                        String str = sqlXml.getString();
                        sqlXml.free();
                        fieldValue = str.endsWith("\n") ? str.substring(0, str.length() - 1) : str;
                    }
                    catch (SQLException e) {
                        log.logThrowable(3, "dbws", e);
                    }
                } else if (fieldValue.getClass().getName().equalsIgnoreCase(ORACLEOPAQUE_STR)) {
                    try {
                        Method getStringMethod;
                        Object xmlTypeFactory;
                        Constructor xmlTypeFactoryConstructor;
                        Class xmlTypeFactoryClass;
                        Class oracleOPAQUE;
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            oracleOPAQUE = AccessController.doPrivileged(new PrivilegedClassForName(IORACLEOPAQUE_STR, true, this.getClass().getClassLoader()));
                            xmlTypeFactoryClass = AccessController.doPrivileged(new PrivilegedClassForName(XMLTYPEFACTORY_STR, true, this.getClass().getClassLoader()));
                            xmlTypeFactoryConstructor = AccessController.doPrivileged(new PrivilegedGetConstructorFor(xmlTypeFactoryClass, new Class[0], true));
                            xmlTypeFactory = AccessController.doPrivileged(new PrivilegedInvokeConstructor(xmlTypeFactoryConstructor, new Object[0]));
                            getStringMethod = AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(xmlTypeFactoryClass, GETSTRING_METHOD, new Class[]{oracleOPAQUE}));
                            fieldValue = AccessController.doPrivileged(new PrivilegedMethodInvoker(getStringMethod, fieldValue, new Object[0]));
                        } else {
                            oracleOPAQUE = PrivilegedAccessHelper.getClassForName(IORACLEOPAQUE_STR, false, this.getClass().getClassLoader());
                            xmlTypeFactoryClass = PrivilegedAccessHelper.getClassForName(XMLTYPEFACTORY_STR, true, this.getClass().getClassLoader());
                            xmlTypeFactoryConstructor = PrivilegedAccessHelper.getConstructorFor(xmlTypeFactoryClass, new Class[0], true);
                            xmlTypeFactory = PrivilegedAccessHelper.invokeConstructor(xmlTypeFactoryConstructor, new Object[0]);
                            getStringMethod = PrivilegedAccessHelper.getDeclaredMethod(xmlTypeFactoryClass, GETSTRING_METHOD, new Class[]{oracleOPAQUE});
                            fieldValue = PrivilegedAccessHelper.invokeMethod(getStringMethod, xmlTypeFactory, new Object[]{fieldValue});
                        }
                    }
                    catch (RuntimeException x) {
                        throw x;
                    }
                    catch (ReflectiveOperationException | PrivilegedActionException e) {
                        log.logThrowable(3, "dbws", e);
                    }
                }
                if (field.getName() == null || (elementName = Util.sqlToXmlName(field.getName())).equals("")) {
                    elementName = RESULT_STR;
                }
                Element columnElement = Util.TEMP_DOC.createElement(elementName);
                rowElement.appendChild(columnElement);
                String fieldValueString = fieldValue.toString();
                if (this.result.getType().equals(Constants.BASE_64_BINARY_QNAME)) {
                    fieldValueString = Helper.buildHexStringFromBytes(Base64.base64Encode((byte[])fieldValue));
                    columnElement.setAttributeNS("http://www.w3.org/2000/xmlns/", XSD_STR, "http://www.w3.org/2001/XMLSchema");
                    columnElement.setAttributeNS("http://www.w3.org/2000/xmlns/", XSI_STR, "http://www.w3.org/2001/XMLSchema-instance");
                    columnElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", XSITYPE_STR, BASE64_BINARY_STR);
                }
                columnElement.appendChild(Util.TEMP_DOC.createTextNode(fieldValueString));
            }
            simpleXMLFormatModel.simpleXML.add(rowElement);
        }
        xmlRoot.setObject(simpleXMLFormatModel);
        return xmlRoot;
    }

    private static final class DataHandlerInstantiationPolicy
    extends InstantiationPolicy {
        protected String mimeType;

        public DataHandlerInstantiationPolicy(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public Object buildNewInstance() throws DescriptorException {
            return new DataHandler(null, this.mimeType);
        }
    }
}

