/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist.proposals;

import java.util.function.Consumer;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.quickassist.GroovyQuickAssistProposal2;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class InlineLocalVariableProposal
extends GroovyQuickAssistProposal2 {
    private VariableScope variableScope;
    private BinaryExpression variableDeclaration;

    @Override
    public String getDisplayString() {
        return "Inline local variable";
    }

    @Override
    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
    }

    @Override
    public int getRelevance() {
        TypeLookupResult result;
        ASTNode coveredNode = this.context.getCoveredNode();
        if (coveredNode instanceof VariableExpression && ((VariableExpression)coveredNode).getAccessedVariable() instanceof VariableExpression && (result = this.context.getNodeType((ASTNode)((VariableExpression)((VariableExpression)coveredNode).getAccessedVariable()))) != null && result.scope != null && !(result.enclosingAssignment.getLeftExpression() instanceof TupleExpression)) {
            this.variableDeclaration = result.enclosingAssignment;
            this.variableScope = result.scope;
            try {
                boolean[] found = new boolean[1];
                this.forEachOccurrence(x -> {
                    boolean bl = blArray[0] = true;
                });
                if (found[0]) {
                    return 10;
                }
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return 0;
    }

    private String getValueExpression() {
        BinaryExpression expr;
        Expression valueExpression = this.variableDeclaration.getRightExpression();
        boolean needsParens = false;
        if (valueExpression instanceof BinaryExpression) {
            expr = (BinaryExpression)valueExpression;
            if (expr.getOperation().getType() != 30 && (expr.getStart() == InlineLocalVariableProposal.startOffset((ASTNode)expr.getLeftExpression()) || expr.getEnd() == InlineLocalVariableProposal.endOffset((ASTNode)expr.getRightExpression()))) {
                needsParens = true;
            }
        } else if (valueExpression instanceof TernaryExpression) {
            expr = (TernaryExpression)valueExpression;
            if (expr.getStart() == InlineLocalVariableProposal.startOffset((ASTNode)expr.getBooleanExpression()) || expr.getEnd() == InlineLocalVariableProposal.endOffset((ASTNode)expr.getFalseExpression())) {
                needsParens = true;
            }
        } else if (valueExpression instanceof CastExpression) {
            expr = (CastExpression)valueExpression;
            if (expr.isCoerce() && expr.getStart() == InlineLocalVariableProposal.startOffset((ASTNode)expr.getExpression()) || !expr.isCoerce() && expr.getEnd() == InlineLocalVariableProposal.endOffset((ASTNode)expr.getExpression())) {
                needsParens = true;
            }
        } else if (valueExpression instanceof RangeExpression) {
            expr = (RangeExpression)valueExpression;
            if (expr.getStart() == InlineLocalVariableProposal.startOffset((ASTNode)expr.getFrom()) || expr.getEnd() == InlineLocalVariableProposal.endOffset((ASTNode)expr.getTo())) {
                needsParens = true;
            }
        } else if (valueExpression instanceof PostfixExpression) {
            needsParens = valueExpression.getStart() == InlineLocalVariableProposal.startOffset((ASTNode)((PostfixExpression)valueExpression).getExpression());
        } else if (valueExpression instanceof PrefixExpression) {
            needsParens = valueExpression.getEnd() == InlineLocalVariableProposal.endOffset((ASTNode)((PrefixExpression)valueExpression).getExpression());
        } else if (valueExpression instanceof BooleanExpression) {
            needsParens = valueExpression.getEnd() == InlineLocalVariableProposal.endOffset((ASTNode)((BooleanExpression)valueExpression).getExpression());
        } else if (valueExpression instanceof BitwiseNegationExpression) {
            needsParens = valueExpression.getEnd() == InlineLocalVariableProposal.endOffset((ASTNode)((BitwiseNegationExpression)valueExpression).getExpression());
        } else if (valueExpression instanceof UnaryMinusExpression) {
            needsParens = valueExpression.getEnd() == InlineLocalVariableProposal.endOffset((ASTNode)((UnaryMinusExpression)valueExpression).getExpression());
        } else if (valueExpression instanceof UnaryPlusExpression) {
            needsParens = valueExpression.getEnd() == InlineLocalVariableProposal.endOffset((ASTNode)((UnaryPlusExpression)valueExpression).getExpression());
        }
        Object valueString = this.context.getNodeText((ASTNode)valueExpression);
        if (needsParens) {
            valueString = "(" + (String)valueString + ")";
        }
        return valueString;
    }

    @Override
    protected TextChange getTextChange(IProgressMonitor monitor) throws BadLocationException {
        monitor.beginTask(this.getDisplayString(), 2);
        int limit = this.context.newTempDocument().getLineInformation(this.variableDeclaration.getLastLineNumber()).getOffset();
        int offset = this.variableDeclaration.getStart();
        int length = this.variableDeclaration.getLength();
        char[] source = this.context.getCompilationUnit().getContents();
        while (offset + length < limit && offset + length < source.length && (Character.isWhitespace(source[offset + length]) || source[offset + length] == ';')) {
            ++length;
        }
        monitor.worked(1);
        MultiTextEdit edits = new MultiTextEdit();
        edits.addChild((TextEdit)new DeleteEdit(offset, length));
        String value = this.getValueExpression();
        this.forEachOccurrence(var -> edits.addChild((TextEdit)new ReplaceEdit(var.getStart(), var.getLength(), value)));
        monitor.worked(1);
        try {
            TextChange textChange = this.toTextChange((TextEdit)edits);
            return textChange;
        }
        finally {
            monitor.done();
        }
    }

    private void forEachOccurrence(final Consumer<VariableExpression> consumer) {
        final VariableExpression variableExpr = (VariableExpression)this.variableDeclaration.getLeftExpression();
        VariableScope.VariableInfo variableInfo = this.variableScope.lookupNameInCurrentScope(variableExpr.getName());
        variableInfo.scopeNode.visit((GroovyCodeVisitor)new CodeVisitorSupport(){

            public void visitVariableExpression(VariableExpression expression) {
                if (expression.getEnd() > 0 && expression != variableExpr && expression.getAccessedVariable() == variableExpr) {
                    consumer.accept(expression);
                }
                super.visitVariableExpression(expression);
            }

            public void visitPostfixExpression(PostfixExpression expression) {
                if (expression.getExpression() instanceof VariableExpression && ((VariableExpression)expression.getExpression()).getAccessedVariable() == variableExpr) {
                    throw new IllegalStateException();
                }
                super.visitPostfixExpression(expression);
            }

            public void visitPrefixExpression(PrefixExpression expression) {
                if (expression.getExpression() instanceof VariableExpression && ((VariableExpression)expression.getExpression()).getAccessedVariable() == variableExpr) {
                    throw new IllegalStateException();
                }
                super.visitPrefixExpression(expression);
            }

            public void visitClosureListExpression(ClosureListExpression expression) {
                if (expression.getExpression(0) == InlineLocalVariableProposal.this.variableDeclaration) {
                    throw new IllegalStateException();
                }
                super.visitClosureListExpression(expression);
            }

            public void visitBinaryExpression(BinaryExpression expression) {
                if (expression != InlineLocalVariableProposal.this.variableDeclaration && expression.getLeftExpression() instanceof VariableExpression && ((VariableExpression)expression.getLeftExpression()).getAccessedVariable() == variableExpr && expression.getOperation().isA(1100)) {
                    throw new IllegalStateException();
                }
                super.visitBinaryExpression(expression);
            }
        });
    }

    private static int startOffset(ASTNode node) {
        Long offsets = (Long)node.getNodeMetaData((Object)"source.offsets");
        int start = offsets != null ? (int)(offsets >> 32) : node.getStart();
        return start;
    }

    private static int endOffset(ASTNode node) {
        Long offsets = (Long)node.getNodeMetaData((Object)"source.offsets");
        int end = offsets != null ? (int)(offsets & 0xFFFFFFFFFFFFFFFFL) : node.getEnd();
        return end;
    }
}

