/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist.proposals;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.quickassist.GroovyQuickAssistProposal2;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyIndentationService;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class SplitVariableDeclAndInitProposal
extends GroovyQuickAssistProposal2 {
    private VariableExpression var;

    @Override
    public String getDisplayString() {
        return "Split variable declaration";
    }

    @Override
    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.localvariable_obj.gif");
    }

    @Override
    public int getRelevance() {
        if (this.var == null) {
            ASTNode node = this.context.getCoveredNode();
            if (node instanceof DeclarationExpression) {
                DeclarationExpression expr = (DeclarationExpression)node;
                if (expr.getLeftExpression() instanceof VariableExpression && expr.getRightExpression() != null) {
                    this.var = (VariableExpression)expr.getLeftExpression();
                }
            } else if (node instanceof VariableExpression) {
                this.var = (VariableExpression)node;
                if (this.var != this.var.getAccessedVariable() || !SplitVariableDeclAndInitProposal.hasInitialExpression(this.var, this.context.getCompilationUnit())) {
                    this.var = null;
                }
            }
        }
        return this.var != null ? 10 : 0;
    }

    static boolean hasInitialExpression(VariableExpression expr, GroovyCompilationUnit unit) {
        char[] contents = unit.getContents();
        int offset = expr.getEnd();
        char c = ' ';
        while (offset < contents.length && CharOperation.isWhitespace((char)(c = contents[offset]))) {
            ++offset;
        }
        return c == '=';
    }

    @Override
    protected TextChange getTextChange(IProgressMonitor monitor) throws BadLocationException {
        IDocument document = this.context.newTempDocument();
        int offset = this.var.getEnd();
        int lineNo = document.getLineOfOffset(offset);
        String insertion = this.context.getLineDelimiter(document, lineNo) + GroovyIndentationService.getLineLeadingWhiteSpace((IDocument)document, (int)lineNo) + this.var.getText();
        return this.toTextChange((TextEdit)new InsertEdit(offset, insertion));
    }
}

