/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.mobile.objectspy.dialog.SaveTestCaseDialog;
import com.kms.katalon.composer.mobile.recorder.components.RecordActionResult;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.handlers.OpenTestCaseHandler;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.swt.widgets.Shell;

public class OpenRecorderHandler {
    protected void saveToTestCase(Shell activeShell, RecordActionResult actionResult) throws ControllerException, Exception {
        SaveTestCaseDialog dialog = new SaveTestCaseDialog(activeShell);
        if (dialog.open() != 0) {
            return;
        }
        SaveTestCaseDialog.ExportTestCaseSelectionResult exportResult = dialog.getResult();
        FolderEntity selectedFolder = exportResult.getFolder();
        FolderTreeEntity selectedFolderTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)selectedFolder);
        TestCaseEntity testCaseEntity = this.getTestCase(exportResult);
        TestCaseTreeEntity testCaseTreeEntity = new TestCaseTreeEntity(testCaseEntity, (ITreeEntity)selectedFolderTreeEntity);
        ExplorerPart.getInstance().refreshTreeEntity((Object)selectedFolderTreeEntity);
        ExplorerPart.getInstance().setSelectedItems(new Object[]{testCaseTreeEntity});
        MCompositePart part = OpenTestCaseHandler.getInstance().openTestCase(testCaseEntity);
        boolean shouldOverride = false;
        if (exportResult.getOption() == SaveTestCaseDialog.ExportTestCaseOption.OVERWRITE_TEST_CASE) {
            shouldOverride = true;
        }
        boolean isNewTestCase = false;
        if (exportResult.getOption() == SaveTestCaseDialog.ExportTestCaseOption.EXPORT_TO_NEW_TEST_CASE) {
            isNewTestCase = true;
        }
        TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)part.getObject();
        TestCasePart testCasePart = testCaseCompositePart.getChildTestCasePart();
        testCaseCompositePart.setScriptContentToManual();
        StringBuilder stringBuilder = new StringBuilder();
        new GroovyWrapperParser(stringBuilder).parseGroovyAstIntoScript(actionResult.getScript());
        ScriptNodeWrapper script = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper((String)stringBuilder.toString());
        List children = script.getBlock().getAstChildren();
        if (shouldOverride) {
            testCasePart.clearAndAddStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
        } else {
            testCasePart.addStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
        }
        this.markTestCaseRecordedWithTestCloud(testCaseCompositePart.getOriginalTestCase());
        testCasePart.addImports(script.getImports());
        testCasePart.getTreeTableInput().setChanged(true);
        testCaseCompositePart.changeScriptNode(testCasePart.getTreeTableInput().getMainClassNode());
        testCaseCompositePart.recorderSave(isNewTestCase);
    }

    private TestCaseEntity getTestCase(SaveTestCaseDialog.ExportTestCaseSelectionResult result) throws Exception {
        switch (result.getOption()) {
            case APPEND_TO_TEST_CASE: 
            case OVERWRITE_TEST_CASE: {
                return TestCaseController.getInstance().getTestCaseByDisplayId(result.getFolder().getIdForDisplay() + "/" + result.getTestCaseName());
            }
            case EXPORT_TO_NEW_TEST_CASE: {
                TestCaseEntity testCaseEntity = TestCaseController.getInstance().newTestCaseWithoutSave(result.getFolder(), result.getTestCaseName());
                this.markTestCaseRecordedWithTestCloud(testCaseEntity);
                return TestCaseController.getInstance().saveNewTestCase(testCaseEntity);
            }
        }
        return null;
    }

    protected void markTestCaseRecordedWithTestCloud(TestCaseEntity testCaseEntity) {
    }
}

