/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.network.oauth.services;

import com.katalon.network.oauth.core.model.exception.OAuthException;
import com.katalon.network.oauth.core.services.IOAuthService;
import com.katalon.network.oauth.services.NimbusHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerConfigurationRequest;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.client.ClientInformation;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.client.ClientRegistrationRequest;
import com.nimbusds.oauth2.sdk.client.ClientRegistrationResponse;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequestSender;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OAuthService
implements IOAuthService {
    @Inject
    private INetworkPreferences networkPreferences;

    public AuthorizationServerMetadata getAuthServerMetadata(String endpoint) throws OAuthException {
        Issuer issuer = new Issuer(endpoint);
        AuthorizationServerConfigurationRequest request = new AuthorizationServerConfigurationRequest(issuer);
        try {
            HTTPResponse response = this.executeRequest(request.toHTTPRequest());
            return AuthorizationServerMetadata.parse((JSONObject)response.getBodyAsJSONObject());
        }
        catch (ParseException e) {
            throw new OAuthException("Failed to parse well-known configuration of endpoint: " + endpoint, (Throwable)e);
        }
        catch (IOException e) {
            throw new OAuthException("Failed to get well-known configuration of endpoint: " + endpoint, (Throwable)e);
        }
    }

    public com.katalon.network.oauth.core.model.AuthorizationRequest setupRequest(ClientInformation clientInfo, URI callbackUri, AuthorizationServerMetadata serverMetadata) throws OAuthException {
        State state = new State(new Secret(16).getValue());
        CodeVerifier codeVerifier = new CodeVerifier();
        AuthorizationRequest request = new AuthorizationRequest.Builder(ResponseType.CODE, clientInfo.getID()).state(state).redirectionURI(callbackUri).endpointURI(serverMetadata.getAuthorizationEndpointURI()).codeChallenge(codeVerifier, CodeChallengeMethod.S256).build();
        com.katalon.network.oauth.core.model.AuthorizationRequest authRequest = new com.katalon.network.oauth.core.model.AuthorizationRequest();
        authRequest.setClientId(clientInfo.getID().getValue());
        authRequest.setState(state.getValue());
        authRequest.setCodeChallenge(codeVerifier.getValue());
        authRequest.setUri(request.toURI());
        authRequest.setRedirectUri(request.getRedirectionURI());
        authRequest.setCodeChallengeMethod(request.getCodeChallengeMethod().getValue());
        return authRequest;
    }

    public ClientInformation registerClient(ClientMetadata clientMetadata, AuthorizationServerMetadata serverMetadata) throws OAuthException {
        ClientRegistrationRequest request = new ClientRegistrationRequest(serverMetadata.getRegistrationEndpointURI(), clientMetadata, null);
        try {
            HTTPResponse response = this.executeRequest(request.toHTTPRequest());
            ClientRegistrationResponse registrationResponse = ClientRegistrationResponse.parse((HTTPResponse)response);
            if (!registrationResponse.indicatesSuccess()) {
                throw new OAuthException("Failed to register StudioAssist OAuth client");
            }
            return registrationResponse.toSuccessResponse().getClientInformation();
        }
        catch (ParseException | IOException e) {
            throw new OAuthException("Failed to register StudioAssist OAuth client", e);
        }
    }

    public Tokens generateToken(String authorizationCode, com.katalon.network.oauth.core.model.AuthorizationRequest authRequest, AuthorizationServerMetadata serverMetadata) throws OAuthException {
        AuthorizationCode authCode = new AuthorizationCode(authorizationCode);
        CodeVerifier codeVerifier = null;
        if (StringUtils.isNotBlank((CharSequence)authRequest.getCodeChallenge())) {
            codeVerifier = new CodeVerifier(authRequest.getCodeChallenge());
        }
        AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant(authCode, authRequest.getRedirectUri(), codeVerifier);
        ClientID clientId = new ClientID(authRequest.getClientId());
        try {
            TokenRequest tokenRequest = new TokenRequest.Builder(serverMetadata.getTokenEndpointURI(), clientId, (AuthorizationGrant)codeGrant).build();
            TokenResponse tokenResponse = TokenResponse.parse((HTTPResponse)this.executeRequest(tokenRequest.toHTTPRequest()));
            if (!tokenResponse.indicatesSuccess()) {
                TokenErrorResponse errorResponse = tokenResponse.toErrorResponse();
                throw new OAuthException("Failed to generate token from authorization code: " + errorResponse.getErrorObject().getDescription());
            }
            return tokenResponse.toSuccessResponse().getTokens();
        }
        catch (ParseException | IOException e) {
            throw new OAuthException("Failed to generate token from authorization code", e);
        }
    }

    public Tokens refreshToken(RefreshToken refreshToken, ClientInformation clientInfo, AuthorizationServerMetadata serverMetadata) throws OAuthException {
        RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(refreshToken);
        try {
            TokenRequest tokenRequest = new TokenRequest.Builder(serverMetadata.getTokenEndpointURI(), clientInfo.getID(), (AuthorizationGrant)refreshTokenGrant).build();
            TokenResponse tokenResponse = TokenResponse.parse((HTTPResponse)this.executeRequest(tokenRequest.toHTTPRequest()));
            if (!tokenResponse.indicatesSuccess()) {
                TokenErrorResponse errorResponse = tokenResponse.toErrorResponse();
                throw new OAuthException("Failed to generate token from authorization code: " + errorResponse.getErrorObject().getDescription());
            }
            return tokenResponse.toSuccessResponse().getTokens();
        }
        catch (ParseException | IOException e) {
            throw new OAuthException("Failed to generate token from refresh token", e);
        }
    }

    private HTTPResponse executeRequest(HTTPRequest request) throws IOException {
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        NimbusHttpClient client = NimbusHttpClient.withOptions(HttpOptions.builder().proxy(proxyConfig).build());
        return request.send((HTTPRequestSender)client);
    }
}

