/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.network.apache.services;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.selector.fixed.FixedProxySelector;
import com.github.markusbernhardt.proxy.selector.misc.BufferedProxySelector;
import com.github.markusbernhardt.proxy.util.PlatformUtil;
import com.kms.katalon.network.apache.services.CustomProxyRoutePlanner;
import com.kms.katalon.network.core.model.config.ManualProxyConfig;
import com.kms.katalon.network.core.model.config.NoProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyAuthentication;
import com.kms.katalon.network.core.model.config.ProxyBasicAuthentication;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyProtocol;
import com.kms.katalon.network.core.model.config.SystemProxyConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;

public class HttpProxyConfigurator {
    public static final HttpProxyConfigurator singleton = new HttpProxyConfigurator();
    private static final List<String> DEFAULT_BYPASS_HOSTS = List.of("localhost", "127.0.0.1", "::1");

    public static HttpProxyConfigurator getInstance() {
        return singleton;
    }

    private HttpProxyConfigurator() {
    }

    public void configureProxy(HttpClientBuilder builder, ProxyConfig proxy, SSLContext sc, URI requestUrl) {
        boolean isSocksProxy;
        if (proxy == null || proxy instanceof NoProxyConfig) {
            return;
        }
        boolean bl = isSocksProxy = proxy instanceof ManualProxyConfig && ((ManualProxyConfig)proxy).getProtocol() == ProxyProtocol.SOCKS;
        if (isSocksProxy) {
            boolean shouldUseSocksConnectionManager;
            boolean bl2 = shouldUseSocksConnectionManager = !this.shouldBypassProxy(requestUrl.getHost(), proxy);
            if (shouldUseSocksConnectionManager) {
                builder.setConnectionManager(this.createSocksConnectionManager(sc, proxy));
            }
            return;
        }
        if (proxy instanceof SystemProxyConfig) {
            builder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(this.getProxySelector()));
            return;
        }
        if (proxy instanceof ManualProxyConfig) {
            ManualProxyConfig setting = (ManualProxyConfig)proxy;
            HttpHost proxyHost = new HttpHost(setting.getAddress(), setting.getPort());
            List bypassedHosts = setting.getBypassedHosts() == null ? Collections.emptyList() : setting.getBypassedHosts();
            builder.setRoutePlanner((HttpRoutePlanner)new CustomProxyRoutePlanner(proxyHost, bypassedHosts));
        }
    }

    public void configureProxy(HttpClient.Builder builder, ProxyConfig proxy, URI requestUrl) {
        if (proxy == null || proxy instanceof NoProxyConfig) {
            return;
        }
        if (proxy instanceof SystemProxyConfig) {
            builder.proxy(this.getProxySelector());
            return;
        }
        if (proxy instanceof ManualProxyConfig) {
            ManualProxyConfig setting = (ManualProxyConfig)proxy;
            if (this.shouldBypassProxy(requestUrl.getHost(), proxy)) {
                return;
            }
            builder.proxy((ProxySelector)new FixedProxySelector(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(setting.getAddress(), setting.getPort()))));
            ProxyAuthentication proxyAuthentication = setting.getAuthentication();
            if (proxyAuthentication instanceof ProxyBasicAuthentication) {
                ProxyBasicAuthentication basicAuth = (ProxyBasicAuthentication)proxyAuthentication;
                builder.authenticator(basicAuth.toAuthenticator());
            }
        }
    }

    public HttpClientContext createClientContextWithProxyAuth(ProxyConfig proxy, URI url, boolean isKerberosSupported) {
        HttpClientContext context = HttpClientContext.create();
        HttpProxyConfigurator.getInstance().configureProxyAuth((HttpContext)context, proxy, url, isKerberosSupported);
        return context;
    }

    public void configureProxyAuth(HttpContext context, ProxyConfig proxy, URI requestUrl, boolean isKerberosSupported) {
        boolean isSocksProxy;
        boolean bl = isSocksProxy = proxy instanceof ManualProxyConfig && ((ManualProxyConfig)proxy).getProtocol() == ProxyProtocol.SOCKS;
        if (proxy == null || proxy instanceof NoProxyConfig || isSocksProxy) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        RegistryBuilder authSchemeRegistryBuilder = RegistryBuilder.create();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (proxy instanceof SystemProxyConfig) {
            ProxySelector proxySelector = this.getProxySelector();
            if (isKerberosSupported) {
                authSchemeRegistryBuilder.register("Negotiate", (Object)new SPNegoSchemeFactory(true));
                List<HttpHost> proxyHosts = this.determineSystemProxyHttpHosts(proxySelector, requestUrl);
                for (HttpHost proxyHost : proxyHosts) {
                    credsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new KerberosCredentials(null));
                }
                clientContext.setAuthSchemeRegistry((Lookup)authSchemeRegistryBuilder.build());
                clientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
            }
            return;
        }
        if (proxy instanceof ManualProxyConfig) {
            ManualProxyConfig setting = (ManualProxyConfig)proxy;
            HttpHost proxyHost = new HttpHost(setting.getAddress(), setting.getPort());
            ProxyAuthentication authentication = setting.getAuthentication();
            if (authentication != null && authentication instanceof ProxyBasicAuthentication) {
                ProxyBasicAuthentication basicAuth = (ProxyBasicAuthentication)authentication;
                authSchemeRegistryBuilder.register("Basic", (Object)new BasicSchemeFactory());
                credsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(basicAuth.getUsername(), basicAuth.getPassword()));
            } else if (isKerberosSupported) {
                authSchemeRegistryBuilder.register("Negotiate", (Object)new SPNegoSchemeFactory(true));
                credsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new KerberosCredentials(null));
            }
            clientContext.setAuthSchemeRegistry((Lookup)authSchemeRegistryBuilder.build());
            clientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
    }

    public ProxySelector getProxySelector() {
        ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
        if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
            proxySearch.addStrategy(ProxySearch.Strategy.IE);
            proxySearch.addStrategy(ProxySearch.Strategy.FIREFOX);
        } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.LINUX) {
            proxySearch.addStrategy(ProxySearch.Strategy.GNOME);
            proxySearch.addStrategy(ProxySearch.Strategy.KDE);
            proxySearch.addStrategy(ProxySearch.Strategy.FIREFOX);
        }
        proxySearch.setPacCacheSettings(50, TimeUnit.MINUTES.toMillis(30L), BufferedProxySelector.CacheScope.CACHE_SCOPE_HOST);
        ProxySelector proxySelector = proxySearch.getProxySelector();
        return proxySelector == null ? ProxySelector.getDefault() : proxySelector;
    }

    private List<HttpHost> determineSystemProxyHttpHosts(ProxySelector proxySelector, URI requestUrl) {
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>();
        List<Proxy> proxies = proxySelector.select(requestUrl);
        for (Proxy proxy : proxies) {
            if (proxy == null || proxy.address() == null) continue;
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            httpHosts.add(new HttpHost(address.getHostName(), address.getPort()));
        }
        return httpHosts;
    }

    private boolean shouldBypassProxy(String host, ProxyConfig proxy) {
        if (StringUtils.isEmpty((CharSequence)host)) {
            return false;
        }
        if (DEFAULT_BYPASS_HOSTS.contains(host)) {
            return true;
        }
        if (proxy instanceof ManualProxyConfig) {
            ManualProxyConfig manualProxy = (ManualProxyConfig)proxy;
            List bypassedHosts = manualProxy.getBypassedHosts();
            if (bypassedHosts == null || bypassedHosts.isEmpty()) {
                return false;
            }
            for (String bypass : bypassedHosts) {
                if (!this.hostMatchesPattern(host, bypass)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hostMatchesPattern(String host, String pattern) {
        if (StringUtils.isEmpty((CharSequence)host) || StringUtils.isEmpty((CharSequence)pattern)) {
            return false;
        }
        String regex = "^" + pattern.replace(".", "\\.").replace("*", ".*") + "$";
        return Pattern.compile(regex, 2).matcher(host).matches();
    }

    private HttpClientConnectionManager createSocksConnectionManager(final SSLContext sc, ProxyConfig proxy) {
        if (proxy instanceof ManualProxyConfig) {
            final ManualProxyConfig manualProxy = (ManualProxyConfig)proxy;
            final String proxyHost = manualProxy.getAddress();
            final int proxyPort = manualProxy.getPort();
            PlainConnectionSocketFactory plainSocketFactory = new PlainConnectionSocketFactory(){

                public Socket createSocket(HttpContext context) throws IOException {
                    String proxyUser = null;
                    String proxyPass = null;
                    ProxyAuthentication proxyAuthentication = manualProxy.getAuthentication();
                    if (proxyAuthentication instanceof ProxyBasicAuthentication) {
                        ProxyBasicAuthentication basicAuth = (ProxyBasicAuthentication)proxyAuthentication;
                        proxyUser = basicAuth.getUsername();
                        proxyPass = basicAuth.getPassword();
                    }
                    HttpHost target = (HttpHost)context.getAttribute("http.target_host");
                    String targetHost = target.getHostName();
                    int targetPort = target.getPort() != -1 ? target.getPort() : (target.getSchemeName().equals("https") ? 443 : 80);
                    return HttpProxyConfigurator.this.createSocks5AuthSocket(proxyHost, proxyPort, proxyUser, proxyPass, targetHost, targetPort);
                }

                public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                    return socket;
                }
            };
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sc, SSLConnectionSocketFactory.getDefaultHostnameVerifier()){

                public Socket createSocket(HttpContext context) throws IOException {
                    String proxyUser = null;
                    String proxyPass = null;
                    ProxyAuthentication proxyAuthentication = manualProxy.getAuthentication();
                    if (proxyAuthentication instanceof ProxyBasicAuthentication) {
                        ProxyBasicAuthentication basicAuth = (ProxyBasicAuthentication)proxyAuthentication;
                        proxyUser = basicAuth.getUsername();
                        proxyPass = basicAuth.getPassword();
                    }
                    HttpHost target = (HttpHost)context.getAttribute("http.target_host");
                    String targetHost = target.getHostName();
                    int targetPort = target.getPort() != -1 ? target.getPort() : 443;
                    Socket tunnel = HttpProxyConfigurator.this.createSocks5AuthSocket(proxyHost, proxyPort, proxyUser, proxyPass, targetHost, targetPort);
                    SSLSocketFactory sslFactory = sc.getSocketFactory();
                    return sslFactory.createSocket(tunnel, targetHost, targetPort, true);
                }

                public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                    return socket;
                }
            };
            Registry registry = RegistryBuilder.create().register("http", (Object)plainSocketFactory).register("https", (Object)sslSocketFactory).build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
            return connManager;
        }
        return null;
    }

    private Socket createSocks5AuthSocket(String proxyHost, int proxyPort, String user, String pass, String destHost, int destPort) throws IOException {
        boolean useAuth;
        Socket socket = new Socket(proxyHost, proxyPort);
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        boolean bl = useAuth = user != null && !user.isEmpty();
        if (useAuth) {
            out.write(new byte[]{5, 1, 2});
        } else {
            byte[] byArray = new byte[3];
            byArray[0] = 5;
            byArray[1] = 1;
            out.write(byArray);
        }
        out.flush();
        if (in.read() != 5) {
            throw new IOException("Invalid SOCKS version");
        }
        int method = in.read();
        if (method == 255) {
            throw new IOException("No acceptable SOCKS5 auth method");
        }
        if (method == 2) {
            byte[] u = user.getBytes(StandardCharsets.UTF_8);
            byte[] p = pass.getBytes(StandardCharsets.UTF_8);
            out.write(1);
            out.write(u.length);
            out.write(u);
            out.write(p.length);
            out.write(p);
            out.flush();
            if (in.read() != 1 || in.read() != 0) {
                throw new IOException("SOCKS5 authentication failed");
            }
        }
        ByteArrayOutputStream connect = new ByteArrayOutputStream();
        connect.write(5);
        connect.write(1);
        connect.write(0);
        connect.write(3);
        connect.write(destHost.length());
        connect.write(destHost.getBytes(StandardCharsets.UTF_8));
        connect.write(destPort >> 8 & 0xFF);
        connect.write(destPort & 0xFF);
        out.write(connect.toByteArray());
        out.flush();
        byte[] response = new byte[10];
        in.read(response);
        if (response[1] != 0) {
            throw new IOException("SOCKS5 connect failed, reply=" + Arrays.toString(response));
        }
        return socket;
    }
}

