/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.domain.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.recorder.web.domain.event.IWebRecordingConnectionEventBus;
import com.katalon.recorder.web.domain.event.WebRecordingConnectionEvent;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class WebRecordingConnectionEventBus
implements IWebRecordingConnectionEventBus {
    private static final Logger logger = LoggerFactory.getLogger(WebRecordingConnectionEventBus.class);
    private final Subject<WebRecordingConnectionEvent> eventPublisher = PublishSubject.create();

    @Inject
    public WebRecordingConnectionEventBus() {
    }

    public void publishEvent(WebRecordingConnectionEvent event) {
        try {
            logger.info("Publishing WebRecordingConnectionEvent | type = {} | event = {}", (Object)event.getClass().getName(), (Object)new ObjectMapper().writeValueAsString((Object)event));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.eventPublisher.onNext((Object)event);
    }

    public <T extends WebRecordingConnectionEvent> Observable<T> getObservableToSubscribe(Class<T> clazz) {
        return this.eventPublisher.filter(clazz::isInstance).cast(clazz);
    }
}

