/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.domain.manager;

import com.google.gson.JsonSyntaxException;
import com.katalon.recorder.core.constant.KeywordPlatform;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.KeywordStep;
import com.katalon.recorder.core.infrastructure.IKeywordDefinitionProvider;
import com.katalon.recorder.web.constant.StepAddingBehavior;
import com.katalon.recorder.web.domain.manager.IWebCapturedStepManager;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.domain.model.IWebRecordingSession;
import com.katalon.recorder.web.infrastructure.IWebCapturedStepService;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Strings;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class WebCapturedStepManager
implements IWebCapturedStepManager {
    private final IWebCapturedStepService capturedStepService;
    private final IKeywordDefinitionProvider keywordDefinitionProvider;

    @Inject
    public WebCapturedStepManager(IWebCapturedStepService capturedStepService, IKeywordDefinitionProvider keywordDefinitionProvider) {
        this.capturedStepService = capturedStepService;
        this.keywordDefinitionProvider = keywordDefinitionProvider;
    }

    public IStep parseStepFromCapturedActionFromEngine(String data, IWebCapturedObject capturedObject) throws JsonSyntaxException, UnsupportedEncodingException {
        return this.capturedStepService.parseStepFromCapturedActionFromEngine(data, capturedObject);
    }

    public StepAddingBehavior handleAddingCapturedStep(IWebRecordingSession recorderSession, IStep capturedStep) {
        List steps = recorderSession.getSteps();
        if (CollectionUtils.isEmpty((Collection)steps)) {
            return StepAddingBehavior.ADD_NEW_STEP;
        }
        if (!(steps.get(steps.size() - 1) instanceof KeywordStep) || !(capturedStep instanceof KeywordStep)) {
            return StepAddingBehavior.ADD_NEW_STEP;
        }
        KeywordStep lastStep = (KeywordStep)steps.get(steps.size() - 1);
        String lastKeywordName = lastStep.getKeywordDefinition().getKeywordRef().getName();
        String capturedKeywordName = capturedStep.getKeywordDefinition().getKeywordRef().getName();
        if ("setText".equals(capturedKeywordName) && "click".equals(lastKeywordName)) {
            return StepAddingBehavior.UPDATE_LAST_STEP;
        }
        if (this.isActionFromContextMenu(lastStep, (KeywordStep)capturedStep)) {
            Trackings.trackWebRecordStepByContextMenu((String)capturedStep.getKeywordDefinition().getKeywordRef().getName());
            return StepAddingBehavior.UPDATE_LAST_STEP;
        }
        if (this.shouldOverrideLastStep(lastStep, (KeywordStep)capturedStep)) {
            return StepAddingBehavior.UPDATE_LAST_STEP;
        }
        return StepAddingBehavior.ADD_NEW_STEP;
    }

    public IStep createKeywordStep(KeywordPlatform platform, String keywordName, Integer argCount) {
        KeywordStep step = new KeywordStep();
        if (argCount == null) {
            step.setKeywordDefinition(this.keywordDefinitionProvider.lookup(platform, keywordName));
            return step;
        }
        step.setKeywordDefinition(this.keywordDefinitionProvider.lookup(platform, keywordName, argCount.intValue()));
        return step;
    }

    private boolean isActionFromContextMenu(KeywordStep lastStep, KeywordStep capturedStep) {
        String capturedStepElementId;
        Object e;
        String capturedStepTargetElement;
        String lastStepElementId;
        Object e2;
        String lastKeywordName = lastStep.getKeywordDefinition().getKeywordRef().getName();
        String capturedKeywordName = capturedStep.getKeywordDefinition().getKeywordRef().getName();
        boolean hasChosenFromContextMenu = Strings.CS.containsAny((CharSequence)capturedKeywordName, new CharSequence[]{"verify", "waitFor", "mouseOver"});
        String lastStepTargetElement = lastStep.getArguments() != null && lastStep.getArguments().size() > 1 && (e2 = lastStep.getArguments().get(0)) instanceof String ? (lastStepElementId = (String)e2) : null;
        String string = capturedStepTargetElement = capturedStep.getArguments() != null && capturedStep.getArguments().size() > 1 && (e = capturedStep.getArguments().get(0)) instanceof String ? (capturedStepElementId = (String)e) : null;
        return "rightClick".equals(lastKeywordName) && lastStepTargetElement != null && lastStepTargetElement.equals(capturedStepTargetElement) && hasChosenFromContextMenu;
    }

    private boolean shouldOverrideLastStep(KeywordStep lastStep, KeywordStep newStep) {
        if (!Strings.CS.equals(lastStep.getKeywordDefinition().getKeywordRef().getName(), newStep.getKeywordDefinition().getKeywordRef().getName())) {
            return false;
        }
        if (this.isDuplicatedStepWithFirstArgument(lastStep, newStep, "setText", "setEncryptedText")) {
            return true;
        }
        return this.isDuplicatedStepWithFirstArgument(lastStep, newStep, "click");
    }

    private boolean isDuplicatedStepWithFirstArgument(KeywordStep lastStep, KeywordStep newStep, String ... keywordNames) {
        Object newStepFirstArg;
        String lastKeywordName = lastStep.getKeywordDefinition().getKeywordRef().getName();
        boolean isKeywordMatch = false;
        String[] stringArray = keywordNames;
        int n = keywordNames.length;
        int n2 = 0;
        while (n2 < n) {
            String keywordName = stringArray[n2];
            if (Strings.CS.equals(lastKeywordName, keywordName)) {
                isKeywordMatch = true;
                break;
            }
            ++n2;
        }
        if (!isKeywordMatch) {
            return false;
        }
        Object lastStepFirstArg = lastStep.getArguments() != null && !lastStep.getArguments().isEmpty() ? (Object)lastStep.getArguments().get(0) : null;
        Object v0 = newStepFirstArg = newStep.getArguments() != null && !newStep.getArguments().isEmpty() ? newStep.getArguments().get(0) : null;
        return lastStepFirstArg != null && lastStepFirstArg.equals(newStepFirstArg);
    }
}

