/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.domain.manager;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonSyntaxException;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionMessageParsingException;
import com.katalon.recorder.web.domain.manager.IWebRecorderEngineManager;
import com.katalon.recorder.web.domain.model.HeartbeatInfo;
import com.katalon.recorder.web.domain.model.HighlightElementInfo;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.domain.model.TakeScreenshotObjectInfo;
import com.katalon.recorder.web.infrastructure.IWebCapturedObjectService;
import com.katalon.recorder.web.infrastructure.IWebCapturedStepService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.UnsupportedEncodingException;
import java.util.List;

@Singleton
public class WebRecorderEngineManager
implements IWebRecorderEngineManager {
    private final IWebCapturedStepService capturedStepService;
    private final IWebCapturedObjectService capturedObjectService;

    @Inject
    public WebRecorderEngineManager(IWebCapturedStepService capturedStepService, IWebCapturedObjectService capturedObjectService) {
        this.capturedStepService = capturedStepService;
        this.capturedObjectService = capturedObjectService;
    }

    public IStep parseStepFromCapturedAction(String actionJson, IWebCapturedObject capturedObject) throws WebRecordingConnectionMessageParsingException {
        IStep capturedStep;
        try {
            capturedStep = this.capturedStepService.parseStepFromCapturedActionFromEngine(actionJson, capturedObject);
        }
        catch (JsonSyntaxException | UnsupportedEncodingException e) {
            throw new WebRecordingConnectionMessageParsingException("Failed to parse captured action from recorder engine", e);
        }
        return capturedStep;
    }

    public IWebCapturedObject parseCapturedObjectsFromCapturedAction(List<IWebCapturedObject> currentCapturedPages, String actionJsonData) throws UnsupportedEncodingException {
        return this.capturedObjectService.parseCapturedObjectsFromActionData(currentCapturedPages, actionJsonData);
    }

    public HighlightElementInfo parseHighlightElementInfoFromMessage(String data) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return (HighlightElementInfo)mapper.readValue(data, HighlightElementInfo.class);
    }

    public TakeScreenshotObjectInfo parseTakeScreenshotObjectInfoFromMessage(String data) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return (TakeScreenshotObjectInfo)mapper.readValue(data, TakeScreenshotObjectInfo.class);
    }

    public HeartbeatInfo parseHeartbeatInfoFromMessage(String data) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return (HeartbeatInfo)mapper.readValue(data, HeartbeatInfo.class);
    }
}

