/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.domain.manager;

import com.katalon.recorder.web.constant.WebRecorderStorageConstant;
import com.katalon.recorder.web.domain.exception.WriteRecordingRequestException;
import com.katalon.recorder.web.domain.manager.IWebRecordingRequestManager;
import com.katalon.recorder.web.domain.model.WebRecordingRequest;
import com.katalon.recorder.web.infrastructure.IWebRecordingRequestRepository;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class WebRecordingRequestManager
implements IWebRecordingRequestManager {
    private static final Logger logger = LoggerFactory.getLogger(WebRecordingRequestManager.class);
    private final IWebRecordingRequestRepository requestRepository;

    @Inject
    public WebRecordingRequestManager(IWebRecordingRequestRepository requestRepository) {
        this.requestRepository = requestRepository;
    }

    public WebRecordingRequest getLastRecordingRequest() {
        String filePath = this.buildFilePath();
        return this.requestRepository.readRecordingRequest(filePath);
    }

    public void saveLastRecordingRequest(WebRecordingRequest request) throws WriteRecordingRequestException {
        if (request == null) {
            return;
        }
        String filePath = this.buildFilePath();
        this.requestRepository.writeRecordingRequest(filePath, request);
        logger.info("saveLastRecordingRequest done | filePath = {}", (Object)filePath);
    }

    private String buildFilePath() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject == null) {
            throw new IllegalStateException("No opened project");
        }
        String projectDir = currentProject.getFolderLocation();
        return projectDir + File.separator + WebRecorderStorageConstant.RECORDER_REQUEST_FILE_PATH;
    }
}

