/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure;

import com.google.common.hash.Hashing;
import com.katalon.recorder.core.constant.AttributeConditionOperator;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.domain.model.CapturedObjectAttribute;
import com.katalon.recorder.core.domain.model.CapturedObjectXPath;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.ICapturedObjectAttribute;
import com.katalon.recorder.core.domain.model.ICapturedObjectXPath;
import com.katalon.recorder.core.infrastructure.ITestCaseService;
import com.katalon.recorder.core.infrastructure.dto.ASTNodeWrapperAdapter;
import com.katalon.recorder.web.constant.WebCapturedObjectType;
import com.katalon.recorder.web.domain.model.CapturedWebElement;
import com.katalon.recorder.web.domain.model.CapturedWebIFrame;
import com.katalon.recorder.web.domain.model.CapturedWebPage;
import com.katalon.recorder.web.domain.model.CapturedWebShadowRoot;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.infrastructure.IWebCapturedObjectService;
import com.katalon.recorder.web.infrastructure.converter.CapturedObjectConverter;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionMapping;
import com.kms.katalon.composer.webui.recorder.ast.RecordedElementMethodCallWrapper;
import com.kms.katalon.composer.webui.recorder.util.HTMLActionJsonParser;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.objectspy.element.WebElement;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class WebCapturedObjectService
implements IWebCapturedObjectService {
    private static final Logger logger = LoggerFactory.getLogger(WebCapturedObjectService.class);
    private static final int MAX_ELEMENT_NAME_LENGTH = 50;
    private final ITestCaseService testCaseService;

    @Inject
    public WebCapturedObjectService(ITestCaseService testCaseService) {
        this.testCaseService = testCaseService;
    }

    public List<IWebCapturedObject> fetchTestObjectFromTestCase(String testCaseId) throws Exception {
        List<ASTNodeWrapper> astNodeWrappers = Optional.ofNullable(this.testCaseService.deserializeTestCase(testCaseId)).map(Map::values).stream().flatMap(Collection::stream).map(ASTNodeWrapperAdapter::getAstNodeWrapper).toList();
        Map<String, List<RecordedElementMethodCallWrapper>> keywordNodeMaps = this.getTestObjectReferences(astNodeWrappers);
        List<WebElementEntity> webElementEntities = keywordNodeMaps.keySet().stream().map(testObjectId -> {
            try {
                return ObjectRepositoryController.getInstance().getWebElementByDisplayPk(testObjectId);
            }
            catch (Exception exception) {
                return null;
            }
        }).filter(we -> we != null && !(we instanceof WebServiceRequestEntity)).collect(Collectors.toList());
        return CapturedObjectConverter.convert(webElementEntities);
    }

    public IWebCapturedObject parseCapturedObjectsFromActionData(List<IWebCapturedObject> currentCapturedPages, String actionJsonData) throws UnsupportedEncodingException {
        HTMLActionMapping action = HTMLActionJsonParser.parseJsonIntoHTMLActionMapping((String)actionJsonData);
        if (action == null) {
            return null;
        }
        WebElement targetElement = action.getTargetElement();
        if (targetElement == null) {
            return null;
        }
        IWebCapturedObject webCapturedObject = this.convert(targetElement);
        return this.addNewElement(currentCapturedPages, webCapturedObject);
    }

    public List<TestObject> parseToTestObjects(List<IWebCapturedObject> capturedObjects) {
        if (capturedObjects == null || capturedObjects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TestObject> testObjects = new ArrayList<TestObject>();
        HashMap<String, TestObject> testObjectMap = new HashMap<String, TestObject>();
        for (IWebCapturedObject capturedObject : capturedObjects) {
            List children;
            TestObject testObject = this.convertToTestObject(capturedObject, testObjectMap);
            if (testObject != null) {
                testObjects.add(testObject);
            }
            if ((children = capturedObject.getChildren()) == null || children.isEmpty()) continue;
            for (ICapturedObject child : children) {
                IWebCapturedObject childCapturedObject;
                TestObject childTestObject;
                if (!(child instanceof IWebCapturedObject) || (childTestObject = this.convertToTestObject(childCapturedObject = (IWebCapturedObject)child, testObjectMap)) == null || testObjects.contains(childTestObject)) continue;
                testObjects.add(childTestObject);
            }
        }
        return testObjects;
    }

    private TestObject convertToTestObject(IWebCapturedObject capturedObject, Map<String, TestObject> testObjectMap) {
        String imagePath;
        Map locators;
        ConditionType conditionType;
        TestObject parentTestObject;
        IWebCapturedObject parentObject;
        ICapturedObject iCapturedObject;
        if (capturedObject == null) {
            return null;
        }
        String objectId = capturedObject.getId();
        if (testObjectMap.containsKey(objectId)) {
            return testObjectMap.get(objectId);
        }
        TestObject testObject = new TestObject(objectId);
        if (capturedObject.hasParent() && (iCapturedObject = capturedObject.getParent()) instanceof IWebCapturedObject && WebCapturedObjectType.PAGE != (parentObject = (IWebCapturedObject)iCapturedObject).getType() && (parentTestObject = this.convertToTestObject(parentObject, testObjectMap)) != null) {
            testObject.setParentObject(parentTestObject);
            testObject.setParentObjectShadowRoot(this.isParentObjectShadowRoot(capturedObject));
        }
        if (capturedObject.getAttributes() != null) {
            for (ICapturedObjectAttribute attribute : capturedObject.getAttributes()) {
                conditionType = attribute.getOperator() != null ? ConditionType.fromValue((String)attribute.getOperator().getDisplayName()) : ConditionType.EQUALS;
                testObject.addProperty(attribute.getName(), conditionType, attribute.getValue(), attribute.getEnabled());
            }
        }
        if (capturedObject.getXPaths() != null) {
            for (ICapturedObjectXPath xpath : capturedObject.getXPaths()) {
                conditionType = xpath.getCondition() != null ? ConditionType.fromValue((String)xpath.getCondition()) : ConditionType.EQUALS;
                testObject.addXpath(xpath.getName(), conditionType, xpath.getValue(), xpath.getEnabled().booleanValue());
            }
        }
        if (capturedObject.getLocatorType() != null) {
            testObject.setSelectorMethod(this.convertLocatorTypeToSelectorMethod(capturedObject.getLocatorType()));
        }
        if ((locators = capturedObject.getLocators()) != null && !locators.isEmpty()) {
            for (Map.Entry entry : locators.entrySet()) {
                SelectorMethod selectorMethod = this.convertLocatorTypeToSelectorMethod((LocatorType)entry.getKey());
                if (selectorMethod == null || entry.getValue() == null) continue;
                testObject.setSelectorValue(selectorMethod, (String)entry.getValue());
            }
        }
        String string = imagePath = locators != null ? (String)locators.get(LocatorType.IMAGE) : null;
        if (imagePath != null) {
            testObject.setImagePath(imagePath);
        }
        testObjectMap.put(objectId, testObject);
        return testObject;
    }

    private SelectorMethod convertLocatorTypeToSelectorMethod(LocatorType locatorType) {
        return switch (locatorType) {
            case LocatorType.XPATH -> SelectorMethod.XPATH;
            case LocatorType.CSS -> SelectorMethod.CSS;
            case LocatorType.IMAGE -> SelectorMethod.IMAGE;
            case LocatorType.SMART_LOCATOR -> SelectorMethod.SMART_LOCATOR;
            case LocatorType.ATTRIBUTES -> SelectorMethod.BASIC;
            default -> SelectorMethod.BASIC;
        };
    }

    private boolean isParentObjectShadowRoot(IWebCapturedObject capturedObject) {
        IWebCapturedObject parent;
        ICapturedObject iCapturedObject = capturedObject.getParent();
        return iCapturedObject instanceof IWebCapturedObject && "SHADOW_ROOT".equals((parent = (IWebCapturedObject)iCapturedObject).getType().name());
    }

    private IWebCapturedObject convert(WebElement targetElement) {
        if (targetElement == null) {
            return null;
        }
        CapturedWebPage result = switch (targetElement.getType()) {
            case WebElement.WebElementType.PAGE -> new CapturedWebPage(targetElement.getScriptId());
            case WebElement.WebElementType.FRAME -> new CapturedWebIFrame(targetElement.getScriptId());
            case WebElement.WebElementType.SHADOW -> new CapturedWebShadowRoot(targetElement.getScriptId());
            default -> new CapturedWebElement(targetElement.getScriptId());
        };
        result.setName(targetElement.getName());
        ArrayList<CapturedObjectAttribute> attributes = new ArrayList<CapturedObjectAttribute>(Optional.ofNullable(targetElement.getProperties()).stream().flatMap(Collection::stream).map(property -> new CapturedObjectAttribute(property.getName(), AttributeConditionOperator.fromDisplayName((String)property.getMatchCondition()), property.getValue(), Boolean.valueOf(property.getIsSelected()))).toList());
        result.setAttributes(attributes);
        ArrayList<CapturedObjectXPath> xpaths = new ArrayList<CapturedObjectXPath>(Optional.ofNullable(targetElement.getXpaths()).stream().flatMap(Collection::stream).map(xpath -> new CapturedObjectXPath(xpath.getName(), xpath.getMatchCondition(), xpath.getValue(), xpath.getIsSelected())).toList());
        result.setXPaths(xpaths);
        result.setLocatorType(LocatorType.valueOf((String)targetElement.getSelectorMethod().name()));
        HashMap locators = new HashMap();
        Optional.ofNullable(targetElement.getSelectorCollection()).map(Map::entrySet).stream().flatMap(Collection::stream).forEach(entry -> {
            String string = locators.put(LocatorType.valueOf((String)((SelectorMethod)entry.getKey()).name()), (String)entry.getValue());
        });
        result.setLocators(locators);
        result.setWindowTitle(targetElement.getWindowTitle());
        if (targetElement.getParent() != null) {
            result.setParent((ICapturedObject)this.convert((WebElement)targetElement.getParent()));
        }
        return result;
    }

    private IWebCapturedObject addNewElement(List<IWebCapturedObject> currentCapturedPages, IWebCapturedObject webCapturedObject) {
        CapturedWebPage parentPageElement = this.findPage(webCapturedObject);
        if (parentPageElement != null) {
            parentPageElement.setName(this.getElementShortName((ICapturedObject)parentPageElement));
            if (currentCapturedPages.contains(parentPageElement)) {
                return this.mergeNewElement(currentCapturedPages.get(currentCapturedPages.indexOf(parentPageElement)), (ICapturedObject)parentPageElement.getChildren().get(0));
            }
            this.updateWebPageElementNames(parentPageElement);
            currentCapturedPages.add((IWebCapturedObject)parentPageElement);
            return webCapturedObject;
        }
        return webCapturedObject;
    }

    private IWebCapturedObject mergeNewElement(IWebCapturedObject existedCapturedParent, ICapturedObject newCapturedObject) {
        if (this.indexOf(existedCapturedParent.getChildren(), newCapturedObject) >= 0) {
            if (newCapturedObject.hasChild().booleanValue()) {
                IWebCapturedObject existedHasChildElement = (IWebCapturedObject)existedCapturedParent.getChildren().get(this.indexOf(existedCapturedParent.getChildren(), newCapturedObject));
                return this.mergeNewElement(existedHasChildElement, (ICapturedObject)newCapturedObject.getChildren().get(0));
            }
            return (IWebCapturedObject)existedCapturedParent.getChildren().get(this.indexOf(existedCapturedParent.getChildren(), newCapturedObject));
        }
        if (existedCapturedParent.getChildren().stream().anyMatch(obj -> obj.getName().equals(newCapturedObject.getName()))) {
            String oldId = newCapturedObject.getId();
            String oldName = newCapturedObject.getName();
            newCapturedObject.setName(this.getNewElementDisplayName(existedCapturedParent, newCapturedObject));
            newCapturedObject.setId(Strings.CS.replace(oldId, oldName, newCapturedObject.getName()));
        }
        newCapturedObject.setParent((ICapturedObject)existedCapturedParent);
        return (IWebCapturedObject)newCapturedObject;
    }

    private String getNewElementDisplayName(IWebCapturedObject existedCapturedParent, ICapturedObject newCapturedObject) {
        String shortName = this.getElementShortName(newCapturedObject);
        List sameLevelElements = existedCapturedParent.getChildren();
        Set sameLevelElementNames = sameLevelElements.stream().map(ICapturedObject::getName).collect(Collectors.toSet());
        Object bufferName = shortName;
        int index = 0;
        while (sameLevelElementNames.contains(bufferName)) {
            bufferName = shortName + "_" + ++index;
        }
        return bufferName;
    }

    private void updateWebPageElementNames(CapturedWebPage parentPageElement) {
        List<ICapturedObject> flattenedElements = this.flattenWebElement((ICapturedObject)parentPageElement);
        for (ICapturedObject webCapturedObject : flattenedElements) {
            IWebCapturedObject parent = (IWebCapturedObject)webCapturedObject.getParent();
            ArrayList<ICapturedObject> precedingElements = new ArrayList<ICapturedObject>();
            int i = 0;
            while (i < this.indexOf(flattenedElements, webCapturedObject)) {
                if (flattenedElements.get(i).getParent() == parent) {
                    precedingElements.add(flattenedElements.get(i));
                }
                ++i;
            }
            Set precedingElementNames = precedingElements.stream().map(ICapturedObject::getName).collect(Collectors.toSet());
            Object webElementName = this.getElementShortName(webCapturedObject);
            int index = 0;
            while (precedingElementNames.contains(webElementName)) {
                webElementName = (String)webElementName + "_" + ++index;
            }
            webCapturedObject.setName((String)webElementName);
        }
    }

    private int indexOf(List<ICapturedObject> elements, ICapturedObject frame) {
        int index = 0;
        while (index < elements.size()) {
            if (Objects.equals(frame.getHashValue(), elements.get(index).getHashValue())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private List<ICapturedObject> flattenWebElement(ICapturedObject webElement) {
        ArrayList<ICapturedObject> elements = new ArrayList<ICapturedObject>();
        if (webElement.hasChild().booleanValue()) {
            elements.add(webElement);
            for (ICapturedObject childElement : webElement.getChildren()) {
                elements.addAll(this.flattenWebElement(childElement));
            }
        } else {
            elements.add(webElement);
        }
        return elements;
    }

    private String getElementShortName(ICapturedObject element) {
        Object shortName;
        String elementName = element.getName();
        if ((elementName = StringUtils.replaceChars((String)elementName, (String)"\n<>:\"/\\|?*", (String)"")).length() > 50) {
            String hash = Hashing.sha256().hashString((CharSequence)elementName, StandardCharsets.UTF_8).toString();
            shortName = elementName.substring(0, 43) + "_" + hash.substring(0, 6);
        } else {
            shortName = elementName;
        }
        return shortName;
    }

    private CapturedWebPage findPage(IWebCapturedObject capturedObject) {
        if (capturedObject == null) {
            return null;
        }
        if (capturedObject instanceof CapturedWebPage) {
            CapturedWebPage capturedWebPage = (CapturedWebPage)capturedObject;
            return capturedWebPage;
        }
        IWebCapturedObject parent = (IWebCapturedObject)capturedObject.getParent();
        if (parent == null) {
            return null;
        }
        return this.findPage(parent);
    }

    private Map<String, List<RecordedElementMethodCallWrapper>> getTestObjectReferences(ASTNodeWrapper wrapper) {
        ASTNodeWrapper aSTNodeWrapper;
        if (wrapper instanceof RecordedElementMethodCallWrapper) {
            return Collections.emptyMap();
        }
        HashMap<String, List<RecordedElementMethodCallWrapper>> keywordNodeIndex = new HashMap<String, List<RecordedElementMethodCallWrapper>>();
        if (wrapper == null) {
            return keywordNodeIndex;
        }
        if (wrapper.hasAstChildren() && wrapper.getAstChildren() != null) {
            this.merge(keywordNodeIndex, this.getTestObjectReferences(wrapper.getAstChildren()));
        }
        if ((aSTNodeWrapper = wrapper.getInput()) instanceof MethodCallExpressionWrapper) {
            MethodCallExpressionWrapper methodCall = (MethodCallExpressionWrapper)aSTNodeWrapper;
            if (!methodCall.isFindTestObjectMethodCall()) {
                return keywordNodeIndex;
            }
            Object testObjectId = AstEntityInputUtil.getEntityRelativeIdFromMethodCall((MethodCallExpressionWrapper)methodCall);
            try {
                testObjectId = ((String)testObjectId).startsWith("Object Repository/") ? testObjectId : "Object Repository/" + (String)testObjectId;
                WebElementEntity entity = ObjectRepositoryController.getInstance().getWebElementByDisplayPk((String)testObjectId);
                if (entity != null && !(entity instanceof WebServiceRequestEntity)) {
                    ArrayList<RecordedElementMethodCallWrapper> refNodes = keywordNodeIndex.getOrDefault(entity.getIdForDisplay(), null);
                    if (refNodes == null) {
                        refNodes = new ArrayList<RecordedElementMethodCallWrapper>();
                    }
                    RecordedElementMethodCallWrapper newWrapper = new RecordedElementMethodCallWrapper(wrapper.getParent(), null);
                    wrapper.getParent().replaceChild(wrapper, (ASTNodeWrapper)newWrapper);
                    refNodes.add(newWrapper);
                    keywordNodeIndex.put(entity.getIdForDisplay(), refNodes);
                }
            }
            catch (Exception e) {
                logger.error("Exception when getting test object | testObjectId = {}", testObjectId, (Object)e);
            }
        } else {
            ASTNodeWrapper aSTNodeWrapper2 = wrapper.getInput();
            if (aSTNodeWrapper2 instanceof ArgumentListExpressionWrapper) {
                ArgumentListExpressionWrapper argumentList = (ArgumentListExpressionWrapper)aSTNodeWrapper2;
                this.merge(keywordNodeIndex, this.getTestObjectReferences(argumentList.getAstChildren()));
            }
        }
        return keywordNodeIndex;
    }

    private Map<String, List<RecordedElementMethodCallWrapper>> getTestObjectReferences(List<? extends ASTNodeWrapper> nodes) {
        HashMap<String, List<RecordedElementMethodCallWrapper>> keywordNodeIndex = new HashMap<String, List<RecordedElementMethodCallWrapper>>();
        for (ASTNodeWrapper aSTNodeWrapper : nodes) {
            Map<String, List<RecordedElementMethodCallWrapper>> childNodeMap = this.getTestObjectReferences(aSTNodeWrapper);
            this.merge(keywordNodeIndex, childNodeMap);
        }
        return keywordNodeIndex;
    }

    private void merge(Map<String, List<RecordedElementMethodCallWrapper>> keywordNodeIndex, Map<String, List<RecordedElementMethodCallWrapper>> childNodeMap) {
        childNodeMap.forEach((objectId, newAstNodes) -> {
            if (keywordNodeIndex.containsKey(objectId)) {
                List currentAstNodes = (List)keywordNodeIndex.get(objectId);
                currentAstNodes.addAll(newAstNodes);
                keywordNodeIndex.put((String)objectId, currentAstNodes);
            } else {
                keywordNodeIndex.put((String)objectId, (List<RecordedElementMethodCallWrapper>)newAstNodes);
            }
        });
    }
}

