/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.katalon.recorder.core.constant.KeywordPlatform;
import com.katalon.recorder.core.domain.model.IKeywordDefinition;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.KeywordStep;
import com.katalon.recorder.core.infrastructure.IKeywordDefinitionProvider;
import com.katalon.recorder.web.constant.WebRecordedAction;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.infrastructure.IWebCapturedStepService;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.util.HTMLElementUtil;
import com.kms.katalon.objectspy.util.WebElementUtils;
import com.kms.katalon.util.CryptoUtil;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class WebCapturedStepService
implements IWebCapturedStepService {
    private static final Logger logger = LoggerFactory.getLogger(WebCapturedStepService.class);
    private final IKeywordDefinitionProvider keywordProvider;

    @Inject
    public WebCapturedStepService(IKeywordDefinitionProvider keywordProvider) {
        this.keywordProvider = keywordProvider;
    }

    public IStep parseStepFromCapturedActionFromEngine(String jsonString, IWebCapturedObject capturedObject) throws JsonSyntaxException, UnsupportedEncodingException {
        JsonObject jsonElement = (JsonObject)JsonParser.parseString((String)HTMLElementUtil.decodeURIComponent((String)jsonString));
        if (jsonElement == null) {
            return null;
        }
        if (!jsonElement.getAsJsonObject().has("action")) {
            return null;
        }
        return new JsonStepAction(this.keywordProvider, jsonElement, capturedObject).buildStep();
    }

    private static class JsonStepAction {
        private static final int KEYCODE_ENTER = 13;
        private JsonObject actionObject;
        private String actionName;
        private String actionData;
        private WebElement element;
        IKeywordDefinitionProvider keywordProvider;

        public JsonStepAction(IKeywordDefinitionProvider keywordProvider, JsonObject jsonElement, IWebCapturedObject capturedObject) throws UnsupportedEncodingException {
            this.keywordProvider = keywordProvider;
            this.init(jsonElement, capturedObject);
        }

        private void init(JsonObject jsonObject, IWebCapturedObject capturedObject) throws UnsupportedEncodingException {
            this.actionObject = this.getActionObject(jsonObject);
            if (this.actionObject == null) {
                throw new IllegalArgumentException();
            }
            this.actionName = this.getActionName(this.actionObject);
            if (this.actionName == null) {
                throw new IllegalArgumentException();
            }
            this.actionData = this.getActionData(this.actionObject);
            if (!this.actionName.equals(WebRecordedAction.NAVIGATE_ACTION_KEY.get())) {
                this.element = WebElementUtils.buildWebElement((JsonObject)jsonObject, (boolean)false);
                if (this.element != null && capturedObject != null) {
                    this.element.setName(capturedObject.getName());
                }
            }
            if (this.isSelectOrDeselectAction(this.actionObject, this.actionName, this.element)) {
                JsonObject actionDataObject = this.actionObject.get(WebRecordedAction.ACTION_DATA_KEY.get()).getAsJsonObject();
                List<String> oldValues = this.getDataValueList(actionDataObject, WebRecordedAction.ACTION_DATA_OLD_VALUE_KEY.get());
                List<String> newValues = this.getDataValueList(actionDataObject, WebRecordedAction.ACTION_DATA_NEW_VALUE_KEY.get());
                if (newValues.size() > oldValues.size()) {
                    newValues.removeAll(oldValues);
                    this.actionName = WebRecordedAction.SELECT_ACTION_KEY.get();
                    this.actionData = newValues.get(0);
                } else if (newValues.size() < oldValues.size()) {
                    oldValues.removeAll(newValues);
                    this.actionName = WebRecordedAction.DESELECT_ACTION_KEY.get();
                    this.actionData = oldValues.get(0);
                } else {
                    this.actionName = WebRecordedAction.SELECT_ACTION_KEY.get();
                    this.actionData = newValues.get(0);
                }
            }
        }

        private boolean isSelectOrDeselectAction(JsonObject actionObject, String actionName, WebElement element) {
            return element != null && element.getTag().toLowerCase().equals(WebRecordedAction.ELEMENT_TYPE_SELECT.get()) && actionName.equals(WebRecordedAction.INPUT_CHANGE_ACTION_KEY.get()) && actionObject.get(WebRecordedAction.ACTION_DATA_KEY.get()).isJsonObject();
        }

        private String getActionData(JsonObject actionObject) {
            if (actionObject.has(WebRecordedAction.ACTION_DATA_KEY.get()) && actionObject.get(WebRecordedAction.ACTION_DATA_KEY.get()).isJsonPrimitive()) {
                return actionObject.get(WebRecordedAction.ACTION_DATA_KEY.get()).getAsString();
            }
            return null;
        }

        private JsonObject getActionObject(JsonObject jsonObject) {
            if (jsonObject.has(WebRecordedAction.ACTION_KEY.get()) && jsonObject.get(WebRecordedAction.ACTION_KEY.get()).isJsonObject()) {
                return jsonObject.getAsJsonObject(WebRecordedAction.ACTION_KEY.get());
            }
            return null;
        }

        private String getActionName(JsonObject actionObject) {
            if (actionObject.has(WebRecordedAction.ACTION_NAME_KEY.get()) && actionObject.get(WebRecordedAction.ACTION_NAME_KEY.get()).isJsonPrimitive()) {
                return actionObject.get(WebRecordedAction.ACTION_NAME_KEY.get()).getAsString();
            }
            return null;
        }

        private List<String> getDataValueList(JsonObject actionDataObject, String memberKey) {
            ArrayList<String> dataValuesList = new ArrayList<String>();
            if (!actionDataObject.has(memberKey) || !actionDataObject.get(memberKey).isJsonArray()) {
                return dataValuesList;
            }
            JsonArray valueArray = actionDataObject.get(memberKey).getAsJsonArray();
            int i = 0;
            while (i < valueArray.size()) {
                dataValuesList.add(valueArray.get(i).getAsString());
                ++i;
            }
            return dataValuesList;
        }

        public IStep buildStep() {
            return this.buildStep(this.actionName, this.actionData, this.element);
        }

        private String removeBomEncoding(String value) {
            if (StringUtils.isNotEmpty((CharSequence)value) && value.contains(WebRecordedAction.UTF8_BOM.get())) {
                return value.replaceAll(WebRecordedAction.UTF8_BOM.get(), "");
            }
            return value;
        }

        private IStep buildStep(String recordedActionName, String actionData, WebElement targetElement) {
            WebRecordedAction action = WebRecordedAction.fromString((String)recordedActionName);
            if (action == null) {
                return null;
            }
            String targetElementName = targetElement == null ? null : targetElement.getScriptId();
            switch (action) {
                case NAVIGATE_ACTION_KEY: {
                    IKeywordDefinition navigateKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "navigateToUrl");
                    KeywordStep navigateStep = new KeywordStep();
                    navigateStep.setKeywordDefinition(navigateKeyword);
                    navigateStep.addArgument((Object)actionData);
                    return navigateStep;
                }
                case INPUT_CHANGE_ACTION_KEY: {
                    IKeywordDefinition setTextKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "setText");
                    WebElementPropertyEntity contentEditability = targetElement.getProperty("contenteditable");
                    if (contentEditability != null && contentEditability.getValue().equals("true")) {
                        actionData = this.removeBomEncoding(actionData);
                        KeywordStep setTextStep = new KeywordStep();
                        setTextStep.setKeywordDefinition(setTextKeyword);
                        setTextStep.addArgument((Object)targetElementName);
                        setTextStep.addArgument((Object)actionData);
                        this.secureSetTextAction(setTextStep, targetElement);
                        return setTextStep;
                    }
                    WebRecordedAction elementType = WebRecordedAction.fromString((String)targetElement.getTag().toLowerCase());
                    if (elementType == null) break;
                    switch (elementType) {
                        case ELEMENT_TYPE_INPUT: {
                            WebElementPropertyEntity typeProp = targetElement.getProperty("type");
                            if (typeProp == null) {
                                KeywordStep oldCaseSetTextStep = new KeywordStep();
                                oldCaseSetTextStep.setKeywordDefinition(setTextKeyword);
                                this.secureSetTextAction(oldCaseSetTextStep, targetElement);
                                return oldCaseSetTextStep;
                            }
                            WebRecordedAction inputType = WebRecordedAction.fromString((String)typeProp.getValue().toLowerCase());
                            if (inputType == WebRecordedAction.ELEMENT_TYPE_INPUT_CHECKBOX) {
                                if (this.isActionDataTrue(actionData)) {
                                    IKeywordDefinition checkKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "check");
                                    KeywordStep checkStep = new KeywordStep();
                                    checkStep.setKeywordDefinition(checkKeyword);
                                    checkStep.addArgument((Object)targetElementName);
                                    return checkStep;
                                }
                                IKeywordDefinition uncheckKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "uncheck");
                                KeywordStep uncheckStep = new KeywordStep();
                                uncheckStep.setKeywordDefinition(uncheckKeyword);
                                uncheckStep.addArgument((Object)targetElementName);
                                return uncheckStep;
                            }
                            KeywordStep setTextStep = new KeywordStep();
                            setTextStep.setKeywordDefinition(setTextKeyword);
                            setTextStep.addArgument((Object)targetElementName);
                            setTextStep.addArgument((Object)actionData);
                            this.secureSetTextAction(setTextStep, targetElement);
                            return setTextStep;
                        }
                        case ELEMENT_TYPE_TEXTAREA: {
                            KeywordStep setTextAreaStep = new KeywordStep();
                            setTextAreaStep.setKeywordDefinition(setTextKeyword);
                            setTextAreaStep.addArgument((Object)targetElementName);
                            setTextAreaStep.addArgument((Object)actionData);
                            this.secureSetTextAction(setTextAreaStep, targetElement);
                            return setTextAreaStep;
                        }
                    }
                    break;
                }
                case SELECT_ACTION_KEY: {
                    IKeywordDefinition selectKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "selectOptionByValue");
                    KeywordStep selectStep = new KeywordStep();
                    selectStep.setKeywordDefinition(selectKeyword);
                    selectStep.addArgument((Object)targetElementName);
                    selectStep.addArgument((Object)actionData);
                    return selectStep;
                }
                case DESELECT_ACTION_KEY: {
                    IKeywordDefinition deselectKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "deselectOptionByValue");
                    KeywordStep deselectStep = new KeywordStep();
                    deselectStep.setKeywordDefinition(deselectKeyword);
                    deselectStep.addArgument((Object)targetElementName);
                    deselectStep.addArgument((Object)actionData);
                    return deselectStep;
                }
                case MOUSE_CLICK_ACTION_KEY: {
                    if (actionData == null) {
                        return null;
                    }
                    WebRecordedAction clickType = WebRecordedAction.fromString((String)actionData);
                    if (clickType == null) break;
                    switch (clickType) {
                        case MOUSE_CLICK_ACTION_DATA_LEFT_CLICK: {
                            IKeywordDefinition clickKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "click");
                            KeywordStep clickStep = new KeywordStep();
                            clickStep.setKeywordDefinition(clickKeyword);
                            clickStep.addArgument((Object)targetElementName);
                            return clickStep;
                        }
                        case MOUSE_CLICK_ACTION_DATA_RIGHT_CLICK: {
                            IKeywordDefinition rightClickKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "rightClick");
                            KeywordStep rightClickStep = new KeywordStep();
                            rightClickStep.setKeywordDefinition(rightClickKeyword);
                            rightClickStep.addArgument((Object)targetElementName);
                            return rightClickStep;
                        }
                    }
                    break;
                }
                case VERIFY_ELEMENT_TEXT: {
                    IKeywordDefinition verifyTextKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "verifyElementText");
                    KeywordStep verifyTextStep = new KeywordStep();
                    verifyTextStep.setKeywordDefinition(verifyTextKeyword);
                    verifyTextStep.addArgument((Object)targetElementName);
                    verifyTextStep.addArgument((Object)actionData);
                    return verifyTextStep;
                }
                case MOUSE_OVER: 
                case VERIFY_ELEMENT_PRESENT: 
                case VERIFY_ELEMENT_NOT_PRESENT: 
                case VERIFY_ELEMENT_VISIBLE: 
                case VERIFY_ELEMENT_NOT_VISIBLE: 
                case VERIFY_ELEMENT_CLICKABLE: 
                case VERIFY_ELEMENT_NOT_CLICKABLE: 
                case WAIT_FOR_ELEMENT_PRESENT: 
                case WAIT_FOR_ELEMENT_NOT_PRESENT: 
                case WAIT_FOR_ELEMENT_VISIBLE: 
                case WAIT_FOR_ELEMENT_NOT_VISIBLE: {
                    IKeywordDefinition keyword = this.keywordProvider.lookup(KeywordPlatform.WEB, action.get());
                    KeywordStep step = new KeywordStep();
                    step.setKeywordDefinition(keyword);
                    step.addArgument((Object)targetElementName);
                    return step;
                }
                case DOUBLE_CLICK_ACTION_KEY: {
                    IKeywordDefinition doubleClickKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "doubleClick");
                    KeywordStep doubleClickStep = new KeywordStep();
                    doubleClickStep.setKeywordDefinition(doubleClickKeyword);
                    doubleClickStep.addArgument((Object)targetElementName);
                    return doubleClickStep;
                }
                case SEND_KEYS_ACTION_KEY: {
                    int keyCode = Integer.parseInt(actionData);
                    if (keyCode != 13) {
                        return null;
                    }
                    IKeywordDefinition sendKeysKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "sendKeys");
                    KeywordStep sendKeysStep = new KeywordStep();
                    sendKeysStep.setKeywordDefinition(sendKeysKeyword);
                    sendKeysStep.addArgument((Object)targetElementName);
                    sendKeysStep.addArgument((Object)"Keys.chord(Keys.ENTER)");
                    sendKeysStep.addArgument((Object)actionData);
                    return sendKeysStep;
                }
                case SWITCH_TO_WINDOW_ACTION_KEY: {
                    IKeywordDefinition switchToWindowKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "switchToWindowTitle");
                    KeywordStep switchToWindowStep = new KeywordStep();
                    switchToWindowStep.setKeywordDefinition(switchToWindowKeyword);
                    switchToWindowStep.addArgument((Object)actionData);
                    return switchToWindowStep;
                }
                case NEW_TAB_ACTION_KEY: {
                    IKeywordDefinition newTabKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "newTab");
                    KeywordStep newTabStep = new KeywordStep();
                    newTabStep.setKeywordDefinition(newTabKeyword);
                    newTabStep.addArgument((Object)actionData);
                    return newTabStep;
                }
            }
            return null;
        }

        private void secureSetTextAction(KeywordStep step, WebElement targetElement) {
            Object e;
            if (!this.isPwInputElement(targetElement)) {
                return;
            }
            IKeywordDefinition encryptedTextKeyword = this.keywordProvider.lookup(KeywordPlatform.WEB, "setEncryptedText");
            step.setKeywordDefinition(encryptedTextKeyword);
            if (step.getArguments() != null && step.getArguments().size() == 2 && (e = step.getArguments().get(1)) instanceof String) {
                String pwValue = (String)e;
                try {
                    String encryptedValue = CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)pwValue));
                    this.updateStepLastArgument(step, encryptedValue);
                }
                catch (UnsupportedEncodingException | GeneralSecurityException e2) {
                    logger.error("Cannot encode for keyword setEncryptedText", (Throwable)e2);
                }
            }
        }

        private boolean isPwInputElement(WebElement targetElement) {
            WebElementPropertyEntity property = targetElement.getProperty("type");
            return Objects.nonNull(property) && Strings.CS.equals("password", property.getValue());
        }

        private List<Object> updateStepLastArgument(KeywordStep step, Object lastArgValue) {
            List arguments = step.getArguments();
            arguments.set(arguments.size() - 1, lastArgValue);
            return arguments;
        }

        private boolean isActionDataTrue(String actionData) {
            return actionData != null && actionData.equalsIgnoreCase(Boolean.TRUE.toString());
        }
    }
}

