/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.recorder.web.infrastructure.event.IWebSocketEventBus;
import com.katalon.recorder.web.infrastructure.event.WebSocketConnectionCloseEvent;
import com.katalon.recorder.web.infrastructure.event.WebSocketConnectionOpenEvent;
import com.katalon.recorder.web.infrastructure.event.WebSocketErrorOccurredEvent;
import com.katalon.recorder.web.infrastructure.event.WebSocketEvent;
import com.katalon.recorder.web.infrastructure.event.WebSocketEventBus;
import com.katalon.recorder.web.infrastructure.event.WebSocketMessageReceivedEvent;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/")
public class WebSocketEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketEndpoint.class);
    private static final String DRIVER_TYPE_KEY = "driverType";
    private static final String BROWSER_VERSION_KEY = "browserVersion";
    private static final String PAGE_TITLE_KEY = "pageTitle";
    private static final String ENGINE_KEY = "engine";
    private static final String ENGINE_TYPE_KEY = "engineType";
    private static final String ENGINE_VERSION_KEY = "engineVersion";
    private static final String ENGINE_EXTENSION_ID_KEY = "engineExtensionId";
    public static final String SMART_LOCATOR_CAPTURE_ENABLED_KEY = "smartLocatorCaptureEnabled";
    private final IWebSocketEventBus webSocketEventBus = WebSocketEventBus.getInstance();

    @OnOpen
    public void onOpen(Session session) {
        WebSocketConnectionOpenEvent webSocketConnectionOpenEvent = new WebSocketConnectionOpenEvent(session);
        Map parameterMap = session.getRequestParameterMap();
        try {
            logger.info("WebSocket connection opened with parameters: " + new ObjectMapper().writeValueAsString((Object)parameterMap));
        }
        catch (JsonProcessingException jsonProcessingException) {}
        if (parameterMap != null) {
            webSocketConnectionOpenEvent.setDriverType(this.extractParam(parameterMap, DRIVER_TYPE_KEY));
            webSocketConnectionOpenEvent.setBrowserVersion(this.extractParam(parameterMap, BROWSER_VERSION_KEY));
            webSocketConnectionOpenEvent.setPageTitle(this.extractParam(parameterMap, PAGE_TITLE_KEY));
            webSocketConnectionOpenEvent.setEngine(this.extractParam(parameterMap, ENGINE_KEY));
            webSocketConnectionOpenEvent.setEngineType(this.extractParam(parameterMap, ENGINE_TYPE_KEY));
            webSocketConnectionOpenEvent.setEngineVersion(this.extractParam(parameterMap, ENGINE_VERSION_KEY));
            webSocketConnectionOpenEvent.setEngineExtensionId(this.extractParam(parameterMap, ENGINE_EXTENSION_ID_KEY));
            webSocketConnectionOpenEvent.setSmartLocatorCaptureEnabled(this.extractParam(parameterMap, SMART_LOCATOR_CAPTURE_ENABLED_KEY) == null ? null : Boolean.valueOf(this.extractParam(parameterMap, SMART_LOCATOR_CAPTURE_ENABLED_KEY)));
        }
        this.webSocketEventBus.publishEvent((WebSocketEvent)webSocketConnectionOpenEvent);
    }

    private String extractParam(Map<String, List<String>> parameterMap, String paramKey) {
        return Optional.ofNullable(parameterMap.get(paramKey)).orElse(Collections.emptyList()).stream().findFirst().orElse(null);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        this.webSocketEventBus.publishEvent((WebSocketEvent)new WebSocketMessageReceivedEvent(session, message));
    }

    @OnClose
    public void onClose(Session session) {
        this.webSocketEventBus.publishEvent((WebSocketEvent)new WebSocketConnectionCloseEvent(session));
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        this.webSocketEventBus.publishEvent((WebSocketEvent)new WebSocketErrorOccurredEvent(session, throwable));
    }
}

