/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure.event;

import com.katalon.recorder.web.infrastructure.event.IWebDriverRunnableEventBus;
import com.katalon.recorder.web.infrastructure.event.WebDriverRunnableEvent;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverRunnableEventBus
implements IWebDriverRunnableEventBus {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverRunnableEventBus.class);
    private final PublishSubject<WebDriverRunnableEvent> eventPublisher = PublishSubject.create();
    private static IWebDriverRunnableEventBus INSTANCE;

    public static synchronized IWebDriverRunnableEventBus getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WebDriverRunnableEventBus();
        }
        return INSTANCE;
    }

    private WebDriverRunnableEventBus() {
    }

    public void close() {
        this.eventPublisher.onComplete();
        INSTANCE = null;
        logger.info("WebSocketEventBus closed");
    }

    public void publishEvent(WebDriverRunnableEvent event) {
        logger.info("Publishing WebDriverRunnableEvent | type = {} | sessionId = {}", (Object)event.getClass().getSimpleName(), (Object)event.getWebDriverId());
        this.eventPublisher.onNext((Object)event);
    }

    public <T extends WebDriverRunnableEvent> Observable<T> getObservableToSubscribe(Class<T> clazz) {
        return this.eventPublisher.filter(clazz::isInstance).cast(clazz);
    }
}

