/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure.event;

import com.katalon.recorder.web.infrastructure.event.IWebSocketEventBus;
import com.katalon.recorder.web.infrastructure.event.WebSocketEvent;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketEventBus
implements IWebSocketEventBus {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketEventBus.class);
    private final PublishSubject<WebSocketEvent> eventPublisher = PublishSubject.create();
    private static IWebSocketEventBus INSTANCE;

    public static synchronized IWebSocketEventBus getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WebSocketEventBus();
        }
        return INSTANCE;
    }

    private WebSocketEventBus() {
    }

    public void close() {
        this.eventPublisher.onComplete();
        INSTANCE = null;
        logger.info("WebSocketEventBus closed");
    }

    public void publishEvent(WebSocketEvent event) {
        logger.info("Publishing WebSocketEvent | type = {} | sessionId = {}", (Object)event.getClass().getSimpleName(), (Object)event.getSessionId());
        this.eventPublisher.onNext((Object)event);
    }

    public <T extends WebSocketEvent> Observable<T> getObservableToSubscribe(Class<T> clazz) {
        return this.eventPublisher.filter(clazz::isInstance).cast(clazz);
    }
}

