/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure.util;

import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.ICapturedObjectAttribute;
import com.katalon.recorder.core.domain.model.ICapturedObjectXPath;
import com.katalon.recorder.web.constant.WebCapturedObjectType;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionClosedException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionNotFoundException;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.infrastructure.runnable.IWebDriverRunnable;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebFrame;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.WebParent;
import com.kms.katalon.objectspy.element.WebShadow;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebElementUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)WebElementUtils.class.getName());
    private static final String HIGHLIGHT_JS_PATH = "/resources/js/highlight.js";
    private static final String DOCUMENT_QUERY_SELECTOR = "return document.querySelector";
    private static final String SHADOW_DOM_QUERY_SELECTOR = ".shadowRoot.querySelector";
    private static final String SCREENSHOT_PATH = "/Screenshots/Targets/";

    public static Integer verifyAndHighlightElement(IWebDriverRunnable webDriverRunnable, IWebCapturedObject capturedObject, LocatorType locatorType) throws WebRecordingConnectionNotFoundException {
        WebDriver webDriver = webDriverRunnable.getWebDriver();
        try {
            List<org.openqa.selenium.WebElement> webElements;
            if (webDriver == null || WebElementUtils.isBrowserClosed(webDriver)) {
                throw new WebRecordingConnectionClosedException("WebDriver is not available or the browser is closed.");
            }
            webDriver.switchTo().window(webDriver.getWindowHandle());
            webDriver.manage().timeouts().implicitlyWait(Duration.ofMillis(100L));
            if (capturedObject.getWindowTitle() != null && !capturedObject.getWindowTitle().isEmpty() && webDriver.getTitle() != capturedObject.getWindowTitle()) {
                WebElementUtils.switchToWindowUsingTitle(webDriver, capturedObject.getWindowTitle(), 1);
            }
            if ((webElements = WebElementUtils.findWebElements(webDriver, capturedObject, locatorType)) == null) {
                return 0;
            }
            if (webElements.isEmpty()) {
                return 0;
            }
            List<org.openqa.selenium.WebElement> finalWebElements = webElements;
            new Thread(() -> WebElementUtils.highlightElements(webDriver, finalWebElements)).start();
            return webElements.size();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<org.openqa.selenium.WebElement> findWebElements(WebDriver webDriver, IWebCapturedObject capturedObject, LocatorType locatorType) {
        List<Object> webElements = new ArrayList<org.openqa.selenium.WebElement>();
        IWebCapturedObject webParent = (IWebCapturedObject)capturedObject.getParent();
        if (webParent != null) {
            WebCapturedObjectType type = webParent.getType();
            switch (type) {
                case IFRAME: 
                case SHADOW_ROOT: {
                    WebElementUtils.switchToFrame(webDriver, capturedObject, locatorType);
                    break;
                }
            }
            if (locatorType == LocatorType.SMART_LOCATOR) {
                String jsLocator = WebElementUtils.getSmartLocatorFromElement(capturedObject);
                org.openqa.selenium.WebElement elementFindBySmartLocator = (org.openqa.selenium.WebElement)((JavascriptExecutor)webDriver).executeScript(jsLocator, new Object[0]);
                webElements.add(elementFindBySmartLocator);
            } else if (locatorType == LocatorType.CSS && type == WebCapturedObjectType.SHADOW_ROOT) {
                String script = DOCUMENT_QUERY_SELECTOR + WebElementUtils.getCssSelectorFromShadowDom(capturedObject) + ";";
                org.openqa.selenium.WebElement elementFindByCSS = (org.openqa.selenium.WebElement)((JavascriptExecutor)webDriver).executeScript(script, new Object[0]);
                webElements.add(elementFindByCSS);
            }
            if (webElements.isEmpty()) {
                By seleniumSelector = WebElementUtils.getSeleniumSelector(capturedObject, locatorType);
                if (seleniumSelector == null) {
                    return null;
                }
                webElements = webDriver.findElements(seleniumSelector);
            }
        }
        return webElements;
    }

    private static boolean switchToWindowUsingTitle(WebDriver webDriver, String title, int timeOutInSeconds) throws WebDriverException, InterruptedException {
        long timeoutAt = System.currentTimeMillis() + (long)timeOutInSeconds * 1000L;
        while (System.currentTimeMillis() < timeoutAt) {
            Set availableWindows = webDriver.getWindowHandles();
            for (String windowId : availableWindows) {
                if (!(webDriver = webDriver.switchTo().window(windowId)).getTitle().equals(title)) continue;
                return true;
            }
            Thread.sleep(200L);
        }
        return false;
    }

    private static By getSeleniumSelector(IWebCapturedObject webCapturedObject, LocatorType locatorType) {
        String selectorValue = webCapturedObject.getLocator(locatorType);
        switch (locatorType) {
            case ATTRIBUTES: {
                return By.cssSelector((String)selectorValue);
            }
            case CSS: {
                if (StringUtils.isEmpty((CharSequence)selectorValue)) {
                    return null;
                }
                return By.cssSelector((String)selectorValue);
            }
            case XPATH: {
                if (StringUtils.isEmpty((CharSequence)selectorValue)) {
                    return null;
                }
                return By.xpath((String)selectorValue);
            }
            case IMAGE: {
                break;
            }
            case SMART_LOCATOR: {
                break;
            }
        }
        return null;
    }

    public static TestObject buildTestObject(IWebCapturedObject webElement) {
        TestObject testObject = new TestObject(webElement.getId());
        IWebCapturedObject webParent = (IWebCapturedObject)webElement.getParent();
        if (webParent != null && WebCapturedObjectType.PAGE != webParent.getType()) {
            TestObject parent = WebElementUtils.buildTestObject(webParent);
            testObject.setParentObject(parent);
        }
        webElement.getAttributes().forEach(prop -> testObject.addProperty(prop.getName(), ConditionType.fromValue((String)prop.getOperator().name()), prop.getValue(), prop.getEnabled()));
        webElement.getXPaths().forEach(xpath -> testObject.addXpath(xpath.getName(), ConditionType.fromValue((String)xpath.getCondition()), xpath.getValue(), xpath.getEnabled().booleanValue()));
        if (webParent != null && WebCapturedObjectType.SHADOW_ROOT == webParent.getType() && StringUtils.isNotEmpty((CharSequence)webParent.getName())) {
            testObject.setParentObjectShadowRoot(true);
            for (ICapturedObject el : webParent.getChildren()) {
                if (!el.getName().equalsIgnoreCase(webParent.getName())) continue;
                testObject.setParentObject(WebElementUtils.buildTestObject((IWebCapturedObject)el));
                break;
            }
        }
        testObject.setSelectorMethod(SelectorMethod.fromDisplayName((String)webElement.getLocatorType().getDisplayName()));
        webElement.getLocators().forEach((key, value) -> testObject.setSelectorValue(SelectorMethod.fromDisplayName((String)key.getDisplayName()), value));
        testObject.setSmartSelectorCollection(WebElementUtils.toSelectorMethodMap(webElement.getLocators()));
        return testObject;
    }

    private static Map<SelectorMethod, String> toSelectorMethodMap(Map<LocatorType, String> locatorMap) {
        if (locatorMap == null) {
            return null;
        }
        HashMap<SelectorMethod, String> selectorMap = new HashMap<SelectorMethod, String>();
        for (Map.Entry<LocatorType, String> entry : locatorMap.entrySet()) {
            SelectorMethod selectorMethod = SelectorMethod.fromDisplayName((String)entry.getKey().getDisplayName());
            selectorMap.put(selectorMethod, entry.getValue());
        }
        return selectorMap;
    }

    private static String getCssSelectorFromShadowDom(IWebCapturedObject webElement) {
        String cssSelector = "('" + webElement.getLocator(LocatorType.CSS) + "')";
        IWebCapturedObject parent = (IWebCapturedObject)webElement.getParent();
        if (parent != null && WebCapturedObjectType.SHADOW_ROOT == parent.getType()) {
            cssSelector = WebElementUtils.getCssSelectorFromShadowDom(parent) + SHADOW_DOM_QUERY_SELECTOR + cssSelector;
        }
        return cssSelector;
    }

    private static String getSmartLocatorFromElement(IWebCapturedObject webElement) {
        String smartLocator = webElement.getLocator(LocatorType.SMART_LOCATOR);
        String jsLocator = String.format("return katalonSmartLocator.find_element_by_smart_locator(`%s`)", smartLocator);
        return jsLocator;
    }

    private static void switchToFrame(WebDriver webDriver, IWebCapturedObject katalonElement, LocatorType locatorType) {
        IWebCapturedObject parentElement = (IWebCapturedObject)katalonElement.getParent();
        if (parentElement == null || WebCapturedObjectType.PAGE == parentElement.getType()) {
            return;
        }
        org.openqa.selenium.WebElement parentSeleniumElement = null;
        boolean isFrame = false;
        WebElementUtils.switchToFrame(webDriver, parentElement, locatorType);
        if (LocatorType.SMART_LOCATOR == parentElement.getLocatorType()) {
            String jsLocator = WebElementUtils.getSmartLocatorFromElement(parentElement);
            parentSeleniumElement = (org.openqa.selenium.WebElement)((JavascriptExecutor)webDriver).executeScript(jsLocator, new Object[0]);
        } else if (WebCapturedObjectType.IFRAME == parentElement.getType()) {
            List elements = webDriver.findElements(WebElementUtils.getSeleniumSelector(parentElement, locatorType));
            if (!elements.isEmpty()) {
                parentSeleniumElement = (org.openqa.selenium.WebElement)elements.get(0);
            }
        } else if (WebCapturedObjectType.SHADOW_ROOT == parentElement.getType()) {
            String script = DOCUMENT_QUERY_SELECTOR + WebElementUtils.getCssSelectorFromShadowDom(katalonElement) + ";";
            parentSeleniumElement = (org.openqa.selenium.WebElement)((JavascriptExecutor)webDriver).executeScript(script, new Object[0]);
        }
        if (parentSeleniumElement == null) {
            return;
        }
        String tagName = parentSeleniumElement.getTagName();
        if ("iFrame".equalsIgnoreCase(tagName) || "frame".equalsIgnoreCase(tagName)) {
            isFrame = true;
        }
        if (isFrame) {
            webDriver.switchTo().frame(parentSeleniumElement);
        }
    }

    private static boolean isBrowserClosed(WebDriver webDriver) {
        try {
            webDriver.getTitle();
            return false;
        }
        catch (WebDriverException webDriverException) {
            return true;
        }
    }

    private static void highlightElements(WebDriver webDriver, List<org.openqa.selenium.WebElement> webElements) {
        if (webDriver instanceof JavascriptExecutor) {
            JavascriptExecutor jsExecutor = (JavascriptExecutor)webDriver;
            org.openqa.selenium.WebElement firstElement = webElements.get(0);
            boolean isInViewPort = (Boolean)((JavascriptExecutor)webDriver).executeScript("var elem = arguments[0],                   box = elem.getBoundingClientRect(),      cx = box.left + box.width / 2,           cy = box.top + box.height / 2,           e = document.elementFromPoint(cx, cy); for (; e; e = e.parentElement) {           if (e === elem)                            return true;                         }                                        return false;                            ", new Object[]{firstElement});
            if (!isInViewPort) {
                jsExecutor.executeScript("arguments[0].scrollIntoView({ behavior: 'auto',          block: 'center',           inline: 'center'           });                       ", new Object[]{firstElement});
            }
            String highlightJS = WebElementUtils.loadHighlightJSFromResource();
            webElements.parallelStream().forEach(element -> jsExecutor.executeScript(highlightJS, new Object[]{element}));
        }
    }

    private static String loadHighlightJSFromResource() {
        try {
            URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(WebElementUtils.class), (IPath)new Path(HIGHLIGHT_JS_PATH), null);
            return StringUtils.join((Iterable)IOUtils.readLines((InputStream)new BufferedInputStream(url.openStream()), (String)"UTF-8"), (String)"\n");
        }
        catch (IOException e) {
            logger.error("Exception when load highlight.js from resource", (Throwable)e);
            return "";
        }
    }

    public static String takeScreenShot(IWebDriverRunnable webDriverRunnable, IWebCapturedObject capturedObject) {
        WebDriver webDriver = webDriverRunnable.getWebDriver();
        String currentProjectLocation = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        String objectRepositoryFolder = capturedObject.getId().replace(capturedObject.getName(), "");
        File imageFolder = new File(currentProjectLocation + SCREENSHOT_PATH + objectRepositoryFolder);
        imageFolder.mkdirs();
        LocatorType locatorType = LocatorType.IMAGE == capturedObject.getLocatorType() ? LocatorType.XPATH : capturedObject.getLocatorType();
        By seleniumSelector = WebElementUtils.getSeleniumSelector(capturedObject, locatorType);
        if (seleniumSelector == null) {
            return null;
        }
        List<org.openqa.selenium.WebElement> webElements = WebElementUtils.findWebElements(webDriver, capturedObject, locatorType);
        return Optional.ofNullable(webElements).stream().flatMap(Collection::stream).findFirst().map(element -> {
            try {
                return WebUiCommonHelper.saveWebElementScreenshotAndResize((WebDriver)webDriver, (org.openqa.selenium.WebElement)element, (String)capturedObject.getName(), (String)imageFolder.getAbsolutePath());
            }
            catch (IOException e) {
                logger.error("Exception when takeScreenShot", (Throwable)e);
                return null;
            }
        }).orElse(null);
    }

    public static List<WebPage> convert(List<IWebCapturedObject> capturedObjects) {
        if (capturedObjects == null) {
            return null;
        }
        ArrayList<WebPage> result = new ArrayList<WebPage>();
        for (IWebCapturedObject capturedObject : capturedObjects) {
            WebPage webPage = (WebPage)WebElementUtils.convert(null, capturedObject);
            result.add(webPage);
        }
        return result;
    }

    private static WebElement convert(WebParent parent, IWebCapturedObject capturedObject) {
        WebPage webElement = switch (capturedObject.getType()) {
            case WebCapturedObjectType.PAGE -> new WebPage(capturedObject.getName());
            case WebCapturedObjectType.IFRAME -> new WebFrame(capturedObject.getName());
            case WebCapturedObjectType.SHADOW_ROOT -> new WebShadow(capturedObject.getName());
            default -> new WebElement(capturedObject.getName());
        };
        webElement.setParent(parent);
        for (ICapturedObjectAttribute iCapturedObjectAttribute : capturedObject.getAttributes()) {
            webElement.addProperty(new WebElementPropertyEntity(iCapturedObjectAttribute.getName(), "Main", iCapturedObjectAttribute.getValue(), iCapturedObjectAttribute.getOperator().getDisplayName(), iCapturedObjectAttribute.getEnabled()));
        }
        for (ICapturedObjectXPath iCapturedObjectXPath : capturedObject.getXPaths()) {
            WebElementXpathEntity webElementXpathEntity = new WebElementXpathEntity(iCapturedObjectXPath.getName(), iCapturedObjectXPath.getValue(), iCapturedObjectXPath.getEnabled().booleanValue());
            webElementXpathEntity.setMatchCondition(iCapturedObjectXPath.getCondition());
            webElement.getXpaths().add(webElementXpathEntity);
        }
        if (capturedObject.getLocatorType() != null) {
            webElement.setSelectorMethod(SelectorMethod.fromDisplayName((String)capturedObject.getLocatorType().getDisplayName()));
        }
        for (Map.Entry entry : capturedObject.getLocators().entrySet()) {
            webElement.setSelectorValue(SelectorMethod.fromDisplayName((String)((LocatorType)entry.getKey()).getDisplayName()), (String)entry.getValue());
        }
        webElement.setWindowTitle(capturedObject.getWindowTitle());
        if (capturedObject.hasChild().booleanValue() && webElement instanceof WebParent) {
            WebParent webParent = (WebParent)webElement;
            for (ICapturedObject child : capturedObject.getChildren()) {
                WebElementUtils.convert(webParent, (IWebCapturedObject)child);
            }
        }
        return webElement;
    }
}

