/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.presentation;

import com.equo.chromium.swt.Browser;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.katalon.recorder.core.domain.model.IKeywordDefinition;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.presentation.IRecorderDialogView;
import com.katalon.recorder.web.presentation.dto.LogMessageType;
import com.katalon.recorder.web.presentation.dto.RecordingConnectionDTO;
import com.katalon.recorder.web.presentation.dto.RunningLogDTO;
import com.kms.katalon.core.webui.common.RunningStatus;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class RecorderDialogView
implements IRecorderDialogView {
    private final AtomicReference<Browser> browser = new AtomicReference();

    @Inject
    public RecorderDialogView() {
    }

    public void init(Browser browser) {
        this.browser.set(browser);
    }

    public void callUpdateRecordingRequest(String testCaseId, String driverType, boolean withProfile, String customCapabilityName, String startupUrl) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callUpdateRecordingRequest", (Object[])new Object[]{testCaseId, driverType, withProfile, customCapabilityName, startupUrl});
    }

    public void callUpdateRecordingStatus(String status) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callUpdateRecordingStatus", (Object[])new Object[]{status});
    }

    public void callUpdateRecordingConnections(List<RecordingConnectionDTO> connections) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callUpdateRecordingConnections", (Object[])new Object[]{connections});
    }

    public void callUpdateSteps(List<IStep> steps) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callUpdateSteps", (Object[])new Object[]{steps});
    }

    public void callAddStep(IStep step) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callAddStep", (Object[])new Object[]{step});
    }

    public void callUpdateLastStep(IStep step) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callUpdateLastStep", (Object[])new Object[]{step});
    }

    public void callUpdateCapturedObjects(List<IWebCapturedObject> testObjects) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callUpdateCapturedObjects", (Object[])new Object[]{testObjects});
    }

    public void callUpdateVariables(List<IVariable> variables) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callUpdateVariables", (Object[])new Object[]{variables});
    }

    public void callAppendRunningLog(String log, LogMessageType type) {
        RunningLogDTO runningLog = new RunningLogDTO(log, type);
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callAppendRunningLog", (Object[])new Object[]{runningLog});
    }

    public void callClearRunningLogs() {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callClearRunningLogs", (Object[])new Object[0]);
    }

    public void callUpdateRunningStatus(RunningStatus status) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callUpdateRunningStatus", (Object[])new Object[]{status});
    }

    public void callLoadKeywordDefinitions(List<IKeywordDefinition> keywords) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"recorderDialogViewFunc.callLoadKeywordDefinitions", (Object[])new Object[]{keywords});
    }
}

