/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.presentation;

import com.equo.chromium.swt.Browser;
import com.katalon.capability.constant.DriverPlatform;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.controller.ICustomCapabilityController;
import com.katalon.capability.exception.MismatchCapabilityTypeException;
import com.katalon.capability.model.CustomCapabilitySetting;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.constant.RecordingConnectionStatus;
import com.katalon.recorder.core.infrastructure.IKeywordDefinitionProvider;
import com.katalon.recorder.web.application.IWebRecorderSessionContext;
import com.katalon.recorder.web.application.IWebRecorderSettingController;
import com.katalon.recorder.web.application.event.IWebViewUpdateEventBus;
import com.katalon.recorder.web.application.event.WebViewModelAddStepEvent;
import com.katalon.recorder.web.application.event.WebViewModelLoadKeywordDefinitionsEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateCapturedObjectsEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateLastStepEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateRecordingConnectionsEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateRecordingStatusEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateStepsEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateVariablesEvent;
import com.katalon.recorder.web.application.event.WebViewRunningLogsUpdateRunningStatusEvent;
import com.katalon.recorder.web.application.event.WebViewShowErrorDialogEvent;
import com.katalon.recorder.web.application.event.WebViewShowHighlightElementInfoEvent;
import com.katalon.recorder.web.application.event.WebViewShowTakeScreenshotElementInfoEvent;
import com.katalon.recorder.web.application.event.WebViewUpdateEmptyEvent;
import com.katalon.recorder.web.application.event.WebViewUpdateEvent;
import com.katalon.recorder.web.constant.WebViewInteractionEventType;
import com.katalon.recorder.web.constant.WebViewUpdateEventType;
import com.katalon.recorder.web.domain.model.HighlightElementInfo;
import com.katalon.recorder.web.domain.model.IWebRecordingConnection;
import com.katalon.recorder.web.domain.model.IWebRecordingConnectionMetadata;
import com.katalon.recorder.web.domain.model.WebRecordingRequest;
import com.katalon.recorder.web.presentation.IRecorderDialogView;
import com.katalon.recorder.web.presentation.IWebCapturedObjectView;
import com.katalon.recorder.web.presentation.IWebConfigurationView;
import com.katalon.recorder.web.presentation.IWebRecorderNavigator;
import com.katalon.recorder.web.presentation.IWebRecordingView;
import com.katalon.recorder.web.presentation.WebRecorderEngineSettingDialog;
import com.katalon.recorder.web.presentation.dto.RecordingConnectionDTO;
import com.katalon.recorder.web.presentation.event.CapturedObjectMakeDefaultLocatorClickedEvent;
import com.katalon.recorder.web.presentation.event.CapturedObjectTakeScreenshotClickedEvent;
import com.katalon.recorder.web.presentation.event.CapturedObjectVerifyAndHighlightClickedEvent;
import com.katalon.recorder.web.presentation.event.ConfigurationStartActiveBrowserEvent;
import com.katalon.recorder.web.presentation.event.ConfigurationStartCustomizedBrowserRecordingEvent;
import com.katalon.recorder.web.presentation.event.ConfigurationStartNewBrowserRecordingEvent;
import com.katalon.recorder.web.presentation.event.IRunStepsLogEventHandler;
import com.katalon.recorder.web.presentation.event.IWebViewInteractionEventBus;
import com.katalon.recorder.web.presentation.event.RecorderDialogLayoutResizedEvent;
import com.katalon.recorder.web.presentation.event.RecordingPauseRecordingClickedEvent;
import com.katalon.recorder.web.presentation.event.RecordingRecordingConnectionSwitchedEvent;
import com.katalon.recorder.web.presentation.event.RecordingResumeRecordingClickedEvent;
import com.katalon.recorder.web.presentation.event.RecordingRunStepsClickedEvent;
import com.katalon.recorder.web.presentation.event.RecordingUpdateStepsEvent;
import com.katalon.recorder.web.presentation.event.RecordingUpdateVariablesEvent;
import com.katalon.recorder.web.presentation.event.WebViewInteractionEmptyEvent;
import com.katalon.recorder.web.presentation.event.WebViewInteractionEvent;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.constants.GlobalStringConstants;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class WebRecorderNavigator
implements IWebRecorderNavigator {
    private static final Logger logger = LoggerFactory.getLogger(WebRecorderNavigator.class);
    private static final String ON_DIALOG_LAYOUT_RESIZED = "webRecorderNavigator.onDialogLayoutResized";
    public static final int HIGHLIGHT_ELEMENT_STATUS_DURATION_IN_SECONDS = 3;
    public static final int TAKE_SCREENSHOT_STATUS_DURATION_IN_SECONDS = 3;
    public static final String SCREENSHOT_TAKEN_MESSAGE = "Screenshot taken!";
    public static final String FAIL_TO_TAKE_SCREENSHOT_MESSAGE = "Fail to take screenshot!";
    private final AtomicReference<Browser> browser;
    private final IWebRecorderSessionContext recordingSessionContext;
    private final ICustomCapabilityController customCapabilityController;
    private final IWebRecorderSettingController recorderSettingController;
    private final IRecorderDialogView recorderDialogView;
    private final IWebConfigurationView configurationView;
    private final IWebRecordingView recordingView;
    private final IWebCapturedObjectView capturedObjectView;
    private final IWebViewInteractionEventBus webViewInteractionEventBus;
    private final IWebViewUpdateEventBus webViewUpdateEventBus;
    private final CompositeDisposable compositeDisposable;
    private final IRunStepsLogEventHandler logEventHandler;
    private final IKeywordDefinitionProvider keywordDefinitionProvider;

    @Inject
    public WebRecorderNavigator(IWebRecorderSessionContext recordingSessionContext, ICustomCapabilityController customCapabilityController, IWebRecorderSettingController recorderSettingController, IRecorderDialogView recorderDialogView, IWebConfigurationView configurationView, IWebRecordingView recordingView, IWebCapturedObjectView capturedObjectView, IWebViewInteractionEventBus webViewInteractionEventBus, IWebViewUpdateEventBus webViewUpdateEventBus, IRunStepsLogEventHandler runStepsLogEventHandler, IKeywordDefinitionProvider keywordDefinitionProvider) {
        this.recordingSessionContext = recordingSessionContext;
        this.customCapabilityController = customCapabilityController;
        this.recorderSettingController = recorderSettingController;
        this.recorderDialogView = recorderDialogView;
        this.configurationView = configurationView;
        this.recordingView = recordingView;
        this.capturedObjectView = capturedObjectView;
        this.webViewInteractionEventBus = webViewInteractionEventBus;
        this.webViewUpdateEventBus = webViewUpdateEventBus;
        this.logEventHandler = runStepsLogEventHandler;
        this.keywordDefinitionProvider = keywordDefinitionProvider;
        this.compositeDisposable = new CompositeDisposable();
        this.browser = new AtomicReference();
    }

    public void init(Browser browser, String testCaseId) throws IOException {
        this.browser.set(browser);
        this.recordingSessionContext.init(testCaseId);
        this.subscribeWebViewUpdateEvents();
        this.subscribeInteractionFromConfigurationView();
        this.subscribeInteractionFromRecordingView();
        this.subscribeInteractionFromCapturedObjectView();
        this.subscribeInteractionFromRecordedStepsTabView();
        Bundle bundle = Platform.getBundle((String)"com.katalon.recorder.web.composer");
        URL webviewUrl = FileLocator.toFileURL((URL)bundle.getResource("resources/webview/WebRecorder.html"));
        browser.setUrl(webviewUrl.toString());
        ComponentUtil.onBrowserLoaded((Browser)this.browser.get(), b -> {
            this.setupBrowserFunctions();
            this.setupViews();
            this.loadLastRecordingRequest();
            this.loadContinuedTestCase();
            this.loadKeywords();
        });
    }

    private void subscribeInteractionFromCapturedObjectView() {
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(CapturedObjectVerifyAndHighlightClickedEvent.class).subscribe(this::onCapturedObjectVerifyAndHighlightClicked));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(CapturedObjectTakeScreenshotClickedEvent.class).subscribe(this::onCapturedObjectTakeScreenshotClicked));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(CapturedObjectMakeDefaultLocatorClickedEvent.class).subscribe(this::onCapturedObjectMakeDefaultLocatorClicked));
    }

    private void onCapturedObjectMakeDefaultLocatorClicked(CapturedObjectMakeDefaultLocatorClickedEvent event) {
        String capturedObjectId = event.getCapturedObjectId();
        LocatorType locatorType = event.getLocatorType();
        try {
            try {
                this.recordingSessionContext.setDefaultLocatorForCapturedObject(capturedObjectId, locatorType);
            }
            catch (Exception e) {
                logger.error("Exception while making default locator for captured object", (Throwable)e);
                this.showMessageDialog("%s%s%s".formatted("Cannot make %s as default locator. Please try again.".formatted(locatorType.getDisplayName()), System.lineSeparator(), e.getMessage()));
                this.recorderDialogView.callUpdateCapturedObjects(this.recordingSessionContext.getRecordingSession().getCapturedObjects());
            }
        }
        finally {
            this.recorderDialogView.callUpdateCapturedObjects(this.recordingSessionContext.getRecordingSession().getCapturedObjects());
        }
    }

    private void onCapturedObjectTakeScreenshotClicked(CapturedObjectTakeScreenshotClickedEvent event) {
        try {
            String capturedObjectId = event.getCapturedObjectId();
            LocatorType locatorType = event.getLocatorType();
            this.capturedObjectView.setTakingScreenshot(true);
            Integer result = this.recordingSessionContext.takeScreenshot(capturedObjectId, locatorType);
            if (-1 == result) {
                return;
            }
            if (result == 0) {
                this.capturedObjectView.updateErrorActionStatusMessage(FAIL_TO_TAKE_SCREENSHOT_MESSAGE, 3);
                this.capturedObjectView.setTakingScreenshot(false);
            } else if (result > 0) {
                this.capturedObjectView.updateSuccessActionStatusMessage(SCREENSHOT_TAKEN_MESSAGE, 3);
                this.recorderDialogView.callUpdateCapturedObjects(this.recordingSessionContext.getRecordingSession().getCapturedObjects());
            } else {
                logger.warn("Invalid take screenshot result: {}", (Object)result);
            }
            this.capturedObjectView.setTakingScreenshot(false);
        }
        catch (Exception e) {
            logger.error("Cannot take screenshot test object", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Cannot take screenshot test object. Please try again.", System.lineSeparator(), e.getMessage()));
            this.capturedObjectView.setTakingScreenshot(false);
        }
    }

    private void onCapturedObjectVerifyAndHighlightClicked(CapturedObjectVerifyAndHighlightClickedEvent event) {
        try {
            String capturedObjectId = event.getCapturedObjectId();
            LocatorType locatorType = event.getLocatorType();
            this.capturedObjectView.setHighlighting(true);
            Integer found = this.recordingSessionContext.verifyAndHighlightTestObject(capturedObjectId, locatorType);
            if (-1 == found) {
                return;
            }
            if (found == 0) {
                this.capturedObjectView.updateErrorActionStatusMessage("No element found using %s".formatted(locatorType.getDisplayName()), 3);
            } else if (found > 0) {
                this.capturedObjectView.updateSuccessActionStatusMessage("Found %s element(s) using %s".formatted(found, locatorType.getDisplayName()), 3);
            } else {
                logger.warn("Invalid verify and highlight result: {}", (Object)found);
            }
            this.capturedObjectView.setHighlighting(false);
        }
        catch (Exception e) {
            logger.error("Cannot verify and highlight test object", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Cannot verify and highlight test object. Please try again.", System.lineSeparator(), e.getMessage()));
            this.capturedObjectView.setHighlighting(false);
        }
    }

    private void loadContinuedTestCase() {
        List variables;
        List testObjects;
        List steps = this.recordingSessionContext.getRecordingSession().getSteps();
        if (CollectionUtils.isNotEmpty((Collection)steps)) {
            this.recorderDialogView.callUpdateSteps(steps);
        }
        if (CollectionUtils.isNotEmpty((Collection)(testObjects = this.recordingSessionContext.getRecordingSession().getCapturedObjects()))) {
            this.recorderDialogView.callUpdateCapturedObjects(testObjects);
        }
        if ((variables = this.recordingSessionContext.getRecordingSession().getVariables()).isEmpty()) {
            return;
        }
        this.recorderDialogView.callUpdateVariables(variables);
    }

    private void loadKeywords() {
        List keywords = this.keywordDefinitionProvider.getBuiltInKeywordDefinitions();
        this.recorderDialogView.callLoadKeywordDefinitions(keywords);
    }

    private void loadLastRecordingRequest() {
        WebRecordingRequest lastRecordingRequest = this.recordingSessionContext.getRecordingSession().getRecordingRequest();
        if (lastRecordingRequest == null) {
            return;
        }
        DriverType driverType = lastRecordingRequest.getDriverType();
        String customCapabilityName = lastRecordingRequest.getCustomCapabilityName();
        if (StringUtils.isNotBlank((CharSequence)customCapabilityName)) {
            try {
                List customCapabilities = this.customCapabilityController.getAllCustomCapabilities();
                String[] split = customCapabilityName.split(" - ", 2);
                customCapabilityName = customCapabilities.stream().anyMatch(cap -> cap.getName().equals(split[1])) ? customCapabilityName : "";
            }
            catch (MismatchCapabilityTypeException e) {
                logger.error("Cannot load custom capability | name = {}", (Object)lastRecordingRequest.getCustomCapabilityName(), (Object)e);
                this.showMessageDialog("Cannot load custom capability: %s".formatted(lastRecordingRequest.getCustomCapabilityName()));
            }
        }
        this.recorderDialogView.callUpdateRecordingRequest(lastRecordingRequest.getTestCaseId() == null ? "" : lastRecordingRequest.getTestCaseId(), driverType == null ? DriverType.CHROME_DRIVER.name() : driverType.name(), lastRecordingRequest.getWithProfile() != null && lastRecordingRequest.getWithProfile() != false, customCapabilityName, lastRecordingRequest.getStartupUrl() == null ? "" : lastRecordingRequest.getStartupUrl());
    }

    private void subscribeWebViewUpdateEvents() {
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewModelUpdateRecordingConnectionsEvent.class).subscribe(event -> this.handleModelUpdateRecordingConnections(event.getRecordingConnections())));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewModelUpdateRecordingStatusEvent.class).subscribe(event -> this.recorderDialogView.callUpdateRecordingStatus(event.getRecordingStatus().name())));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewShowErrorDialogEvent.class).subscribe(event -> this.showMessageDialog(event.getMessage())));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewModelUpdateCapturedObjectsEvent.class).subscribe(event -> this.recorderDialogView.callUpdateCapturedObjects(event.getCapturedObjects())));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewModelUpdateStepsEvent.class).subscribe(event -> this.recorderDialogView.callUpdateSteps(event.getSteps())));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewModelAddStepEvent.class).subscribe(event -> this.recorderDialogView.callAddStep(event.getStep())));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewModelUpdateLastStepEvent.class).subscribe(event -> this.recorderDialogView.callUpdateLastStep(event.getStep())));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewModelUpdateStepsEvent.class).subscribe(event -> this.recorderDialogView.callUpdateSteps(event.getSteps())));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewModelUpdateVariablesEvent.class).subscribe(event -> this.recorderDialogView.callUpdateVariables(event.getVariables())));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewModelLoadKeywordDefinitionsEvent.class).subscribe(event -> this.recorderDialogView.callLoadKeywordDefinitions(event.getKeywords())));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewShowHighlightElementInfoEvent.class).subscribe(this::handleShowHighlightElementInfoEvent));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewShowTakeScreenshotElementInfoEvent.class).subscribe(this::handleShowTakeScreenshotElementInfoEvent));
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewRunningLogsUpdateRunningStatusEvent.class).subscribe(event -> this.recorderDialogView.callUpdateRunningStatus(event.getStatus())));
    }

    private void handleShowTakeScreenshotElementInfoEvent(WebViewShowTakeScreenshotElementInfoEvent event) {
        boolean success = event.getSuccess();
        String message = event.getMessage();
        if (success) {
            this.capturedObjectView.updateSuccessActionStatusMessage(SCREENSHOT_TAKEN_MESSAGE, 3);
        } else {
            this.capturedObjectView.updateErrorActionStatusMessage(StringUtils.isBlank((CharSequence)message) ? FAIL_TO_TAKE_SCREENSHOT_MESSAGE : message, 3);
        }
        this.capturedObjectView.setTakingScreenshot(false);
    }

    private void handleShowHighlightElementInfoEvent(WebViewShowHighlightElementInfoEvent event) {
        HighlightElementInfo highlightElementInfo = event.getHighlightElementInfo();
        Exception exception = event.getException();
        if (exception == null && highlightElementInfo != null) {
            String locatorType = highlightElementInfo.getLocatorType();
            Integer found = highlightElementInfo.getFound();
            this.capturedObjectView.setHighlighting(false);
            if (found == 0) {
                this.capturedObjectView.updateErrorActionStatusMessage("No element found using %s".formatted(locatorType), 3);
            } else if (found > 0) {
                this.capturedObjectView.updateSuccessActionStatusMessage("Found %s element(s) using %s".formatted(found, locatorType), 3);
            } else {
                logger.warn("Invalid highlight element result: {}", (Object)found);
            }
        } else if (exception != null) {
            this.capturedObjectView.setHighlighting(false);
            this.capturedObjectView.updateErrorActionStatusMessage("Error occurred when highlighting element", 3);
        }
    }

    private void subscribeInteractionFromConfigurationView() {
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(WebViewInteractionEmptyEvent.class, WebViewInteractionEventType.CONFIGURATION_ACTIVE_BROWSER_TAB_CLICKED).subscribe(ignored -> this.onActiveBrowserTabClick()));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(WebViewInteractionEmptyEvent.class, WebViewInteractionEventType.CONFIGURATION_CUSTOMIZED_BROWSER_TAB_CLICKED).subscribe(ignored -> this.onCustomizedBrowserTabClicked()));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(WebViewInteractionEmptyEvent.class, WebViewInteractionEventType.CONFIGURATION_ADD_CUSTOMIZED_BROWSER_CLICKED).subscribe(ignored -> this.onAddCustomizedBrowserClick()));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(WebViewInteractionEmptyEvent.class, WebViewInteractionEventType.CONFIGURATION_EDIT_CUSTOMIZED_BROWSER_CLICKED).subscribe(ignored -> this.onEditCustomizedBrowserClick()));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(ConfigurationStartNewBrowserRecordingEvent.class).subscribe(this::onStartNewBrowserRecording));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(ConfigurationStartActiveBrowserEvent.class).subscribe(this::onStartActiveBrowserRecording));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(ConfigurationStartCustomizedBrowserRecordingEvent.class).subscribe(this::onStartCustomBrowserRecording));
    }

    private void subscribeInteractionFromRecordingView() {
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(RecordingRecordingConnectionSwitchedEvent.class).subscribe(this::onRecordingConnectionSwitched));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(RecordingPauseRecordingClickedEvent.class).subscribe(this::onPauseRecordingClicked));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(RecordingResumeRecordingClickedEvent.class).subscribe(this::onResumeRecordingClicked));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(WebViewInteractionEmptyEvent.class, WebViewInteractionEventType.RECORDING_SAVE_CLICKED).subscribe(ignore -> this.onSaveClicked()));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(WebViewInteractionEmptyEvent.class, WebViewInteractionEventType.RECORDING_OPEN_ENGINE_SETTING_CLICKED).subscribe(ignore -> this.onOpenEngineSetting()));
    }

    private void onOpenEngineSetting() {
        try {
            Boolean smartLocatorCaptureEnabled = Optional.ofNullable(this.recordingSessionContext.getRecordingSession().getActiveConnection()).map(IWebRecordingConnection::getMetadata).map(IWebRecordingConnectionMetadata::getSmartLocatorCaptureEnabled).orElse(null);
            if (smartLocatorCaptureEnabled == null) {
                return;
            }
            WebRecorderEngineSettingDialog webRecorderEngineSettingDialog = new WebRecorderEngineSettingDialog(this.browser.get().getShell(), smartLocatorCaptureEnabled);
            webRecorderEngineSettingDialog.open();
            Boolean smartLocatorCaptureEnabledResult = webRecorderEngineSettingDialog.getSmartLocatorCaptureEnabled();
            this.recordingSessionContext.updateRecorderEngineSetting(smartLocatorCaptureEnabledResult.booleanValue());
        }
        catch (Exception e) {
            logger.error("Exception while openning recorder engine setting", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Cannot openning recorder engine setting. Please try again.", System.lineSeparator(), e.getMessage()));
        }
    }

    private void subscribeInteractionFromRecordedStepsTabView() {
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(RecordingRunStepsClickedEvent.class).subscribe(this::onRunStepsClicked));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(RecordingUpdateStepsEvent.class).subscribe(this::onUpdateSteps));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(RecordingUpdateVariablesEvent.class).subscribe(this::onUpdateVariables));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(WebViewInteractionEmptyEvent.class, WebViewInteractionEventType.RECORDING_STOP_RUNNING_STEPS_CLICKED).subscribe(ignore -> this.onStopRunningStepsClicked()));
    }

    public void onLayoutResized(float devicePixelRatio, int width, int height) {
        logger.debug("Layout resized: devicePixelRatio={}, width={}, height={}", new Object[]{Float.valueOf(devicePixelRatio), width, height});
        this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new RecorderDialogLayoutResizedEvent(devicePixelRatio, width, height));
    }

    public IWebRecorderSessionContext getWebRecorderSessionContext() {
        return this.recordingSessionContext;
    }

    public void close() {
        try {
            this.logEventHandler.removeListener();
            this.recordingSessionContext.close();
        }
        catch (Exception e) {
            logger.error("Error while closing WebRecorderNavigator", (Throwable)e);
        }
        this.compositeDisposable.dispose();
        logger.info("WebRecorderNavigator closed");
    }

    private void onSaveClicked() {
        try {
            Boolean saveResult = this.recordingSessionContext.save();
            if (saveResult.booleanValue()) {
                this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewUpdateEmptyEvent(WebViewUpdateEventType.CLOSE_RECORDER_DIALOG));
            }
        }
        catch (Exception e) {
            logger.error("Exception while saving recording session", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Cannot save recording session. Please try again.", System.lineSeparator(), e.getMessage()));
        }
    }

    private void onResumeRecordingClicked(RecordingResumeRecordingClickedEvent event) {
        try {
            this.recordingSessionContext.resumeRecording(event.getRecordingConnectionId());
        }
        catch (Exception e) {
            logger.error("Cannot resume current recording session", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Cannot resume current recording session. Please try again.", System.lineSeparator(), e.getMessage()));
        }
    }

    private void onPauseRecordingClicked(RecordingPauseRecordingClickedEvent event) {
        try {
            this.recordingSessionContext.pauseRecording(event.getRecordingConnectionId());
        }
        catch (Exception e) {
            logger.error("Cannot pause current recording session", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Cannot pause current recording session. Please try again.", System.lineSeparator(), e.getMessage()));
        }
    }

    private void onEditCustomizedBrowserClick() {
        this.recorderSettingController.openProjectCustomCapabilitySettingsDialog();
        this.reloadCustomizedBrowser();
    }

    private void onAddCustomizedBrowserClick() {
        this.recorderSettingController.openProjectCustomCapabilitySettingsDialog();
        this.reloadCustomizedBrowser();
    }

    private void onRunStepsClicked(RecordingRunStepsClickedEvent event) {
        try {
            this.recordingSessionContext.executeSteps(event.getPlayOption(), event.getStepIndices());
        }
        catch (Exception e) {
            logger.error("Exception while running steps", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Error while running steps. Please try again.", System.lineSeparator(), e.getMessage()));
        }
    }

    private void onUpdateSteps(RecordingUpdateStepsEvent updateStepsEvent) {
        this.recordingSessionContext.updateSteps(updateStepsEvent.getSteps());
    }

    private void onUpdateVariables(RecordingUpdateVariablesEvent updateVariablesEvent) {
        this.recordingSessionContext.updateVariables(updateVariablesEvent.getVariables());
    }

    private void onStopRunningStepsClicked() {
        try {
            this.recordingSessionContext.stopExecutingSteps();
        }
        catch (Exception e) {
            logger.error("Exception while stop running steps", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Error while stop running steps. Please try again.", System.lineSeparator(), e.getMessage()));
        }
    }

    private void reloadCustomizedBrowser() {
        List customCapabilities = new ArrayList();
        try {
            customCapabilities = this.customCapabilityController.getAllCustomCapabilities();
        }
        catch (MismatchCapabilityTypeException e) {
            logger.error("Exception while getting custom capabilities", (Throwable)e);
        }
        ArrayList<CallSite> customizedBrowsers = new ArrayList<CallSite>();
        for (CustomCapabilitySetting customCapability : customCapabilities) {
            DriverType supportedDriverType = customCapability.getSupportedDriver(DriverPlatform.WEB);
            if (DriverType.CHROME_DRIVER != supportedDriverType && DriverType.EDGE_CHROMIUM_DRIVER != supportedDriverType) continue;
            customizedBrowsers.add((CallSite)((Object)(supportedDriverType.getDisplayName() + " - " + customCapability.getName())));
        }
        this.configurationView.updateCustomizedBrowsersDropdown(customizedBrowsers);
    }

    private void onCustomizedBrowserTabClicked() {
        this.reloadCustomizedBrowser();
    }

    private void onActiveBrowserTabClick() {
        this.handleModelUpdateRecordingConnections(this.recordingSessionContext.getRecordingSession().getRecordingConnections());
    }

    private void handleModelUpdateRecordingConnections(List<IWebRecordingConnection> recordingConnections) {
        List<RecordingConnectionDTO> recordingConnectionDTOList = recordingConnections.stream().map(conn -> {
            if (conn.getMetadata().getDriverType() == null) {
                return new RecordingConnectionDTO(conn.getRecordingConnectionId(), RecordingConnectionStatus.CONNECTED.name(), null, null, null, null, null, null, Boolean.valueOf(false), "Unknown (incompatible)");
            }
            return new RecordingConnectionDTO(conn.getRecordingConnectionId(), conn.getStatus().name(), conn.getMetadata().getDriverType().name(), conn.getMetadata().getBrowserVersion(), conn.getMetadata().getPageTitle(), conn.getMetadata().getEngine().name(), conn.getMetadata().getEngineType().name(), conn.getMetadata().getEngineVersion(), conn.getMetadata().getEngineCompatible(), conn.getMetadata().getPageTitle());
        }).toList();
        this.recorderDialogView.callUpdateRecordingConnections(recordingConnectionDTOList);
    }

    private void setupViews() {
        this.recorderDialogView.init(this.browser.get());
        this.configurationView.init(this.browser.get());
        this.recordingView.init(this.browser.get());
        this.capturedObjectView.init(this.browser.get());
    }

    private void setupBrowserFunctions() {
        BrowserFunctionUtil.registerBrowserFunction((String)ON_DIALOG_LAYOUT_RESIZED, Float.class, Integer.class, Integer.class, this::onLayoutResized);
    }

    private void onStartNewBrowserRecording(ConfigurationStartNewBrowserRecordingEvent event) {
        try {
            this.recordingSessionContext.startNewBrowserRecordingSession(event.getRecordingRequest());
        }
        catch (Exception e) {
            logger.error("Cannot start new browser recording session", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Cannot start new browser recording session. Please try again.", System.lineSeparator(), e.getMessage()));
            this.recordingSessionContext.backToConfiguration();
        }
    }

    private void showMessageDialog(String message) {
        UISynchronizeService.asyncExec(() -> MessageDialog.openError((Shell)this.browser.get().getShell(), (String)GlobalStringConstants.ERROR, (String)message));
    }

    private void onStartActiveBrowserRecording(ConfigurationStartActiveBrowserEvent event) {
        try {
            this.recordingSessionContext.startActiveBrowserRecordingSession(event.getRecordingRequest());
        }
        catch (Exception e) {
            logger.error("Cannot start active browser recording session", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Cannot start active browser recording session. Please try again.", System.lineSeparator(), e.getMessage()));
            this.recordingSessionContext.backToConfiguration();
        }
    }

    private void onStartCustomBrowserRecording(ConfigurationStartCustomizedBrowserRecordingEvent event) {
        try {
            this.recordingSessionContext.startCustomBrowserRecordingSession(event.getRecordingRequest());
        }
        catch (Exception e) {
            logger.error("Cannot start custom browser recording session", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Cannot start active browser recording session. Please try again.", System.lineSeparator(), e.getMessage()));
            this.recordingSessionContext.backToConfiguration();
        }
    }

    private void onRecordingConnectionSwitched(RecordingRecordingConnectionSwitchedEvent event) {
        try {
            this.recordingSessionContext.switchRecordingConnection(event.getRecordingConnectionId());
        }
        catch (Exception e) {
            logger.error("Cannot switch recording connection", (Throwable)e);
            this.showMessageDialog("%s%s%s".formatted("Cannot switch recording connection. Please try again.", System.lineSeparator(), e.getMessage()));
        }
    }
}

