/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.presentation.event;

import com.katalon.recorder.web.presentation.IRecorderDialogView;
import com.katalon.recorder.web.presentation.dto.LogMessageType;
import com.katalon.recorder.web.presentation.event.IRunStepsLogEventHandler;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.webui.common.RunningStatus;
import com.kms.katalon.execution.logging.RecordingOutputStreamHandler;
import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Creatable
public class RunStepsLogEventHandler
implements EventHandler,
IRunStepsLogEventHandler {
    private final IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private final IRecorderDialogView recorderDialogView;

    @Inject
    public RunStepsLogEventHandler(IRecorderDialogView recorderDialogView) {
        this.recorderDialogView = recorderDialogView;
        this.registerEventListeners();
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("WEBUI_VERIFICATION/LOG_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("WEBUI_VERIFICATION/EXECUTION_FINISHED", (EventHandler)this);
        this.eventBroker.subscribe("WEBUI_VERIFICATION/START_EXECUTION", (EventHandler)this);
        this.eventBroker.subscribe("WEBUI_VERIFICATION/STOP_EXECUTION", (EventHandler)this);
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "WEBUI_VERIFICATION/LOG_UPDATED": {
                RecordingOutputStreamHandler.RecordedOutputLine output = (RecordingOutputStreamHandler.RecordedOutputLine)this.getObject(event);
                this.recorderDialogView.callAppendRunningLog(output.getText(), this.toLogMessageType(output.getType()));
                return;
            }
            case "WEBUI_VERIFICATION/EXECUTION_FINISHED": {
                TestStatus.TestStatusValue status = (TestStatus.TestStatusValue)this.getObject(event);
                RunningStatus runningStatus = this.toRunningStatus(status);
                this.recorderDialogView.callUpdateRunningStatus(runningStatus);
                return;
            }
            case "WEBUI_VERIFICATION/START_EXECUTION": {
                this.recorderDialogView.callClearRunningLogs();
                this.recorderDialogView.callUpdateRunningStatus(RunningStatus.RUNNING);
                return;
            }
            case "WEBUI_VERIFICATION/STOP_EXECUTION": {
                this.recorderDialogView.callUpdateRunningStatus(RunningStatus.STOP);
                return;
            }
        }
    }

    public void removeListener() {
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    private Object getObject(Event event) {
        return event.getProperty("org.eclipse.e4.data");
    }

    private LogMessageType toLogMessageType(RecordingOutputStreamHandler.OutputType outputType) {
        return LogMessageType.valueOf((String)outputType.toString());
    }

    private RunningStatus toRunningStatus(TestStatus.TestStatusValue status) {
        return switch (status) {
            case TestStatus.TestStatusValue.PASSED -> RunningStatus.PASSED;
            case TestStatus.TestStatusValue.FAILED, TestStatus.TestStatusValue.ERROR -> RunningStatus.FAILED;
            case TestStatus.TestStatusValue.INCOMPLETE, TestStatus.TestStatusValue.SKIPPED -> RunningStatus.STOP;
            case TestStatus.TestStatusValue.NOT_RUN -> RunningStatus.NOT_RUN;
            default -> RunningStatus.NOT_RUN;
        };
    }
}

