/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.analytics.dialog.UploadSelectionDialog;
import com.kms.katalon.composer.integration.analytics.handlers.KatalonAnalytics;
import com.kms.katalon.composer.report.constants.ComposerReportMessageConstants;
import com.kms.katalon.composer.report.constants.ImageConstants;
import com.kms.katalon.composer.report.constants.StringConstants;
import com.kms.katalon.composer.report.provider.ReportActionColumnLabelProvider;
import com.kms.katalon.composer.report.provider.ReportCollectionTableLabelProvider;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.reporting.ExportReportProvider;
import com.kms.katalon.core.reporting.KatalonExportReportProvider;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.execution.entity.ReportFolder;
import com.kms.katalon.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.integration.analytics.report.AnalyticsReportService;
import com.kms.katalon.testops.core.model.TestOpsErrorResponse;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ReportCollectionPart
extends EventServiceAdapter
implements IComposerPartEvent {
    private ReportCollectionEntity reportCollectionEntity;
    private TableViewer tableViewer;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private MPart mpart;
    @Inject
    private Shell shell;
    private boolean isInitialized;
    private Composite mainComposite;
    private Composite reportCollectionMainComposite;
    private AnalyticsReportService analyticsReportService = new AnalyticsReportService();
    private ToolBar tbExportReport;
    private Composite exportReportToolbarComposite;
    MenuItem uploadMenuItem;
    @Inject
    private ITestOpsController testOpsController;

    @PostConstruct
    public void initialize(Composite parent, ReportCollectionEntity reportCollectionEntity, MPart mpart) {
        this.reportCollectionEntity = reportCollectionEntity;
        this.mainComposite = parent;
        this.mpart = mpart;
        Composite reportComposite = new Composite(parent, 0);
        GridLayout glMessageComposite = new GridLayout();
        glMessageComposite.marginTop = 20;
        reportComposite.setLayout((Layout)glMessageComposite);
        reportComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite controlComposite = new Composite(parent, 0);
        GridLayout glComposite = new GridLayout();
        glComposite.marginTop = 0;
        controlComposite.setLayout((Layout)glComposite);
        controlComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        parent.setLayoutData((Object)new GridData(1808));
        StackLayout layout = new StackLayout();
        parent.setLayout((Layout)layout);
        if (this.reportCollectionEntity == null) {
            layout.topControl = reportComposite;
            Image imgReportEmpty = ImageConstants.IMG_REPORT_EMPRY_TEST_SUITE_COLLECTION;
            Label lblReport = new Label(reportComposite, 0);
            lblReport.setImage(imgReportEmpty);
            lblReport.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        } else {
            layout.topControl = controlComposite;
            parent.layout();
            new HelpToolBarForMPart(mpart, DocumentationMessageConstants.REPORT_TEST_SUITE_COLLECTION);
            this.createControls(controlComposite);
            this.updateInput();
            this.eventBroker.subscribe("EXPLORER/RENAMED_SELECTED_ITEM", (EventHandler)this);
            this.eventBroker.subscribe("REPORT/COLLECTION/RENAMED", (EventHandler)this);
            this.isInitialized = true;
        }
    }

    private void updateInput() {
        this.updateTestCaseAmount();
        this.tableViewer.setInput((Object)this.reportCollectionEntity.getReportItemDescriptions());
    }

    public void updateReport(ReportCollectionEntity report) {
        if (!this.isInitialized) {
            this.initialize(this.mainComposite, report, this.mpart);
        }
        this.tableViewer.setInput((Object)report.getReportItemDescriptions());
        this.reportCollectionEntity = report;
    }

    private void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.reportCollectionMainComposite = new Composite(parent, 0);
        this.reportCollectionMainComposite.setLayout((Layout)new GridLayout(1, false));
        this.reportCollectionMainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.exportReportToolbarComposite = new Composite(this.reportCollectionMainComposite, 0);
        this.exportReportToolbarComposite.setLayout((Layout)new GridLayout(1, false));
        this.exportReportToolbarComposite.setLayoutData((Object)new GridData(131072, 128, true, false, 1, 1));
        this.createExportReportToolbar(this.exportReportToolbarComposite);
        this.tableViewer = new CTableViewer(this.reportCollectionMainComposite, 67584);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tableViewerColumnNo = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNo = tableViewerColumnNo.getColumn();
        tblclmnNo.setWidth(50);
        tblclmnNo.setText(StringConstants.NO_);
        tableViewerColumnNo.setLabelProvider((CellLabelProvider)new ReportCollectionTableLabelProvider(0));
        TableViewerColumn tableViewerColumnId = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnId = tableViewerColumnId.getColumn();
        tblclmnId.setWidth(250);
        tblclmnId.setText(StringConstants.ID);
        tableViewerColumnId.setLabelProvider((CellLabelProvider)new ReportCollectionTableLabelProvider(1));
        TableViewerColumn tableViewerColumnEnviroment = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnEnvironment = tableViewerColumnEnviroment.getColumn();
        tblclmnEnvironment.setWidth(100);
        tblclmnEnvironment.setText(StringConstants.REPORT_COLLECTION_LBL_ENVIRONMENT);
        tableViewerColumnEnviroment.setLabelProvider((CellLabelProvider)new ReportCollectionTableLabelProvider(2));
        TableViewerColumn tableViewerColumnProfile = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnProfile = tableViewerColumnProfile.getColumn();
        tblclmnProfile.setWidth(120);
        tblclmnProfile.setText(StringConstants.REPORT_COLLECTION_COLUMN_PROFILE);
        tableViewerColumnProfile.setLabelProvider((CellLabelProvider)new ReportCollectionTableLabelProvider(3));
        TableViewerColumn tableViewerColumnStatus = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnStatus = tableViewerColumnStatus.getColumn();
        tblclmnStatus.setWidth(100);
        tblclmnStatus.setText(StringConstants.STATUS);
        tableViewerColumnStatus.setLabelProvider((CellLabelProvider)new ReportCollectionTableLabelProvider(4));
        TableViewerColumn tableViewerColumnFailedTests = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnFailedTests = tableViewerColumnFailedTests.getColumn();
        tblclmnFailedTests.setWidth(120);
        tblclmnFailedTests.setText(StringConstants.REPORT_COLLECTION_COLUMN_FAILED_TEST);
        tableViewerColumnFailedTests.setLabelProvider((CellLabelProvider)new ReportCollectionTableLabelProvider(5));
        TableViewerColumn tableViewerColumnAction = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnAction = tableViewerColumnAction.getColumn();
        tblclmnAction.setWidth(90);
        tableViewerColumnAction.setLabelProvider((CellLabelProvider)new ReportActionColumnLabelProvider(6));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject.getType() == ProjectType.WEBSERVICE) {
            tblclmnEnvironment.setWidth(0);
            tblclmnEnvironment.setResizable(false);
        }
    }

    private void createExportReportToolbar(Composite parent) {
        if (this.tbExportReport != null) {
            this.tbExportReport.dispose();
        }
        this.tbExportReport = new ToolBar(parent, 131072);
        this.tbExportReport.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.createExportReportMenu(this.tbExportReport);
        this.createKatalonTestOpsMenu(this.tbExportReport);
        parent.requestLayout();
    }

    private void createExportReportMenu(ToolBar toolBar) {
        final ToolItem btnExportReport = new ToolItem(toolBar, 4);
        btnExportReport.setText(ComposerReportMessageConstants.BTN_EXPORT_REPORT);
        final Menu exportReportMenu = new Menu((Control)btnExportReport.getParent().getShell());
        KatalonExportReportProvider exportProvider = new KatalonExportReportProvider();
        String[] stringArray = exportProvider.getSupportedTypeForTestSuiteCollection();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedType = stringArray[n2];
            this.createExportReportMenuItem(supportedType, exportReportMenu, (ExportReportProvider)exportProvider);
            ++n2;
        }
        btnExportReport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = btnExportReport.getBounds();
                Point pt = btnExportReport.getParent().toDisplay(new Point(rect.x, rect.y));
                exportReportMenu.setLocation(pt.x, pt.y + rect.height);
                exportReportMenu.setVisible(true);
            }
        });
    }

    private void createKatalonTestOpsMenu(ToolBar toolBar) {
        final ToolItem btnTestOps = new ToolItem(toolBar, 4);
        btnTestOps.setText(ComposerReportMessageConstants.BTN_KATALON_ANALYTICS);
        btnTestOps.setImage(ImageManager.getImage((String)"testops_icon_16x16.png"));
        final Menu testOpsMenu = new Menu((Control)btnTestOps.getParent().getShell());
        MenuItem accessTestOpsMenuItem = new MenuItem(testOpsMenu, 8);
        this.uploadMenuItem = new MenuItem(testOpsMenu, 8);
        final AnalyticsSettingStore analyticsSettingStore = AnalyticsSettingStore.getStore((String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        accessTestOpsMenuItem.setText(ComposerReportMessageConstants.BTN_ACCESSKA);
        accessTestOpsMenuItem.setID(0);
        accessTestOpsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trackings.trackOpenKAIntegration((String)"report");
                try {
                    String serverUrl = analyticsSettingStore.getServerEndpoint();
                    Program.launch((String)serverUrl);
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ex.getMessage());
                }
            }
        });
        this.uploadMenuItem.setText(ComposerTestcaseMessageConstants.BTN_UPLOAD);
        this.uploadMenuItem.setID(1);
        this.uploadMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trackings.trackOpenKAIntegration((String)"report");
                ReportCollectionPart.this.startIntegrating();
            }
        });
        btnTestOps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = btnTestOps.getBounds();
                Point pt = btnTestOps.getParent().toDisplay(new Point(rect.x, rect.y));
                testOpsMenu.setLocation(pt.x, pt.y + rect.height);
                testOpsMenu.setVisible(true);
            }
        });
    }

    private void startIntegrating() {
        try {
            if (!this.testOpsController.isIntegrated()) {
                KatalonAnalytics handler = new KatalonAnalytics();
                handler.execute();
            } else {
                this.uploadReportHandle();
            }
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ex.getMessage());
        }
    }

    private void uploadReportHandle() {
        UploadSelectionDialog uploadSelectionDialog = new UploadSelectionDialog(this.shell);
        BundleContext bundleContext = FrameworkUtil.getBundle(ReportCollectionPart.class).getBundleContext();
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        ContextInjectionFactory.inject((Object)uploadSelectionDialog, (IEclipseContext)context);
        int returnCode = uploadSelectionDialog.open();
        if (returnCode == 2) {
            this.uploadReportToKatalonTestOps();
        }
    }

    private List<String> getReportFolder() {
        List reports = this.reportCollectionEntity.getReportItemDescriptions();
        String reportCollectionFile = this.reportCollectionEntity.getParentFolder().getLocation();
        String projectFolder = this.reportCollectionEntity.getProject().getFolderLocation();
        ArrayList<String> paths = new ArrayList<String>();
        for (ReportItemDescription reportItemDescription : reports) {
            String path = projectFolder + File.separator + reportItemDescription.getReportLocation();
            paths.add(path);
        }
        paths.add(reportCollectionFile);
        return paths;
    }

    private void uploadReportToKatalonTestOps() {
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(this.shell);
        try {
            monitor.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(ComposerReportMessageConstants.REPORT_MSG_UPLOADING_TO_ANALYTICS, 3);
                        monitor.subTask(ComposerReportMessageConstants.REPORT_MSG_UPLOADING_TO_ANALYTICS_SENDING);
                        monitor.worked(1);
                        ReportFolder reportFolder = new ReportFolder(ReportCollectionPart.this.getReportFolder());
                        ReportCollectionPart.this.analyticsReportService.uploadManually(reportFolder);
                        monitor.subTask(ComposerReportMessageConstants.REPORT_MSG_UPLOADING_TO_ANALYTICS_SUCCESSFULLY);
                        monitor.worked(2);
                    }
                    catch (AnalyticsApiException ex) {
                        LoggerSingleton.logError((Throwable)ex);
                        UISynchronizeService.syncExec(() -> {
                            String message = TestOpsErrorResponse.getFromException((Exception)((Object)ex)) == TestOpsErrorResponse.TEST_RESULT_QUOTA_EXCEEDED ? ComposerReportMessageConstants.REPORT_ERROR_MSG_TEST_RESULT_QUOTA_EXCEEDED : ComposerReportMessageConstants.REPORT_ERROR_MSG_UNABLE_TO_UPLOAD_REPORT;
                            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)message);
                        });
                    }
                }
            });
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerReportMessageConstants.REPORT_ERROR_MSG_UNABLE_TO_UPLOAD_REPORT);
        }
    }

    private MenuItem createExportReportMenuItem(String reportType, Menu exportReportMenu, final ExportReportProvider provider) {
        final MenuItem menuItem = new MenuItem(exportReportMenu, 8);
        menuItem.setText(reportType);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String reportType = menuItem.getText();
                DirectoryDialog directoryDialog = new DirectoryDialog(ReportCollectionPart.this.shell);
                String folderPath = directoryDialog.open();
                if (StringUtils.isEmpty((CharSequence)folderPath)) {
                    return;
                }
                final File exportDirectory = new File(folderPath);
                if (exportDirectory != null && exportDirectory.exists() && exportDirectory.isDirectory()) {
                    Job job = new Job("Export test suite report"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                monitor.beginTask("Exporting report to " + reportType + " format...", -1);
                                ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
                                File exportedFile = provider.exportTestSuiteCollection(exportDirectory, currentProject.getFolderLocation(), (this).ReportCollectionPart.this.reportCollectionEntity.getParentFolder().getLocation(), reportType, null);
                                UISynchronizeService.syncExec(() -> {
                                    boolean bl = Program.launch((String)exportedFile.toURI().toString());
                                });
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                                UISynchronizeService.syncExec(() -> MessageDialog.openError((Shell)(this).ReportCollectionPart.this.shell, (String)"Error", (String)("Unable to export report (" + e.getMessage() + ")")));
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                }
            }
        });
        return menuItem;
    }

    public String getEntityId() {
        if (this.reportCollectionEntity == null) {
            return "";
        }
        return this.reportCollectionEntity.getIdForDisplay();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
    }

    @PreDestroy
    public void onClose() {
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "EXPLORER/RENAMED_SELECTED_ITEM": {
                Object[] objects = this.getObjects(event);
                if (objects == null || objects.length != 2) {
                    return;
                }
                this.handleRenamedReportItem(objects);
                break;
            }
            case "REPORT/COLLECTION/RENAMED": {
                Object eventObject = this.getObject(event);
                if (!(eventObject instanceof ReportCollectionEntity)) {
                    return;
                }
                ReportCollectionEntity reportCollection = (ReportCollectionEntity)eventObject;
                if (!StringUtils.equals((CharSequence)this.reportCollectionEntity.getId(), (CharSequence)reportCollection.getId())) {
                    return;
                }
                this.setPartLabel(reportCollection.getDisplayName());
            }
        }
    }

    private void handleRenamedReportItem(Object[] objects) {
        Object oldRelativeId = objects[0];
        ReportItemDescription reportNameChanged = this.getReportNameChanged(oldRelativeId);
        if (reportNameChanged != null) {
            reportNameChanged.setReportLocation((String)objects[1]);
            this.tableViewer.refresh((Object)reportNameChanged);
        }
    }

    private ReportItemDescription getReportNameChanged(Object oldRelativeId) {
        for (ReportItemDescription itemDescription : this.reportCollectionEntity.getReportItemDescriptions()) {
            if (!itemDescription.getReportLocation().equals(oldRelativeId)) continue;
            return itemDescription;
        }
        return null;
    }

    private void setPartLabel(String label) {
        this.mpart.setLabel(label);
    }

    public MPart getMPart() {
        return this.mpart;
    }

    private void updateTestCaseAmount() {
        String projectLocation = this.reportCollectionEntity.getProject().getFolderLocation();
        for (ReportItemDescription itemDescription : this.reportCollectionEntity.getReportItemDescriptions()) {
            String reportLocation = projectLocation + File.separator + itemDescription.getReportLocation();
            File testCaseBinding = new File(reportLocation, "testCaseBinding");
            if (!testCaseBinding.exists()) continue;
            try {
                List testCases = FileUtils.readLines((File)testCaseBinding, (String)"UTF-8");
                itemDescription.setTestCaseAmount(testCases.size());
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }
}

